/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import chemaxon.struc.Molecule;
import java.util.Arrays;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.matrix.Vector;

public class TanimotoIndexedFilter
implements IndexedFilter {
    private float[] distMatrix;
    private boolean excludeSame = true;
    private Molecule molecule;
    private float maxDistance = 0.2f;
    private float minDistance = 0.0f;
    private String name;

    public TanimotoIndexedFilter(String name, Molecule m) {
        this.name = name;
        this.molecule = m;
    }

    @Override
    public boolean accept(int index) {
        float dist = this.distMatrix[index];
        if (dist <= this.maxDistance && dist >= this.minDistance) {
            if (this.excludeSame) {
                if (dist != 0.0f) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setExcludeSame(boolean excludeSame) {
        this.excludeSame = excludeSame;
    }

    @Override
    public void setValueProvider(Vector moleculeProvider) {
        this.distMatrix = new float[moleculeProvider.size()];
        Arrays.fill(this.distMatrix, Float.NaN);
        if (this.molecule != null) {
            int size = moleculeProvider.size();
            for (int i = 0; i < size; ++i) {
                Molecule m = (Molecule)moleculeProvider.getValue(i);
                if (m == null) continue;
                this.distMatrix[i] = MoleculeUtil.getTanimoto(this.molecule, m);
            }
        }
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public String toString() {
        return this.name;
    }
}

