/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapEditorKit;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class TopFilterComponent
extends JPanel
implements FilterComponent {
    private Filters.TopFilter filter;

    public TopFilterComponent(final Filters.TopFilter filter) {
        this.filter = filter;
        CellConstraints cc = new CellConstraints();
        TimerTextField valueTextField = new TimerTextField(!filter.isEmpty() ? "" + filter.getN() : ""){

            @Override
            public void update() {
                try {
                    String text = this.getText();
                    if (text != null) {
                        TopFilterComponent.this.setValue(ParserHelper.parseInt(text.trim()));
                    } else {
                        TopFilterComponent.this.setValue(-1);
                    }
                }
                catch (NumberFormatException nfe) {
                    TopFilterComponent.this.setValue(-1);
                }
            }
        };
        final JComboBox functionOrMetadataChooser = UIUtil.createComboBox();
        Project project = Application.getProject();
        if (project != null) {
            List<String> columns = MetadataUtil.getColumnNames(project.getOriginalDataset().getRowMetadata(), Number.class);
            for (String s : columns) {
                functionOrMetadataChooser.addItem(s);
            }
        }
        Collection<FloatListFunction> functions = HeatMapEditorKit.getDefaultFunctions();
        for (FloatListFunction f : functions) {
            functionOrMetadataChooser.addItem(f);
        }
        functionOrMetadataChooser.setSelectedIndex(-1);
        if (!filter.isEmpty()) {
            functionOrMetadataChooser.setSelectedItem(filter.getMetadataName() != null ? filter.getMetadataName() : filter.getFunction());
        }
        functionOrMetadataChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = functionOrMetadataChooser.getSelectedItem();
                filter.setFilterBy(item);
            }
        });
        FormLayout fl = new FormLayout(UIUtil.createColumnStringForFormLayout(7), "p, 6px, p");
        this.setLayout((LayoutManager)fl);
        this.add((Component)new JLabel("Top"), cc.xy(1, 1));
        this.add((Component)valueTextField, cc.xy(3, 1));
        final JComboBox topOrBottomComboBox = UIUtil.createComboBox(new Object[]{"lowest", "highest"});
        topOrBottomComboBox.setSelectedIndex(filter.isEmpty() ? 1 : (filter.isTop() ? 1 : 0));
        topOrBottomComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFilterComponent.this.setTop(topOrBottomComboBox.getSelectedIndex() == 1);
            }
        });
        this.add((Component)topOrBottomComboBox, cc.xy(5, 1));
        this.add((Component)new JLabel("by"), cc.xy(7, 1));
        this.add((Component)functionOrMetadataChooser, cc.xyw(1, 3, fl.getColumnCount()));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return "Top";
    }

    protected void setTop(boolean top) {
        this.filter.setTop(top);
    }

    protected void setValue(int value) {
        this.filter.setN(value);
    }
}

