/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.broadinstitute.genee.gsea.GeneSetMatrixParameterInput;
import org.broadinstitute.genee.gui.FTPFile;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.QuickListFilter;

public class MSigDBGeneSetSelectorPanel
extends JPanel
implements InputParameter<FTPFile[]> {
    private JList list;
    private FilterableListModel listModel = new FilterableListModel();

    public MSigDBGeneSetSelectorPanel() {
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new GeneSetMatrixParameterInput.GeneSetsFromFTPSiteRenderer());
        this.list.setSelectionMode(2);
        this.setLayout(new BorderLayout());
        this.add((Component)new QuickListFilter(this.list.getSelectionModel(), this.listModel){

            @Override
            protected String getSavedSearchKey() {
                return "msigdb.geneset";
            }
        }.getComponent(), "North");
        this.add(UIUtil.createNoBorderScrollPane(this.list));
    }

    public void setSelectedByURL(Set<String> urls) {
        ListSelectionModel selectionModel = this.list.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int count = this.list.getModel().getSize();
        for (int i = 0; i < count; ++i) {
            FTPFile file = (FTPFile)this.list.getModel().getElementAt(i);
            if (!urls.contains(file.getPath())) continue;
            selectionModel.addSelectionInterval(this.listModel.getSize() - 1, this.listModel.getSize() - 1);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void init() {
        GeneSetMatrixParameterInput.createMSigDBFilenames();
        if (this.listModel.getActualModel().getSize() == 0 && GeneSetMatrixParameterInput.msigDBFileNames != null) {
            ListSelectionModel selectionModel = this.list.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            for (FTPFile file : GeneSetMatrixParameterInput.msigDBFileNames) {
                this.listModel.addElement(file);
                if (!file.getName().contains(GeneSetMatrixParameterInput.latestVersion)) continue;
                selectionModel.addSelectionInterval(this.listModel.getSize() - 1, this.listModel.getSize() - 1);
            }
            selectionModel.setValueIsAdjusting(false);
        }
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public FTPFile[] getParameterValue() {
        Object[] selection = this.list.getSelectedValues();
        FTPFile[] files = new FTPFile[selection.length];
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            files[i] = (FTPFile)selection[i];
        }
        return files;
    }

    @Override
    public void init(Object value) {
    }

    @Override
    public void setValueFromString(String s) {
        String[] tokens = s.split("\n");
        HashSet<String> geneSetUrls = new HashSet<String>();
        for (String token : tokens) {
            geneSetUrls.add(token);
        }
        this.setSelectedByURL(geneSetUrls);
    }

    @Override
    public Class<?> getValueClass() {
        return FTPFile[].class;
    }
}

