/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jidesoft.swing.StyledLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.HistoryParameter;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.CommandLineRunner;
import org.broadinstitute.genee.gui.parameters.DefaultInputLabel;
import org.broadinstitute.genee.gui.parameters.ExcludeMaskedCheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.IncludeSelectedColumnsCheckBox;
import org.broadinstitute.genee.gui.parameters.IncludeSelectedRowsCheckBox;
import org.broadinstitute.genee.gui.parameters.InputLabel;
import org.broadinstitute.genee.gui.parameters.InputPanelBuilder;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.InputParameterUtils;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public abstract class AbstractGenericInputAction<T>
extends AbstractAction
implements GENEEWindowNotifier {
    public static final String ACTIVE_NODE_KEY = "active.node";
    public static final String DATASET_KEY = "dataset";
    public static final String OPERATION_KEY = "Operation";
    public static final String PROJECT_INFO_GROUP_KEY = "project.info.group";
    public static final String PROJECT_KEY = "project";
    private Map<String, Object> defaultInputMap;
    private String description;
    private ExcludeMaskedCheckBoxParameter excludeMaskedColumnsCheckBox;
    private ExcludeMaskedCheckBoxParameter excludeMaskedRowsCheckBox;
    private URL helpUrl;
    private boolean includeSelectedCheckBoxesDefaultValue = true;
    private IncludeSelectedColumnsCheckBox includeSelectedColumnsCheckBox;
    private IncludeSelectedRowsCheckBox includeSelectedRowsCheckBox;
    private InputPanelBuilder inputPanel = new InputPanelBuilder();
    private GENEEWindow inputWindow;
    private boolean isPacked = false;
    private String name;
    private JButton okBtn;
    private JButton resetBtn;
    private boolean resetButtonVisible = true;
    private boolean runInBackground = true;
    private boolean selectedAndMaskedCheckBoxesVisible = false;

    public AbstractGenericInputAction(String name) {
        super(name + "\u2026");
        this.name = name;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.inputWindow == null) {
            JPanel btnPanel;
            this.inputWindow = Application.createDialog(this.name, this);
            final JButton cancelBtn = new JButton("Cancel");
            this.okBtn = new JButton("OK");
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == cancelBtn) {
                        AbstractGenericInputAction.this.inputWindow.dispose();
                    } else {
                        AbstractGenericInputAction.this.ok();
                    }
                }
            };
            this.resetBtn = new JButton("Reset");
            this.resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractGenericInputAction.this.reset();
                }
            });
            this.okBtn.addActionListener(l);
            cancelBtn.addActionListener(l);
            JButton commandLineBtn = null;
            boolean showCommandButton = false;
            if (showCommandButton) {
                commandLineBtn = new JButton("Command");
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Map<String, Object> map = AbstractGenericInputAction.this.createInputMap();
                            AbstractGenericInputAction.this.cleanup(map);
                            History m = AbstractGenericInputAction.this.getInputPanelBuilder().createHistory(map);
                            StringBuilder sb = new StringBuilder();
                            sb.append("java -Xmx6g -cp " + Application.getName() + ".jar ");
                            sb.append(CommandLineRunner.class.getName());
                            sb.append(" ");
                            sb.append(this.getClass());
                            sb.append(" path-to-data");
                            List<HistoryParameter> params = m.getParameters();
                            for (HistoryParameter p : params) {
                                sb.append(" ");
                                sb.append(p.getKey());
                                sb.append("=");
                                sb.append(p.getValue());
                            }
                            UIUtil.showMessageDialog(AbstractGenericInputAction.this.getInputPanelBuilder().getFormBuilder().getPanel(), sb.toString());
                        }
                        catch (Exception e1) {
                            UIUtil.showErrorDialog(AbstractGenericInputAction.this.inputPanel.getFormBuilder().getPanel(), e1.getMessage());
                        }
                    }
                };
                commandLineBtn.addActionListener(listener);
            }
            JButton helpBtn = null;
            if (this.helpUrl != null) {
                helpBtn = new JButton("Help");
                helpBtn.setIcon(IconManager.loadIcon("16x16/help.gif"));
                ActionListener helpListener = new ActionListener(){
                    GENEEWindow helpWindow;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (this.helpWindow == null) {
                            this.helpWindow = Application.createDialog(AbstractGenericInputAction.this.inputWindow.getContentPane(), "Help");
                            JEditorPane pane = new JEditorPane();
                            pane.setContentType("text/html");
                            pane.setEditable(false);
                            try {
                                pane.setPage(AbstractGenericInputAction.this.helpUrl);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            this.helpWindow.getContentPane().add(new JScrollPane(pane));
                            this.helpWindow.setSize(500, 600);
                        }
                        this.helpWindow.setVisible(true);
                    }
                };
                helpBtn.addActionListener(helpListener);
                btnPanel = UIUtil.buildHelpOKCancelBar(helpBtn, this.okBtn, cancelBtn);
            } else {
                btnPanel = UIUtil.buildOKCancelBar(this.okBtn, cancelBtn);
            }
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.add(btnPanel);
            tmp.add((Component)ButtonBarFactory.buildRightAlignedBar((JButton)this.resetBtn), "South");
            btnPanel = tmp;
            this.inputWindow.getContentPane().add((Component)UIUtil.createNoBorderScrollPane(this.inputPanel.getFormBuilder().getPanel()), "Center");
            this.inputWindow.getContentPane().add((Component)btnPanel, "South");
            if (this.description != null) {
                JPanel p = new JPanel(new BorderLayout());
                StyledLabel descriptionLabel = new StyledLabel(this.description);
                descriptionLabel.setLineWrap(true);
                p.add((Component)descriptionLabel, "North");
                JSeparator sep = new JSeparator();
                p.add((Component)sep, "Center");
                this.inputWindow.getContentPane().add((Component)p, "North");
            }
            if (this.selectedAndMaskedCheckBoxesVisible) {
                this.includeSelectedRowsCheckBox = new IncludeSelectedRowsCheckBox("Selected rows", this.includeSelectedCheckBoxesDefaultValue);
                this.includeSelectedColumnsCheckBox = new IncludeSelectedColumnsCheckBox("Selected columns", this.includeSelectedCheckBoxesDefaultValue);
                if (this.inputPanel.getFormBuilder().getPanel().getComponentCount() > 0) {
                    this.inputPanel.getFormBuilder().addSpanned(new JSeparator());
                    this.inputPanel.getFormBuilder().nextRow();
                }
                this.inputPanel.getFormBuilder().addFirstColumn(new JLabel("Include:"));
                this.inputPanel.getFormBuilder().add(this.includeSelectedColumnsCheckBox);
                this.inputPanel.getFormBuilder().nextSmallRow();
                this.inputPanel.getFormBuilder().add(this.includeSelectedRowsCheckBox);
                this.inputPanel.getFormBuilder().nextSmallRow();
                this.excludeMaskedRowsCheckBox = new ExcludeMaskedCheckBoxParameter(true);
                this.excludeMaskedColumnsCheckBox = new ExcludeMaskedCheckBoxParameter(false);
                this.inputPanel.getFormBuilder().addSpanned(new JSeparator());
                this.inputPanel.getFormBuilder().nextRow();
                this.inputPanel.getFormBuilder().addFirstColumn(new JLabel("Exclude:"));
                this.inputPanel.getFormBuilder().add(this.excludeMaskedColumnsCheckBox);
                this.inputPanel.getFormBuilder().nextSmallRow();
                this.inputPanel.getFormBuilder().add(this.excludeMaskedRowsCheckBox);
                this.inputPanel.getFormBuilder().nextSmallRow();
            }
        }
        if (!this.beforeWindowShown()) {
            return;
        }
        if (this.defaultInputMap == null) {
            this.defaultInputMap = this.inputPanel.getParameterValueMap(new ArrayList<String>());
        }
        this.resetBtn.setVisible(this.resetButtonVisible && this.inputPanel.getParameterNames().size() > 0);
        if (!this.isPacked) {
            this.inputWindow.pack();
            this.isPacked = true;
        }
        this.inputWindow.getRootPane().setDefaultButton(this.okBtn);
        this.inputWindow.setVisible(true);
        this.okBtn.requestFocus();
    }

    public void addIndentedParameter(InputLabel inputLabel, InputParameter<?> inputParameter, boolean required, int level) {
        this.inputPanel.addIndentedParameter(inputLabel, inputParameter, required, level);
    }

    public DefaultInputLabel addIndentedParameter(String name, InputParameter<?> inputParameter, boolean required, int level) {
        DefaultInputLabel inputLabel = new DefaultInputLabel(name);
        this.inputPanel.addIndentedParameter(inputLabel, inputParameter, required, level);
        return inputLabel;
    }

    public void addParameter(InputLabel inputLabel, InputParameter<?> inputParameter, boolean required) {
        this.inputPanel.add(inputLabel, inputParameter, required);
    }

    public InputParameter<?> addParameter(String name, InputParameter<?> inputParameter, boolean required) {
        return this.addParameter(name, inputParameter, null, required);
    }

    public InputParameter<?> addParameter(String name, InputParameter<?> inputParameter, String description, boolean required) {
        DefaultInputLabel inputLabel = new DefaultInputLabel(name);
        this.inputPanel.add(inputLabel, inputParameter, description, required);
        return inputParameter;
    }

    public void addSpannedParameter(InputLabel inputLabel, InputParameter<?> inputParameter, boolean required) {
        this.inputPanel.add(inputLabel, inputParameter, null, required, true);
    }

    public Map<String, Object> createInputMap() throws Exception {
        String operation;
        ArrayList<String> errors = new ArrayList<String>();
        this.beforeGetParameterValues(errors);
        Map<String, Object> map = this.inputPanel.getParameterValueMap(errors);
        if (errors.size() > 0) {
            StringBuilder buf = new StringBuilder();
            int size = errors.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    buf.append("\n");
                }
                buf.append((String)errors.get(i));
            }
            throw new IllegalArgumentException(buf.toString());
        }
        boolean includeSelectedColumns = this.includeSelectedColumnsCheckBox != null && this.includeSelectedColumnsCheckBox.isEnabled() && this.includeSelectedColumnsCheckBox.isSelected();
        boolean includeSelectedRows = this.includeSelectedRowsCheckBox != null && this.includeSelectedRowsCheckBox.isEnabled() && this.includeSelectedRowsCheckBox.isSelected();
        boolean excludeMaskedRows = this.excludeMaskedRowsCheckBox != null && this.excludeMaskedRowsCheckBox.isEnabled() && this.excludeMaskedRowsCheckBox.isSelected();
        boolean excludeMaskedColumns = this.excludeMaskedColumnsCheckBox != null && this.excludeMaskedColumnsCheckBox.isEnabled() && this.excludeMaskedColumnsCheckBox.isSelected();
        GENEETreeNode tmp = Application.getWindowManager().getNode();
        map.put(ACTIVE_NODE_KEY, tmp);
        if (tmp instanceof ProjectGENEEResultTreeNode) {
            ProjectGENEEResultTreeNode node = (ProjectGENEEResultTreeNode)tmp;
            Dataset dataset = node.getProject().getOriginalDataset();
            if (dataset == null) {
                throw new NullPointerException("Dataset is null.");
            }
            dataset = DatasetUtil.sliceView(dataset, node.getProject().getModelRowIndices(includeSelectedRows, excludeMaskedRows), node.getProject().getModelColumnIndices(includeSelectedColumns, excludeMaskedColumns));
            map.put(PROJECT_INFO_GROUP_KEY, node.getGroup());
            map.put(PROJECT_KEY, node.getProject());
            map.put(DATASET_KEY, dataset);
            this.customizeMap(node.getProject(), map);
        }
        if ((operation = (String)this.getValue("Name")) != null && operation.endsWith("\u2026")) {
            operation = operation.substring(0, operation.length() - "\u2026".length());
        }
        map.put(OPERATION_KEY, operation);
        return map;
    }

    public T execute(Map<String, Object> map) throws Exception {
        Map<String, Object> defaultValuesMap = this.inputPanel.getParameterValueMap(new ArrayList<String>());
        GENEETreeNode tmp = Application.getWindowManager().getNode();
        if (tmp instanceof ProjectGENEEResultTreeNode) {
            ProjectGENEEResultTreeNode node = (ProjectGENEEResultTreeNode)tmp;
            Dataset dataset = node.getProject().getOriginalDataset();
            defaultValuesMap.put(PROJECT_INFO_GROUP_KEY, node.getGroup());
            defaultValuesMap.put(PROJECT_KEY, node.getProject());
            defaultValuesMap.put(DATASET_KEY, dataset);
            for (String key : map.keySet()) {
                Object value = map.get(key);
                defaultValuesMap.put(key.replace('.', ' '), value);
            }
            this.customizeMap(node.getProject(), defaultValuesMap);
        } else {
            defaultValuesMap.putAll(map);
        }
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        return this.execute(defaultValuesMap, null);
    }

    public InputPanelBuilder getInputPanelBuilder() {
        return this.inputPanel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    @Override
    public void notifyHidden() {
        if (this.includeSelectedRowsCheckBox != null) {
            this.includeSelectedRowsCheckBox.notifyHidden();
            this.includeSelectedColumnsCheckBox.notifyHidden();
        }
        if (this.excludeMaskedRowsCheckBox != null) {
            this.excludeMaskedRowsCheckBox.notifyHidden();
            this.excludeMaskedColumnsCheckBox.notifyHidden();
        }
    }

    @Override
    public void notifyShowing() {
        if (this.includeSelectedRowsCheckBox != null) {
            this.includeSelectedRowsCheckBox.notifyShowing();
            this.includeSelectedColumnsCheckBox.notifyShowing();
        }
        if (this.excludeMaskedRowsCheckBox != null) {
            this.excludeMaskedRowsCheckBox.notifyShowing();
            this.excludeMaskedColumnsCheckBox.notifyShowing();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIncludeSelectedCheckBoxSelected(boolean b) {
        if (this.includeSelectedColumnsCheckBox != null) {
            this.includeSelectedColumnsCheckBox.setSelected(b);
            this.includeSelectedRowsCheckBox.setSelected(b);
        } else {
            this.includeSelectedCheckBoxesDefaultValue = b;
        }
    }

    public void setParameterValue(String parameter, Object value) {
        this.inputPanel.setParameterValue(parameter, value);
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    protected void beforeGetParameterValues(List<String> errors) {
    }

    public boolean beforeWindowShown() {
        return true;
    }

    protected void customizeMap(Project p, Map<String, Object> map) {
    }

    protected void dispose() {
        this.inputWindow.dispose();
    }

    protected abstract T execute(Map<String, Object> var1, ProgressNotifier var2) throws Exception;

    protected History getHistory(Map<String, Object> parameterValueMap) {
        return this.inputPanel.createHistory(parameterValueMap);
    }

    protected void pack() {
        if (this.inputWindow != null) {
            this.inputWindow.pack();
        }
    }

    protected void setHelpUrl(URL helpUrl) {
        this.helpUrl = helpUrl;
    }

    protected void setResetButtonVisible(boolean visible) {
        this.resetButtonVisible = visible;
    }

    protected void setShowSelectedAndMasked(boolean b) {
        this.selectedAndMaskedCheckBoxesVisible = b;
    }

    protected abstract void succeeded(Map<String, Object> var1, MutableTreeNode var2, T var3);

    private void _succeeded(Map<String, Object> map, T result) {
        MutableTreeNode activeNode = (MutableTreeNode)map.get(ACTIVE_NODE_KEY);
        this.succeeded(map, activeNode, result);
        this.cleanup(map);
    }

    private void cleanup(Map<String, Object> map) {
        map.remove(ACTIVE_NODE_KEY);
        map.remove(OPERATION_KEY);
        map.remove(DATASET_KEY);
        map.remove(PROJECT_KEY);
        map.remove(PROJECT_INFO_GROUP_KEY);
    }

    private void ok() {
        try {
            if (!this.beforeWindowShown()) {
                return;
            }
            final Map<String, Object> map = this.createInputMap();
            if (map == null) {
                return;
            }
            if (this.inputWindow != null) {
                this.inputWindow.setVisible(false);
            }
            if (this.runInBackground) {
                BackgroundTask task = new BackgroundTask<T>(this.name){

                    @Override
                    protected T doInBackground() throws Exception {
                        TrackerUtil.trackPageView((String)AbstractGenericInputAction.this.getValue("Name"));
                        return AbstractGenericInputAction.this.execute(map, this);
                    }

                    @Override
                    protected void succeeded(T result) {
                        AbstractGenericInputAction.this._succeeded(map, result);
                    }
                };
                task.execute();
            } else {
                try {
                    TrackerUtil.trackPageView((String)this.getValue("Name"));
                    T result = this.execute(map, null);
                    this._succeeded(map, result);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            UIUtil.showErrorDialog(this.inputPanel.getFormBuilder().getPanel(), e.getMessage());
        }
    }

    private void reset() {
        if (this.excludeMaskedRowsCheckBox != null) {
            this.excludeMaskedRowsCheckBox.setSelected(true);
        }
        if (this.excludeMaskedColumnsCheckBox != null) {
            this.excludeMaskedColumnsCheckBox.setSelected(true);
        }
        if (this.includeSelectedRowsCheckBox != null) {
            this.includeSelectedRowsCheckBox.setSelected(true);
        }
        if (this.includeSelectedColumnsCheckBox != null) {
            this.includeSelectedColumnsCheckBox.setSelected(true);
        }
        for (String key : this.defaultInputMap.keySet()) {
            InputParameter<?> p = this.getInputPanelBuilder().getInputParameter(key);
            Object val = this.defaultInputMap.get(key);
            if (p == null || val == null) continue;
            String s = InputParameterUtils.toStringValue(val);
            p.setValueFromString(s);
        }
    }
}

