/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class BreadthFirstEnumeration
implements Enumeration<TreeNode> {
    protected Queue queue;
    private int maxDepth;
    private int depth = 1;

    public BreadthFirstEnumeration(TreeNode rootNode) {
        this(rootNode, -1);
    }

    public BreadthFirstEnumeration(TreeNode rootNode, int maxDepth) {
        Vector<TreeNode> v = new Vector<TreeNode>(1);
        v.addElement(rootNode);
        this.queue = new Queue();
        this.queue.enqueue(v.elements());
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
    }

    @Override
    public TreeNode nextElement() {
        Enumeration enumer = (Enumeration)this.queue.firstObject();
        TreeNode node = (TreeNode)enumer.nextElement();
        Enumeration<? extends TreeNode> children = node.children();
        if (!enumer.hasMoreElements()) {
            this.queue.dequeue();
        }
        if (children.hasMoreElements() && (this.maxDepth <= 0 || this.depth <= this.maxDepth)) {
            ++this.depth;
            this.queue.enqueue(children);
        }
        return node;
    }

    final class Queue {
        QNode head;
        QNode tail;

        Queue() {
        }

        public Object dequeue() {
            if (this.head == null) {
                throw new NoSuchElementException("No more elements");
            }
            Object retval = this.head.object;
            QNode oldHead = this.head;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            } else {
                oldHead.next = null;
            }
            return retval;
        }

        public void enqueue(Object anObject) {
            if (this.head == null) {
                this.head = this.tail = new QNode(anObject, null);
            } else {
                this.tail = this.tail.next = new QNode(anObject, null);
            }
        }

        public Object firstObject() {
            if (this.head == null) {
                throw new NoSuchElementException("No more elements");
            }
            return this.head.object;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        final class QNode {
            public Object object;
            public QNode next;

            public QNode(Object object, QNode next) {
                this.object = object;
                this.next = next;
            }
        }
    }
}

