/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public abstract class CustomSortOrderChooserPanel
extends JPanel {
    private JList list;
    private Vector vector;
    private JScrollPane sp;

    public CustomSortOrderChooserPanel() {
        this.setLayout(new BorderLayout());
        this.list = new JList(new DefaultListModel());
        JPanel btnPanel = this.createMoveUpDownPanel();
        this.add(UIUtil.createNoBorderScrollPane(this.list));
        this.add((Component)btnPanel, "West");
        this.sp = UIUtil.createNoBorderScrollPane(this);
    }

    public Comparator<Object> createComparator() {
        return Comparators.createComparatorForOrder(Arrays.asList(((DefaultListModel)this.list.getModel()).toArray()));
    }

    public Component getComponent() {
        return this.sp;
    }

    public void setComparator() {
        this.vector.setComparator(this.createComparator());
        this.notifyChanged();
    }

    public void setVector(Vector vector) {
        SequencedCollection<Object> iterable;
        this.vector = vector;
        Set values = VectorUtil.getValues(vector);
        if (vector.getComparator() != null) {
            Object[] array = values.toArray();
            Arrays.sort(array, vector.getComparator());
            iterable = Arrays.asList(array);
        } else {
            iterable = new TreeSet(values);
        }
        DefaultListModel model = new DefaultListModel();
        for (Object t : iterable) {
            model.addElement(t);
        }
        this.list.setModel(model);
    }

    protected abstract void notifyChanged();

    private JPanel createMoveUpDownPanel() {
        CellConstraints cc = new CellConstraints();
        final JButton moveUpButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveUp.png")));
        moveUpButton.setToolTipText("Move the selected items up");
        final JButton moveDownButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveDown.png")));
        moveDownButton.setToolTipText("Move the selected items down");
        final JButton moveToTopButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveToTop.png")));
        moveToTopButton.setToolTipText("Move the selected items to the top");
        final JButton moveToBottomButton = new JButton(new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveToBottom.png")));
        moveToBottomButton.setToolTipText("Move the selected items to the bottom");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                DefaultListModel model = (DefaultListModel)CustomSortOrderChooserPanel.this.list.getModel();
                int[] selected = CustomSortOrderChooserPanel.this.list.getSelectedIndices();
                if (selected == null || selected.length == 0) {
                    return;
                }
                Object[] values = CustomSortOrderChooserPanel.this.list.getSelectedValues();
                if (e.getSource() == moveDownButton) {
                    for (int idx : selected) {
                        if (idx >= model.size() - 1) continue;
                        obj = model.remove(idx);
                        model.add(idx + 1, obj);
                    }
                } else if (e.getSource() == moveUpButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(idx - 1, obj);
                    }
                } else if (e.getSource() == moveToTopButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(0, obj);
                    }
                } else if (e.getSource() == moveToBottomButton) {
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        obj = model.remove(idx);
                        model.add(model.getSize(), obj);
                    }
                }
                CustomSortOrderChooserPanel.this.setComparator();
                CustomSortOrderChooserPanel.this.list.getSelectionModel().setValueIsAdjusting(true);
                CustomSortOrderChooserPanel.this.list.getSelectionModel().clearSelection();
                block4: for (Object value : values) {
                    ListModel dm = CustomSortOrderChooserPanel.this.list.getModel();
                    int c = dm.getSize();
                    for (int i = 0; i < c; ++i) {
                        if (!value.equals(dm.getElementAt(i))) continue;
                        CustomSortOrderChooserPanel.this.list.getSelectionModel().addSelectionInterval(i, i);
                        continue block4;
                    }
                }
                CustomSortOrderChooserPanel.this.list.getSelectionModel().setValueIsAdjusting(false);
            }
        };
        moveToTopButton.addActionListener(l);
        moveToBottomButton.addActionListener(l);
        moveUpButton.addActionListener(l);
        moveDownButton.addActionListener(l);
        JPanel panel = new JPanel((LayoutManager)new FormLayout("left:p:none, 2px", "15px, p:none, 5px, p:none, 15px, p:none, 5px, p:none, 15px"));
        panel.add((Component)moveToTopButton, cc.xy(1, 2));
        panel.add((Component)moveUpButton, cc.xy(1, 4));
        panel.add((Component)moveDownButton, cc.xy(1, 6));
        panel.add((Component)moveToBottomButton, cc.xy(1, 8));
        return panel;
    }
}

