/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import org.jdesktop.swingx.util.OS;

public final class FileChooserUtil {
    private static final String DIR = "dir";
    private static JFileChooser fileChooser;
    private static boolean awtEnabled;

    private FileChooserUtil() {
    }

    public static boolean overwriteFile(Component parent, File f) {
        if (!f.exists()) {
            return true;
        }
        String message = "An item named " + f.getName() + " already exists in this location.\nDo you want to replace it with the one that you are saving?";
        return UIUtil.showOkCancelDialog(parent, "", message, "Replace", "Cancel");
    }

    public static File[] showMultiSelectOpenDialog(Component parent, String title) {
        return FileChooserUtil.showMultiSelectOpenDialog(parent, title, null);
    }

    public static File[] showMultiSelectOpenDialog(Component parent, final String title, final Set<String> extensions) {
        parent = FileChooserUtil.getParent(parent);
        FileChooserUtil.init();
        if (extensions != null) {
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = IOUtil.getExtension(f);
                    return extension != null && extensions.contains(extension);
                }

                @Override
                public String getDescription() {
                    return title;
                }
            });
        } else {
            fileChooser.setFileFilter(null);
        }
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(0);
        File[] files = null;
        if (fileChooser.showOpenDialog(parent) == 0) {
            files = fileChooser.getSelectedFiles();
            FileChooserUtil.saveDirectory(fileChooser.getCurrentDirectory());
        }
        fileChooser.setFileFilter(null);
        return files;
    }

    public static File showOpenDialog(Component parent) {
        return FileChooserUtil.showOpenDialog(parent, null);
    }

    public static File showOpenDialog(Component parent, String title) {
        parent = FileChooserUtil.getParent(parent);
        if (awtEnabled && OS.isMacOSX() && (parent instanceof Frame || parent instanceof Dialog)) {
            return FileChooserUtil.showAwtFileDialog(parent, 0, null, title, false);
        }
        FileChooserUtil.init();
        fileChooser.setDialogTitle(title);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        File file = null;
        if (fileChooser.showOpenDialog(parent) == 0) {
            file = fileChooser.getSelectedFile();
        }
        FileChooserUtil.saveDirectory(fileChooser.getCurrentDirectory());
        return file;
    }

    public static File showSaveDialog(Component parent) {
        return FileChooserUtil.showSaveDialog(parent, null, "");
    }

    public static File showSaveDialog(Component parent, String[] extensions, String dialogTitle) {
        parent = FileChooserUtil.getParent(parent);
        if (awtEnabled && OS.isMacOSX() && (parent instanceof Frame || parent instanceof Dialog)) {
            return FileChooserUtil.ensureCorrectExtension(parent, FileChooserUtil.showAwtFileDialog(parent, 1, null, dialogTitle, false), extensions, true);
        }
        FileChooserUtil.init();
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        File outputFile = null;
        if (fileChooser.showSaveDialog(parent) == 0) {
            outputFile = fileChooser.getSelectedFile();
            if (!FileChooserUtil.overwriteFile(parent, outputFile = FileChooserUtil.ensureCorrectExtension(parent, outputFile, extensions, false))) {
                outputFile = null;
            }
        }
        FileChooserUtil.saveDirectory(fileChooser.getCurrentDirectory());
        return outputFile;
    }

    public static File showSelectDirectoryDialog(Component parent, String dialogTitle) {
        return FileChooserUtil.showSelectDirectoryDialog(parent, dialogTitle, null);
    }

    public static File showSelectDirectoryDialog(Component parent, String dialogTitle, File selectedDirectory) {
        parent = FileChooserUtil.getParent(parent);
        if (awtEnabled && OS.isMacOSX() && (parent instanceof Frame || parent instanceof Dialog)) {
            return FileChooserUtil.showAwtFileDialog(parent, 0, selectedDirectory, dialogTitle, true);
        }
        FileChooserUtil.init();
        if (selectedDirectory != null && selectedDirectory.exists()) {
            fileChooser.setSelectedFile(selectedDirectory);
        }
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        if (dialogTitle != null) {
            fileChooser.setDialogTitle(dialogTitle);
        }
        File file = null;
        if (fileChooser.showOpenDialog(parent) == 0) {
            file = fileChooser.getSelectedFile();
        }
        FileChooserUtil.saveDirectory(fileChooser.getCurrentDirectory());
        return file;
    }

    private static FileDialog createAwtDialog(Component parent, int mode, String title) {
        FileDialog fc = null;
        if (parent instanceof Frame) {
            fc = new FileDialog((Frame)parent, title, mode);
        } else if (parent instanceof Dialog) {
            fc = new FileDialog((Dialog)parent, title, mode);
        } else {
            throw new IllegalArgumentException();
        }
        return fc;
    }

    private static File ensureCorrectExtension(Component parent, File file, String[] extensions, boolean prompt) {
        if (file != null && extensions != null) {
            String name = file.getName();
            int length = extensions.length;
            for (int i = 0; i < length; ++i) {
                if (!name.toLowerCase().endsWith(extensions[i].toLowerCase())) continue;
                return file;
            }
            if (extensions.length > 0) {
                name = name + extensions[0];
                file = new File(file.getParent(), name);
                if (prompt && !FileChooserUtil.overwriteFile(parent, file)) {
                    return null;
                }
                return file;
            }
        }
        return file;
    }

    private static Component getParent(Component parent) {
        if (parent == null) {
            parent = JOptionPane.getRootFrame();
        }
        parent = UIUtil.getTopLevelAncestor(parent);
        return parent;
    }

    private static JFileChooser init() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        FileChooserUtil.restoreLastDirectory();
        return fileChooser;
    }

    private static void restoreLastDirectory() {
        File directory;
        Preferences prefs = Preferences.userNodeForPackage(FileChooserUtil.class);
        String dir = prefs.get(DIR, null);
        if (dir != null && (directory = new File(dir)).exists() && directory.isDirectory()) {
            fileChooser.setCurrentDirectory(directory);
        }
    }

    private static void saveDirectory(File directory) {
        if (directory == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(FileChooserUtil.class);
        try {
            prefs.put(DIR, directory.getCanonicalPath());
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private static File showAwtFileDialog(Component parent, int mode, File selectedDirectory, String title, boolean directoriesOnly) {
        if (directoriesOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        } else {
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
        FileDialog fc = FileChooserUtil.createAwtDialog(parent, mode, title);
        if (selectedDirectory != null && selectedDirectory.exists()) {
            fc.setDirectory(selectedDirectory.getPath());
        } else {
            Preferences prefs = Preferences.userNodeForPackage(FileChooserUtil.class);
            String dir = prefs.get(DIR, null);
            if (dir != null) {
                fc.setDirectory(dir);
            }
        }
        fc.setModal(true);
        fc.setVisible(true);
        String f = fc.getFile();
        String directory = fc.getDirectory();
        if (directory != null) {
            FileChooserUtil.saveDirectory(new File(directory));
        }
        if (f != null && directory != null) {
            File file = new File(directory, f);
            return file;
        }
        return null;
    }

    static {
        awtEnabled = false;
    }
}

