/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.list.DefaultListModelWrapper;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.io.util.IOUtil;

public class FilterableListModel
extends DefaultListModelWrapper {
    private LuceneSearchParser.IndexedSearchPredicate IndexedSearchPredicate;

    public FilterableListModel() {
        super(new DefaultListModel());
    }

    public void addElement(int originalIndex, Object obj) {
        ((DefaultListModel)this.getActualModel()).add(originalIndex, obj);
        this.setFilter(this.IndexedSearchPredicate);
    }

    public void addElement(Object object) {
        ((DefaultListModel)this.getActualModel()).addElement(object);
        this.setFilter(this.IndexedSearchPredicate);
    }

    public int indexOf(Object item) {
        return ((DefaultListModel)this.getActualModel()).indexOf(item);
    }

    public boolean isSorted() {
        return this.IndexedSearchPredicate != null;
    }

    public Object remove(int idx) {
        Object value = ((DefaultListModel)this.getActualModel()).remove(idx);
        this.setFilter(this.IndexedSearchPredicate);
        return value;
    }

    public void removeAllElements() {
        ((DefaultListModel)this.getActualModel()).clear();
        this.setFilter(this.IndexedSearchPredicate);
    }

    public void removeElement(Object item) {
        ((DefaultListModel)this.getActualModel()).removeElement(item);
        this.setFilter(this.IndexedSearchPredicate);
    }

    public void setFilter(LuceneSearchParser.IndexedSearchPredicate predicate) {
        this.IndexedSearchPredicate = predicate;
        if (predicate != null) {
            predicate.setData(this.getActualModel());
            TIntArrayList indices = new TIntArrayList();
            int size = this.getActualModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(i)) continue;
                indices.add(i);
            }
            int[] oldIndices = this.getIndexes();
            this.setIndexes(indices.toArray());
            this.fireEvents(oldIndices, this.getIndexes());
        } else {
            int[] indices = IOUtil.seqInt(0, this.getActualModel().getSize(), 1);
            int[] oldIndices = this.getIndexes();
            this.setIndexes(indices);
            this.fireEvents(oldIndices, this.getIndexes());
        }
    }

    public void setItems(Collection<?> items) {
        DefaultListModel model = (DefaultListModel)this.getActualModel();
        if (model.getSize() > 0) {
            model.clear();
        }
        for (Object item : items) {
            model.addElement(item);
        }
        this.setFilter(this.IndexedSearchPredicate);
    }
}

