/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class IncreaseDecreasePanel
extends JPanel {
    private JTextField textField;
    private JButton upButton;
    private JButton downButton;
    private float value;
    private float change;
    private float minValue;
    private float maxValue;

    public IncreaseDecreasePanel(int ncols, float initialValue, float increment, float minimumValue, float maximumValue) {
        this.change = increment;
        this.value = initialValue;
        this.minValue = minimumValue;
        this.maxValue = maximumValue;
        this.textField = new JTextField(ncols);
        this.textField.setText(Formatter.format(this.value));
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float tmp = ParserHelper.parseFloat(IncreaseDecreasePanel.this.textField.getText().trim());
                if (tmp > IncreaseDecreasePanel.this.maxValue || tmp < IncreaseDecreasePanel.this.minValue) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    IncreaseDecreasePanel.this.value = tmp;
                    ActionListenerHelper.fireActionPerformed(IncreaseDecreasePanel.this.listenerList, e);
                }
            }
        });
        this.upButton = new JideButton((Icon)IconManager.loadIcon("8x7/12586.ArrowUp.gif"));
        this.upButton.setPreferredSize(new Dimension(8, 7));
        this.downButton = new JideButton((Icon)IconManager.loadIcon("8x7/12601.ArrowDown.gif"));
        this.downButton.setPreferredSize(new Dimension(8, 7));
        this.setLayout((LayoutManager)new FormLayout("p, 4px, p", "p"));
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.textField, cc.xy(1, 1));
        JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("p", "top:p, bottom:p"));
        buttonPanel.add((Component)this.upButton, cc.xy(1, 1));
        buttonPanel.add((Component)this.downButton, cc.xy(1, 2));
        this.add((Component)buttonPanel, cc.xy(3, 1));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncreaseDecreasePanel.this.value += IncreaseDecreasePanel.this.change;
                if (IncreaseDecreasePanel.this.value > IncreaseDecreasePanel.this.maxValue) {
                    IncreaseDecreasePanel.this.value = IncreaseDecreasePanel.this.maxValue;
                }
                ActionListenerHelper.fireActionPerformed(IncreaseDecreasePanel.this.listenerList, e);
                IncreaseDecreasePanel.this.textField.setText(Formatter.format(IncreaseDecreasePanel.this.value));
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncreaseDecreasePanel.this.value -= IncreaseDecreasePanel.this.change;
                if (IncreaseDecreasePanel.this.value < IncreaseDecreasePanel.this.minValue) {
                    IncreaseDecreasePanel.this.value = IncreaseDecreasePanel.this.minValue;
                }
                ActionListenerHelper.fireActionPerformed(IncreaseDecreasePanel.this.listenerList, e);
                IncreaseDecreasePanel.this.textField.setText(Formatter.format(IncreaseDecreasePanel.this.value));
            }
        });
    }

    public void setValue(float value) {
        this.value = value;
        this.textField.setText(Formatter.format(value));
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public float getValue() {
        return this.value;
    }
}

