/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.google.common.base.Objects;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.comparator.FastComparableComparator;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractMultiTableModel;
import com.jidesoft.grid.AbstractTableCellEditorRenderer;
import com.jidesoft.grid.CellRolloverSupport;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Comparator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.category.DefaultVectorColorModel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.CustomSortOrderChooserPanel;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.TableAutoComplete;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.MetadataDataType;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.LinearGradientChooserPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.table.FilterableTableModel;
import org.broadinstitute.genee.table.TableFilterField;
import org.broadinstitute.genee.table.TableUtil;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

public class MetadataEditor {
    private static final int CHART_COL = 6;
    private static final int COLOR_COL = 1;
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Boolean.class, Boolean.class, EditColorDummyObject.class, Boolean.class, Boolean.class, ChartStyle.class, MetadataDataType.class, Boolean.class, EditSortOrderDummyObject.class, JLabel.class};
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Color Bar", "Text Color", "Edit Color", "Text", "Tooltip", "Chart", "Data Type", "Custom Sort Order", "Edit Sort Order", "Delete"};
    private static final int DATA_TYPE_COL = 7;
    private static final int DELETE_COL = 10;
    private static final int EDIT_COLOR_COL = 3;
    private static final int META_DATA_NAME_COL = 0;
    private static final int SORT_ORDER_COL = 8;
    private static final int SORT_ORDER_EDIT_COL = 9;
    private static final int TEXT_COL = 4;
    private static final int TEXT_COLOR_COL = 2;
    private static final int TOOL_TIP_COL = 5;
    private MultiFilterableTableModel filterableModel;
    private MetadataModel metadataModel;
    private JPanel panel;
    private Project project;
    private boolean rows;
    private TableScrollPane tableScrollPane;

    public MetadataEditor(Project project, boolean rows) {
        this.project = project;
        this.rows = rows;
        this.metadataModel = rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
        this.init();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    private void configureTable(final JTable table) {
        ButtonsCellEditorRenderer editColorRenderer = new ButtonsCellEditorRenderer("Edit\u2026"){

            @Override
            protected void buttonClicked(int row) {
                MetadataEditor.this.showColorEditorDialog(MetadataEditor.this.filterableModel.getModelIndex(row));
            }
        };
        table.setDefaultEditor(EditColorDummyObject.class, (TableCellEditor)((Object)editColorRenderer));
        table.setDefaultRenderer(EditColorDummyObject.class, (TableCellRenderer)((Object)editColorRenderer));
        ButtonsCellEditorRenderer customSortOrder = new ButtonsCellEditorRenderer("Edit\u2026"){

            @Override
            protected void buttonClicked(int row) {
                MetadataEditor.this.showCustomSortOrderDialog(MetadataEditor.this.filterableModel.getModelIndex(row));
            }
        };
        table.setDefaultEditor(EditSortOrderDummyObject.class, (TableCellEditor)((Object)customSortOrder));
        table.setDefaultRenderer(EditSortOrderDummyObject.class, (TableCellRenderer)((Object)customSortOrder));
        table.setDefaultEditor(MetadataDataType.class, new DefaultCellEditor(UIUtil.createComboBox((Object[])MetadataDataType.getAllowedValues())));
        table.setDefaultEditor(ChartStyle.class, new DefaultCellEditor(UIUtil.createComboBox(ChartStyle.values())));
        table.setShowGrid(false);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.setIntercellSpacing(new Dimension());
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setRowHeight(40);
        table.setDefaultRenderer(JLabel.class, new DeleteIconRenderer());
        table.setMinimumSize(new Dimension(0, 0));
        table.setFont(new Font(UIUtil.getFontName(), 0, 12));
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int rowIndex = table.rowAtPoint(event.getPoint());
                int columnIndex = table.convertColumnIndexToModel(table.columnAtPoint(event.getPoint()));
                if (columnIndex == COLUMN_NAMES.length - 1 && rowIndex >= 0 && rowIndex < table.getRowCount() && UIUtil.showOkCancelDialog(table, "Are you sure you want to delete " + table.getModel().getValueAt(rowIndex, 0) + "?", "")) {
                    MetadataEditor.this.metadataModel.remove(MetadataEditor.this.filterableModel.getModelIndex(rowIndex));
                    if (MetadataEditor.this.rows) {
                        MetadataEditor.this.project.fireRowMetadataChanged();
                    } else {
                        MetadataEditor.this.project.fireColumnMetadataChanged();
                    }
                }
            }
        });
        table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int columnIndex = table.convertColumnIndexToModel(table.columnAtPoint(e.getPoint()));
                if (columnIndex == COLUMN_NAMES.length - 1) {
                    table.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    table.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        table.getTableHeader().setFont(new Font(UIUtil.getFontName(), 0, 13));
        table.setAutoResizeMode(0);
        TableUtil.sizeColumns(table);
    }

    private void init() {
        this.project.addProjectListener(new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                boolean changed = false;
                if (MetadataEditor.this.rows && e.getType() == 5) {
                    changed = true;
                } else if (!MetadataEditor.this.rows && e.getType() == 6) {
                    changed = true;
                }
                if (changed) {
                    ((AbstractTableModel)MetadataEditor.this.tableScrollPane.getMainTable().getModel()).fireTableStructureChanged();
                }
            }
        });
        this.filterableModel = new MultiFilterableTableModel((TableModel)((Object)new MetadataEditorTableModel(this.metadataModel, this.project, this.rows)));
        TableFilterField filterField = new TableFilterField(this.filterableModel, null){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        };
        this.tableScrollPane = new TableScrollPane(this.filterableModel){

            protected JTable createTable(TableModel model, boolean sortable) {
                return new JTable(model){

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                        Object value = this.getValueAt(row, column);
                        boolean hasFocus = false;
                        boolean isSelected = this.isCellSelected(row, column);
                        return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
                    }
                };
            }

            protected void customizeTable(JTable table) {
                MetadataEditor.this.configureTable(table);
            }
        };
        new TableAutoComplete(filterField, (TableModel)this.tableScrollPane.getModel());
        this.tableScrollPane.setBorder(null);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.tableScrollPane);
        JPanel tmp = new JPanel(new FlowLayout(0));
        tmp.add((Component)((Object)filterField));
        this.panel.add((Component)tmp, "North");
    }

    private void showColorEditorDialog(final int rowIndex) {
        JPanel colorComponent = null;
        boolean discrete = MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "Discrete Key");
        colorComponent = discrete ? new DiscreteColorEditorPanel(this.metadataModel.get(rowIndex), this.rows ? this.project.getRowColorModel() : this.project.getColumnColorModel()) : new ContinuousColorEditorPanel(this.metadataModel.get(rowIndex), this.rows ? this.project.getRowColorModel() : this.project.getColumnColorModel());
        final GENEEWindow window = Application.getWindowManager().createInputWindow(this.metadataModel.getColumnName(rowIndex) + " color", null);
        ((Dialog)((Object)window)).setModal(true);
        window.getContentPane().add((Component)UIUtil.createNoBorderScrollPane(colorComponent), "Center");
        FormBuilder fb = new FormBuilder();
        fb.nextRow();
        final JCheckBox cb = new JCheckBox("Discrete", discrete);
        cb.setEnabled(Number.class.isAssignableFrom(this.metadataModel.get(rowIndex).getColumnClass()));
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel c = null;
                if (cb.isSelected()) {
                    MetadataEditor.this.metadataModel.get(rowIndex).setProperty("Discrete Key", true);
                    c = new DiscreteColorEditorPanel(MetadataEditor.this.metadataModel.get(rowIndex), MetadataEditor.this.rows ? MetadataEditor.this.project.getRowColorModel() : MetadataEditor.this.project.getColumnColorModel());
                } else {
                    MetadataEditor.this.metadataModel.get(rowIndex).setProperty("Discrete Key", null);
                    c = new ContinuousColorEditorPanel(MetadataEditor.this.metadataModel.get(rowIndex), MetadataEditor.this.rows ? MetadataEditor.this.project.getRowColorModel() : MetadataEditor.this.project.getColumnColorModel());
                }
                int cc = window.getContentPane().getComponentCount();
                for (int i = 0; i < cc; ++i) {
                    Component tmp = window.getContentPane().getComponent(i);
                    if (!(tmp instanceof JScrollPane)) continue;
                    window.getContentPane().remove(i);
                    --i;
                    --cc;
                }
                window.getContentPane().add((Component)UIUtil.createNoBorderScrollPane(c), "Center");
                window.getContentPane().invalidate();
                window.getContentPane().validate();
                c.revalidate();
                c.repaint();
                window.pack();
            }
        });
        fb.addSpanned(cb);
        window.getContentPane().add(UIUtil.createNoBorderScrollPane(colorComponent));
        window.getContentPane().add((Component)fb.getPanel(), "South");
        window.pack();
        window.setVisible(true);
    }

    private void showCustomSortOrderDialog(int rowIndex) {
        CustomSortOrderChooserPanel sortOrderPanel = new CustomSortOrderChooserPanel(){

            @Override
            protected void notifyChanged() {
                if (MetadataEditor.this.rows) {
                    MetadataEditor.this.project.setRowSortOrder(MetadataEditor.this.project.getRowSortKeys());
                } else {
                    MetadataEditor.this.project.setColumnSortOrder(MetadataEditor.this.project.getColumnSortKeys());
                }
            }
        };
        sortOrderPanel.setVector(this.metadataModel.get(rowIndex));
        GENEEWindow window = Application.getWindowManager().createInputWindow(this.metadataModel.getColumnName(rowIndex) + " custom sort order", null);
        ((Dialog)((Object)window)).setModal(true);
        window.getContentPane().add(sortOrderPanel.getComponent());
        window.pack();
        window.setVisible(true);
    }

    public static Action createAction(boolean rows) {
        final boolean _rows = rows;
        return new AbstractAction("Edit " + (_rows ? "Row" : "Column") + " Annotations"){
            private GENEEWindow dialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView((String)this.getValue("Name"));
                if (this.dialog == null) {
                    this.dialog = Application.createDialog("Edit " + (_rows ? "Row" : "Column") + " Annotations");
                    this.dialog.getContentPane().add(new MetadataEditor(Application.getProject(), _rows).getComponent());
                    this.dialog.pack();
                    this.dialog.setSize(this.dialog.getWidth() + 270, this.dialog.getHeight());
                }
                this.dialog.setVisible(true);
            }
        };
    }

    private static class MultiFilterableTableModel
    extends FilterableTableModel
    implements MultiTableModel {
        public MultiFilterableTableModel(TableModel tableModel) {
            super(tableModel);
        }

        public Class<?> getCellClassAt(int paramInt1, int paramInt2) {
            return this.getColumnClass(paramInt2);
        }

        public int getColumnType(int index) {
            return ((MultiTableModel)this.tableModel).getColumnType(index);
        }

        public ConverterContext getConverterContextAt(int paramInt1, int paramInt2) {
            return null;
        }

        public EditorContext getEditorContextAt(int paramInt1, int paramInt2) {
            return null;
        }

        public int getTableIndex(int index) {
            return ((MultiTableModel)this.tableModel).getTableIndex(index);
        }
    }

    private static class MetadataEditorTableModel
    extends AbstractMultiTableModel {
        private MetadataModel metadataModel;
        private Project project;
        private boolean rows;

        public MetadataEditorTableModel(MetadataModel metadataModel, Project project, boolean rows) {
            this.metadataModel = metadataModel;
            this.project = project;
            this.rows = rows;
        }

        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        public int getColumnType(int column) {
            if (column == 0) {
                return 1;
            }
            return 0;
        }

        public int getRowCount() {
            return this.metadataModel.getMetadataCount();
        }

        public int getTableIndex(int arg0) {
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.metadataModel.getColumnName(rowIndex);
            }
            if (columnIndex == 1) {
                return MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "Color Visible");
            }
            if (columnIndex == 2) {
                return MetadataUtil.getBoolean(this.metadataModel.get(rowIndex), "Text Color Visible");
            }
            if (columnIndex == 4) {
                return MetadataUtil.isTextVisible(this.metadataModel.get(rowIndex));
            }
            if (columnIndex == 5) {
                return MetadataUtil.isToolTipVisible(this.metadataModel.get(rowIndex));
            }
            if (columnIndex == 6) {
                Integer style = (Integer)this.metadataModel.get(rowIndex).getProperty("Chart Style");
                if (style == null) {
                    return new ChartStyle(-1);
                }
                return new ChartStyle(style);
            }
            if (columnIndex == 7) {
                return MetadataDataType.getType(this.metadataModel.get(rowIndex).getColumnClass());
            }
            if (columnIndex == 8) {
                Comparator<Object> c = this.metadataModel.get(rowIndex).getComparator();
                return !(c instanceof Comparators.StringCaseInsensitiveComparator) && !(c instanceof FastComparableComparator);
            }
            if (columnIndex == 3) {
                return new EditColorDummyObject();
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex > 0 && columnIndex < COLUMN_NAMES.length - 1) {
                if (columnIndex == 6) {
                    return Number.class.isAssignableFrom(this.metadataModel.get(rowIndex).getColumnClass());
                }
                return true;
            }
            return false;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            boolean fireMetadataChanged = true;
            String property = null;
            if (columnIndex == 1) {
                property = "Color Visible";
            } else if (columnIndex == 4) {
                property = "Text Visible";
            } else if (columnIndex == 5) {
                property = "Tooltip Visible";
            } else if (columnIndex == 6) {
                property = "Chart Style";
                ChartStyle style = (ChartStyle)aValue;
                aValue = style.style == -1 ? null : Integer.valueOf(style.style);
            } else if (columnIndex == 7) {
                if (aValue != null) {
                    Object oldValue = this.getValueAt(rowIndex, columnIndex);
                    try {
                        String metadataName = this.metadataModel.getColumnName(rowIndex);
                        if (!aValue.equals(oldValue)) {
                            DatasetUtil.changeDataType(this.project, this.rows, metadataName, (MetadataDataType)((Object)aValue));
                            fireMetadataChanged = true;
                        }
                    }
                    catch (IllegalArgumentException x) {
                        fireMetadataChanged = false;
                        UIUtil.showErrorDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), x.getMessage());
                    }
                }
            } else if (columnIndex == 2) {
                property = "Text Color Visible";
                if (((Boolean)aValue).booleanValue()) {
                    this.metadataModel.get(rowIndex).setProperty("Text Visible", (Boolean)aValue);
                }
            } else if (columnIndex == 8) {
                boolean custom = (Boolean)aValue;
                this.metadataModel.get(rowIndex).setComparator(custom ? new Comparators.AscendingComparator() : null);
            }
            if (property != null) {
                Object oldProperty = this.metadataModel.get(rowIndex).getProperty(property);
                this.metadataModel.get(rowIndex).setProperty(property, aValue);
                boolean bl = fireMetadataChanged = !Objects.equal((Object)aValue, (Object)oldProperty);
            }
            if (fireMetadataChanged) {
                if (this.rows) {
                    this.project.fireRowMetadataChanged();
                } else {
                    this.project.fireColumnMetadataChanged();
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    private static class EditSortOrderDummyObject {
        private EditSortOrderDummyObject() {
        }

        public String toString() {
            return "Edit\u2026";
        }
    }

    private static class EditColorDummyObject {
        private EditColorDummyObject() {
        }

        public String toString() {
            return "Edit\u2026";
        }
    }

    private static class DiscreteColorEditorPanel
    extends JPanel {
        public DiscreteColorEditorPanel(final Vector vector, final VectorColorModel colorModel) {
            Set values = VectorUtil.getValues(vector);
            this.setLayout((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(2), UIUtil.createRowStringForFormLayout(values.size())));
            CellConstraints cc = new CellConstraints();
            int rowIndex = 1;
            for (final Object val : values) {
                final EditColorButton editColorBtn = new EditColorButton((Color)colorModel.getMappedValue(vector, val));
                this.add((Component)new JLabel(Formatter.toString(val)), cc.xy(1, rowIndex));
                this.add((Component)editColorBtn, cc.xy(3, rowIndex));
                editColorBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        colorModel.setMappedValue(vector, val, editColorBtn.getColor());
                    }
                });
                rowIndex += 2;
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static class DeleteIconRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setIcon(IconManager.loadIcon("16x16/14763.delete.gif"));
            return super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }
    }

    private static class ContinuousColorEditorPanel
    extends JPanel {
        private HeatMapColorScheme colorScheme;
        private LinearGradientChooserPanel linearGradientChooserPanel;

        public ContinuousColorEditorPanel(final Vector vector, VectorColorModel colorModel) {
            this.colorScheme = colorModel.getContinuousColorScheme(vector);
            this.linearGradientChooserPanel = new LinearGradientChooserPanel();
            this.linearGradientChooserPanel.setMinMax(this.colorScheme.getMin(), this.colorScheme.getMax());
            this.linearGradientChooserPanel.setColors(this.colorScheme.isDiscrete(), this.colorScheme.getColors(), this.colorScheme.getFractions());
            ThumbDataListener tdl = new ThumbDataListener(){

                public void positionChanged(ThumbDataEvent e) {
                    this.updateColorScheme();
                }

                public void thumbAdded(ThumbDataEvent e) {
                    this.updateColorScheme();
                }

                public void thumbRemoved(ThumbDataEvent e) {
                    this.updateColorScheme();
                }

                public void valueChanged(ThumbDataEvent e) {
                    this.updateColorScheme();
                }

                private void updateColorScheme() {
                    if (ContinuousColorEditorPanel.this.colorScheme != null && ContinuousColorEditorPanel.this.linearGradientChooserPanel.isEnabled()) {
                        LinearGradientChooserPanel.FractionColorPair[] pairs = ContinuousColorEditorPanel.this.linearGradientChooserPanel.getFractionColorPairs();
                        float[] fractions = new float[pairs.length];
                        Color[] colors = new Color[pairs.length];
                        for (int i = 0; i < fractions.length; ++i) {
                            fractions[i] = pairs[i].getFraction();
                            colors[i] = pairs[i].getColor();
                        }
                        ContinuousColorEditorPanel.this.colorScheme.setColors(colors, fractions);
                    }
                }
            };
            this.linearGradientChooserPanel.addThumbDataListener(tdl);
            JButton resetBtn = new JButton("Reset");
            resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    float min = VectorUtil.getMin(vector);
                    float max = VectorUtil.getMax(vector);
                    ContinuousColorEditorPanel.this.colorScheme.setGlobalMinMode(2, min);
                    ContinuousColorEditorPanel.this.colorScheme.setGlobalMaxMode(2, max);
                    if (min < 0.0f && max > 0.0f) {
                        float span = max - min;
                        float zeroFraction = (0.0f - min) / span;
                        if (Float.isInfinite(span)) {
                            zeroFraction = 1.0E-5f;
                        }
                        ContinuousColorEditorPanel.this.colorScheme.setColors(DefaultVectorColorModel.DEFAULT_CONTINUOUS_COLORS, new float[]{0.0f, zeroFraction, 1.0f});
                    } else {
                        ContinuousColorEditorPanel.this.colorScheme.setColors(DefaultVectorColorModel.DEFAULT_CONTINUOUS_COLORS);
                    }
                    ContinuousColorEditorPanel.this.linearGradientChooserPanel.setMinMax(min, max);
                    ContinuousColorEditorPanel.this.linearGradientChooserPanel.setColors(ContinuousColorEditorPanel.this.colorScheme.isDiscrete(), ContinuousColorEditorPanel.this.colorScheme.getColors(), ContinuousColorEditorPanel.this.colorScheme.getFractions());
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.linearGradientChooserPanel, "Center");
            this.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{resetBtn}), "South");
            this.revalidate();
        }
    }

    private static class ChartStyle {
        private int style;
        private String text;

        public ChartStyle(int style) {
            this.style = style;
            if (style == -1) {
                this.text = "(None)";
            } else if (2 == style) {
                this.text = "Line";
            } else if (4 == style) {
                this.text = "Point";
            } else if (64 == style) {
                this.text = "Bar";
            } else {
                System.err.println("Unknown style: " + style);
                this.style = -1;
                this.text = "(None)";
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChartStyle) {
                ChartStyle other = (ChartStyle)obj;
                return this.style == other.style;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.style;
            return result;
        }

        public String toString() {
            return this.text;
        }

        public static ChartStyle[] values() {
            return new ChartStyle[]{new ChartStyle(-1), new ChartStyle(2), new ChartStyle(4), new ChartStyle(64)};
        }
    }

    private static abstract class ButtonsCellEditorRenderer
    extends AbstractTableCellEditorRenderer
    implements CellRolloverSupport {
        private String text;

        public ButtonsCellEditorRenderer(String text) {
            this.text = text;
        }

        public void configureTableCellEditorRendererComponent(JTable table, Component editorRendererComponent, boolean forRenderer, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
            if (!forRenderer) {
                JButton removeButton = (JButton)((JPanel)editorRendererComponent).getComponent(0);
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ButtonsCellEditorRenderer.this.buttonClicked(row);
                    }
                });
            }
        }

        public Component createTableCellEditorRendererComponent(JTable table, int row, int column) {
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            panel.setOpaque(true);
            JButton button = new JButton(this.text);
            button.setOpaque(false);
            panel.add(button);
            return panel;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isRollover(JTable table, MouseEvent e, int row, int column) {
            return true;
        }

        protected abstract void buttonClicked(int var1);
    }
}

