/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.gui.AbstractComparisonComponent;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.GENEEDefaultListCellRenderer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.QuickListFilter;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

class MultiComparisonComponent
extends AbstractComparisonComponent {
    private JideSplitPane splitPane;
    private JPanel panel;
    private CheckBoxList[] lists;

    MultiComparisonComponent() {
    }

    @Override
    public JComponent getJComponent() {
        return this.panel;
    }

    @Override
    protected List<Combination>[] getSelectedCombinations() {
        List<Combination> c1 = MultiComparisonComponent.getSelectedClassCombinations(this.lists[0], this.project.getSortedFilteredDataset().getColumnMetadata());
        List<Combination> c2 = MultiComparisonComponent.getSelectedClassCombinations(this.lists[2], this.project.getSortedFilteredDataset().getColumnMetadata());
        return new List[]{c1, c2};
    }

    @Override
    protected void _setProject(Project project) {
        this.setMetadataNames(new ArrayList<String>(MetadataUtil.getNames(project.getOriginalDataset().getColumnMetadata())));
    }

    @Override
    protected List<String> getSelectedFields() {
        Object[] selection = this.lists[1].getCheckBoxListSelectedValues();
        ArrayList<String> selectedMetadataNames = new ArrayList<String>();
        for (Object obj : selection) {
            selectedMetadataNames.add((String)obj);
        }
        return selectedMetadataNames;
    }

    @Override
    protected void init() {
        this.splitPane = new JideSplitPane();
        this.lists = new CheckBoxList[3];
        this.addList(0, "Class A");
        this.addList(1, "Annotations");
        this.lists[1].getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultiComparisonComponent.this.updateCombinations();
            }
        });
        this.lists[1].getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultiComparisonComponent.this.updateCombinations();
            }
        });
        this.addList(2, "Class B");
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.splitPane);
        this.panel.add((Component)this.groupByFormBuilder.getPanel(), "South");
    }

    private void addList(int index, String label) {
        FilterableListModel listModel = new FilterableListModel();
        final CheckBoxList checkBoxList = new CheckBoxList((ListModel)((Object)listModel)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = Math.min(d.width, 300);
                return d;
            }
        };
        checkBoxList.setCellRenderer((ListCellRenderer)new GENEEDefaultListCellRenderer());
        checkBoxList.setVisibleRowCount(16);
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout("left:p", "p, p, top:p"));
        topPanel.add((Component)new JLabel(label), CC.xy((int)1, (int)1));
        topPanel.add((Component)new QuickListFilter((ListSelectionModel)checkBoxList.getCheckBoxListSelectionModel(), listModel){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        }.getComponent(), CC.xy((int)1, (int)2));
        final JCheckBox selectAllButton = new JCheckBox("(Select All)", false);
        selectAllButton.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectAllButton.isSelected()) {
                    checkBoxList.selectAll();
                } else {
                    checkBoxList.selectNone();
                }
            }
        });
        topPanel.add((Component)selectAllButton, CC.xy((int)1, (int)3));
        topPanel.setMinimumSize(new Dimension(0, 0));
        JScrollPane sp = UIUtil.createNoBorderScrollPane((Component)checkBoxList);
        sp.setMinimumSize(new Dimension(0, 0));
        sp.setMaximumSize(new Dimension(400, Integer.MAX_VALUE));
        JPanel panel = new JPanel((LayoutManager)new FormLayout("p:g", "top:p, top:p, top:p"));
        panel.setMinimumSize(new Dimension());
        panel.add((Component)topPanel, CC.xy((int)1, (int)1));
        panel.add((Component)sp, CC.xy((int)1, (int)2));
        if (index != 1) {
            final JComponent combine = this.createCombineCategoriesComponent(index == 0);
            combine.setVisible(checkBoxList.getCheckBoxListSelectedIndices().length > 1);
            checkBoxList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    combine.setVisible(checkBoxList.getCheckBoxListSelectedIndices().length > 1);
                    combine.invalidate();
                    combine.validate();
                    combine.repaint();
                }
            });
            combine.setMinimumSize(new Dimension());
            panel.add((Component)combine, CC.xy((int)1, (int)3));
        }
        this.lists[index] = checkBoxList;
        this.splitPane.add((Component)panel, (Object)CC.xy((int)(index + 1), (int)1));
    }

    private JComponent createCombineCategoriesComponent(final boolean classA) {
        ButtonGroupHelper bg = new ButtonGroupHelper();
        final JRadioButton intersectionBtn = bg.createRadioButton("AND");
        JRadioButton unionBtn = bg.createRadioButton("OR", true);
        bg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (classA) {
                    MultiComparisonComponent.this.classAIntersection = intersectionBtn.isSelected();
                } else {
                    MultiComparisonComponent.this.classBIntersection = intersectionBtn.isSelected();
                }
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Combine values:");
        formBuilder.add(intersectionBtn);
        formBuilder.nextSmallRow();
        formBuilder.add(unionBtn);
        return formBuilder.getPanel();
    }

    private void setMetadataNames(List<String> names) {
        Object[] selection0 = this.lists[0].getCheckBoxListSelectedValues();
        Object[] selection1 = this.lists[1].getCheckBoxListSelectedValues();
        Object[] selection2 = this.lists[2].getCheckBoxListSelectedValues();
        FilterableListModel model = (FilterableListModel)((Object)this.lists[1].getModel());
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        model.setItems(names);
        if (selection1 != null && selection1.length > 0) {
            this.lists[1].clearCheckBoxListSelection();
            this.lists[1].addCheckBoxListSelectedValues(selection1);
            this.lists[0].clearCheckBoxListSelection();
            this.lists[0].addCheckBoxListSelectedValues(selection0);
            this.lists[2].clearCheckBoxListSelection();
            this.lists[2].addCheckBoxListSelectedValues(selection2);
        } else if (this.firstTime && names.contains("pert_desc")) {
            this.lists[1].addCheckBoxListSelectedValue((Object)"pert_desc", true);
        }
    }

    private void updateCombinations() {
        List<String> selectedFields = this.getSelectedFields();
        Vector[] vectors = MetadataUtil.getVectors(this.project.getSortedFilteredDataset().getColumnMetadata(), selectedFields.toArray(new String[0]));
        List<Combination> combinations = VectorUtil.getCombinations(vectors);
        Object[] tmp = this.lists[0].getCheckBoxListSelectedValues();
        ((FilterableListModel)((Object)this.lists[0].getModel())).setItems(combinations);
        this.lists[0].setSelectedObjects(tmp);
        tmp = this.lists[2].getCheckBoxListSelectedValues();
        ((FilterableListModel)((Object)this.lists[2].getModel())).setItems(combinations);
        this.lists[2].setSelectedObjects(tmp);
        int[] locations = this.splitPane.getDividerLocations();
        this.lists[0].revalidate();
        this.lists[0].repaint();
        this.lists[2].revalidate();
        this.lists[2].repaint();
        this.splitPane.setDividerLocations(locations);
    }
}

