/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.swing.DefaultOverlayable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class OverlayHider {
    public OverlayHider(final DefaultOverlayable overlay, final JTextComponent textComponent) {
        textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                overlay.setOverlayVisible(OverlayHider.this.isEmpty(textComponent));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                overlay.setOverlayVisible(OverlayHider.this.isEmpty(textComponent));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                overlay.setOverlayVisible(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                overlay.setOverlayVisible(OverlayHider.this.isEmpty(textComponent));
            }
        });
    }

    private boolean isEmpty(JTextComponent textComponent) {
        return textComponent.getDocument().getLength() == 0 || textComponent.getText().trim().length() == 0;
    }
}

