/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class SliderPanel
extends JPanel {
    private JSlider slider;
    private TimerTextField textField;
    private float scale = 1.0f;
    private float value;
    private boolean updatingUsingTextField = true;

    public SliderPanel(float value, float min, float max, final float scale) {
        this.scale = scale;
        this.textField = new TimerTextField(){

            @Override
            public void update() {
                try {
                    SliderPanel.this.updatingUsingTextField = true;
                    float d = ParserHelper.parseFloat(this.getText().trim());
                    SliderPanel.this.setSliderFromText(d);
                    SliderPanel.this.updatingUsingTextField = false;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        int mappedMin = Math.round(min * scale);
        int mappedMax = Math.round(max * scale);
        int mappedValue = Math.round(value * scale);
        if (mappedValue > mappedMax) {
            mappedValue = mappedMax;
        }
        if (mappedValue < mappedMin) {
            mappedValue = mappedMin;
        }
        this.slider = new JSlider(mappedMin, mappedMax, mappedValue);
        this.setValue(value, false);
        this.updatingUsingTextField = false;
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.setLayout((LayoutManager)new FormLayout("pref, 6px, pref", "pref:none"));
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.slider, cc.xy(1, 1));
        this.add((Component)this.textField, cc.xy(3, 1));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SliderPanel.this.updatingUsingTextField && !((JSlider)e.getSource()).getValueIsAdjusting()) {
                    float value = (float)SliderPanel.this.slider.getValue() / scale;
                    SliderPanel.this.setTextFromSlider(value);
                }
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public float getValue() {
        return this.value;
    }

    public void setLabels(int[] tickMarks, int minorTickSpacing) {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        for (int tick : tickMarks) {
            String label = Formatter.format(tick);
            labels.put(Math.round((float)tick * this.scale), new JLabel(label, 0));
        }
        this.slider.setMinorTickSpacing(Math.round((float)minorTickSpacing * this.scale));
        this.slider.setLabelTable(labels);
    }

    public void setSliderFromText(float value) {
        this.slider.setValue(Math.round(value * this.scale));
        this.value = value;
        this.notifyListeners();
    }

    public void setTextFromSlider(float value) {
        this.textField.setText(Formatter.format(value));
        this.value = value;
        this.notifyListeners();
    }

    public void setValue(float value, boolean update) {
        this.updatingUsingTextField = true;
        this.slider.setValue(Math.round(value * this.scale));
        if (update) {
            this.textField.setText(Formatter.format(value));
        } else {
            this.textField.setTextNoUpdate(Formatter.format(value));
        }
        this.value = value;
        this.updatingUsingTextField = false;
    }

    private void notifyListeners() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent e = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

