/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JSplitPane;

public class SplitPaneSynchronizer
implements PropertyChangeListener {
    public static final String DIVIDER_LOCATION = "dividerLocation";
    private ArrayList<JSplitPane> splitPanes;

    public SplitPaneSynchronizer(JSplitPane ... splitPanes) {
        this.splitPanes = new ArrayList(splitPanes.length);
        for (JSplitPane splitPane : splitPanes) {
            this.addSplitPane(splitPane);
        }
    }

    public void addSplitPane(JSplitPane splitPane) {
        splitPane.addPropertyChangeListener(DIVIDER_LOCATION, this);
        this.splitPanes.add(splitPane);
    }

    public void removeSplitPane(JSplitPane splitPane) {
        splitPane.removePropertyChangeListener(DIVIDER_LOCATION, this);
        this.splitPanes.remove(splitPane);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JSplitPane source = (JSplitPane)e.getSource();
        int location = (Integer)e.getNewValue();
        for (JSplitPane splitPane : this.splitPanes) {
            splitPane.removePropertyChangeListener(DIVIDER_LOCATION, this);
        }
        for (JSplitPane splitPane : this.splitPanes) {
            if (splitPane == source || splitPane.getDividerLocation() == location) continue;
            splitPane.setDividerLocation(location);
        }
        for (JSplitPane splitPane : this.splitPanes) {
            splitPane.addPropertyChangeListener(DIVIDER_LOCATION, this);
        }
    }

    public int getDividerLocation() {
        return this.splitPanes.get(0).getDividerLocation();
    }
}

