/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.heatmap.AbstractQuickFilterPanel;

public class TableAutoComplete
extends DelimListDataIntelliHints {
    private TableModel tableModel;
    private AbstractQuickFilterPanel quickSearch;

    public TableAutoComplete(AbstractQuickFilterPanel qf, TableModel tableModel) {
        super(qf.getTextField());
        this.quickSearch = qf;
        this.tableModel = tableModel;
    }

    @Override
    public Collection<String> getMatches(String text) {
        boolean caseSensitive = this.isCaseSensitive();
        TreeSet<String> matches = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String field = this.quickSearch.getDefaultFilterColumnName();
        if (field.equals("All")) {
            int cols = this.tableModel.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                if (!String.class.isAssignableFrom(this.tableModel.getColumnClass(j))) continue;
                this.getMatches(j, caseSensitive, matches, text);
            }
        } else {
            int columnIndex = -1;
            int cols = this.tableModel.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                if (!field.equals(this.tableModel.getColumnName(j))) continue;
                columnIndex = j;
                break;
            }
            if (columnIndex != -1) {
                this.getMatches(columnIndex, caseSensitive, matches, text);
            }
        }
        this.getAdditionalMatches(field, caseSensitive, matches, text);
        return matches;
    }

    protected void getAdditionalMatches(String field, boolean caseSensitive, Set<String> matches, String text) {
    }

    private void getMatches(int columnIndex, boolean caseSensitive, Set<String> matches, String text) {
        int rows = this.tableModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String value;
            Object obj = this.tableModel.getValueAt(i, columnIndex);
            if (obj == null) continue;
            String _value = value = (String)obj;
            if (!caseSensitive) {
                _value = _value.toLowerCase();
            }
            if (!_value.startsWith(text)) continue;
            matches.add(value);
        }
    }
}

