/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class TextComponentListener {
    private Timer timer;
    private DocumentListener documentListener;
    private JTextComponent textComponent;

    public TextComponentListener(JTextComponent textComponent, int delay) {
        this.timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentListener.this.update();
            }
        });
        this.timer.setRepeats(false);
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextComponentListener.this.timer.stop();
                    TextComponentListener.this.update();
                }
            });
        }
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextComponentListener.this._start();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextComponentListener.this._start();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextComponentListener.this._start();
            }
        };
        this.textComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this.documentListener);
    }

    public void setTextNoUpdate(String text) {
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.textComponent.setText(text);
        this.textComponent.getDocument().addDocumentListener(this.documentListener);
    }

    protected abstract void update();

    private void _start() {
        if (!this.timer.isRunning()) {
            this.timer.restart();
        }
    }
}

