/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import ch.randelshofer.quaqua.QuaquaManager;
import com.google.common.base.Function;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.utils.Lm;
import gnu.trove.list.array.TIntArrayList;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.WindowManager;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.GENEEToolTipManager;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ReportErrorPanel;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.jdesktop.swingx.util.OS;

public class UIUtil {
    public static final int DEFAULT_FONT_SIZE = !GraphicsEnvironment.isHeadless() ? UIManager.getFont("Panel.font").getSize() : 13;
    public static final Color DRAG_OVER_COLOR = new Color(31, 119, 180);
    public static final String ELLIPSIS = "\u2026";
    public static final Color HIGHLIGHT_COLOR = new Color(243, 129, 53);
    public static final String INFO_WINDOW_TOOLTIPS_PROPERTY = "info.window.property";
    public static final Color LIGHT_BLUE = new Color(239, 239, 255);
    public static final String MICRO = "\u00b5";
    public static final String POWER_2 = "\u00b2";
    public static final String PROTOTYPE_CELL_VALUE = "AAAAAAAAAAAA";
    public static final Map<RenderingHints.Key, Object> RENDERING_HINTS;
    public static final Color SELECTION_COLOR;
    public static final String SIGMA = "\u03c3";
    public static final String TWO_SUBSCRIPT = "\u2082";
    private static final String fontName;
    private static Frame frame;
    private static Random random;
    private static long seed;
    private static boolean useInfoWindowForToolTips;

    private UIUtil() {
    }

    public static void addCloseWindowKeystroke(final GENEEWindow window) {
        int sc = UIUtil.getMenuShortcutKeyMask();
        KeyStroke ks = KeyStroke.getKeyStroke(87, sc);
        AbstractAction action = new AbstractAction("Close Dialog"){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
                window.dispose();
            }
        };
        window.getRootPane().getInputMap(0).put(ks, action.getValue("Name"));
        window.getRootPane().getInputMap(2).put(ks, action.getValue("Name"));
        window.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static void addCloseWindowKeystroke(final JFrame window) {
        int sc = UIUtil.getMenuShortcutKeyMask();
        KeyStroke ks = KeyStroke.getKeyStroke(87, sc);
        AbstractAction action = new AbstractAction("Close Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.dispose();
            }
        };
        window.getRootPane().getInputMap(0).put(ks, action.getValue("Name"));
        window.getRootPane().getInputMap(2).put(ks, action.getValue("Name"));
        window.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static void addKeyboardShortcut(JComponent c, Action action) {
        UIUtil.addKeyboardShortcut(c, action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    public static void addKeyboardShortcut(JComponent c, Action action, KeyStroke ks) {
        if (c != null) {
            int[] conditions;
            c.getActionMap().put(action.getValue("Name"), action);
            for (int condition : conditions = new int[]{1, 2, 0}) {
                InputMap inputMap = c.getInputMap(condition);
                inputMap.put(ks, action.getValue("Name"));
            }
        }
    }

    public static void addToWindow(Window window, Component c) {
        if (window instanceof JFrame) {
            ((JFrame)window).getContentPane().add(c);
        } else if (window instanceof JDialog) {
            ((JDialog)window).getContentPane().add(c);
        }
    }

    public static void applyRecursively(Component c, Function<? super Component, Void> function) {
        function.apply((Object)c);
        if (c instanceof Container) {
            Component[] children;
            Container j = (Container)c;
            for (Component child : children = j.getComponents()) {
                UIUtil.applyRecursively(child, function);
            }
        }
    }

    public static JPanel buildHelpOKCancelBar(JButton help, JButton ok, JButton cancel) {
        JPanel panel = ButtonBarFactory.buildHelpOKCancelBar((JButton)help, (JButton)ok, (JButton)cancel);
        return panel;
    }

    public static JPanel buildLeftRightAlignedBar(JComponent[] leftAlignedBtns, JComponent[] rightAlignedBtns) {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        if (leftAlignedBtns != null && leftAlignedBtns.length > 0) {
            builder.addButton(leftAlignedBtns);
        }
        builder.addRelatedGap();
        builder.addGlue();
        if (rightAlignedBtns != null && rightAlignedBtns.length > 0) {
            builder.addButton(rightAlignedBtns);
        }
        JPanel panel = builder.getPanel();
        return panel;
    }

    public static JPanel buildOKBar(JButton ok) {
        JPanel panel = ButtonBarFactory.buildOKBar((JButton)ok);
        return panel;
    }

    public static JPanel buildOKCancelApplyBar(JButton ok, JButton cancel, JButton apply) {
        JPanel panel = ButtonBarFactory.buildOKCancelApplyBar((JButton)ok, (JButton)cancel, (JButton)apply);
        return panel;
    }

    public static JPanel buildOKCancelBar(GENEEWindow dialog, ActionListener okListener) {
        return UIUtil.buildOKCancelBar(dialog, okListener, null);
    }

    public static JPanel buildOKCancelBar(final GENEEWindow dialog, ActionListener okListener, ActionListener cancelListener) {
        JButton cancel = new JButton("Cancel");
        JButton ok = new JButton("OK");
        if (cancelListener == null) {
            cancelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            };
        }
        cancel.addActionListener(cancelListener);
        ok.addActionListener(okListener);
        dialog.getRootPane().setDefaultButton(ok);
        JPanel panel = ButtonBarFactory.buildOKCancelBar((JButton)ok, (JButton)cancel);
        return panel;
    }

    public static JPanel buildOKCancelBar(JButton ok, JButton cancel) {
        JPanel panel = ButtonBarFactory.buildOKCancelBar((JButton)ok, (JButton)cancel);
        return panel;
    }

    public static void centerOnScreen(Component c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setLocation((screenSize.width - c.getWidth()) / 2, (screenSize.height - c.getHeight()) / 2);
    }

    public static void checkSize(GENEEWindow c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        boolean resize = false;
        Dimension size = new Dimension(c.getWidth(), c.getHeight());
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
            resize = true;
        }
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
            resize = true;
        }
        if (resize) {
            c.setSize(size.width, size.height);
        }
    }

    public static JLabel createBigLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() + 2.0f));
        return label;
    }

    public static JLabel createBoldLabel(String text) {
        JLabel l = new JLabel(text);
        l.setFont(l.getFont().deriveFont(1));
        return l;
    }

    public static Color createColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static String createColumnStringForFormLayout(int columns) {
        return UIUtil.createColumnStringForFormLayout("p", columns);
    }

    public static String createColumnStringForFormLayout(String columnString, int columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columnString);
            if (i == columns - 1) continue;
            sb.append(", 6px");
        }
        return sb.toString();
    }

    public static String createColumnStringForTwoColumnFormLayout() {
        return UIUtil.createColumnStringForTwoColumnFormLayout(OS.isMacOSX());
    }

    public static String createColumnStringForTwoColumnFormLayout(boolean rightAlignLabels) {
        return rightAlignLabels ? "right:pref, 6px, left:pref:g" : "left:pref, 6px, left:pref:g";
    }

    public static JComboBox createComboBox() {
        ListExComboBox cb = new ListExComboBox();
        return cb;
    }

    public static JComboBox createComboBox(ComboBoxModel m) {
        ListExComboBox cb = new ListExComboBox(m);
        return cb;
    }

    public static JComboBox createComboBox(Object[] items) {
        ListExComboBox cb = new ListExComboBox(items);
        return cb;
    }

    public static DocumentPane createDocumentPane(final DocumentPane.TabbedPaneCustomizer customizer) {
        DocumentPane documentPane = new DocumentPane();
        documentPane.setFloatingContainerCloseAction(1);
        documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

            public void customize(JideTabbedPane tabbedPane) {
                tabbedPane.setTabPlacement(1);
                tabbedPane.setHideOneTab(false);
                tabbedPane.setShowCloseButtonOnTab(true);
                tabbedPane.setTabEditingAllowed(true);
                tabbedPane.setBoldActiveTab(false);
                tabbedPane.setShowIconsOnTab(false);
                tabbedPane.setShowTabButtons(true);
                if (customizer != null) {
                    customizer.customize(tabbedPane);
                }
            }
        });
        documentPane.setFloatingAllowed(false);
        return documentPane;
    }

    public static JTextField createLabelLikeTextField(String s) {
        JTextField tf = new JTextField(s){

            @Override
            public void setBorder(Border b) {
            }
        };
        UIUtil.setLabelProperties(tf);
        return tf;
    }

    public static JTextField createLabelLikeTextField(String s, int columns) {
        JTextField tf = new JTextField(s, columns);
        UIUtil.setLabelProperties(tf);
        return tf;
    }

    public static JScrollPane createNoBorderScrollPane(Component c) {
        JScrollPane sp = new JScrollPane(c);
        sp.setBorder(null);
        return sp;
    }

    public static String createRowStringForFormLayout(int rows) {
        return UIUtil.createStringForFormLayout("8px", "pref", rows);
    }

    public static JScrollPane createScrollPane(Component c) {
        JScrollPane jsp = c != null ? new JScrollPane(c) : new JScrollPane();
        return jsp;
    }

    public static JLabel createSmallLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() - 2.0f));
        return label;
    }

    public static String createStringForFormLayout(String spacer, String size, int n) {
        if (spacer == null) {
            spacer = "6px";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
                sb.append(spacer);
                sb.append(", ");
            }
            sb.append(size);
        }
        return sb.toString();
    }

    public static JTabbedPane createTabbedPane() {
        JTabbedPane tp = new JTabbedPane();
        tp.putClientProperty("Quaqua.TabbedPane.shortenTabs", false);
        return tp;
    }

    public static ColumnSpec decodeColumnSpec(String encodedColumnSpec) {
        return ColumnSpec.decode((String)encodedColumnSpec);
    }

    public static RowSpec decodeRowSpec(String encodedRowSpec) {
        return RowSpec.decode((String)encodedRowSpec);
    }

    public static int drawRotatedString(Graphics2D g2, String s, int height) {
        g2.rotate(-1.5707963267948966);
        g2.translate(-height, 1);
        FontRenderContext frc = g2.getFontRenderContext();
        AttributedString as = new AttributedString(s);
        LineBreakMeasurer measurer = new LineBreakMeasurer(as.getIterator(), frc);
        int y = 0;
        while (measurer.getPosition() < s.length()) {
            TextLayout layout = measurer.nextLayout(height);
            y = (int)((float)y + layout.getAscent());
            layout.draw(g2, (int)((double)(height / 2) - layout.getBounds().getWidth() / 2.0), y);
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
        }
        g2.translate(height, 1);
        g2.rotate(1.5707963267948966);
        return y;
    }

    public static int drawWrappedString(Graphics2D g2, String s, int width) {
        FontRenderContext frc = g2.getFontRenderContext();
        AttributedString as = new AttributedString(s);
        LineBreakMeasurer measurer = new LineBreakMeasurer(as.getIterator(), frc);
        int y = 0;
        while (measurer.getPosition() < s.length()) {
            TextLayout layout = measurer.nextLayout(width);
            y = (int)((float)y + layout.getAscent());
            layout.draw(g2, (int)((double)(width / 2) - layout.getBounds().getWidth() / 2.0), y);
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
        }
        return y;
    }

    public static Frame getCurrentFrame() {
        if (frame != null) {
            return frame;
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        return UIUtil.getFrameForComponent(window);
    }

    public static String getFontName() {
        return fontName;
    }

    public static Frame getFrameForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return UIUtil.getFrameForComponent(parentComponent.getParent());
    }

    public static Dimension getMaximumWindowSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = UIUtil.getScreenInsets();
        int width = screenSize.width - insets.left - insets.right - 10;
        int height = screenSize.height - insets.top - insets.bottom - 10;
        return new Dimension(width, height);
    }

    public static JMenu getMenu(JMenuBar menuBar, String name) {
        int count = menuBar.getMenuCount();
        for (int i = 0; i < count; ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (!name.equals(menu.getText())) continue;
            return menu;
        }
        return null;
    }

    public static int getMenuShortcutKeyMask() {
        return GraphicsEnvironment.isHeadless() ? 0 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static Component getParent(Component parentComponent, Class<?> c) throws HeadlessException {
        if (parentComponent == null) {
            return parentComponent;
        }
        if (c.isAssignableFrom(parentComponent.getClass())) {
            return parentComponent;
        }
        return UIUtil.getParent(parentComponent.getParent(), c);
    }

    public static int getPixelsForInches(double inches) {
        double dotsPerInch = GraphicsEnvironment.isHeadless() ? 1.0 : (double)Toolkit.getDefaultToolkit().getScreenResolution();
        return (int)Math.floor(dotsPerInch * inches);
    }

    public static Insets getScreenInsets() {
        return Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public static JScrollPane getScrollPane(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof JScrollPane)) continue;
            return (JScrollPane)p;
        }
        return null;
    }

    public static int[] getSelectedIndices(ListSelectionModel listSelectionModel) {
        TIntArrayList list = new TIntArrayList();
        int min = listSelectionModel.getMinSelectionIndex();
        int max = listSelectionModel.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return list.toArray();
        }
        for (int i = min; i <= max; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            list.add(i);
        }
        return list.toArray();
    }

    public static Set<Object> getSelectedValues(ListSelectionModel listSelectionModel, ListModel listModel) {
        HashSet<Object> list = new HashSet<Object>();
        int min = listSelectionModel.getMinSelectionIndex();
        int max = listSelectionModel.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return list;
        }
        for (int i = min; i <= max; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            list.add(listModel.getElementAt(i));
        }
        return list;
    }

    public static int[] getSelection(ListSelectionModel selectionModel, int min, int max) {
        int size;
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return new int[0];
        }
        if (iMin < min) {
            iMin = min;
        }
        if (iMax > max) {
            iMax = max;
        }
        if ((size = 1 + (iMax - iMin)) <= 0) {
            return new int[0];
        }
        int[] rvTmp = new int[size];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        if (rv.length == 0) {
            return new int[0];
        }
        return rv;
    }

    public static final int getTabIndex(String title, JTabbedPane tabbedPane) {
        int tabs = tabbedPane.getTabCount();
        for (int i = 0; i < tabs; ++i) {
            if (!title.equals(tabbedPane.getTitleAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static Container getTopLevelAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Window) && !(p instanceof Applet) && !(p instanceof JInternalFrame)) continue;
            return (Container)p;
        }
        return null;
    }

    public static Set<Object> getUnselectedValues(ListSelectionModel checkBoxListSelectionModel, ListModel listModel) {
        HashSet<Object> set = new HashSet<Object>();
        int size = listModel.getSize();
        for (int i = 0; i < size; ++i) {
            if (checkBoxListSelectionModel.isSelectedIndex(i)) continue;
            set.add(listModel.getElementAt(i));
        }
        return set;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return UIUtil.getWindowForComponent(parentComponent.getParent());
    }

    public static int getWrappedStringHeight(FontRenderContext frc, String s, int totalWidth) {
        AttributedString as = new AttributedString(s);
        LineBreakMeasurer measurer = new LineBreakMeasurer(as.getIterator(), frc);
        int y = 0;
        while (measurer.getPosition() < s.length()) {
            TextLayout layout = measurer.nextLayout(totalWidth);
            y = (int)((float)y + layout.getAscent());
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
        }
        return y;
    }

    public static void insertAfter(JMenu menu, Action action, boolean separator) {
        int idx = -1;
        int size = menu.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!menu.getItem(i).getName().equals(action.getValue("Name"))) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        if (separator) {
            menu.insertSeparator(idx);
            ++idx;
        }
        menu.insert(action, idx);
    }

    public static Object invokeAndWait(Callable<?> callable) {
        if (EventQueue.isDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            MyRunnable r = new MyRunnable(callable);
            EventQueue.invokeAndWait(r);
            return r.value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void invokeAndWait(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void invokeLater(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public static void pack(final GENEEWindow dialog, final int minWidth, final int minHeight) {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.pack();
                Dimension size = new Dimension(dialog.getWidth(), dialog.getHeight());
                int _minWidth = minWidth;
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int maxWidth = screenSize.width;
                _minWidth = Math.min(_minWidth, maxWidth);
                if (dialog.getWidth() > maxWidth) {
                    size.width = maxWidth;
                }
                int maxHeight = screenSize.height;
                int _minHeight = minHeight;
                _minHeight = Math.min(maxHeight, _minHeight);
                if (dialog.getHeight() > maxHeight) {
                    size.height = maxHeight;
                }
                if (dialog.getWidth() < _minWidth) {
                    size.width = _minWidth;
                }
                if (dialog.getHeight() < _minHeight) {
                    size.height = _minHeight;
                }
                dialog.setSize(size.width, size.height);
            }
        });
    }

    public static float parseFloat(String text, String variableName) {
        try {
            return ParserHelper.parseFloat(text);
        }
        catch (NumberFormatException e) {
            UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), variableName + " is not a number.");
            throw new RuntimeException();
        }
    }

    public static Color[] rainbow(int n) {
        int start = 0;
        float end = (float)Math.max(1, n - 1) / (float)n;
        Color[] ret = new Color[n];
        float[] d = UIUtil.seqFloat(start, end, n);
        for (int i = start; i < n; ++i) {
            Color color;
            float hue = d[i] % 1.0f;
            ret[i] = color = Color.getHSBColor(hue, 1.0f, 1.0f);
        }
        return ret;
    }

    public static synchronized Color randomColor() {
        if (random == null) {
            random = new Random(seed);
        }
        return new Color((int)(random.nextFloat() * 255.0f), (int)(random.nextFloat() * 255.0f), (int)(random.nextFloat() * 255.0f));
    }

    public static void registerToolTip(JComponent c) {
        if (useInfoWindowForToolTips) {
            GENEEToolTipManager.sharedInstance().registerComponent(c);
            ToolTipManager.sharedInstance().unregisterComponent(c);
        } else {
            ToolTipManager.sharedInstance().registerComponent(c);
        }
    }

    public static String rep(String string, int ntimes, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ntimes; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static void revalidateAndRepaint(JComponent c) {
        c.revalidate();
        c.repaint();
    }

    public static void setChildrenEnabledRecursively(Component c, boolean b) {
        if (c instanceof Container) {
            Component[] children;
            Container j = (Container)c;
            for (Component child : children = c instanceof JMenu ? ((JMenu)j).getMenuComponents() : j.getComponents()) {
                child.setEnabled(b);
                UIUtil.setChildrenEnabledRecursively(child, b);
            }
        }
    }

    public static void setDialogBorder(JComponent c) {
        c.setBorder(BorderFactory.createEmptyBorder(12, 20, 20, 20));
    }

    public static void setElements(JComboBox comboBox, List<?> elements) {
        Object priorSelected = comboBox.getSelectedItem();
        comboBox.removeAllItems();
        if (elements != null) {
            for (Object e : elements) {
                comboBox.addItem(e);
            }
            if (priorSelected != null) {
                comboBox.setSelectedItem(priorSelected);
            } else if (comboBox.getItemCount() > 0) {
                comboBox.setSelectedIndex(0);
            }
        }
    }

    public static void setFrame(Frame frame) {
        UIUtil.frame = frame;
    }

    public static void setLabelProperties(JComponent c) {
        c.setOpaque(false);
        c.setFont(UIManager.getFont("Label.font"));
        c.setBackground(UIManager.getColor("Label.background"));
        c.setBorder(UIManager.getBorder("Label.border"));
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).setEditable(false);
            ((JTextComponent)c).setDisabledTextColor(UIManager.getColor("Label.foreground"));
        }
    }

    public static void setLookAndFeel() {
        UIUtil.verifyJideLicense();
        LookAndFeelFactory.addUIDefaultsCustomizer((LookAndFeelFactory.UIDefaultsCustomizer)new LookAndFeelFactory.UIDefaultsCustomizer(){

            public void customize(UIDefaults uiDefaults) {
            }
        });
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        if (OS.isWindows()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (OS.isMacOSX()) {
            try {
                HashSet<String> includes = new HashSet<String>();
                includes.add("ScrollPane");
                includes.add("ScrollBar");
                QuaquaManager.setIncludedUIs(includes);
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println("Unable to set the look and feel.");
            }
        } else {
            boolean setLookAndFeel = false;
            if (!setLookAndFeel) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.err.println("Unable to set the look and feel.");
                }
            }
        }
        UIManager.put("Table.selectionBackground", new ColorUIResource(new Color(182, 213, 253)));
        if (OS.isMacOSX()) {
            UIManager.put("SidePaneUI", "org.broadinstitute.genee.gui.AquaSidePaneUI");
        }
    }

    public static void setSelectedItemIgnoreCase(JComboBox comboBox, String item) {
        item = item.toLowerCase();
        int nitems = comboBox.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            String s;
            Object value = comboBox.getItemAt(i);
            String string = s = value != null ? value.toString().toLowerCase() : "";
            if (!item.equals(s)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static void setToMaximumPreferredWidth(JComponent ... components) {
        int max = 0;
        for (JComponent c : components) {
            max = Math.max(max, c.getPreferredSize().width);
        }
        for (JComponent c : components) {
            Dimension d = c.getPreferredSize();
            d.width = max;
            c.setPreferredSize(d);
        }
    }

    public static void setToMaximumWhenShown(JScrollPane sp) {
        final BoundedRangeModel model = sp.getVerticalScrollBar().getModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setValue(model.getMaximum());
                model.removeChangeListener(this);
            }
        });
    }

    public static void setWindowTitle(Window window, String title) {
        if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        }
    }

    public static void showBalloonTip(JComponent owner, String message) {
        BalloonTip tip = new BalloonTip((Component)new JLabel(message));
        tip.show(owner, 0, 0);
    }

    public static Color showColorDialog(Component component, String title, Color initialColor) {
        return JColorChooser.showDialog(component, title, initialColor);
    }

    public static void showDialog(final GENEEWindow dialog) {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.pack();
                Dimension size = new Dimension(dialog.getWidth(), dialog.getHeight());
                if (dialog.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width) {
                    size.width = Toolkit.getDefaultToolkit().getScreenSize().width;
                }
                if (dialog.getHeight() + 50 > Toolkit.getDefaultToolkit().getScreenSize().height) {
                    size.height = Toolkit.getDefaultToolkit().getScreenSize().height - 50;
                }
                dialog.setSize(size.width, size.height);
                dialog.setVisible(true);
            }
        });
    }

    public static void showErrorDialog(Component parent, String message) {
        UIUtil._showErrorDialog(UIUtil.getWindowForComponent(parent), message, "", null);
    }

    public static void showErrorDialog(Component parent, String message, String title) {
        UIUtil._showErrorDialog(UIUtil.getWindowForComponent(parent), message, title, null);
    }

    public static void showErrorDialog(Component parent, String message, String title, Throwable t) {
        UIUtil._showErrorDialog(UIUtil.getWindowForComponent(parent), message, title, t);
    }

    public static void showFrame(final Frame frame) {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setExtendedState(frame.getExtendedState() | 6);
                frame.setVisible(true);
            }
        });
    }

    public static void showInFrame(Component c) {
        WindowManager windowManager = Application.getWindowManager();
        if (windowManager == null) {
            windowManager = new DefaultWindowManager();
        }
        Application.setWindowManager(windowManager);
        windowManager.init();
        JFrame frame = (JFrame)windowManager.getWindow();
        frame.getContentPane().add(c);
        frame.setDefaultCloseOperation(3);
        UIUtil.showFrame(frame);
    }

    public static String showInputDialog(final Component parent, final String message, final String initialValue) {
        return (String)UIUtil.invokeAndWait(new Callable<String>(){

            @Override
            public String call() {
                return (String)JOptionPane.showInputDialog(parent, message, "", 3, IconManager.loadIcon("heatmap-64.gif"), null, initialValue);
            }
        });
    }

    public static void showMessageDialog(Component parent, Object message) {
        UIUtil._showMessageDialog(UIUtil.getWindowForComponent(parent), message, "");
    }

    public static boolean showOkCancelDialog(final Component parent, final Object message, final String title) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return JOptionPane.showOptionDialog(UIUtil.getWindowForComponent(parent), message, title, 2, 1, IconManager.loadIcon("heatmap-64.gif"), new Object[]{"OK", "Cancel"}, "OK") == 0;
            }
        };
        return (Boolean)UIUtil.invokeAndWait(callable);
    }

    public static boolean showOkCancelDialog(final Component parent, final String title, final Object message, final Object ok, final Object cancel) {
        return (Boolean)UIUtil.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return JOptionPane.showOptionDialog(UIUtil.getWindowForComponent(parent), message, title, 2, 1, IconManager.loadIcon("heatmap-64.gif"), new Object[]{ok, cancel}, ok) == 0;
            }
        });
    }

    public static void sizeToScreen(GENEEWindow window) {
        Dimension screenSize = UIUtil.getMaximumWindowSize();
        window.setSize(screenSize.width, screenSize.height);
    }

    public static void sizeToScreen(JDialog window) {
        Dimension screenSize = UIUtil.getMaximumWindowSize();
        window.setSize(screenSize.width, screenSize.height);
    }

    public static void standaloneInit() {
        if (!GraphicsEnvironment.isHeadless()) {
            ToolTipManager.sharedInstance().setInitialDelay(200);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        UIUtil.setLookAndFeel();
    }

    public static void syncDividerLocations(JideSplitPane ... splitPanes) {
        final JideSplitPane[] _splitPanes = splitPanes;
        PropertyChangeListener l = new PropertyChangeListener(){
            int size;
            {
                this.size = _splitPanes[0].getDividerLocation(0);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JideSplitPane splitPane = (JideSplitPane)evt.getSource();
                int[] locations = splitPane.getDividerLocations();
                int[] sizes = new int[locations.length];
                for (int i = 0; i < sizes.length; ++i) {
                    sizes[i] = i == 0 ? locations[i] : locations[i] - locations[i - 1];
                }
                int size = sizes[0];
                boolean found = false;
                for (int i = 0; i < sizes.length && !found; ++i) {
                    if (sizes[i] == this.size) continue;
                    this.size = size = sizes[i];
                    found = true;
                }
                int minSize = 2;
                if (size < minSize) {
                    size = minSize;
                }
                int i = 0;
                int location = size;
                while (i < locations.length) {
                    locations[i] = location;
                    ++i;
                    location += size;
                }
                for (JideSplitPane sp : _splitPanes) {
                    sp.removePropertyChangeListener("dividerLocation", (PropertyChangeListener)this);
                }
                for (JideSplitPane sp : _splitPanes) {
                    sp.setDividerLocations(locations);
                }
                for (JideSplitPane sp : _splitPanes) {
                    sp.addPropertyChangeListener("dividerLocation", (PropertyChangeListener)this);
                }
            }
        };
        for (JideSplitPane sp : splitPanes) {
            sp.addPropertyChangeListener("dividerLocation", l);
        }
    }

    public static String trim(String text, int maxchars) {
        if (text.length() >= maxchars) {
            text = text.substring(0, maxchars - 1 - ELLIPSIS.length()) + ELLIPSIS;
        }
        return text;
    }

    public static void unregisterToolTip(JComponent c) {
        if (useInfoWindowForToolTips) {
            GENEEToolTipManager.sharedInstance().unregisterComponent(c);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(c);
        }
    }

    public static void verifyJideLicense() {
        Lm.verifyLicense((String)"The Broad Institute, MIT", (String)"Gene Pattern", (String)"D.DQSR7z9m6fxL1IqWZ6svQFmE6vj3Q");
    }

    private static void _showErrorDialog(final Component parent, final String message, final String title, final Throwable t) {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (t == null) {
                    String m = message;
                    if (message != null && message.length() > 120) {
                        StyledLabel label = new StyledLabel(message);
                        label.setLineWrap(true);
                        m = label;
                    }
                    JOptionPane.showMessageDialog(parent, m, title, 0, IconManager.loadIcon("heatmap-64.gif"));
                    return;
                }
                JButton sendToTeam = new JButton("Send to " + Application.getName() + " Team");
                JButton closeBtn = new JButton("Close");
                final ReportErrorPanel errorPanel = new ReportErrorPanel();
                Preferences prefs = Preferences.userNodeForPackage(UIUtil.class);
                String email = prefs.get("email", "");
                if ("".equals(email)) {
                    errorPanel.setEmailAddress(email);
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)new JLabel(message), "Center");
                JOptionPane pane = new JOptionPane(p, 0, 0, IconManager.loadIcon("heatmap-64.gif"), new Object[]{sendToTeam, closeBtn}, null);
                p.add((Component)errorPanel, "South");
                final GENEEWindow dialog = Application.createDialog(title);
                dialog.getContentPane().add(pane);
                closeBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                sendToTeam.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                        final String email = errorPanel.getEmailAddress();
                        Preferences prefs = Preferences.userNodeForPackage(UIUtil.class);
                        if (email != null) {
                            prefs.put("email", email);
                        }
                        final String comments = errorPanel.getComments();
                        new BackgroundTask<Void>("Sending error"){

                            @Override
                            protected Void doInBackground() throws Exception {
                                String s;
                                StringBuilder buf = new StringBuilder();
                                buf.append("http://www.broadinstitute.org/cancer/software/" + Application.getName() + "/error.php?");
                                StringBuilder params = new StringBuilder();
                                params.append("comments=");
                                params.append(comments);
                                params.append("&email=");
                                params.append(email);
                                params.append("&stack=");
                                params.append(ToStringUtil.toString(t));
                                Application.Version version = Application.getVersion();
                                if (version != null) {
                                    params.append("&version=");
                                    params.append(version.versionString + " " + version.date);
                                }
                                URLConnection conn = new URL(buf.toString()).openConnection();
                                conn.setDoOutput(true);
                                conn.setDefaultUseCaches(false);
                                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                                out.write(params.toString());
                                out.close();
                                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                while ((s = in.readLine()) != null) {
                                }
                                in.close();
                                return null;
                            }
                        }.execute();
                    }
                });
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    private static void _showMessageDialog(final Component parent, final Object message, final String title) {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, message, title, 1, IconManager.loadIcon("heatmap-64.gif"));
            }
        });
    }

    private static float[] seqFloat(float start, float stop, int length) {
        float[] a = new float[length];
        float d = (stop - start) / (float)(length - 1);
        for (int i = 0; i < length; ++i) {
            a[i] = (float)i * d;
        }
        return a;
    }

    static {
        SELECTION_COLOR = new Color(182, 213, 253);
        seed = 129381209L;
        useInfoWindowForToolTips = true;
        UIManager.put("Slider.paintValue", false);
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RENDERING_HINTS = Collections.unmodifiableMap(map);
        fontName = OS.isMacOSX() ? UIManager.getFont("Panel.font").getFontName() : "Helvetica";
        String prop = System.getProperty(INFO_WINDOW_TOOLTIPS_PROPERTY);
        if (prop != null && !(useInfoWindowForToolTips = Boolean.valueOf(prop).booleanValue())) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }
    }

    private static class MyRunnable
    implements Runnable {
        private Callable<?> callable;
        private Object value;

        private MyRunnable(Callable<?> c) {
            this.callable = c;
        }

        @Override
        public void run() {
            try {
                this.value = this.callable.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

