/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.clustering.cc.CC;
import org.broadinstitute.genee.clustering.cc.ClusteringAlgorithm;
import org.broadinstitute.genee.clustering.cc.HCLClusterer;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.kmeans.KMeansClusterer;
import org.broadinstitute.genee.clustering.som.SOMClusterer;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.ClusteringActionUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.DefaultInputLabel;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowColumnNorm;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class CCAlgorithmAction
extends AbstractInputAction {
    private static final String NORMALIZATION = "Normalization";
    private static final String ITERATIONS = "Iterations";
    private static final String LINKAGE_METHOD = "Linkage method";
    private static final String DISTANCE_METRIC = "Distance metric";
    private static final String CLUSTER_ROWS_OR_COLUMNS = "Cluster";
    private static final String CLUSTERING_ALGORITHM = "Clustering algorithm";
    private static final String RESAMPLING_ITERATIONS = "Resampling iterations";
    private static final String NUMBER_OF_CLUSTERS = "Number of clusters";
    private static final String RANDOM_NUMBER_GENERATOR_SEED = "Random number generator seed";
    public static final BasicMapEntry[] NORMALIZATION_OPTIONS = new BasicMapEntry[]{new BasicMapEntry<Integer>("Row-wise", 0), new BasicMapEntry<Integer>("Column-wise", 1), new BasicMapEntry<Integer>("Both", 2), new BasicMapEntry<Integer>("None", 3)};

    public CCAlgorithmAction() {
        super("Consensus Clustering");
        this.addParameter(NUMBER_OF_CLUSTERS, new TextFieldInputParameter("2-5"), true);
        this.addParameter(RESAMPLING_ITERATIONS, new IntegerInputParameter(20), true);
        final ComboBoxParameter clusteringComboBox = (ComboBoxParameter)this.addParameter(CLUSTERING_ALGORITHM, new ComboBoxParameter((Object[])new BasicMapEntry[]{new BasicMapEntry<Integer>("Hierarchical", 0), new BasicMapEntry<Integer>("KMeans", 1)}, 0), false);
        this.addParameter(CLUSTER_ROWS_OR_COLUMNS, new ComboBoxParameter((Object[])new BasicMapEntry[]{new BasicMapEntry<Boolean>("Rows", true), new BasicMapEntry<Boolean>("Columns", false)}, 1), false);
        final ComboBoxParameter similarityMetricComboBox = new ComboBoxParameter((Object[])ClusteringActionUtil.DISTANCE_METRICS, ClusteringActionUtil.PEARSON);
        final DefaultInputLabel similarityMetricLabel = this.addIndentedParameter(DISTANCE_METRIC, similarityMetricComboBox, false, 1);
        final ComboBoxParameter linkageMethodComboBox = new ComboBoxParameter((Object[])new LinkageMethod[]{LinkageMethod.SINGLE_LINKAGE, LinkageMethod.COMPLETE_LINKAGE, LinkageMethod.AVERAGE_LINKAGE}, (Object)LinkageMethod.AVERAGE_LINKAGE);
        final DefaultInputLabel linkageMethodLabel = this.addIndentedParameter(LINKAGE_METHOD, linkageMethodComboBox, false, 1);
        final IntegerInputParameter iterationsTextField = new IntegerInputParameter(2000);
        final DefaultInputLabel iterationsLabel = this.addIndentedParameter(ITERATIONS, iterationsTextField, false, 1);
        this.addParameter(NORMALIZATION, new ComboBoxParameter((Object[])NORMALIZATION_OPTIONS, 0), false);
        this.addParameter(RANDOM_NUMBER_GENERATOR_SEED, new IntegerInputParameter(779948241), false);
        iterationsTextField.setEnabled(false);
        iterationsLabel.setEnabled(false);
        clusteringComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = clusteringComboBox.getSelectedIndex();
                linkageMethodComboBox.setEnabled(selection == 0);
                linkageMethodLabel.setEnabled(linkageMethodComboBox.isEnabled());
                iterationsTextField.setEnabled(selection != 0);
                iterationsLabel.setEnabled(iterationsTextField.isEnabled());
                similarityMetricComboBox.setEnabled(selection != 2);
                similarityMetricLabel.setEnabled(similarityMetricComboBox.isEnabled());
            }
        });
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        Dataset dataset = (Dataset)map.get("dataset");
        CC cc = new CC();
        cc.setNumberOfClusters(IOUtil.rangeToIntArray((String)map.get(NUMBER_OF_CLUSTERS)));
        cc.setResamplingIterations((Integer)map.get(RESAMPLING_ITERATIONS));
        DistanceFunction distanceFunction = null;
        if (map.get(DISTANCE_METRIC) != null) {
            distanceFunction = (DistanceFunction)((BasicMapEntry)map.get(DISTANCE_METRIC)).getValue();
        }
        int clusteringAlgorithm = (Integer)((BasicMapEntry)map.get(CLUSTERING_ALGORITHM)).getValue();
        ClusteringAlgorithm clusterer = null;
        if (clusteringAlgorithm == 0) {
            clusterer = new HCLClusterer();
            ((HCLClusterer)clusterer).setLinkageMethod((LinkageMethod)((Object)map.get(LINKAGE_METHOD)));
            clusterer.setDistanceFunction(distanceFunction);
        } else if (clusteringAlgorithm == 1) {
            clusterer = new KMeansClusterer();
        } else if (clusteringAlgorithm == 2) {
            clusterer = new SOMClusterer();
            clusterer.setDistanceFunction(distanceFunction);
        }
        Integer maxIter = (Integer)map.get(ITERATIONS);
        if (maxIter != null) {
            clusterer.setIterations(maxIter);
        }
        clusterer.setDistanceFunction(distanceFunction);
        dataset = CCAlgorithmAction.normalize((Integer)((BasicMapEntry)map.get(NORMALIZATION)).getValue(), dataset);
        boolean clusterRows = (Boolean)((BasicMapEntry)map.get(CLUSTER_ROWS_OR_COLUMNS)).getValue();
        dataset = !clusterRows ? DatasetUtil.transposeView(dataset) : dataset;
        cc.setSeed((Integer)map.get(RANDOM_NUMBER_GENERATOR_SEED));
        cc.setClusterer(clusterer);
        cc.setDataset(dataset);
        cc.execute();
        Project parentProject = (Project)map.get("project");
        List<Dataset> resultDatasets = cc.getResultDatasets();
        List<Dendrogram> dendrograms = cc.getDendrograms();
        ComponentCustomizer c = new ComponentCustomizer(){

            @Override
            public boolean inherits() {
                return false;
            }

            @Override
            public void customize(Component c) {
                HeatMapPanel p = (HeatMapPanel)c;
                p.getColorScheme().setGlobalMinMode(2, 0.0f);
                p.getColorScheme().setGlobalMaxMode(2, 1.0f);
                p.getColorScheme().setColors(new Color[]{Color.WHITE, Color.RED});
            }
        };
        ViewableGENEETreeNode[] results = new ViewableGENEETreeNode[resultDatasets.size()];
        History history = this.getHistory(map);
        for (int i = 0; i < resultDatasets.size(); ++i) {
            DefaultProject p = new DefaultProject(resultDatasets.get(i), null, dendrograms.get(i), clusterRows ? parentProject.getRowColorModel() : parentProject.getColumnColorModel(), !clusterRows ? parentProject.getColumnColorModel() : parentProject.getRowColorModel());
            results[i] = new ProjectGENEEResultTreeNode((Project)p, history, c);
        }
        if (results.length == 1) {
            return results[0];
        }
        int[] numberOfClusters = cc.getNumberOfClusters();
        MutableTreeNode[] folders = new GENEEFolderNode[numberOfClusters.length];
        for (int i = 0; i < numberOfClusters.length; ++i) {
            folders[i] = new GENEEFolderNode("" + numberOfClusters[i], history, results[i]);
        }
        return new GENEEFolderNode((String)map.get("Operation"), history, folders);
    }

    public static Dataset normalize(int normalization, Dataset dataset) {
        if (normalization != 3) {
            RowMajorArray2DDataset copy = DatasetUtil.deepCopy(dataset);
            if (normalization == 0) {
                DatasetRowColumnNorm.rowNormalize(copy);
            } else if (normalization == 1) {
                DatasetRowColumnNorm.columnNormalize(copy);
            } else {
                DatasetRowColumnNorm.allNormalize(copy);
            }
            dataset = copy;
        }
        return dataset;
    }
}

