/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.broadinstitute.genee.gui.actions.ToolRunner;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.ToStringUtil;

public class CommandLineRunner {
    public static void setHeadless(boolean b) {
        System.setProperty("java.awt.headless", String.valueOf(b));
    }

    public static Project[] execute(String[] args) throws Exception {
        String actionName = args[0];
        ToolRunner runner = new ToolRunner(actionName, ProjectIO.readProject(args[1]));
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            String[] keyVal = arg.split("=");
            runner.setParameterValue(keyVal[0], keyVal[1]);
        }
        return runner.execute();
    }

    public static void main(String[] args) {
        File dir = null;
        try {
            if (args.length == 0) {
                System.out.println("className dataFile key=val...");
                System.exit(0);
            }
            Project[] projects = CommandLineRunner.execute(args);
            dir = IOUtil.getUniqueFile(new File(".").getCanonicalPath(), args[0].replace('/', '_').replace(' ', '_'), "");
            dir.delete();
            dir.mkdirs();
            for (int i = 0; i < projects.length; ++i) {
                Project p = projects[i];
                File f = new File(dir, p.getOriginalDataset().getName());
                ProjectIO.writeProject(p, "gctx", f.getCanonicalPath(), true);
                System.out.println("Wrote " + f);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            try {
                File f = IOUtil.getUniqueFile(dir.getCanonicalPath(), "stderr", ".txt");
                Files.write((CharSequence)ToStringUtil.toString(x), (File)f, (Charset)Charset.defaultCharset());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

