/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.HCLClusterHelper;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.AbstractMoleculeDistanceFunction;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.ClusteringActionUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.DefaultInputLabel;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.CityBlock;
import org.broadinstitute.genee.math.stat.function.bivariate.CosineSimilarity;
import org.broadinstitute.genee.math.stat.function.bivariate.EuclideanDistance;
import org.broadinstitute.genee.math.stat.function.bivariate.KendallsTau;
import org.broadinstitute.genee.math.stat.function.bivariate.OneMinusPearsonCorrelation;
import org.broadinstitute.genee.math.stat.function.bivariate.SpearmanDistance;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public abstract class DistanceMatrixAction
extends AbstractInputAction {
    public static final String DISTANCE_FUNCTION = "Metric";
    public static BivariateFloatListFunction[] FUNCTIONS = new BivariateFloatListFunction[]{new OneMinusPearsonCorrelation(){

        @Override
        public String toString() {
            return "Pearson correlation";
        }
    }, new SpearmanDistance(){

        @Override
        public String toString() {
            return "Spearman rank correlation";
        }
    }, new KendallsTau(), new EuclideanDistance(), new CityBlock(), new CosineSimilarity()};
    private static final String CLUSTER_MATRIX = "Cluster the distance/similarity matrix";
    private static final String COLUMN_DISTANCE_MATRIX_ROW_SPACE = "Compute distance/similarity matrix in space of selected rows only";
    private static final String GROUP_BY = "Group by";
    private static final String GROUP_COLUMNS_ENABLED = "Group columns in heat map";
    private static final String GROUP_ROWS_ENABLED = "Group rows in heat map";
    private static final String INCLUDE_SELECTED_COLUMNS = "Include selected columns only";
    private static final String INCLUDE_SELECTED_ROWS = "Include selected rows only";
    private static final String ROW_DISTANCE_MATRIX_COLUMN_SPACE = "Compute distance/similarity matrix in space of selected columns only";
    private static final String LINKAGE_METHOD = "Linkage method";
    private static final String DATASET_ON_COLUMNS = "Dataset along columns";
    private static final String DATASET_ON_ROWS = "Dataset along rows";
    private ComboBoxParameter distanceFunctionsComboBox;
    private CheckBoxListParameter groupByParameter;
    private boolean row;
    private ComboBoxParameter linkageComboBox;
    private ComboBoxParameter datasetOnColumnsComboBox;
    private ComboBoxParameter datasetOnRowsComboBox;
    private static final String COLUMNS_PREFIX = "columns.";
    private static final String ROWS_PREFIX = "rows.";
    private static final String DISTANCE_FUNCTION_NAME = "distance.function.name";
    private ProjectGENEEResultTreeNode node;

    public DistanceMatrixAction(boolean row) {
        super((row ? "Row" : "Column") + " Distance/Similarity Matrix");
        this.row = row;
        this.distanceFunctionsComboBox = new ComboBoxParameter((Object[])FUNCTIONS, FUNCTIONS[0]);
        this.datasetOnRowsComboBox = new ComboBoxParameter(String.class);
        this.datasetOnColumnsComboBox = new ComboBoxParameter(String.class);
        this.addParameter(DISTANCE_FUNCTION, this.distanceFunctionsComboBox, false);
        if (row) {
            this.addParameter(new HiddenInputLabel(INCLUDE_SELECTED_ROWS), new CheckBoxParameter(INCLUDE_SELECTED_ROWS), false);
            this.addParameter(new HiddenInputLabel(ROW_DISTANCE_MATRIX_COLUMN_SPACE), new CheckBoxParameter(ROW_DISTANCE_MATRIX_COLUMN_SPACE), false);
        } else {
            this.addParameter(new HiddenInputLabel(INCLUDE_SELECTED_COLUMNS), new CheckBoxParameter(INCLUDE_SELECTED_COLUMNS), false);
            this.addParameter(new HiddenInputLabel(COLUMN_DISTANCE_MATRIX_ROW_SPACE), new CheckBoxParameter(COLUMN_DISTANCE_MATRIX_ROW_SPACE), false);
        }
        final CheckBoxParameter clusterCheckBox = new CheckBoxParameter(CLUSTER_MATRIX, true);
        clusterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistanceMatrixAction.this.linkageComboBox.setEnabled(clusterCheckBox.isSelected());
            }
        });
        this.addParameter(new HiddenInputLabel(CLUSTER_MATRIX), clusterCheckBox, false);
        this.linkageComboBox = new ComboBoxParameter((Object[])new LinkageMethod[]{LinkageMethod.SINGLE_LINKAGE, LinkageMethod.COMPLETE_LINKAGE, LinkageMethod.AVERAGE_LINKAGE}, (Object)LinkageMethod.AVERAGE_LINKAGE);
        this.addIndentedParameter(LINKAGE_METHOD, this.linkageComboBox, false, 1);
        this.addGroupBy();
        this.getInputPanelBuilder().setVisible(DATASET_ON_ROWS, false);
        this.getInputPanelBuilder().setVisible(DATASET_ON_COLUMNS, false);
        this.addParameter(DATASET_ON_ROWS, this.datasetOnRowsComboBox, false);
        this.addParameter(DATASET_ON_COLUMNS, this.datasetOnColumnsComboBox, false);
    }

    @Override
    public boolean beforeWindowShown() {
        GENEETreeNode tmp;
        if (this.node == null && (tmp = Application.getWindowManager().getNode()) instanceof ProjectGENEEResultTreeNode) {
            this.node = (ProjectGENEEResultTreeNode)tmp;
        }
        List linked = this.node.getGroup() != null ? this.node.getGroup().getChildNodes() : Collections.EMPTY_LIST;
        ArrayList<ProjectGENEEResultTreeNode> linkedProjects = new ArrayList<ProjectGENEEResultTreeNode>();
        if (linked.size() == 0) {
            linkedProjects.add(this.node);
        }
        for (ProjectGENEEResultTreeNode p : linked) {
            linkedProjects.add(p);
        }
        Collections.sort(linkedProjects, new Comparator<ProjectGENEEResultTreeNode>(){

            @Override
            public int compare(ProjectGENEEResultTreeNode o1, ProjectGENEEResultTreeNode o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        Object selection1 = this.datasetOnRowsComboBox.getSelectedItem();
        Object selection2 = this.datasetOnColumnsComboBox.getSelectedItem();
        this.datasetOnRowsComboBox.removeAllItems();
        this.datasetOnColumnsComboBox.removeAllItems();
        for (ProjectGENEEResultTreeNode p : linkedProjects) {
            this.datasetOnRowsComboBox.addItem(p);
            this.datasetOnColumnsComboBox.addItem(p);
        }
        Project project = this.node.getProject();
        this.datasetOnRowsComboBox.setSelectedItem(selection1 != null ? selection1 : project);
        this.datasetOnColumnsComboBox.setSelectedItem(selection2 != null ? selection2 : project);
        this.getInputPanelBuilder().setVisible(DATASET_ON_ROWS, linkedProjects.size() > 1);
        this.getInputPanelBuilder().setVisible(DATASET_ON_COLUMNS, linkedProjects.size() > 1);
        String[] rowFields = MetadataUtil.getNames(project.getOriginalDataset().getRowMetadata()).toArray(new String[0]);
        Arrays.sort(rowFields, String.CASE_INSENSITIVE_ORDER);
        this.groupByParameter.init(rowFields);
        if (UserUtil.isBroadUser()) {
            try {
                ClusteringActionUtil.addMoleculeMetrics((JComboBox)((Object)this.distanceFunctionsComboBox), this.row ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata());
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
        return true;
    }

    @Override
    protected void customizeMap(Project project, Map<String, Object> map) {
        ProjectGENEEResultTreeNode alongRows = (ProjectGENEEResultTreeNode)this.datasetOnRowsComboBox.getSelectedItem();
        ProjectGENEEResultTreeNode alongColumns = (ProjectGENEEResultTreeNode)this.datasetOnColumnsComboBox.getSelectedItem();
        this.addToMap(alongRows.getProject(), map, ROWS_PREFIX);
        if (alongRows != alongColumns) {
            this.addToMap(alongColumns.getProject(), map, COLUMNS_PREFIX);
        }
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        Dataset datasetOnColumns;
        Object distanceFunction = map.get(DISTANCE_FUNCTION);
        final Dataset datasetOnRows = (Dataset)map.get("rows.dataset");
        Dataset dataset = datasetOnColumns = map.get("columns.dataset") != null ? (Dataset)map.get("columns.dataset") : datasetOnRows;
        if (datasetOnRows == datasetOnColumns && datasetOnRows.getRowCount() < 2) {
            throw new RuntimeException("Please select at least two " + (this.row ? "rows" : "columns"));
        }
        RowMajorArray2DDataset distanceDataset = new RowMajorArray2DDataset(datasetOnRows == datasetOnColumns ? datasetOnRows.getName() : datasetOnRows.getName() + "-" + datasetOnColumns.getName(), datasetOnRows.getRowCount(), datasetOnColumns.getRowCount());
        if (distanceFunction instanceof BivariateFloatListFunction) {
            BivariateFloatListFunction f = (BivariateFloatListFunction)map.get(DISTANCE_FUNCTION);
            map.put(DISTANCE_FUNCTION_NAME, f.toString());
            DatasetRowView datasetOnRowsView = new DatasetRowView(datasetOnRows);
            DatasetRowView datasetOnColumnsView = new DatasetRowView(datasetOnColumns);
            int n = datasetOnRows.getRowCount();
            for (int i = 0; i < n; ++i) {
                datasetOnRowsView.setIndex(i);
                for (int j = 0; j <= i; ++j) {
                    datasetOnColumnsView.setIndex(j);
                    float dist = f.evaluate(datasetOnRowsView, datasetOnColumnsView);
                    distanceDataset.setValue(i, j, dist);
                    distanceDataset.setValue(j, i, dist);
                }
            }
        } else {
            BasicMapEntry option = (BasicMapEntry)distanceFunction;
            map.put(DISTANCE_FUNCTION_NAME, option.toString());
            MoleculeUtil.fillDistanceMatrix(datasetOnRows, distanceDataset, (AbstractMoleculeDistanceFunction)option.getValue());
        }
        final boolean groupBy = this.row ? (Boolean)map.get(GROUP_ROWS_ENABLED) : (Boolean)map.get(GROUP_COLUMNS_ENABLED);
        Object[] groupByArray = (Object[])(groupBy ? map.get(GROUP_BY) : null);
        String[] groupByFields = null;
        if (groupByArray != null && groupByArray.length > 0) {
            groupByFields = new String[groupByArray.length];
            for (int i = 0; i < groupByArray.length; ++i) {
                groupByFields[i] = (String)groupByArray[i];
            }
        }
        boolean clusterMatrix = (Boolean)map.get(CLUSTER_MATRIX);
        distanceDataset.setRowMetadata(datasetOnRows.getRowMetadata());
        if (datasetOnRows == datasetOnColumns) {
            distanceDataset.setColumnMetadata(distanceDataset.getRowMetadata());
        } else {
            distanceDataset.setColumnMetadata(datasetOnColumns.getRowMetadata());
        }
        Dataset _distanceDataset = distanceDataset;
        Dendrogram rowDendrogram = null;
        Dendrogram columnDendrogram = null;
        if (clusterMatrix) {
            int i;
            LinkageMethod linkageMethod = (LinkageMethod)((Object)map.get(LINKAGE_METHOD));
            float[][] distanceMatrix = new float[distanceDataset.getRowCount()][];
            int n = distanceDataset.getRowCount();
            for (i = 1; i < n; ++i) {
                distanceMatrix[i] = new float[i];
            }
            for (i = 1; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    distanceMatrix[i][j] = distanceDataset.getValue(i, j);
                }
            }
            HCLClusterHelper clusterHelper = new HCLClusterHelper(distanceDataset, distanceMatrix, null, null, false, groupByFields, linkageMethod, null, clusterMatrix, null, null);
            final Map<Identifier, TIntArrayList> groupByToRowIndices = clusterHelper.getGroupByToRowIndices();
            ComponentCustomizer c = new ComponentCustomizer(){

                @Override
                public void customize(Component c) {
                    final HeatMapPanel p = (HeatMapPanel)c;
                    p.getColorScheme().setGlobalMinMode(0);
                    p.getColorScheme().setGlobalMaxMode(0);
                    SizesAndPositionsListener sizesAndPositionsListener = new SizesAndPositionsListener(){

                        @Override
                        public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                            SizesAndPositions other;
                            p.getRowSizesAndPositions().removeSizesAndPositionsListener(this);
                            p.getColumnSizesAndPositions().removeSizesAndPositionsListener(this);
                            SizesAndPositions source = (SizesAndPositions)e.getSource();
                            SizesAndPositions sizesAndPositions = other = source == p.getColumnSizesAndPositions() ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                            if (e.isLengthChanged()) {
                                other.setLength(source.getLength());
                            } else if (e.isSpacesChanged()) {
                                other.setSpaceSizes(source.getSpaceSizes());
                            } else if (e.isSizeChanged()) {
                                other.setSize(source.getSize());
                            }
                            other.notifyListeners(e != null ? e.getType() : 4);
                            p.getRowSizesAndPositions().addSizesAndPositionsListener(this);
                            p.getColumnSizesAndPositions().addSizesAndPositionsListener(this);
                        }
                    };
                    SizesAndPositions rowSizes = p.getRowSizesAndPositions();
                    SizesAndPositions columnSizes = p.getColumnSizesAndPositions();
                    if (groupBy) {
                        float[] spaces = new float[rowSizes.getLength()];
                        int index = 0;
                        for (Identifier group : groupByToRowIndices.keySet()) {
                            TIntArrayList indicesForGroup = (TIntArrayList)groupByToRowIndices.get(group);
                            spaces[(index += indicesForGroup.size()) - 1] = 10.0f;
                        }
                        rowSizes.setSpaceSizes(spaces);
                        rowSizes.notifyListeners(2);
                        columnSizes.setSpaceSizes(spaces);
                        columnSizes.notifyListeners(2);
                    }
                    if (datasetOnRows == datasetOnColumns) {
                        rowSizes.addSizesAndPositionsListener(sizesAndPositionsListener);
                        columnSizes.addSizesAndPositionsListener(sizesAndPositionsListener);
                    }
                }

                @Override
                public boolean inherits() {
                    return false;
                }
            };
            map.put("customizer", c);
            rowDendrogram = clusterHelper.getRowDendrogram();
            columnDendrogram = clusterHelper.getColumnDendrogram();
            if (columnDendrogram == null) {
                columnDendrogram = rowDendrogram;
            }
            _distanceDataset = DatasetUtil.sliceView(distanceDataset, clusterHelper.getRowOrder(), clusterHelper.getColumnOrder() == null ? clusterHelper.getRowOrder() : clusterHelper.getColumnOrder());
            map.put("rows.dataset", DatasetUtil.sliceView(datasetOnRows, clusterHelper.getRowOrder(), null));
            if (datasetOnColumns != datasetOnRows) {
                map.put("columns.dataset", DatasetUtil.sliceView(datasetOnColumns, clusterHelper.getColumnOrder(), null));
            }
        }
        if (distanceFunction instanceof OneMinusPearsonCorrelation || distanceFunction instanceof SpearmanDistance) {
            int nrows = distanceDataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncols = distanceDataset.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    float value = -distanceDataset.getValue(i, j) + 1.0f;
                    distanceDataset.setValue(i, j, value);
                }
            }
        }
        DefaultProject project = new DefaultProject(DatasetUtil.shallowCopy(_distanceDataset));
        project.setRowDendrogram(rowDendrogram);
        project.setColumnDendrogram(columnDendrogram);
        map.remove("rows.dataset");
        ComponentCustomizer cc = (ComponentCustomizer)map.remove("customizer");
        History history = this.getHistory(map);
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode((Project)project, history, cc);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }

    private void addGroupBy() {
        final CheckBoxParameter groupByCheckBox = new CheckBoxParameter(this.row ? GROUP_ROWS_ENABLED : GROUP_COLUMNS_ENABLED);
        this.addParameter(new HiddenInputLabel(this.row ? GROUP_ROWS_ENABLED : GROUP_COLUMNS_ENABLED), groupByCheckBox, false);
        this.groupByParameter = new CheckBoxListParameter();
        final DefaultInputLabel groupByLabel = this.addIndentedParameter(GROUP_BY, this.groupByParameter, false, 1);
        groupByLabel.setEnabled(false);
        this.groupByParameter.getJComponent().setEnabled(false);
        UIUtil.setChildrenEnabledRecursively(this.groupByParameter.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
        groupByCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistanceMatrixAction.this.groupByParameter.getJComponent().setEnabled(groupByCheckBox.isSelected());
                UIUtil.setChildrenEnabledRecursively(DistanceMatrixAction.this.groupByParameter.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
                groupByLabel.setEnabled(groupByCheckBox.isSelected());
            }
        });
    }

    private void addToMap(Project p, Map<String, Object> map, String keyPrefix) {
        Dataset dataset;
        map.put(keyPrefix + "project", p);
        if (this.row) {
            int[] columnIndices;
            int[] rowIndices = (Boolean)map.get(INCLUDE_SELECTED_ROWS) != false ? p.getRowSelectionModel().getSelectedModelIndices() : p.getModelRowIndices(false, false);
            int[] nArray = columnIndices = (Boolean)map.get(ROW_DISTANCE_MATRIX_COLUMN_SPACE) != false ? p.getColumnSelectionModel().getSelectedModelIndices() : p.getModelColumnIndices(false, false);
            if (rowIndices != null && rowIndices.length == 0) {
                rowIndices = IOUtil.seqInt(p.getOriginalDataset().getRowCount());
            }
            if (columnIndices != null && columnIndices.length == 0) {
                columnIndices = IOUtil.seqInt(p.getOriginalDataset().getColumnCount());
            }
            dataset = DatasetUtil.sliceView(p.getOriginalDataset(), rowIndices, columnIndices);
        } else {
            int[] columnIndices;
            int[] rowIndices = (Boolean)map.get(COLUMN_DISTANCE_MATRIX_ROW_SPACE) != false ? p.getRowSelectionModel().getSelectedModelIndices() : p.getModelRowIndices(false, false);
            int[] nArray = columnIndices = (Boolean)map.get(INCLUDE_SELECTED_COLUMNS) != false ? p.getColumnSelectionModel().getSelectedModelIndices() : p.getModelColumnIndices(false, false);
            if (rowIndices != null && rowIndices.length == 0) {
                rowIndices = IOUtil.seqInt(p.getOriginalDataset().getRowCount());
            }
            if (columnIndices != null && columnIndices.length == 0) {
                columnIndices = IOUtil.seqInt(p.getOriginalDataset().getColumnCount());
            }
            dataset = DatasetUtil.sliceView(p.getOriginalDataset(), rowIndices, columnIndices);
        }
        if (!this.row) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        map.put(keyPrefix + "dataset", dataset);
    }

    private static class DistanceMatrixDisplay {
        private DistanceMatrixDisplay(Project distanceMatrixProject, Map<String, Object> map, boolean row) {
        }
    }
}

