/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.HCLClusterHelper;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.ClusteringActionUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HierarchicalClusteringAction
extends AbstractInputAction {
    private static final String CLUSTER_COLUMNS = "Cluster columns";
    private static final String CLUSTER_COLUMNS_ROW_SPACE = "Cluster columns in space of selected rows only";
    private static final String CLUSTER_ROWS = "Cluster rows";
    private static final String CLUSTER_ROWS_COLUMN_SPACE = "Cluster rows in space of selected columns only";
    private static final String COLUMN_DIST_METRIC = "Column distance metric";
    private static final String COLUMNS_CLUSTER_SELECTED_COLUMNS = "Cluster selected columns only";
    private static final String GROUP_COLUMNS_BY = "Group columns by";
    private static final String GROUP_COLUMNS_ENABLED = "Group columns";
    private static final String GROUP_ROWS_BY = "Group rows by";
    private static final String GROUP_ROWS_ENABLED = "Group rows";
    private static final String LINKAGE_METHOD = "Linkage method";
    private static final String ROW_DIST_METRIC = "Row distance metric";
    private static final String ROWS_CLUSTER_SELECTED_ROWS = "Cluster selected rows only";
    private static final String SELECTED_COLUMN_INDICES_KEY = "Selected column indices";
    private static final String SELECTED_ROW_INDICES_KEY = "Selected row indices";
    private CheckBoxListParameter columnMetadataSelectorParameter;
    private ComboBoxParameter columnMetricComboBox;
    private CheckBoxListParameter rowMetadataSelectorParameter;
    private ComboBoxParameter rowMetricComboBox;

    public HierarchicalClusteringAction() {
        super("Hierarchical Clustering");
        this.putValue("ShortDescription", "Hierarchical clustering");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/hcl.png"));
        ArrayList<BasicMapEntry<DistanceFunction>> columnMetrics = new ArrayList<BasicMapEntry<DistanceFunction>>();
        columnMetrics.addAll(Arrays.asList(ClusteringActionUtil.DISTANCE_METRICS));
        ArrayList<BasicMapEntry<DistanceFunction>> rowMetrics = new ArrayList<BasicMapEntry<DistanceFunction>>();
        rowMetrics.addAll(Arrays.asList(ClusteringActionUtil.DISTANCE_METRICS));
        this.columnMetricComboBox = new ComboBoxParameter((Object[])columnMetrics.toArray(new BasicMapEntry[0]), ClusteringActionUtil.PEARSON);
        this.rowMetricComboBox = new ComboBoxParameter((Object[])rowMetrics.toArray(new BasicMapEntry[0]), ClusteringActionUtil.PEARSON);
        CheckBoxParameter clusterColumnsCheckBox = new CheckBoxParameter(CLUSTER_COLUMNS, true);
        this.addParameter(new HiddenInputLabel(CLUSTER_COLUMNS), clusterColumnsCheckBox, true);
        this.addParameter(COLUMN_DIST_METRIC, this.columnMetricComboBox, false);
        this.columnMetadataSelectorParameter = ClusteringActionUtil.addClusterOptionsParameters(this, GROUP_COLUMNS_ENABLED, GROUP_COLUMNS_BY, COLUMNS_CLUSTER_SELECTED_COLUMNS, CLUSTER_COLUMNS_ROW_SPACE, COLUMN_DIST_METRIC, clusterColumnsCheckBox, new String[0]);
        this.getInputPanelBuilder().getFormBuilder().addSeparator();
        CheckBoxParameter clusterRowsCheckBox = new CheckBoxParameter(CLUSTER_ROWS, false);
        this.addParameter(new HiddenInputLabel(CLUSTER_ROWS), clusterRowsCheckBox, true);
        this.addParameter(ROW_DIST_METRIC, this.rowMetricComboBox, false);
        this.rowMetadataSelectorParameter = ClusteringActionUtil.addClusterOptionsParameters(this, GROUP_ROWS_ENABLED, GROUP_ROWS_BY, ROWS_CLUSTER_SELECTED_ROWS, CLUSTER_ROWS_COLUMN_SPACE, ROW_DIST_METRIC, clusterRowsCheckBox, new String[0]);
        this.getInputPanelBuilder().getFormBuilder().addSeparator();
        this.addParameter(LINKAGE_METHOD, new ComboBoxParameter((Object[])new LinkageMethod[]{LinkageMethod.SINGLE_LINKAGE, LinkageMethod.COMPLETE_LINKAGE, LinkageMethod.AVERAGE_LINKAGE}, (Object)LinkageMethod.AVERAGE_LINKAGE), false);
    }

    @Override
    public boolean beforeWindowShown() {
        Project project = Application.getProject();
        String[] rowFields = MetadataUtil.getNames(project.getOriginalDataset().getRowMetadata()).toArray(new String[0]);
        Arrays.sort(rowFields, String.CASE_INSENSITIVE_ORDER);
        this.rowMetadataSelectorParameter.init(rowFields);
        String[] columnFields = MetadataUtil.getNames(project.getOriginalDataset().getColumnMetadata()).toArray(new String[0]);
        Arrays.sort(columnFields, String.CASE_INSENSITIVE_ORDER);
        this.columnMetadataSelectorParameter.init(columnFields);
        if (UserUtil.isBroadUser()) {
            try {
                ClusteringActionUtil.addMoleculeMetrics((JComboBox)((Object)this.rowMetricComboBox), project.getOriginalDataset().getRowMetadata());
                ClusteringActionUtil.addMoleculeMetrics((JComboBox)((Object)this.columnMetricComboBox), project.getOriginalDataset().getColumnMetadata());
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
        return true;
    }

    @Override
    protected void customizeMap(Project p, Map<String, Object> map) {
        boolean getSelectedRows;
        boolean getSelectedColumns;
        boolean bl = getSelectedColumns = (Boolean)map.get(COLUMNS_CLUSTER_SELECTED_COLUMNS) != false || (Boolean)map.get(CLUSTER_ROWS_COLUMN_SPACE) != false;
        if (getSelectedColumns) {
            map.put(SELECTED_COLUMN_INDICES_KEY, p.getColumnSelectionModel().getSelectedViewIndices());
        }
        boolean bl2 = getSelectedRows = (Boolean)map.get(ROWS_CLUSTER_SELECTED_ROWS) != false || (Boolean)map.get(CLUSTER_COLUMNS_ROW_SPACE) != false;
        if (getSelectedRows) {
            map.put(SELECTED_ROW_INDICES_KEY, p.getRowSelectionModel().getSelectedViewIndices());
        }
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        int i;
        int length;
        TIntArrayList indices;
        boolean columnsGrouped;
        LinkageMethod linkageMethod = (LinkageMethod)((Object)map.get(LINKAGE_METHOD));
        BasicMapEntry rowMetricObject = (BasicMapEntry)map.get(ROW_DIST_METRIC);
        BasicMapEntry columnMetricObject = (BasicMapEntry)map.get(COLUMN_DIST_METRIC);
        boolean rowsGrouped = (Boolean)map.get(GROUP_ROWS_ENABLED);
        Object[] groupRowsByArray = (Object[])(rowsGrouped ? map.get(GROUP_ROWS_BY) : null);
        String[] groupRowsByField = null;
        if (groupRowsByArray != null && groupRowsByArray.length > 0) {
            groupRowsByField = new String[groupRowsByArray.length];
            for (int i2 = 0; i2 < groupRowsByArray.length; ++i2) {
                groupRowsByField[i2] = (String)groupRowsByArray[i2];
            }
        }
        Object[] groupColumnsByArray = (Object[])((columnsGrouped = ((Boolean)map.get(GROUP_COLUMNS_ENABLED)).booleanValue()) ? map.get(GROUP_COLUMNS_BY) : null);
        String[] groupColumnsByField = null;
        if (groupColumnsByArray != null && groupColumnsByArray.length > 0) {
            groupColumnsByField = new String[groupColumnsByArray.length];
            for (int i3 = 0; i3 < groupColumnsByArray.length; ++i3) {
                groupColumnsByField[i3] = (String)groupColumnsByArray[i3];
            }
        }
        Dataset filteredSortedDataset = (Dataset)map.get("dataset");
        int[] rowsToCluster = (int[])map.remove(SELECTED_ROW_INDICES_KEY);
        int[] columnsToCluster = (int[])map.remove(SELECTED_COLUMN_INDICES_KEY);
        if (rowsToCluster != null && rowsToCluster.length == 0) {
            rowsToCluster = null;
        }
        if (columnsToCluster != null && columnsToCluster.length == 0) {
            columnsToCluster = null;
        }
        if (rowsToCluster != null && rowsToCluster.length <= 1) {
            throw new RuntimeException("Please select more than one row.");
        }
        if (columnsToCluster != null && columnsToCluster.length <= 1) {
            throw new RuntimeException("Please select more than one column.");
        }
        Dendrogram rowDendrogram = null;
        int[] reorderedRowIndices = null;
        Map<Identifier, TIntArrayList> groupByToRowIndices = null;
        if (rowMetricObject != null) {
            Dataset selectedDataset = DatasetUtil.sliceView(filteredSortedDataset, rowsToCluster, (int[])((Boolean)map.get(CLUSTER_ROWS_COLUMN_SPACE) != false ? columnsToCluster : null));
            HCLClusterHelper c = new HCLClusterHelper(selectedDataset, rowMetricObject != null ? (DistanceFunction)rowMetricObject.getValue() : null, groupRowsByField, linkageMethod, null, null, null);
            rowDendrogram = c.getRowDendrogram();
            reorderedRowIndices = c.getRowOrder();
            groupByToRowIndices = c.getGroupByToRowIndices();
        }
        Dendrogram columnDendrogram = null;
        int[] reorderedColumnIndices = null;
        Map<Identifier, TIntArrayList> groupByToColumnIndices = null;
        if (columnMetricObject != null) {
            Dataset selectedDataset = DatasetUtil.sliceView(filteredSortedDataset, (int[])((Boolean)map.get(CLUSTER_COLUMNS_ROW_SPACE) != false ? rowsToCluster : null), columnsToCluster);
            HCLClusterHelper c = new HCLClusterHelper(selectedDataset, null, null, null, columnMetricObject != null ? (DistanceFunction)columnMetricObject.getValue() : null, groupColumnsByField, linkageMethod);
            columnDendrogram = c.getColumnDendrogram();
            reorderedColumnIndices = c.getColumnOrder();
            groupByToColumnIndices = c.getGroupByToColumnIndices();
        }
        if (rowsToCluster != null && reorderedRowIndices != null) {
            indices = new TIntArrayList();
            length = reorderedRowIndices.length;
            for (int i4 = 0; i4 < length; ++i4) {
                indices.add(rowsToCluster[reorderedRowIndices[i4]]);
            }
            TIntHashSet selectedRowIndicesSet = new TIntHashSet(rowsToCluster);
            int rows = filteredSortedDataset.getRowCount();
            for (i = 0; i < rows; ++i) {
                if (selectedRowIndicesSet.contains(i)) continue;
                indices.add(i);
            }
            reorderedRowIndices = indices.toArray();
        }
        if (columnsToCluster != null && reorderedColumnIndices != null) {
            indices = new TIntArrayList();
            length = reorderedColumnIndices.length;
            for (int i5 = 0; i5 < length; ++i5) {
                indices.add(columnsToCluster[reorderedColumnIndices[i5]]);
            }
            TIntHashSet set = new TIntHashSet(columnsToCluster);
            int cols = filteredSortedDataset.getColumnCount();
            for (i = 0; i < cols; ++i) {
                if (set.contains(i)) continue;
                indices.add(i);
            }
            reorderedColumnIndices = indices.toArray();
        }
        final Map<Identifier, TIntArrayList> _groupByToRowIndices = groupByToRowIndices;
        final Map<Identifier, TIntArrayList> _groupByToColumnIndices = groupByToColumnIndices;
        final String[] _groupRowsByField = groupRowsByField;
        final String[] _groupColumnsByField = groupColumnsByField;
        ComponentCustomizer componentCustomizer = new ComponentCustomizer(){

            @Override
            public void customize(Component c) {
                TIntArrayList indicesForGroup;
                int index;
                float[] spaces;
                HeatMapPanel p = (HeatMapPanel)c;
                if (_groupRowsByField != null) {
                    SizesAndPositions rowSizes = p.getRowSizesAndPositions();
                    spaces = new float[rowSizes.getLength()];
                    index = 0;
                    for (Identifier group : _groupByToRowIndices.keySet()) {
                        indicesForGroup = (TIntArrayList)_groupByToRowIndices.get(group);
                        spaces[(index += indicesForGroup.size()) - 1] = 10.0f;
                    }
                    rowSizes.setSpaceSizes(spaces);
                }
                if (_groupColumnsByField != null) {
                    SizesAndPositions columnSizes = p.getColumnSizesAndPositions();
                    spaces = new float[columnSizes.getLength()];
                    index = 0;
                    for (Identifier group : _groupByToColumnIndices.keySet()) {
                        indicesForGroup = (TIntArrayList)_groupByToColumnIndices.get(group);
                        spaces[(index += indicesForGroup.size()) - 1] = 10.0f;
                    }
                    columnSizes.setSpaceSizes(spaces);
                    columnSizes.notifyListeners(2);
                }
            }

            @Override
            public boolean inherits() {
                return false;
            }
        };
        History history = this.getHistory(map);
        Dataset reorderedDataset = DatasetUtil.shallowCopy(DatasetUtil.sliceView(filteredSortedDataset, reorderedRowIndices, reorderedColumnIndices));
        if (rowDendrogram != null) {
            String[] leafNodeIds = rowDendrogram.getLeafNodeIds();
            reorderedDataset.getRowMetadata().add("gene id", String.class);
            int geneIdMetadataIndex = reorderedDataset.getRowMetadata().getMetadataCount() - 1;
            Vector v = reorderedDataset.getRowMetadata().get(geneIdMetadataIndex);
            int nrows = leafNodeIds.length;
            for (int j = 0; j < nrows; ++j) {
                v.setValue(j, leafNodeIds[j]);
            }
        }
        DefaultProject newProject = new DefaultProject(reorderedDataset, rowDendrogram, null, (Project)map.get("project"));
        if (columnDendrogram != null) {
            String[] leafNodeIds = columnDendrogram.getLeafNodeIds();
            reorderedDataset.getColumnMetadata().add("array id", String.class);
            int arrayIdMetadataIndex = reorderedDataset.getColumnMetadata().getMetadataCount() - 1;
            Vector v = reorderedDataset.getColumnMetadata().get(arrayIdMetadataIndex);
            int ncols = leafNodeIds.length;
            for (int j = 0; j < ncols; ++j) {
                v.setValue(j, leafNodeIds[j]);
            }
            newProject.setColumnDendrogram(columnDendrogram);
        }
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode((Project)newProject, history, componentCustomizer);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

