/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import chemaxon.struc.Molecule;
import java.net.URL;
import java.util.Date;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.compound.MolarConcentration;

public enum MetadataDataType {
    NUMBER("Number"),
    TEXT("Text"),
    URL("URL"),
    DATE("Date"),
    MOLECULE("Molecule"),
    MOLAR_CONCENTRATION("Molar Concentration");

    private String string;

    private MetadataDataType(String string2) {
        this.string = string2;
    }

    public String toString() {
        return this.string;
    }

    public static MetadataDataType[] getAllowedValues() {
        MetadataDataType[] metadataDataTypeArray;
        if (UserUtil.isBroadUser()) {
            MetadataDataType[] metadataDataTypeArray2 = new MetadataDataType[6];
            metadataDataTypeArray2[0] = NUMBER;
            metadataDataTypeArray2[1] = TEXT;
            metadataDataTypeArray2[2] = URL;
            metadataDataTypeArray2[3] = DATE;
            metadataDataTypeArray2[4] = MOLECULE;
            metadataDataTypeArray = metadataDataTypeArray2;
            metadataDataTypeArray2[5] = MOLAR_CONCENTRATION;
        } else {
            MetadataDataType[] metadataDataTypeArray3 = new MetadataDataType[5];
            metadataDataTypeArray3[0] = NUMBER;
            metadataDataTypeArray3[1] = TEXT;
            metadataDataTypeArray3[2] = URL;
            metadataDataTypeArray3[3] = DATE;
            metadataDataTypeArray = metadataDataTypeArray3;
            metadataDataTypeArray3[4] = MOLAR_CONCENTRATION;
        }
        return metadataDataTypeArray;
    }

    public static Class<?> getClass(MetadataDataType type) {
        if (type.equals((Object)NUMBER)) {
            return Float.class;
        }
        if (type.equals((Object)TEXT)) {
            return String.class;
        }
        if (type.equals((Object)DATE)) {
            return Date.class;
        }
        if (type.equals((Object)URL)) {
            return URL.class;
        }
        if (type.equals((Object)MOLECULE)) {
            return Molecule.class;
        }
        if (type.equals((Object)MOLAR_CONCENTRATION)) {
            return MolarConcentration.class;
        }
        return String.class;
    }

    public static MetadataDataType getType(Class<?> c) {
        if (Number.class.isAssignableFrom(c)) {
            return NUMBER;
        }
        if (String.class.isAssignableFrom(c)) {
            return TEXT;
        }
        if (Date.class.isAssignableFrom(c)) {
            return DATE;
        }
        if (URL.class.isAssignableFrom(c)) {
            return URL;
        }
        if (Molecule.class.isAssignableFrom(c)) {
            return MOLECULE;
        }
        if (MolarConcentration.class.isAssignableFrom(c)) {
            return MOLAR_CONCENTRATION;
        }
        return TEXT;
    }
}

