/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.compound.CurveFittingAction;
import org.broadinstitute.genee.gui.AbstractGenericInputAction;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.BreadthFirstEnumeration;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.AdjustDataAction;
import org.broadinstitute.genee.gui.actions.CCAlgorithmAction;
import org.broadinstitute.genee.gui.actions.CollapseDatasetAction;
import org.broadinstitute.genee.gui.actions.ColumnDistanceMatrixAction;
import org.broadinstitute.genee.gui.actions.HierarchicalClusteringAction;
import org.broadinstitute.genee.gui.actions.HypergeometricAction;
import org.broadinstitute.genee.gui.actions.KMeansAction;
import org.broadinstitute.genee.gui.actions.MarkerSelectionAction;
import org.broadinstitute.genee.gui.actions.NewHeatMapAction;
import org.broadinstitute.genee.gui.actions.NullWindowManager;
import org.broadinstitute.genee.gui.actions.RowDistanceMatrixAction;
import org.broadinstitute.genee.gui.actions.TransposeAction;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.InputParameterUtils;
import org.broadinstitute.genee.heatmap.DisplayInfo;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;

public class ToolRunner {
    private static HashMap<String, Class<AbstractGenericInputAction>> nameToClass;
    private AbstractGenericInputAction action;
    private Map inputMap;

    public ToolRunner(String name, Project project) {
        this.action = ToolRunner.getAction(name);
        this.action.setRunInBackground(false);
        ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(project, new DisplayInfo(new JPanel()), new History(this.action.toString()));
        Application.getWindowManager().setNode(node);
        this.action.beforeWindowShown();
    }

    public Project[] execute() throws Exception {
        this.inputMap = this.action.createInputMap();
        String operation = (String)this.action.getValue("Name");
        if (operation != null && operation.endsWith("\u2026")) {
            operation = operation.substring(0, operation.length() - "\u2026".length());
        }
        this.inputMap.put("Operation", operation);
        Object result = this.action.execute(this.inputMap);
        return result instanceof MutableTreeNode ? ToolRunner.getProjects((MutableTreeNode)result) : null;
    }

    public Map getInputMap() {
        return this.inputMap;
    }

    public void setParameterValue(String key, Object value) {
        InputParameter<?> p = this.action.getInputPanelBuilder().getInputParameter(key);
        if (p == null) {
            throw new IllegalArgumentException(key + " not found.");
        }
        p.setValueFromString(InputParameterUtils.toStringValue(value));
    }

    public static AbstractGenericInputAction getAction(String actionName) {
        try {
            return nameToClass.get(actionName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Project[] getProjects(MutableTreeNode node) {
        BreadthFirstEnumeration e = new BreadthFirstEnumeration(node);
        ArrayList<Project> projects = new ArrayList<Project>();
        while (e.hasMoreElements()) {
            TreeNode next = e.nextElement();
            if (!(next instanceof ProjectGENEEResultTreeNode)) continue;
            projects.add(((ProjectGENEEResultTreeNode)next).getProject());
        }
        return projects.toArray(new Project[0]);
    }

    public static void show(HeatMapPanel heatMapPanel) {
        if (!GraphicsEnvironment.isHeadless()) {
            History map = new History("R Import");
            DisplayInfo displayInfo = new DisplayInfo(heatMapPanel, null);
            ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(heatMapPanel.getProject(), displayInfo, map);
            Application.add(new GENEEFolderNode("R Import", node.getAuditTrail().last(), node));
            UIUtil.getCurrentFrame().setVisible(true);
        }
    }

    private static void registerActions() {
        Class[] actions = new Class[]{CurveFittingAction.class, AdjustDataAction.class, CCAlgorithmAction.class, CollapseDatasetAction.class, RowDistanceMatrixAction.class, ColumnDistanceMatrixAction.class, HierarchicalClusteringAction.class, HypergeometricAction.class, KMeansAction.class, MarkerSelectionAction.class, NewHeatMapAction.class, TransposeAction.class};
        nameToClass = new HashMap();
        for (Class c : actions) {
            try {
                AbstractInputAction action = (AbstractInputAction)c.newInstance();
                nameToClass.put(action.getName(), c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("org.broadinstitute.genee.commandLine", "true");
        UIUtil.standaloneInit();
        System.setProperty("org.broadinstitute.genee.application.exit", "false");
        NullWindowManager windowManager = new NullWindowManager();
        Application.setWindowManager(windowManager);
        windowManager.init();
        Application.init(null);
        ToolRunner.registerActions();
    }
}

