/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.jidesoft.combobox.ListExComboBox;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.util.Formatter;

public class ComboBoxParameter
extends ListExComboBox
implements InputParameter {
    private Class<?> c;

    public ComboBoxParameter(Class<?> c) {
        this.c = c;
    }

    @Override
    public Class<?> getValueClass() {
        return this.c;
    }

    public ComboBoxParameter(Object[] choices, int selectedIndex) {
        if (choices != null) {
            for (Object choice : choices) {
                this.addItem(choice);
            }
        }
        if (selectedIndex >= 0) {
            this.setSelectedIndex(selectedIndex);
        } else if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public ComboBoxParameter(Object[] choices, Object defaultValue) {
        if (choices != null) {
            for (Object choice : choices) {
                this.addItem(choice);
            }
        }
        if (defaultValue != null) {
            this.setSelectedItem(defaultValue);
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    public Object getParameterValue() {
        return !this.isEnabled() ? null : this.getSelectedItem();
    }

    @Override
    public void init(Object obj) {
        this.removeAllItems();
        if (obj != null) {
            Object[] value = (Object[])obj;
            for (int i = 0; i < value.length; ++i) {
                this.addItem(value[i]);
            }
        }
    }

    @Override
    public void setValueFromString(String s) {
        int index = -1;
        int cc = this.getItemCount();
        for (int i = 0; i < cc; ++i) {
            String itemText = Formatter.toString(this.getItemAt(i));
            if (!s.equals(itemText)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.setSelectedIndex(index);
        } else {
            System.out.println("Unable to find value for " + s);
        }
    }
}

