/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import org.broadinstitute.genee.gui.parameters.AbstractTextFieldInputParameter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class FloatInputParameter
extends AbstractTextFieldInputParameter<Float> {
    public FloatInputParameter() {
    }

    public FloatInputParameter(float value) {
        super(Formatter.format(value));
    }

    @Override
    public Float getParameterValue() {
        if (this.isEnabled()) {
            return Float.valueOf(ParserHelper.parseFloat(this.getText().trim()));
        }
        return null;
    }

    @Override
    public Class<?> getValueClass() {
        return Float.class;
    }

    @Override
    public void init(Object value) {
        this.setText(Formatter.format((Float)value));
    }

    @Override
    public void setValueFromString(String s) {
        this.setText(s);
    }
}

