/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.jidesoft.swing.StyledLabel;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputLabel;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.InputParameterUtils;
import org.broadinstitute.genee.gui.parameters.ValidationException;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;

public class InputPanelBuilder {
    private FormBuilder formBuilder;
    private Set<String> optionalParameters = new HashSet<String>();
    private Map<String, ParameterWrapper> parameterNameToParameterInput;

    public InputPanelBuilder() {
        this.formBuilder = new FormBuilder();
        this.parameterNameToParameterInput = new LinkedHashMap<String, ParameterWrapper>();
        this.formBuilder.nextRow();
    }

    public void add(InputLabel inputLabel, InputParameter<?> input, boolean required) {
        this.add(inputLabel, input, null, required, false);
    }

    public void add(InputLabel inputLabel, InputParameter<?> input, String description, boolean required) {
        this.add(inputLabel, input, description, required, false);
    }

    public void add(InputLabel inputLabel, InputParameter<?> input, String description, boolean required, boolean spanAllColumns) {
        Component inputLabelComponent = inputLabel.getComponent();
        if (inputLabelComponent != null) {
            this.formBuilder.addFirstColumn(inputLabelComponent);
        }
        if (spanAllColumns) {
            this.formBuilder.addSpanned(input.getJComponent());
        } else {
            this.formBuilder.add(input.getJComponent());
        }
        StyledLabel descriptionComponent = null;
        if (description != null) {
            StyledLabel descriptionLabel = new StyledLabel(" " + description);
            descriptionLabel.setLineWrap(true);
            descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(descriptionLabel.getFont().getSize2D() - 2.0f));
            descriptionComponent = descriptionLabel;
        }
        this.parameterNameToParameterInput.put(inputLabel.getName(), new ParameterWrapper(input, inputLabel, (JComponent)descriptionComponent));
        if (!required) {
            this.optionalParameters.add(inputLabel.getName());
        }
        if (descriptionComponent != null) {
            this.formBuilder.nextRowNoSpace();
            this.formBuilder.add((Component)descriptionComponent);
        }
        this.formBuilder.nextRow();
    }

    public void addIndentedParameter(InputLabel inputLabel, InputParameter<?> input, boolean required, int level) {
        FormBuilder builder = new FormBuilder();
        builder.setIndentedBorder(level);
        builder.nextRow();
        Component inputLabelComponent = inputLabel.getComponent();
        if (inputLabelComponent != null) {
            builder.addFirstColumn(inputLabelComponent);
        }
        builder.add(input.getJComponent());
        this.parameterNameToParameterInput.put(inputLabel.getName(), new ParameterWrapper(input, inputLabel, null));
        if (!required) {
            this.optionalParameters.add(inputLabel.getName());
        }
        this.formBuilder.add(builder.getPanel());
        this.formBuilder.nextRow();
    }

    public void addToParameterMap(InputLabel inputLabel, InputParameter<?> inputParameter, boolean required) {
        this.parameterNameToParameterInput.put(inputLabel.getName(), new ParameterWrapper(inputParameter, inputLabel, null));
        if (!required) {
            this.optionalParameters.add(inputLabel.getName());
        }
    }

    public FormBuilder getFormBuilder() {
        return this.formBuilder;
    }

    public History createHistory(Map<String, Object> nameToValue) {
        History history = new History((String)nameToValue.get("Operation"));
        HashSet<String> skip = new HashSet<String>(Arrays.asList("active.node", "Operation", "dataset", "project", "project.info.group"));
        for (String name : nameToValue.keySet()) {
            Object value;
            if (skip.contains(name) || (value = nameToValue.get(name)) == null || value instanceof Dataset || value instanceof Project) continue;
            String stringValue = InputParameterUtils.toStringValue(value);
            history.add(name, stringValue);
        }
        return history;
    }

    public InputParameter<?> getInputParameter(String name) {
        ParameterWrapper p = this.parameterNameToParameterInput.get(name);
        return p != null ? p.inputParameter : null;
    }

    public Collection<String> getParameterNames() {
        HashSet<String> set = new HashSet<String>(this.parameterNameToParameterInput.keySet());
        return set;
    }

    public Map<String, Object> getParameterValueMap(List<String> errors) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String name : this.parameterNameToParameterInput.keySet()) {
            try {
                Object value = this.getParameterValue(name);
                if (value == null && !this.optionalParameters.contains(name)) {
                    errors.add("Please provide a value for " + name + ".");
                }
                if (value == null) continue;
                map.put(name, value);
            }
            catch (ValidationException e) {
                errors.add(e.getMessage());
            }
        }
        return map;
    }

    public void setEnabled(String name, boolean enabled) {
        ParameterWrapper p = this.parameterNameToParameterInput.get(name);
        if (p != null) {
            if (p.inputLabel.getComponent() != null) {
                p.inputLabel.getComponent().setEnabled(enabled);
            }
            if (p.inputParameter.getJComponent() != null) {
                p.inputParameter.getJComponent().setEnabled(enabled);
                UIUtil.setChildrenEnabledRecursively(p.inputParameter.getJComponent(), enabled);
            }
            if (p.descriptionComponent != null) {
                p.descriptionComponent.setEnabled(enabled);
                UIUtil.setChildrenEnabledRecursively(p.descriptionComponent, enabled);
            }
        }
    }

    public void setParameterValue(String parameter, Object value) {
        if (value instanceof Object[]) {
            this._setParameterValue(parameter, (Object[])value);
        }
        ParameterWrapper p = this.parameterNameToParameterInput.get(parameter);
        p.inputParameter.init(value);
    }

    public void setVisible(String name, boolean visible) {
        ParameterWrapper p = this.parameterNameToParameterInput.get(name);
        if (p != null) {
            if (p.inputLabel.getComponent() != null) {
                p.inputLabel.getComponent().setVisible(visible);
            }
            if (p.inputParameter.getJComponent() != null) {
                p.inputParameter.getJComponent().setVisible(visible);
            }
            if (p.descriptionComponent != null) {
                p.descriptionComponent.setVisible(visible);
            }
        }
    }

    private void _setParameterValue(String parameter, Object[] choices) {
        InputParameter component = this.parameterNameToParameterInput.get(parameter).inputParameter;
        if (component instanceof JComboBox) {
            JComboBox c = (JComboBox)((Object)component);
            c.removeAllItems();
            if (choices != null) {
                for (Object value : choices) {
                    c.addItem(value);
                }
            }
            if (c.getItemCount() > 0) {
                c.setSelectedIndex(0);
            }
        }
    }

    private Object getParameterValue(String parameter) {
        InputParameter c = this.parameterNameToParameterInput.get(parameter).inputParameter;
        return c.getParameterValue();
    }

    private static class ParameterWrapper {
        private InputLabel inputLabel;
        private JComponent descriptionComponent;
        private InputParameter<?> inputParameter;

        public ParameterWrapper(InputParameter<?> inputParameter, InputLabel inputLabel, JComponent descriptionComponent) {
            this.inputParameter = inputParameter;
            this.inputLabel = inputLabel;
            this.descriptionComponent = descriptionComponent;
        }
    }
}

