/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.google.common.base.Predicate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.chart.BetweenFilter;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public final class DefaultElementPainter
implements ElementPainter {
    private HeatMapColorScheme colorScheme;
    private Project project;
    private Rectangle2D.Float rect = new Rectangle2D.Float();
    private List<PredicateAndShape> allPredicates = new ArrayList<PredicateAndShape>();
    private Map<Integer, Collection<PredicateAndShape>> datasetToPredicate = new LinkedHashMap<Integer, Collection<PredicateAndShape>>();
    private boolean useShape;

    public void addShape(PredicateAndShape ps) {
        this.allPredicates.remove(ps);
        this.allPredicates.add(ps);
    }

    @Override
    public ElementPainter copy() {
        DefaultElementPainter painter = new DefaultElementPainter();
        painter.project = this.project;
        painter.colorScheme = DefaultHeatMapColorScheme.copy(this.colorScheme);
        painter.colorScheme.setProject(this.project);
        for (PredicateAndShape p : this.allPredicates) {
            painter.allPredicates.add(p.copy());
        }
        return painter;
    }

    @Override
    public void draw(Graphics2D g, Dataset dataset, int row, int column, float xpix, float ypix, float columnSize, float rowSize) {
        g.setColor(this.colorScheme.getColor(row, column, dataset.getValue(row, column)));
        if (!this.useShape) {
            this.rect.setRect(xpix, ypix, columnSize, rowSize);
            g.fill(this.rect);
        } else {
            boolean found = false;
            for (Integer index : this.datasetToPredicate.keySet()) {
                PredicateAndShape predicate = null;
                float val = dataset.getValue(row, column, index);
                for (PredicateAndShape p : this.datasetToPredicate.get(index)) {
                    if (!p.predicate.apply((Object)Float.valueOf(val))) continue;
                    predicate = p;
                    break;
                }
                if (predicate == null) continue;
                found = true;
                Shape shape = predicate.shape;
                AffineTransform transform = AffineTransform.getTranslateInstance(xpix, ypix);
                Rectangle2D bounds = shape.getBounds2D();
                transform.concatenate(AffineTransform.getScaleInstance((double)columnSize / bounds.getWidth(), (double)rowSize / bounds.getHeight()));
                Shape fillShape = transform.createTransformedShape(shape);
                Color c = predicate.getFillColor();
                if (c == null) {
                    c = this.colorScheme.getColor(row, column, dataset.getValue(row, column));
                }
                g.setColor(c);
                g.fill(fillShape);
                if (predicate.borderColor == null) continue;
                Stroke stroke = g.getStroke();
                float lineWidth = 0.0f;
                if (predicate.borderStroke != null) {
                    if (predicate.borderStroke instanceof BasicStroke) {
                        lineWidth = ((BasicStroke)predicate.borderStroke).getLineWidth();
                    }
                    g.setStroke(predicate.borderStroke);
                }
                g.setColor(predicate.borderColor);
                columnSize = columnSize - 1.0f - lineWidth;
                rowSize = rowSize - 1.0f - lineWidth;
                transform = AffineTransform.getTranslateInstance(xpix + lineWidth / 2.0f, ypix + lineWidth / 2.0f);
                transform.concatenate(AffineTransform.getScaleInstance((double)columnSize / bounds.getWidth(), (double)rowSize / bounds.getHeight()));
                Shape drawShape = transform.createTransformedShape(shape);
                g.draw(drawShape);
                g.setStroke(stroke);
            }
            if (!found) {
                this.rect.setRect(xpix, ypix, columnSize, rowSize);
                g.fill(this.rect);
            }
        }
    }

    public List<PredicateAndShape> getAllPredicates() {
        return this.allPredicates;
    }

    public boolean isUseShape() {
        return this.useShape;
    }

    public void removeShape(PredicateAndShape ps) {
        this.allPredicates.remove(ps);
    }

    @Override
    public boolean setColorScheme(HeatMapColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        colorScheme.setProject(this.project);
        return true;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
        this.useShape = false;
        this.datasetToPredicate.clear();
        for (PredicateAndShape p : this.allPredicates) {
            int datasetSeriesIndex;
            if (!p.enabled || p.shape == null) continue;
            int n = datasetSeriesIndex = p.datasetName != null ? DatasetUtil.getSeriesIndex(project.getOriginalDataset(), p.datasetName) : -1;
            if (datasetSeriesIndex != -1) {
                int n2 = datasetSeriesIndex = Number.class.isAssignableFrom(project.getOriginalDataset().getSeriesClass(datasetSeriesIndex)) ? datasetSeriesIndex : -1;
            }
            if (datasetSeriesIndex == -1) continue;
            Collection<PredicateAndShape> datasetPredicates = this.datasetToPredicate.get(datasetSeriesIndex);
            if (datasetPredicates == null) {
                datasetPredicates = new ArrayList<PredicateAndShape>();
                this.datasetToPredicate.put(datasetSeriesIndex, datasetPredicates);
            }
            datasetPredicates.add(p);
            this.useShape = true;
        }
    }

    public static class PredicateAndShape {
        private Predicate<Number> predicate;
        private Shape shape;
        private Color borderColor;
        private Stroke borderStroke;
        private String datasetName;
        private boolean enabled = false;
        private int shapeIndex;
        private Color fillColor;

        public PredicateAndShape(Predicate<Number> predicate, Shape shape, int shapeIndex, String datasetName) {
            this.predicate = predicate;
            this.shape = shape;
            this.datasetName = datasetName;
        }

        public PredicateAndShape copy() {
            PredicateAndShape copy = new PredicateAndShape(this.predicate instanceof BetweenFilter ? ((BetweenFilter)this.predicate).copy() : new BetweenFilter(), ShapeUtil.getShape(this.shapeIndex, 12.0f), this.shapeIndex, this.datasetName);
            copy.datasetName = this.datasetName;
            copy.borderColor = this.borderColor;
            copy.borderStroke = this.borderStroke;
            copy.enabled = this.enabled;
            copy.fillColor = this.fillColor;
            return copy;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public Stroke getBorderStroke() {
            return this.borderStroke;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public Predicate<Number> getPredicate() {
            return this.predicate;
        }

        public Shape getShape() {
            return this.shape;
        }

        public int getShapeIndex() {
            return this.shapeIndex;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        public void setBorderStroke(Stroke borderStroke) {
            this.borderStroke = borderStroke;
        }

        public void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void setPredicate(Predicate<Number> predicate) {
            this.predicate = predicate;
        }

        public void setShape(Shape shape, int shapeIndex) {
            this.shape = shape;
            this.shapeIndex = shapeIndex;
        }
    }
}

