/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.heatmap.ColorSupplier;
import org.broadinstitute.genee.heatmap.DiscreteColorSupplier;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.heatmap.MultiGradientColorSupplier;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetSeriesAdapter;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DefaultHeatMapColorScheme
implements HeatMapColorScheme {
    private ColorSupplier colorSupplier;
    private float customGlobalMax;
    private float customGlobalMin;
    private String customName;
    private transient Dataset dataset;
    private transient String datasetName;
    private boolean discrete;
    private transient HeatMapColorSchemeLegend legend;
    private Set<ChangeListener> listeners = new LinkedHashSet<ChangeListener>();
    private boolean logScale;
    private int maxGlobalScalingMode = 0;
    private int minGlobalScalingMode = 0;
    private Color missingColor = Color.LIGHT_GRAY;
    private transient Project project;
    private transient ProjectListener projectListener;
    private boolean relative;
    private float rowNormalizedMax = 3.0f;
    private float rowNormalizedMin = -3.0f;
    private int rowScalingMode = 2;
    private RowStats rowStats;
    private String separateColorSchemesForColumnMetadataField;
    private HashMap<Object, RowStats> valueToRowStats;
    private Vector vector;

    public DefaultHeatMapColorScheme() {
        this(false);
    }

    public DefaultHeatMapColorScheme(boolean relative) {
        this.relative = relative;
        this.colorSupplier = new MultiGradientColorSupplier();
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                DefaultHeatMapColorScheme.this.updateDataset();
            }
        };
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void dispose() {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[0]);
    }

    @Override
    public Color getColor(int row, int column, float value) {
        if (Float.isNaN(value)) {
            return this.missingColor;
        }
        if (this.logScale) {
            value = LogScaleUnivariateFunction.log2(value);
        }
        if (this.relative) {
            RowStats rowStats = this.separateColorSchemesForColumnMetadataField != null ? this.valueToRowStats.get(this.vector.getValue(column)) : this.rowStats;
            rowStats.maybeUpdate(row);
            if (this.rowScalingMode != 2) {
                this.colorSupplier.setMin(this.rowNormalizedMin);
                this.colorSupplier.setMax(this.rowNormalizedMax);
            } else if (this.rowScalingMode == 2) {
                this.colorSupplier.setMin(rowStats.rowCachedMin);
                this.colorSupplier.setMax(rowStats.rowCachedMax);
            }
            if (this.rowScalingMode == 3) {
                value -= rowStats.standardDeviation.getMean();
                value /= rowStats.rowScalingCachedStdev;
            } else if (this.rowScalingMode == 4) {
                value -= rowStats.medianAbsoluteDeviation.getMedian();
                value /= rowStats.rowScalingCachedMAD;
            }
        }
        return this.colorSupplier.getColor(row, column, value);
    }

    @Override
    public Color[] getColors() {
        return this.colorSupplier.getColors();
    }

    @Override
    public float getCustomGlobalMax() {
        return this.customGlobalMax;
    }

    @Override
    public float getCustomGlobalMin() {
        return this.customGlobalMin;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public float[] getFractions() {
        return this.colorSupplier.getFractions();
    }

    @Override
    public HeatMapColorSchemeLegend getLegend() {
        if (this.legend == null) {
            this.legend = new HeatMapColorSchemeLegend(this);
        }
        return this.legend;
    }

    @Override
    public float getMax() {
        float max;
        if (this.isRelative()) {
            if (this.getRowScalingMode() == 2) {
                return 1.0f;
            }
            max = this.getRowNormalizedMax();
        } else {
            max = this.colorSupplier.getMax();
        }
        return max;
    }

    @Override
    public int getMaxGlobalScalingMode() {
        return this.maxGlobalScalingMode;
    }

    @Override
    public float getMin() {
        float min;
        if (this.isRelative()) {
            if (this.getRowScalingMode() == 2) {
                return -1.0f;
            }
            min = this.getRowNormalizedMin();
        } else {
            min = this.colorSupplier.getMin();
        }
        return min;
    }

    @Override
    public int getMinGlobalScalingMode() {
        return this.minGlobalScalingMode;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColor;
    }

    @Override
    public String getName() {
        if (this.customName != null) {
            return this.customName;
        }
        return this.isRelative() ? "relative" : "global";
    }

    @Override
    public float getRowNormalizedMax() {
        return this.rowNormalizedMax;
    }

    @Override
    public float getRowNormalizedMin() {
        return this.rowNormalizedMin;
    }

    @Override
    public int getRowScalingMode() {
        return this.rowScalingMode;
    }

    @Override
    public String getSeparateColorSchemesForColumnMetadataField() {
        return this.separateColorSchemesForColumnMetadataField;
    }

    @Override
    public boolean isDiscrete() {
        return this.discrete;
    }

    @Override
    public boolean isLogScale() {
        return this.logScale;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setColors(Color[] colors) {
        float[] fractions = new float[colors.length];
        float step = 1.0f / (float)(colors.length - 1);
        float f = 0.0f;
        for (int i = 0; i < colors.length; ++i) {
            fractions[i] = f;
            f += step;
        }
        this.setColors(colors, fractions);
        this.notifyListeners();
    }

    @Override
    public void setColors(Color[] colors, float[] fractions) {
        this.colorSupplier.setPaint(fractions, colors);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setDiscrete(boolean discrete) {
        if (this.discrete != discrete) {
            this.discrete = discrete;
            ColorSupplier oldColorSupplier = this.colorSupplier;
            ColorSupplier newColorSupplier = discrete ? new DiscreteColorSupplier() : new MultiGradientColorSupplier();
            newColorSupplier.setMin(oldColorSupplier.getMin());
            newColorSupplier.setMax(oldColorSupplier.getMax());
            newColorSupplier.setPaint(oldColorSupplier.getFractions(), oldColorSupplier.getColors());
            this.colorSupplier = newColorSupplier;
            this.updateDataset();
            this.repaintLegend();
            this.notifyListeners();
        }
    }

    @Override
    public void setGlobalMaxMode(int mode) {
        this.relative = false;
        this.maxGlobalScalingMode = mode;
        this.updateGlobalMax();
        this.notifyListeners();
    }

    @Override
    public void setGlobalMaxMode(int mode, float customValue) {
        this.relative = false;
        this.maxGlobalScalingMode = mode;
        this.customGlobalMax = customValue;
        this.updateGlobalMax();
        this.notifyListeners();
    }

    @Override
    public void setGlobalMinMode(int mode) {
        this.relative = false;
        this.minGlobalScalingMode = mode;
        this.updateGlobalMin();
        this.notifyListeners();
    }

    @Override
    public void setGlobalMinMode(int mode, float customValue) {
        this.relative = false;
        this.minGlobalScalingMode = mode;
        this.customGlobalMin = customValue;
        this.updateGlobalMin();
        this.notifyListeners();
    }

    @Override
    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setMissingColor(Color missingColor) {
        this.missingColor = missingColor;
        this.notifyListeners();
    }

    @Override
    public void setName(String name) {
        this.customName = name;
        this.notifyListeners();
    }

    @Override
    public void setProject(Project p) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = p;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
        } else {
            System.out.println("Project is null.");
        }
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setRelative(boolean relative) {
        this.relative = relative;
        this.updateGlobalMin();
        this.updateGlobalMax();
        this.notifyListeners();
    }

    @Override
    public void setRowNormalizedMax(float rowNormalizedMax) {
        this.rowNormalizedMax = rowNormalizedMax;
        this.colorSupplier.setMax(rowNormalizedMax);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setRowNormalizedMin(float rowNormalizedMin) {
        this.rowNormalizedMin = rowNormalizedMin;
        this.colorSupplier.setMin(rowNormalizedMin);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setRowScalingMode(int mode) {
        this.rowScalingMode = mode;
        this.colorSupplier.setMin(this.rowNormalizedMin);
        this.colorSupplier.setMax(this.rowNormalizedMax);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setSeparateColorSchemesForColumnMetadataField(String separateColorSchemesForColumnMetadataField) {
        this.separateColorSchemesForColumnMetadataField = separateColorSchemesForColumnMetadataField;
        this.updateDataset();
        this.notifyListeners();
    }

    protected void repaintLegend() {
        if (this.legend != null) {
            this.legend.revalidate();
            this.legend.repaint();
        }
    }

    protected void updateGlobalMax() {
        Dataset fullDataset;
        if (this.relative) {
            return;
        }
        if (this.maxGlobalScalingMode == 2) {
            this.colorSupplier.setMax(this.customGlobalMax);
        } else if (this.project != null && (fullDataset = this.getDataset(true)) != null) {
            float max;
            if (this.maxGlobalScalingMode == 0) {
                max = DatasetUtil.max(fullDataset);
            } else if (this.maxGlobalScalingMode == 1) {
                max = FloatListStatUtils.percentile(DatasetUtil.floatListView(fullDataset), 90);
            } else {
                throw new IllegalArgumentException("Scaling mode: " + this.maxGlobalScalingMode);
            }
            this.colorSupplier.setMax(max);
        }
        this.repaintLegend();
    }

    protected void updateGlobalMin() {
        Dataset fullDataset;
        if (this.relative) {
            return;
        }
        if (this.minGlobalScalingMode == 2) {
            this.colorSupplier.setMin(this.customGlobalMin);
        } else if (this.project != null && (fullDataset = this.getDataset(true)) != null) {
            float min = 0.0f;
            if (this.minGlobalScalingMode == 0) {
                min = DatasetUtil.min(fullDataset);
            } else if (this.minGlobalScalingMode == 1) {
                min = FloatListStatUtils.percentile(DatasetUtil.floatListView(fullDataset), 10);
            } else {
                throw new RuntimeException();
            }
            this.colorSupplier.setMin(min);
        }
        this.repaintLegend();
    }

    private Dataset getDataset(boolean full) {
        Dataset dataset = null;
        if (this.project != null) {
            Dataset dataset2 = dataset = full ? this.project.getOriginalDataset() : this.project.getSortedFilteredDataset();
            if (this.datasetName != null) {
                dataset = new DatasetSeriesAdapter(dataset, DatasetUtil.getSeriesIndex(dataset, this.datasetName));
            }
            if (this.logScale) {
                dataset = new Log2Dataset(dataset);
            }
        }
        return dataset;
    }

    private void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void updateDataset() {
        if (this.project != null) {
            this.dataset = this.getDataset(false);
            this.valueToRowStats = new HashMap();
            this.vector = this.dataset.getColumnMetadata().get(this.separateColorSchemesForColumnMetadataField);
            if (this.vector == null) {
                this.rowStats = new RowStats(this.dataset, null);
                this.valueToRowStats.put(null, this.rowStats);
            } else {
                Map valueToIndices = VectorUtil.createValueToIndicesMap(this.vector);
                for (Object value : valueToIndices.keySet()) {
                    this.valueToRowStats.put(value, new RowStats(this.dataset, valueToIndices.get(value).toArray()));
                }
            }
            this.updateGlobalMin();
            this.updateGlobalMax();
        }
    }

    public static HeatMapColorScheme copy(HeatMapColorScheme source) {
        DefaultHeatMapColorScheme colorScheme = new DefaultHeatMapColorScheme();
        colorScheme.colorSupplier = !source.isDiscrete() ? new MultiGradientColorSupplier() : new DiscreteColorSupplier();
        colorScheme.relative = source.isRelative();
        colorScheme.separateColorSchemesForColumnMetadataField = source.getSeparateColorSchemesForColumnMetadataField();
        colorScheme.rowScalingMode = source.getRowScalingMode();
        colorScheme.missingColor = source.getMissingColor();
        colorScheme.minGlobalScalingMode = source.getMinGlobalScalingMode();
        colorScheme.maxGlobalScalingMode = source.getMaxGlobalScalingMode();
        colorScheme.customGlobalMin = source.getCustomGlobalMin();
        colorScheme.customGlobalMax = source.getCustomGlobalMax();
        colorScheme.rowNormalizedMin = source.getRowNormalizedMin();
        colorScheme.rowNormalizedMax = source.getRowNormalizedMax();
        colorScheme.logScale = source.isLogScale();
        colorScheme.datasetName = source.getDatasetName();
        colorScheme.updateGlobalMin();
        colorScheme.updateGlobalMax();
        colorScheme.setColors(source.getColors(), source.getFractions());
        return colorScheme;
    }

    public static HeatMapColorScheme load(String name) {
        Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
        Preferences p = prefs.node("color.scheme");
        p = p.node(name);
        DefaultHeatMapColorScheme cs = new DefaultHeatMapColorScheme();
        cs.relative = p.getBoolean("relative", true);
        cs.rowScalingMode = p.getInt("rowScalingMode", 2);
        try {
            cs.missingColor = ImageUtil.decodeColor(p.get("missingColor", ""));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        cs.minGlobalScalingMode = p.getInt("minGlobalScalingMode", cs.minGlobalScalingMode);
        cs.maxGlobalScalingMode = p.getInt("maxGlobalScalingMode", cs.maxGlobalScalingMode);
        cs.customGlobalMin = p.getFloat("customGlobalMin", cs.customGlobalMin);
        cs.customGlobalMax = p.getFloat("customGlobalMax", cs.customGlobalMax);
        cs.rowNormalizedMin = p.getFloat("rowStdevMin", cs.rowNormalizedMin);
        cs.rowNormalizedMax = p.getFloat("rowStdevMax", cs.rowNormalizedMax);
        cs.discrete = p.getBoolean("discrete", false);
        int fractionsLength = p.getInt("n.fractions", 0);
        float[] fractions = new float[fractionsLength];
        for (int i = 0; i < fractions.length; ++i) {
            fractions[i] = p.getFloat("fraction" + i, fractions[i]);
        }
        int colorsLength = p.getInt("n.colors", 0);
        Color[] colors = new Color[colorsLength];
        for (int i = 0; i < colors.length; ++i) {
            try {
                colors[i] = ImageUtil.decodeColor(p.get("color" + i, ""));
                continue;
            }
            catch (NumberFormatException nfe) {
                colors[i] = Color.RED;
            }
        }
        cs.setDiscrete(cs.discrete);
        cs.colorSupplier.setPaint(fractions, colors);
        cs.updateGlobalMin();
        cs.updateGlobalMax();
        return cs;
    }

    public static void save(HeatMapColorScheme colorScheme, String name) {
        Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
        Preferences p = prefs.node("color.scheme");
        p = p.node(name);
        p.putBoolean("relative", colorScheme.isRelative());
        p.putInt("rowScalingMode", colorScheme.getRowScalingMode());
        p.put("missingColor", ImageUtil.toString(colorScheme.getMissingColor()));
        p.putInt("minGlobalScalingMode", colorScheme.getMinGlobalScalingMode());
        p.putInt("maxGlobalScalingMode", colorScheme.getMaxGlobalScalingMode());
        p.putFloat("customGlobalMin", colorScheme.getCustomGlobalMin());
        p.putFloat("customGlobalMax", colorScheme.getCustomGlobalMax());
        p.putFloat("rowStdevMin", colorScheme.getRowNormalizedMin());
        p.putFloat("rowStdevMax", colorScheme.getRowNormalizedMax());
        float[] fractions = colorScheme.getFractions();
        p.putInt("n.fractions", fractions.length);
        for (int i = 0; i < fractions.length; ++i) {
            p.putFloat("fraction" + i, fractions[i]);
        }
        Color[] colors = colorScheme.getColors();
        p.putInt("n.colors", colors.length);
        for (int i = 0; i < colors.length; ++i) {
            p.put("color" + i, ImageUtil.toString(colors[i]));
        }
    }

    private class RowStats {
        private transient float cachedRow = -1.0f;
        private transient DatasetRowView datasetRowView;
        private transient MedianAbsoluteDeviation medianAbsoluteDeviation = new MedianAbsoluteDeviation();
        private transient float rowCachedMax;
        private transient float rowCachedMin;
        private transient float rowScalingCachedMAD;
        private transient float rowScalingCachedStdev;
        private transient StandardDeviation standardDeviation = new StandardDeviation();

        private RowStats(Dataset dataset, int[] columnIndices) {
            this.datasetRowView = new DatasetRowView(dataset, columnIndices);
        }

        public void maybeUpdate(int row) {
            if (this.cachedRow != (float)row) {
                this.cachedRow = row;
                this.datasetRowView.setIndex(row);
                if (DefaultHeatMapColorScheme.this.rowScalingMode == 3) {
                    this.rowScalingCachedStdev = this.standardDeviation.evaluate(this.datasetRowView);
                } else if (DefaultHeatMapColorScheme.this.rowScalingMode == 4) {
                    this.rowScalingCachedMAD = this.medianAbsoluteDeviation.evaluate(this.datasetRowView);
                } else {
                    this.rowCachedMax = -3.4028235E38f;
                    this.rowCachedMin = Float.MAX_VALUE;
                    int ncols = this.datasetRowView.size();
                    for (int j = 0; j < ncols; ++j) {
                        float d = this.datasetRowView.getValue(j);
                        if (Float.isNaN(d)) continue;
                        this.rowCachedMax = d > this.rowCachedMax ? d : this.rowCachedMax;
                        this.rowCachedMin = d < this.rowCachedMin ? d : this.rowCachedMin;
                    }
                }
            }
        }
    }

    private static class Log2Dataset
    extends DatasetAdapter {
        public Log2Dataset(Dataset dataset) {
            super(dataset);
        }

        @Override
        public float getValue(int rowIndex, int columnIndex) {
            float val = this.dataset.getValue(rowIndex, columnIndex);
            return LogScaleUnivariateFunction.log2(val);
        }
    }
}

