/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import org.broadinstitute.genee.heatmap.AbstractSizesAndPositions;
import org.broadinstitute.genee.heatmap.FloatSizeSequence;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class DefaultSizesAndPositions
extends AbstractSizesAndPositions {
    private int length;
    private float size = 12.0f;
    private FloatSizeSequence spaceSizeSequence = new FloatSizeSequence();

    public DefaultSizesAndPositions() {
    }

    public DefaultSizesAndPositions(int length) {
        this.setLength(length);
    }

    @Override
    public int getIndex(float position, boolean exact) {
        if (exact) {
            return this.binaryExactSearch(position);
        }
        return this.binaryInExactSearch(position);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public float getPosition(int index) {
        return this.size * (float)index + this.spaceSizeSequence.getPosition(index);
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public float getSpaceSize(int index) {
        return this.spaceSizeSequence.getSize(index);
    }

    @Override
    public float[] getSpaceSizes() {
        return this.spaceSizeSequence.getSizes();
    }

    @Override
    public void setLength(int length) {
        this.length = length;
        this.spaceSizeSequence.setSizes(new float[length]);
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    public void setSpaceSize(int index, float spaceSize) {
        this.spaceSizeSequence.setSize(index, spaceSize);
    }

    @Override
    public void setSpaceSizes(float[] sizes) {
        this.spaceSizeSequence.setSizes(sizes);
    }

    private int binaryExactSearch(float position) {
        int low = 0;
        int high = this.length - 1;
        float size = this.getSize();
        while (low <= high) {
            int mid = low + high >> 1;
            float midVal = this.getPosition(mid);
            if (midVal <= position && position < midVal + size) {
                return mid;
            }
            int cmp = Float.compare(midVal, position);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private int binaryInExactSearch(float position) {
        int low = 0;
        int high = this.length - 1;
        float maxIndex = this.getLength() - 1;
        float size = this.getSize();
        while (low <= high) {
            float nextStart;
            int mid = low + high >> 1;
            float midVal = this.getPosition(mid);
            float f = nextStart = maxIndex == (float)mid ? midVal + size : this.getPosition(mid + 1);
            if (midVal <= position && position < nextStart) {
                return mid;
            }
            int cmp = Float.compare(midVal, position);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    public static int[] getIndices(SizesAndPositions sizesAndPositions, float position) {
        int lowerIndex;
        float size = sizesAndPositions.getSize();
        int upperIndex = sizesAndPositions.getIndex(position + size, true);
        if (upperIndex < 0) {
            upperIndex = sizesAndPositions.getLength() - 1;
        }
        if ((lowerIndex = sizesAndPositions.getIndex(position - size, true)) < 0) {
            lowerIndex = 0;
        }
        TIntArrayList indices = new TIntArrayList();
        for (int i = lowerIndex; i <= upperIndex; ++i) {
            boolean inside;
            float lowerVal = sizesAndPositions.getPosition(i);
            float upperVal = lowerVal + size;
            boolean bl = inside = upperVal >= position && lowerVal <= position;
            if (!inside) continue;
            indices.add(i);
        }
        return indices.toArray();
    }
}

