/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.heatmap.FilePlateWellValue;
import org.broadinstitute.genee.heatmap.ToolTipSupplier;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.FloatList;

public class FilePlateWellValueList
implements ToolTipSupplier,
FloatList {
    private List<FilePlateWellValue> list = new ArrayList<FilePlateWellValue>();

    public void add(FilePlateWellValue filePlateWellValue) {
        this.list.add(filePlateWellValue);
    }

    @Override
    public float getValue(int index) {
        return this.list.get(index).getValue();
    }

    @Override
    public String getToolTipText() {
        StringBuilder buf = new StringBuilder();
        buf.append("<table border=1><tr><th>File<th>Plate<th>Well<th>Value");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            buf.append("<tr>");
            FilePlateWellValue val = this.list.get(i);
            buf.append("<td>");
            buf.append(new File(val.getFile()).getName());
            buf.append("<td>");
            buf.append(val.getPlate());
            buf.append("<td>");
            buf.append(val.getWell());
            buf.append("<td>");
            buf.append(Formatter.format(val.getValue()));
        }
        buf.append("</table>");
        return buf.toString();
    }

    @Override
    public void setValue(int index, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

