/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

class FloatSizeSequence {
    private static float[] emptyArray = new float[0];
    float[] a = emptyArray;

    public float getPosition(int index) {
        return this.getPosition(0, this.a.length, index);
    }

    public float getSize(int index) {
        return this.getPosition(index + 1) - this.getPosition(index);
    }

    public float[] getSizes() {
        int n = this.a.length;
        float[] sizes = new float[n];
        this.getSizes(0, n, sizes);
        return sizes;
    }

    public void setSize(int index, float size) {
        this.changeSize(0, this.a.length, index, size - this.getSize(index));
    }

    public void setSizes(float[] sizes) {
        if (this.a.length != sizes.length) {
            this.a = new float[sizes.length];
        }
        this.setSizes(0, this.a.length, sizes);
    }

    private void changeSize(int from, int to, int index, float delta) {
        if (to <= from) {
            return;
        }
        int m = (from + to) / 2;
        if (index <= m) {
            int n = m;
            this.a[n] = this.a[n] + delta;
            this.changeSize(from, m, index, delta);
        } else {
            this.changeSize(m + 1, to, index, delta);
        }
    }

    private float getPosition(int from, int to, int index) {
        if (to <= from) {
            return 0.0f;
        }
        int m = (from + to) / 2;
        if (index <= m) {
            return this.getPosition(from, m, index);
        }
        return this.a[m] + this.getPosition(m + 1, to, index);
    }

    private float getSizes(int from, int to, float[] sizes) {
        if (to <= from) {
            return 0.0f;
        }
        int m = (from + to) / 2;
        sizes[m] = this.a[m] - this.getSizes(from, m, sizes);
        return this.a[m] + this.getSizes(m + 1, to, sizes);
    }

    private float setSizes(int from, int to, float[] sizes) {
        if (to <= from) {
            return 0.0f;
        }
        int m = (from + to) / 2;
        this.a[m] = sizes[m] + this.setSizes(from, m, sizes);
        return this.a[m] + this.setSizes(m + 1, to, sizes);
    }
}

