/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.set.hash.TIntHashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.filter.AbstractFilter;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.ElementEvent;
import org.broadinstitute.genee.heatmap.ElementSelectionListener;
import org.broadinstitute.genee.heatmap.ElementSelectionModel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;

public class GENEEResultNodeGroup {
    public static final Object NO_SIZE_SYNC = new Object();
    private Set<ProjectGENEEResultTreeNode> childNodes = new HashSet<ProjectGENEEResultTreeNode>();
    private MyListSelectionListener columnListSelectionListener;
    private ColumnProjectListener columnProjectListener;
    private ScrollListener columnScrollListener;
    private MySizesAndPositionsListener columnSizesAndPositionsListener;
    private MyElementSelectionListener elementSelectionListener;
    private MyMouseMovedPositionListener mouseMovedPositionListener;
    private ProjectGENEEResultTreeNode parentNode;
    private MyListSelectionListener rowListSelectionListener;
    private RowProjectListener rowProjectListener;
    private ScrollListener rowScrollListener;
    private MySizesAndPositionsListener rowSizesAndPositionsListener = new MySizesAndPositionsListener(true);

    public GENEEResultNodeGroup() {
        this.columnSizesAndPositionsListener = new MySizesAndPositionsListener(false);
        this.mouseMovedPositionListener = new MyMouseMovedPositionListener();
        this.rowProjectListener = new RowProjectListener();
        this.columnProjectListener = new ColumnProjectListener();
        this.rowScrollListener = new ScrollListener(true);
        this.columnScrollListener = new ScrollListener(false);
        this.rowListSelectionListener = new MyListSelectionListener(true, this.rowScrollListener);
        this.columnListSelectionListener = new MyListSelectionListener(false, this.columnScrollListener);
        this.elementSelectionListener = new MyElementSelectionListener(this.rowListSelectionListener, this.columnListSelectionListener, this.rowScrollListener, this.columnScrollListener);
    }

    public void addChild(ProjectGENEEResultTreeNode node) {
        this.childNodes.add(node);
        this.doLink();
    }

    public void dispose() {
        this.parentNode = null;
        this.childNodes.clear();
        this.doLink();
    }

    public Collection<ProjectGENEEResultTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public ProjectGENEEResultTreeNode getParentNode() {
        return this.parentNode;
    }

    public void removeChild(ProjectGENEEResultTreeNode node) {
        this.childNodes.remove(node);
        this.doLink();
    }

    public void setParentNode(ProjectGENEEResultTreeNode node) {
        this.childNodes.remove(node);
        this.parentNode = node;
        if (this.parentNode == null && this.childNodes.size() > 0) {
            ProjectGENEEResultTreeNode newParent;
            this.parentNode = newParent = this.childNodes.iterator().next();
            this.childNodes.remove(newParent);
        }
        this.doLink();
    }

    private void doLink() {
        ArrayList<ProjectGENEEResultTreeNode> tmp = new ArrayList<ProjectGENEEResultTreeNode>();
        if (this.parentNode != null) {
            tmp.add(this.parentNode);
        } else {
            System.err.println("Parent node is null");
        }
        tmp.addAll(this.childNodes);
        Set<HeatMapPanel> panels = GENEEResultNodeGroup.getPanels(tmp);
        this.columnSizesAndPositionsListener.setPanels(panels);
        this.columnListSelectionListener.setPanels(panels);
        this.columnProjectListener.setPanels(panels);
        this.columnScrollListener.setPanels(panels);
        this.rowSizesAndPositionsListener.setPanels(panels);
        this.rowListSelectionListener.setPanels(panels);
        this.rowProjectListener.setPanels(panels);
        this.rowScrollListener.setPanels(panels);
        this.elementSelectionListener.setPanels(panels);
        this.mouseMovedPositionListener.setPanels(panels);
    }

    private static Set<HeatMapPanel> getPanels(Collection<ProjectGENEEResultTreeNode> nodes) {
        HashSet<HeatMapPanel> set = new HashSet<HeatMapPanel>();
        for (ProjectGENEEResultTreeNode p : nodes) {
            set.add((HeatMapPanel)p.getDisplayInfo().getComponent());
        }
        return set;
    }

    private static void syncSizesAndPositions(SizesAndPositions source, SizesAndPositions sizesAndPositions, SizesAndPositionsEvent e) {
        if (sizesAndPositions != source) {
            if (e == null || e.isLengthChanged()) {
                sizesAndPositions.setLength(source.getLength());
            }
            if (e == null || e.isSizeChanged()) {
                sizesAndPositions.setSize(source.getSize());
            }
            if (e == null || e.isSpacesChanged()) {
                sizesAndPositions.setSpaceSizes(source.getSpaceSizes());
            }
            sizesAndPositions.notifyListeners(e != null ? e.getType() : 4);
        }
    }

    private static class ScrollListener
    implements ChangeListener {
        private Collection<BoundedRangeModel> models = new LinkedHashSet<BoundedRangeModel>();
        private boolean rows;

        public ScrollListener(boolean rows) {
            this.rows = rows;
        }

        public void addChangeListener() {
            for (BoundedRangeModel m : this.models) {
                m.addChangeListener(this);
            }
        }

        public void removeChangeListener() {
            for (BoundedRangeModel m : this.models) {
                m.removeChangeListener(this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeChangeListener();
            this.models.clear();
            if (!this.rows) {
                for (HeatMapPanel p : panels) {
                    this.models.add(p.getHorizontalBoundedRangeModel());
                }
            } else {
                for (HeatMapPanel p : panels) {
                    this.models.add(p.getVerticalBoundedRangeModel());
                }
            }
            this.addChangeListener();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BoundedRangeModel source = (BoundedRangeModel)e.getSource();
            int range1 = source.getMaximum() - source.getMinimum() - source.getExtent();
            float percent = (float)source.getValue() / (float)range1;
            this.removeChangeListener();
            for (BoundedRangeModel m : this.models) {
                if (m == source) continue;
                int range2 = m.getMaximum() - m.getMinimum() - m.getExtent();
                int newValue = Math.round(percent * (float)range2);
                m.setValue(newValue);
            }
            this.addChangeListener();
        }
    }

    private static class RowProjectListener
    implements ProjectListener {
        private Collection<HeatMapPanel> panels = Collections.emptyList();

        private RowProjectListener() {
        }

        public void addProjectListener() {
            LinkedHashSet<Project> projects = new LinkedHashSet<Project>();
            for (HeatMapPanel heatMapPanel : this.panels) {
                projects.add(heatMapPanel.getProject());
            }
            for (Project project : projects) {
                project.addProjectListener(this);
            }
        }

        @Override
        public void projectChanged(ProjectEvent e) {
            Project sourceProject = (Project)e.getSource();
            this.sync(sourceProject, e);
        }

        public void removeProjectListener() {
            for (HeatMapPanel p : this.panels) {
                p.getProject().removeProjectListener(this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeProjectListener();
            this.panels = panels;
            this.addProjectListener();
            if (panels.size() > 0) {
                this.sync(panels.iterator().next().getProject(), null);
            }
        }

        public void sync(Project sourceProject, ProjectEvent e) {
            this.removeProjectListener();
            if (e == null || e.getType() == 7) {
                for (final HeatMapPanel p : this.panels) {
                    int rows = sourceProject.getOriginalDataset().getRowCount();
                    final TIntHashSet acceptModelIndices = new TIntHashSet();
                    for (int i = 0; i < rows; ++i) {
                        int viewIndex = sourceProject.convertModelRowIndexToView(i);
                        if (viewIndex == -1) continue;
                        acceptModelIndices.add(i);
                    }
                    if (p.getProject() == sourceProject) continue;
                    p.getProject().setRowFilter(null);
                    AbstractFilter filter = new AbstractFilter(){

                        @Override
                        public boolean accept(int index) {
                            int modelIndex = p.getProject().convertViewRowIndexToModel(index);
                            if (modelIndex != -1) {
                                return acceptModelIndices.contains(modelIndex);
                            }
                            return false;
                        }

                        @Override
                        public void init(Object object) {
                        }

                        @Override
                        public boolean isEmpty() {
                            return false;
                        }
                    };
                    p.getProject().setRowFilter(filter);
                    filter.fireFilterChanged();
                }
            }
            if (e == null || e.getType() == 1) {
                TIntHashSet viewRowMask = sourceProject.getViewRowMask();
                int[] array = viewRowMask.toArray();
                for (HeatMapPanel p : this.panels) {
                    if (p.getProject() == sourceProject) continue;
                    p.getProject().clearRowMask();
                    p.getProject().addToRowMask(array);
                }
            }
            if (e == null || e.getType() == 8) {
                int[] order = sourceProject.getRowSortOrder();
                for (HeatMapPanel p : this.panels) {
                    if (p.getProject() == sourceProject) continue;
                    p.getProject().setRowSortOrder(order == null ? null : Arrays.asList(new SortKeys.CustomSortKey(order, SortOrder.UNSORTED)));
                }
            }
            this.addProjectListener();
        }
    }

    private static class MySizesAndPositionsListener
    implements SizesAndPositionsListener {
        private Collection<HeatMapPanel> panels = Collections.emptyList();
        private boolean rows;

        public MySizesAndPositionsListener(boolean rows) {
            this.rows = rows;
        }

        public void addListener() {
            LinkedHashSet<SizesAndPositions> set = new LinkedHashSet<SizesAndPositions>();
            for (HeatMapPanel p : this.panels) {
                SizesAndPositions sizesAndPositions = this.rows ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                set.add(sizesAndPositions);
            }
            for (SizesAndPositions sizesAndPositions : set) {
                sizesAndPositions.addSizesAndPositionsListener(this);
            }
        }

        public void removeListener() {
            for (HeatMapPanel p : this.panels) {
                SizesAndPositions sizesAndPositions = this.rows ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                sizesAndPositions.removeSizesAndPositionsListener(this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeListener();
            this.panels = panels;
            this.addListener();
            if (panels.size() > 0) {
                HeatMapPanel p = panels.iterator().next();
                SizesAndPositions sizesAndPositions = this.rows ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                this.sync(sizesAndPositions, null);
            }
        }

        @Override
        public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
            this.sync((SizesAndPositions)e.getSource(), e);
        }

        public void sync(SizesAndPositions source, SizesAndPositionsEvent e) {
            boolean sync;
            JComponent sourcePanel = null;
            for (HeatMapPanel p : this.panels) {
                SizesAndPositions sizesAndPositions = this.rows ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                if (sizesAndPositions != source) continue;
                sourcePanel = p;
                break;
            }
            boolean bl = sync = sourcePanel.getClientProperty(NO_SIZE_SYNC) == null;
            if (sync) {
                this.removeListener();
                for (HeatMapPanel p : this.panels) {
                    SizesAndPositions sizesAndPositions = this.rows ? p.getRowSizesAndPositions() : p.getColumnSizesAndPositions();
                    sync = p.getClientProperty(NO_SIZE_SYNC) == null;
                    if (!sync) continue;
                    GENEEResultNodeGroup.syncSizesAndPositions(source, sizesAndPositions, e);
                }
                this.addListener();
            }
        }
    }

    private static class MyMouseMovedPositionListener
    implements PropertyChangeListener {
        private Collection<HeatMapPanel> intersection = Collections.emptySet();

        private MyMouseMovedPositionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HeatMapPanel source = (HeatMapPanel)evt.getSource();
            MatrixElement matrixElement = (MatrixElement)evt.getNewValue();
            for (HeatMapPanel p : this.intersection) {
                if (p == source) continue;
                p.removePropertyChangeListener("mouseMovedPosition", this);
            }
            for (HeatMapPanel p : this.intersection) {
                if (p == source) continue;
                p.setMouseMovedPosition(matrixElement.getRow(), matrixElement.getColumn());
                p.addPropertyChangeListener("mouseMovedPosition", this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            for (HeatMapPanel p : this.intersection) {
                p.removePropertyChangeListener("mouseMovedPosition", this);
            }
            this.intersection = panels;
            for (HeatMapPanel p : this.intersection) {
                p.addPropertyChangeListener("mouseMovedPosition", this);
            }
        }
    }

    private static class MyListSelectionListener
    implements ListSelectionListener {
        private Collection<HeatMapPanel> panels = Collections.emptyList();
        private boolean rows;
        private ScrollListener scrollListener;

        public MyListSelectionListener(boolean rows, ScrollListener scrollListener) {
            this.rows = rows;
            this.scrollListener = scrollListener;
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeListSelectionListener();
            this.panels = panels;
            this.addListSelectionListener();
            if (panels.size() > 0) {
                HeatMapPanel p = panels.iterator().next();
                ListSelectionModel selectionModel = this.rows ? p.getRowTable().getSelectionModel() : p.getColumnTable().getColumnModel().getSelectionModel();
                this.syncListSelectionModel(selectionModel);
            }
        }

        public void syncListSelectionModel(ListSelectionModel source) {
            this.removeListSelectionListener();
            int[] indices = UIUtil.getSelectedIndices(source);
            HeatMapPanel sourcePanel = null;
            for (HeatMapPanel heatMapPanel : this.panels) {
                ListSelectionModel selectionModel;
                ListSelectionModel listSelectionModel = selectionModel = this.rows ? heatMapPanel.getRowTable().getSelectionModel() : heatMapPanel.getColumnTable().getColumnModel().getSelectionModel();
                if (selectionModel != source) {
                    selectionModel.setValueIsAdjusting(true);
                    selectionModel.clearSelection();
                    int length = indices.length;
                    for (int i = 0; i < length; ++i) {
                        selectionModel.addSelectionInterval(indices[i], indices[i]);
                    }
                    selectionModel.setValueIsAdjusting(false);
                    continue;
                }
                sourcePanel = heatMapPanel;
            }
            if (indices.length > 0 && sourcePanel != null) {
                this.scrollListener.removeChangeListener();
                int selectionIndex = source.getAnchorSelectionIndex();
                this.scroll(selectionIndex, sourcePanel);
                this.scrollListener.addChangeListener();
            }
            this.addListSelectionListener();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.syncListSelectionModel((ListSelectionModel)e.getSource());
        }

        private void addListSelectionListener() {
            LinkedHashSet<ListSelectionModel> models = new LinkedHashSet<ListSelectionModel>();
            for (HeatMapPanel heatMapPanel : this.panels) {
                ListSelectionModel selectionModel = this.rows ? heatMapPanel.getRowTable().getSelectionModel() : heatMapPanel.getColumnTable().getColumnModel().getSelectionModel();
                models.add(selectionModel);
            }
            for (ListSelectionModel m : models) {
                m.addListSelectionListener(this);
            }
        }

        private void removeListSelectionListener() {
            for (HeatMapPanel heatMapPanel : this.panels) {
                ListSelectionModel selectionModel = this.rows ? heatMapPanel.getRowTable().getSelectionModel() : heatMapPanel.getColumnTable().getColumnModel().getSelectionModel();
                selectionModel.removeListSelectionListener(this);
            }
        }

        private void scroll(int index, HeatMapPanel sourcePanel) {
            for (HeatMapPanel p : this.panels) {
                if (p == sourcePanel) continue;
                if (this.rows) {
                    p.scrollToRow(index);
                    continue;
                }
                p.scrollToColumn(index);
            }
        }
    }

    private static class MyElementSelectionListener
    implements ElementSelectionListener {
        private MyListSelectionListener columnListSelectionListener;
        private ScrollListener columnScrollListener;
        private Collection<HeatMapPanel> intersection = Collections.emptySet();
        private MyListSelectionListener rowListSelectionListener;
        private ScrollListener rowScrollListener;

        public MyElementSelectionListener(MyListSelectionListener rowListSelectionListener, MyListSelectionListener columnListSelectionListener, ScrollListener rowScrollListener, ScrollListener columnScrollListener) {
            this.rowListSelectionListener = rowListSelectionListener;
            this.columnListSelectionListener = columnListSelectionListener;
            this.rowScrollListener = rowScrollListener;
            this.columnScrollListener = columnScrollListener;
        }

        public void addElementSelectionListener() {
            LinkedHashSet<ElementSelectionModel> models = new LinkedHashSet<ElementSelectionModel>();
            for (HeatMapPanel p : this.intersection) {
                ElementSelectionModel selectionModel = p.getProject().getElementSelectionModel();
                models.add(selectionModel);
            }
            for (ElementSelectionModel m : models) {
                m.addElementSelectionListener(this);
            }
        }

        @Override
        public void elementSelectionChanged(ElementEvent e) {
            ElementSelectionModel source = (ElementSelectionModel)e.getSource();
            this.syncElementSelection(source);
        }

        public void removeElementSelectionListener() {
            for (HeatMapPanel p : this.intersection) {
                p.getProject().getElementSelectionModel().removeElementSelectionListener(this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeElementSelectionListener();
            this.intersection = panels;
            this.addElementSelectionListener();
            if (this.intersection.size() > 0) {
                this.syncElementSelection(this.intersection.iterator().next().getProject().getElementSelectionModel());
            }
        }

        public void syncElementSelection(ElementSelectionModel source) {
            this.removeElementSelectionListener();
            List<MatrixElement> selection = source.getSelectedElements();
            HeatMapPanel sourcePanel = null;
            for (HeatMapPanel p : this.intersection) {
                if (p.getProject().getElementSelectionModel() != source) {
                    p.getProject().getElementSelectionModel().setSelectedElements(selection);
                    continue;
                }
                sourcePanel = p;
            }
            if (selection.size() > 0 && sourcePanel != null) {
                this.rowScrollListener.removeChangeListener();
                this.rowListSelectionListener.removeListSelectionListener();
                this.rowListSelectionListener.addListSelectionListener();
                this.rowScrollListener.addChangeListener();
                this.columnScrollListener.removeChangeListener();
                this.columnListSelectionListener.removeListSelectionListener();
                this.columnListSelectionListener.addListSelectionListener();
                this.columnScrollListener.addChangeListener();
            }
            this.addElementSelectionListener();
        }
    }

    private static class ColumnProjectListener
    implements ProjectListener {
        private Collection<HeatMapPanel> panels = Collections.emptyList();

        private ColumnProjectListener() {
        }

        public void addProjectListener() {
            LinkedHashSet<Project> projects = new LinkedHashSet<Project>();
            for (HeatMapPanel heatMapPanel : this.panels) {
                projects.add(heatMapPanel.getProject());
            }
            for (Project project : projects) {
                project.addProjectListener(this);
            }
        }

        @Override
        public void projectChanged(ProjectEvent e) {
            this.sync((Project)e.getSource(), e);
        }

        public void removeProjectListener() {
            for (HeatMapPanel p : this.panels) {
                p.getProject().removeProjectListener(this);
            }
        }

        public void setPanels(Collection<HeatMapPanel> panels) {
            this.removeProjectListener();
            this.panels = panels;
            this.addProjectListener();
            if (panels.size() > 0) {
                this.sync(panels.iterator().next().getProject(), null);
            }
        }

        public void sync(Project sourceProject, ProjectEvent e) {
            this.removeProjectListener();
            if (e == null || e.getType() == 12) {
                TIntHashSet mask = sourceProject.getViewColumnMask();
                int[] array = mask.toArray();
                for (HeatMapPanel p : this.panels) {
                    if (p.getProject() == sourceProject) continue;
                    p.getProject().clearColumnMask();
                    p.getProject().addToColumnMask(array);
                }
            }
            if (e == null || e.getType() == 0) {
                int[] order = sourceProject.getColumnSortOrder();
                for (HeatMapPanel p : this.panels) {
                    if (p.getProject() == sourceProject) continue;
                    p.getProject().setColumnSortOrder(order == null ? null : Arrays.asList(new SortKeys.CustomSortKey(order)));
                }
            }
            this.addProjectListener();
        }
    }
}

