/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.server.GeneeServer;

public class GeneralOptionsPanel
extends JPanel {
    private JLabel listeningLabel;

    public GeneralOptionsPanel() {
        FormBuilder formBuilder = new FormBuilder(this);
        formBuilder.addSeparator("General");
        formBuilder.addLabel(Application.getName() + " Home Directory:");
        final JLabel label = UIUtil.createSmallLabel(IOUtil.getPath(Application.getGENEEDir()));
        JButton editBtn = new JButton("Edit\u2026");
        editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = FileChooserUtil.showSelectDirectoryDialog(GeneralOptionsPanel.this, "Choose directory");
                if (file != null) {
                    if (!file.canWrite()) {
                        UIUtil.showErrorDialog(GeneralOptionsPanel.this, "You do not have permission to write to " + file.getName() + ".");
                        return;
                    }
                    label.setText(IOUtil.getPath(file));
                    Application.setGENEEDir(file);
                }
            }
        });
        formBuilder.add(editBtn);
        formBuilder.nextRowNoSpace();
        formBuilder.addSpanned(label);
        formBuilder.nextRow();
        final Preferences p = Preferences.userNodeForPackage(Application.class);
        final JCheckBox usageCheckBox = new JCheckBox("Allow anonymous usage statistics", TrackerUtil.isAllowUsageStats());
        usageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.setAllowUsageStats(usageCheckBox.isSelected());
            }
        });
        formBuilder.addSpanned(usageCheckBox);
        formBuilder.nextRow();
        final JCheckBox listenCheckBox = new JCheckBox("Listen for connections on port", p.getBoolean("listen.incoming", GeneeServer.getInstance().isRunning()));
        formBuilder.addFirstColumn(listenCheckBox);
        final JTextField portField = new JTextField(20);
        portField.setText(String.valueOf(GeneeServer.getInstance().getPort()));
        formBuilder.add(portField);
        portField.setEnabled(listenCheckBox.isEnabled());
        listenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                portField.setEnabled(listenCheckBox.isEnabled());
                if (listenCheckBox.isSelected()) {
                    GeneralOptionsPanel.this.startServer();
                } else {
                    GeneralOptionsPanel.this.stopServer();
                }
                p.putBoolean("listen.incoming", listenCheckBox.isSelected());
                try {
                    p.sync();
                }
                catch (BackingStoreException x) {
                    x.printStackTrace();
                }
            }
        });
        portField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer port = Integer.parseInt(portField.getText().trim());
                GeneeServer.getInstance().setPort(port);
                if (listenCheckBox.isSelected()) {
                    GeneralOptionsPanel.this.startServer();
                } else {
                    GeneralOptionsPanel.this.stopServer();
                }
            }
        });
        formBuilder.nextSmallRow();
        this.listeningLabel = new JLabel("");
        formBuilder.addSpanned(this.listeningLabel);
        if (GeneeServer.getInstance().isRunning()) {
            this.setStartServerLabel();
        }
    }

    private void setStartServerLabel() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.listeningLabel.setText("Listening on " + localHost.getHostAddress() + ":" + GeneeServer.getInstance().getPort());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
    }

    private void startServer() {
        GeneeServer.getInstance().start();
        this.setStartServerLabel();
    }

    private void stopServer() {
        GeneeServer.getInstance().stop();
        this.listeningLabel.setText("");
    }
}

