/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.list.array.TIntArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.category.VectorVisualMapper;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.AbstractXYChartSeries;
import org.broadinstitute.genee.chart.BarRenderer;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.ChartRenderer;
import org.broadinstitute.genee.chart.ChartSelectionModel;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DefaultXYChartSeries;
import org.broadinstitute.genee.chart.LineAndShapeRenderer;
import org.broadinstitute.genee.chart.RangeRenderer;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.chart.SlicedXYChartDataset;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYChartSeries;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.FloatRange;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HeatMapChart
extends JComponent
implements ChartPropertiesSupplier,
Drawable {
    private List<XYChartDataset> chartDatasets = Collections.emptyList();
    private VectorColorModel colorModel;
    private WorldCoordinateMapper coordinateMapper;
    private Image image;
    private boolean isRowChart;
    private List<String> metadataColumnNames;
    private MetadataModel metadataModel;
    private int priorLeftOrTop = -1;
    private int priorRightOrBottom = -1;
    private Project project;
    private ProjectListener projectListener;
    private ArrayList<ChartRenderer> renderers;
    private SizesAndPositionsListener sizesAndPositionsListener;
    private Stroke stroke = new BasicStroke();
    private boolean validImage;
    private SizesAndPositions viewSizesAndPositions;
    private Rectangle visibleRect = new Rectangle();

    public HeatMapChart(final SizesAndPositions viewSizesAndPositions, List<String> metadataColumnNames, final boolean isRowChart) {
        this.isRowChart = isRowChart;
        this.metadataColumnNames = metadataColumnNames;
        this.viewSizesAndPositions = viewSizesAndPositions;
        this.setMinimumSize(new Dimension(0, 0));
        this.setBackground(Color.WHITE);
        this.sizesAndPositionsListener = new SizesAndPositionsListener(){

            @Override
            public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                HeatMapChart.this.revalidate();
                HeatMapChart.this.repaint();
            }
        };
        viewSizesAndPositions.addSizesAndPositionsListener(this.sizesAndPositionsListener);
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                if (e == null || isRowChart && e.isRowChanged() || !isRowChart && e.isColumnChanged()) {
                    HeatMapChart.this.createChartDatasets();
                    HeatMapChart.this.revalidate();
                    HeatMapChart.this.repaint();
                }
            }
        };
        this.coordinateMapper = isRowChart ? new WorldCoordinateMapper(){

            @Override
            public float yToPix(float y) {
                return viewSizesAndPositions.getPosition((int)y) + viewSizesAndPositions.getSize() / 2.0f;
            }
        } : new WorldCoordinateMapper(){

            @Override
            public float xToPix(float x) {
                return viewSizesAndPositions.getPosition((int)x) + viewSizesAndPositions.getSize() / 2.0f;
            }
        };
        this.coordinateMapper.setBottomGutter(0.0f);
        this.coordinateMapper.setTopGutter(0.0f);
        this.coordinateMapper.setLeftGutter(0.0f);
        this.coordinateMapper.setRightGutter(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    Boolean colorEnabled = (Boolean)HeatMapChart.this.metadataModel.get(0).getProperty("Chart Color Enabled");
                    final Color color = (Color)HeatMapChart.this.metadataModel.get(0).getProperty("Chart Color");
                    final JCheckBoxMenuItem useAnnotationColorsMenuItem = new JCheckBoxMenuItem("Use Annotation Colors", !Boolean.TRUE.equals(colorEnabled));
                    JMenuItem chooseColorMenuItem = new JMenuItem("Choose Chart Color\u2026");
                    chooseColorMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Color c = UIUtil.showColorDialog(HeatMapChart.this, "Chart Color", color);
                            if (c != null) {
                                HeatMapChart.this.metadataModel.get(0).setProperty("Chart Color Enabled", true);
                                HeatMapChart.this.metadataModel.get(0).setProperty("Chart Color", c);
                                HeatMapChart.this.validImage = false;
                                HeatMapChart.this.repaint();
                            }
                        }
                    });
                    useAnnotationColorsMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeatMapChart.this.metadataModel.get(0).setProperty("Chart Color Enabled", !useAnnotationColorsMenuItem.isSelected());
                            HeatMapChart.this.validImage = false;
                            HeatMapChart.this.repaint();
                        }
                    });
                    popupMenu.add(useAnnotationColorsMenuItem);
                    popupMenu.add(chooseColorMenuItem);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
        this.getParent().setBackground(Color.WHITE);
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        int left = HeatMapElementPanel.getLeft(clip, this.viewSizesAndPositions);
        int right = HeatMapElementPanel.getRight(this.project.getViewColumnCount(), clip, this.viewSizesAndPositions);
        this.internalDraw((Graphics2D)g, left, right, this.isRowChart ? clip.width : clip.height, false);
    }

    public float getAutoscaleXMax() {
        float max = -3.4028235E38f;
        for (XYChartDataset d : this.chartDatasets) {
            max = Math.max(d.getXMax(), max);
        }
        return max;
    }

    public float getAutoscaleXMin() {
        float min = Float.MAX_VALUE;
        for (XYChartDataset d : this.chartDatasets) {
            min = Math.min(d.getXMin(), min);
        }
        return min;
    }

    public float getAutoscaleYMax() {
        float max = -3.4028235E38f;
        for (XYChartDataset d : this.chartDatasets) {
            max = Math.max(d.getYMax(), max);
        }
        return max;
    }

    public float getAutoscaleYMin() {
        float min = Float.MAX_VALUE;
        for (XYChartDataset d : this.chartDatasets) {
            min = Math.min(d.getYMin(), min);
        }
        return min;
    }

    @Override
    public float getBarSize(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.viewSizesAndPositions.getSize();
    }

    public WorldCoordinateMapper getCoordinateMapper() {
        return this.coordinateMapper;
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension size = this.getPreferredSize();
        if (this.isShowing()) {
            if (this.isRowChart) {
                size.width = this.getVisibleRect().width;
                size.height = HeatMapPanel.getSizeNoBorder(this.viewSizesAndPositions);
            } else {
                size.height = this.getVisibleRect().height;
                size.width = HeatMapPanel.getSizeNoBorder(this.viewSizesAndPositions);
            }
        }
        return size;
    }

    @Override
    public float getGutter() {
        return 0.0f;
    }

    @Override
    public Color getItemColor(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        Boolean colorEnabled = (Boolean)this.metadataModel.get(seriesIndex).getProperty("Chart Color Enabled");
        if (Boolean.TRUE.equals(colorEnabled)) {
            Color color = (Color)this.metadataModel.get(seriesIndex).getProperty("Chart Color");
            return color != null ? color : QualitativeColorSchemes.getTenColor(0);
        }
        if (this.isRowChart) {
            return (Color)this.colorModel.getMappedValue(this.metadataModel.get(seriesIndex), this.metadataModel.get(seriesIndex).getValue((int)chartDataset.getY(seriesIndex, itemIndex)));
        }
        return (Color)this.colorModel.getMappedValue(this.metadataModel.get(seriesIndex), this.metadataModel.get(seriesIndex).getValue((int)chartDataset.getX(seriesIndex, itemIndex)));
    }

    @Override
    public Shape getItemShape(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex, float pointSize) {
        return ShapeUtil.getShape(0, pointSize);
    }

    @Override
    public float getItemSize(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.viewSizesAndPositions.getSize();
    }

    @Override
    public Stroke getItemStroke(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return this.stroke;
    }

    public List<String> getMetadataColumnNames() {
        return this.metadataColumnNames;
    }

    @Override
    public Dimension getPreferredSize() {
        int widthOrHeight = HeatMapPanel.getSize(this.viewSizesAndPositions);
        int w = 60;
        if (this.chartDatasets == null || this.chartDatasets.size() == 0) {
            return this.isRowChart ? new Dimension(0, widthOrHeight) : new Dimension(widthOrHeight, 0);
        }
        return this.isRowChart ? new Dimension(w, widthOrHeight) : new Dimension(widthOrHeight, w);
    }

    @Override
    public Stroke getSeriesStroke(XYChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        return this.stroke;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.isRowChart) {
            int[] indices = DefaultSizesAndPositions.getIndices(this.viewSizesAndPositions, e.getY());
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            Dataset dataset = this.project.getSortedFilteredDataset();
            String metadataName = this.metadataColumnNames.get(0);
            for (int index : indices) {
                buf.append(DatasetUtil.getToolTipText(dataset, index, -1, metadataName, null));
                buf.append("<br>");
            }
            return buf.toString();
        }
        int[] indices = DefaultSizesAndPositions.getIndices(this.viewSizesAndPositions, e.getX());
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        Dataset dataset = this.project.getSortedFilteredDataset();
        String metadataName = this.metadataColumnNames.get(0);
        for (int index : indices) {
            buf.append(DatasetUtil.getToolTipText(dataset, -1, index, null, metadataName));
            buf.append("<br>");
        }
        return buf.toString();
    }

    @Override
    public void init(ChartSelectionModel chartSelectionModel, int width, int height) {
    }

    public void invalidateImage() {
        this.validImage = false;
    }

    @Override
    public boolean isSelected(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        return false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return true;
    }

    @Override
    public boolean isSizeBySeries() {
        return false;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        if (this.viewSizesAndPositions != null) {
            this.viewSizesAndPositions.removeSizesAndPositionsListener(this.sizesAndPositionsListener);
        }
        UIUtil.unregisterToolTip(this);
    }

    @Override
    public void setColorByChartHighlighter(Highlighter highlighter) {
    }

    @Override
    public void setColorBySeries(boolean b) {
    }

    @Override
    public void setColorByVector(Vector vector) {
    }

    @Override
    public void setColorModel(VectorColorModel colorModel) {
    }

    @Override
    public void setDefaultColor(Color defaultChartColor) {
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        if (project != null) {
            this.colorModel = this.isRowChart ? project.getRowColorModel() : project.getColumnColorModel();
            project.addProjectListener(this.projectListener);
            this.projectListener.projectChanged(null);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setShapeByChartHighlighter(Highlighter highlighter) {
    }

    @Override
    public void setShapeBySeries(boolean b) {
    }

    @Override
    public void setShapeByVector(Vector shapeByVector, VectorVisualMapper<Integer> vectorShapeModel) {
    }

    @Override
    public void setSizeByChartHighlighter(Highlighter highlighter) {
    }

    @Override
    public void setSizeBySeries(boolean b) {
    }

    @Override
    public void setSizeByVector(Vector sizeByVector, Map<Object, Float> valueToSize) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        int tmpRightOrBottom;
        int tmpLeftOrTop;
        super.paintComponent(g);
        Rectangle currentVisibleRect = this.getVisibleRect();
        if (this.validImage && (currentVisibleRect.height != this.visibleRect.height || currentVisibleRect.y != this.visibleRect.y || currentVisibleRect.width != this.visibleRect.width || currentVisibleRect.x != this.visibleRect.x)) {
            this.validImage = false;
        }
        if (!this.isRowChart) {
            tmpLeftOrTop = HeatMapElementPanel.getLeft(currentVisibleRect, this.viewSizesAndPositions);
            tmpRightOrBottom = HeatMapElementPanel.getRight(this.project.getViewColumnCount(), currentVisibleRect, this.viewSizesAndPositions);
        } else {
            tmpLeftOrTop = HeatMapElementPanel.getTop(this.project.getViewRowCount(), currentVisibleRect, this.viewSizesAndPositions);
            tmpRightOrBottom = HeatMapElementPanel.getBottom(this.project.getViewRowCount(), currentVisibleRect, this.viewSizesAndPositions);
        }
        if (this.validImage && (tmpLeftOrTop != this.priorLeftOrTop || tmpRightOrBottom != this.priorRightOrBottom)) {
            this.validImage = false;
        }
        if (!this.validImage) {
            this.validImage = true;
            this.visibleRect = currentVisibleRect;
            this.priorLeftOrTop = tmpLeftOrTop;
            this.priorRightOrBottom = tmpRightOrBottom;
            this.image = new BufferedImage(this.visibleRect.width, this.visibleRect.height, 2);
            Graphics2D imageGraphics = (Graphics2D)this.image.getGraphics();
            this.internalDraw(imageGraphics, tmpLeftOrTop, tmpRightOrBottom, this.isRowChart ? this.getVisibleRect().width : this.getVisibleRect().height, true);
            imageGraphics.dispose();
        }
        g.drawImage(this.image, this.visibleRect.x, this.visibleRect.y, null);
    }

    private void createChartDatasets() {
        this.metadataModel = this.isRowChart ? this.project.getSortedFilteredDataset().getRowMetadata() : this.project.getSortedFilteredDataset().getColumnMetadata();
        TIntArrayList indices = new TIntArrayList(MetadataUtil.getIndices(this.metadataModel, this.metadataColumnNames, true));
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.getQuick(i);
            if (index != -1) continue;
            System.out.println("chart-out of date metadata");
            indices.removeAt(i);
            --i;
        }
        this.metadataModel = new MetadataModelColumnView(this.metadataModel, indices.toArray());
        TIntArrayList metadataIndices = new TIntArrayList();
        this.chartDatasets = new ArrayList<XYChartDataset>();
        this.renderers = new ArrayList();
        int size = this.metadataModel.getMetadataCount();
        for (int metadataIndex = 0; metadataIndex < size; ++metadataIndex) {
            AbstractChartRenderer r;
            Integer style = (Integer)this.metadataModel.get(metadataIndex).getProperty("Chart Style");
            if (style == null) continue;
            if (style == 64) {
                BarRenderer barRenderer = new BarRenderer(false);
                if (this.isRowChart) {
                    barRenderer.setHorizontal(true);
                }
                r = barRenderer;
            } else if (style == 8) {
                r = new RangeRenderer();
            } else {
                LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
                lineAndShapeRenderer.setProperty("lines", 2 == style);
                lineAndShapeRenderer.setProperty("points", 4 == style);
                r = lineAndShapeRenderer;
            }
            XYChartSeries series = this.createSeries(this.metadataModel.get(metadataIndex), style);
            metadataIndices.add(metadataIndex);
            DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
            chartDataset.addSeries(series);
            if (this.isRowChart) {
                if (chartDataset.getXMin() > 0.0f && chartDataset.getXMax() > 0.0f && 64 == style) {
                    chartDataset.setXMin(0.0f);
                } else if (chartDataset.getXMax() < 0.0f && 64 == style) {
                    chartDataset.setXMax(0.0f);
                }
            } else if (chartDataset.getYMin() > 0.0f && chartDataset.getYMax() > 0.0f && 64 == style) {
                chartDataset.setYMin(0.0f);
            } else if (chartDataset.getYMax() < 0.0f && 64 == style) {
                chartDataset.setYMax(0.0f);
            }
            r.setChartPropertiesSupplier(this);
            this.renderers.add(r);
            this.chartDatasets.add(chartDataset);
        }
        this.metadataModel = metadataIndices.size() != this.metadataModel.getMetadataCount() ? new MetadataModelColumnView(this.metadataModel, metadataIndices.toArray()) : this.metadataModel;
    }

    private XYChartSeries createRangeSeries(final Vector vector) {
        AbstractXYChartSeries series = new AbstractXYChartSeries(vector.getName()){

            @Override
            public int getItemCount() {
                return vector.size();
            }

            @Override
            public float getX(int index) {
                FloatRange range = (FloatRange)vector.getValue(index);
                return range != null ? range.getMax() : Float.NaN;
            }

            @Override
            public float getXStart(int index) {
                FloatRange range = (FloatRange)vector.getValue(index);
                return range != null ? range.getMin() : Float.NaN;
            }

            @Override
            public float getY(int index) {
                return index;
            }
        };
        series.autoscaleX();
        series.setYMin(0.0f);
        series.setYMax(vector.size());
        return series;
    }

    private XYChartSeries createSeries(Vector vector, int style) {
        if (style == 8) {
            return this.createRangeSeries(vector);
        }
        DefaultXYChartSeries series = new DefaultXYChartSeries(vector.getName(), vector.size());
        if (Number.class.isAssignableFrom(vector.getColumnClass())) {
            int size = vector.size();
            for (int j = 0; j < size; ++j) {
                float y;
                float x;
                float val;
                Number value = (Number)vector.getValue(j);
                float f = val = value != null ? value.floatValue() : Float.NaN;
                if (this.isRowChart) {
                    x = val;
                    y = j;
                } else {
                    x = j;
                    y = val;
                }
                series.add(x, y);
            }
        }
        return series;
    }

    private void internalDraw(Graphics2D g, int leftOrTop, int rightOrBottom, int widthOrHeight, boolean translate) {
        g.setFont(this.getFont());
        g.setRenderingHints(UIUtil.RENDERING_HINTS);
        if (translate) {
            g.translate(-this.visibleRect.x, -this.visibleRect.y);
        }
        this.coordinateMapper.setXMin(this.getAutoscaleXMin());
        this.coordinateMapper.setXMax(this.getAutoscaleXMax());
        this.coordinateMapper.setYMin(this.getAutoscaleYMin());
        this.coordinateMapper.setYMax(this.getAutoscaleYMax());
        boolean points = false;
        int size = this.metadataModel.getMetadataCount();
        for (int metadataIndex = 0; metadataIndex < size && !points; ++metadataIndex) {
            Integer style = (Integer)this.metadataModel.get(metadataIndex).getProperty("Chart Style");
            if (style == null || 4 != style) continue;
            points = true;
        }
        float gutter = points ? this.viewSizesAndPositions.getSize() / 2.0f : 2.0f;
        gutter = Math.max(6.0f, gutter);
        if (this.isRowChart) {
            this.coordinateMapper.setLeftGutter(gutter);
            this.coordinateMapper.setRightGutter(gutter);
        } else {
            this.coordinateMapper.setTopGutter(gutter);
            this.coordinateMapper.setBottomGutter(gutter);
        }
        List<Object> slicedList = new ArrayList();
        if (translate && leftOrTop != -1) {
            for (XYChartDataset d : this.chartDatasets) {
                slicedList.add(new SlicedXYChartDataset(d, leftOrTop, rightOrBottom - leftOrTop));
            }
        } else {
            slicedList = this.chartDatasets;
        }
        int size2 = HeatMapPanel.getSize(this.viewSizesAndPositions);
        if (this.isRowChart) {
            this.coordinateMapper.setXYPixelScale(widthOrHeight, size2);
        } else {
            this.coordinateMapper.setXYPixelScale(size2, widthOrHeight);
        }
        for (int i = 0; i < slicedList.size(); ++i) {
            ChartRenderer chartRenderer = this.renderers.get(i);
            chartRenderer.paint((XYChartDataset)slicedList.get(i), i, g, this.coordinateMapper);
        }
    }
}

