/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.set.hash.TIntHashSet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetSeriesAdapter;

public class HeatMapElementRenderer {
    private HeatMapColorScheme colorScheme;
    private Dataset dataset;
    private boolean drawGrid = true;
    private boolean drawValues = false;
    private ElementPainter elementPainter = new DefaultElementPainter();
    private Color gridColor = Color.GRAY;
    private TIntHashSet maskedColumnIndices = new TIntHashSet(1);
    private TIntHashSet maskedRowIndices = new TIntHashSet(1);
    private Project project;

    public void setProject(Project project) {
        this.project = project;
        this.dataset = project.getSortedFilteredDataset();
        if (this.colorScheme == null) {
            if (this.dataset != null && this.dataset.getColumnCount() == 1) {
                this.colorScheme = new DefaultHeatMapColorScheme(false);
            } else if (Boolean.TRUE.equals(this.dataset.getProperty("isBinary"))) {
                this.colorScheme = new DefaultHeatMapColorScheme(true);
                HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(this.colorScheme, "binary");
            } else {
                this.colorScheme = new DefaultHeatMapColorScheme(true);
            }
        }
        this.elementPainter.setProject(project);
        this.colorScheme.setProject(project);
        this.colorScheme.getLegend().setVisible(this.elementPainter.setColorScheme(this.colorScheme));
    }

    public void draw(Graphics2D g2, int left, int right, int top, int bottom, SizesAndPositions columnSizesAndPositions, SizesAndPositions rowSizesAndPositions) {
        g2.addRenderingHints(UIUtil.RENDERING_HINTS);
        float rowSize = rowSizesAndPositions.getSize();
        float columnSize = columnSizesAndPositions.getSize();
        int minSize = 7;
        boolean drawValues = this.drawValues && columnSize > (float)minSize && rowSize > (float)minSize;
        FontMetrics fm = null;
        if (drawValues) {
            float fontSize = rowSize - 1.0f;
            Font font = g2.getFont().deriveFont(fontSize);
            int width = g2.getFontMetrics(font).stringWidth("-999.999");
            fontSize = (rowSize - 3.0f) / (float)width * fontSize;
            g2.setFont(g2.getFont().deriveFont(fontSize));
            fm = g2.getFontMetrics();
        }
        boolean drawGrid = this.drawGrid && columnSize > (float)minSize && rowSize > (float)minSize;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        if (drawGrid && this.elementPainter instanceof DefaultElementPainter) {
            drawGrid = !((DefaultElementPainter)this.elementPainter).isUseShape();
        }
        Stroke stroke = g2.getStroke();
        Dataset dataset = this.colorScheme.getDatasetName() == null ? this.dataset : new DatasetSeriesAdapter(this.dataset, this.colorScheme.getDatasetName());
        float gridStrokeWidth = 0.5f;
        BasicStroke gridStroke = new BasicStroke(gridStrokeWidth);
        for (int row = top; row < bottom; ++row) {
            float py = rowSizesAndPositions.getPosition(row);
            for (int column = left; column < right; ++column) {
                float px = columnSizesAndPositions.getPosition(column);
                this.elementPainter.draw(g2, dataset, row, column, px, py, columnSize, rowSize);
                if (drawValues) {
                    g2.setColor(Color.BLACK);
                    float d = dataset.getValue(row, column);
                    String val = Formatter.format(d);
                    g2.drawString(val, px + columnSize / 2.0f - (float)(fm.stringWidth(val) / 2), py + rowSize / 2.0f + 1.0f);
                }
                if (!drawGrid) continue;
                rect.x = px;
                rect.y = py;
                rect.width = columnSize;
                rect.height = rowSize;
                g2.setStroke(gridStroke);
                g2.setColor(this.gridColor);
                g2.setStroke(stroke);
                g2.draw(rect);
            }
        }
        if (this.maskedRowIndices != null && this.maskedRowIndices.size() > 0) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2.setColor(Color.DARK_GRAY);
            float leftx = columnSizesAndPositions.getPosition(left);
            float rightx = columnSizesAndPositions.getPosition(right);
            for (int row = top; row < bottom; ++row) {
                boolean mask = this.maskedRowIndices.contains(row);
                if (!mask) continue;
                float y = rowSizesAndPositions.getPosition(row);
                rect.setRect(leftx, y, rightx, rowSizesAndPositions.getSize());
                g2.fill(rect);
            }
            g2.setComposite(oldComposite);
        }
        if (this.maskedColumnIndices != null && this.maskedColumnIndices.size() > 0) {
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2.setColor(Color.DARK_GRAY);
            float topy = rowSizesAndPositions.getPosition(top);
            float bottomy = rowSizesAndPositions.getPosition(bottom);
            for (int column = left; column < right; ++column) {
                boolean mask = this.maskedColumnIndices.contains(column);
                if (!mask) continue;
                float x = columnSizesAndPositions.getPosition(column);
                rect.setRect(x, topy, columnSizesAndPositions.getSize(), bottomy - topy);
                g2.fill(rect);
            }
            g2.setComposite(oldComposite);
        }
    }

    public int getBottom(Rectangle rect, SizesAndPositions sizesAndPositions) {
        return HeatMapElementPanel.getBottom(this.dataset.getRowCount(), rect, sizesAndPositions);
    }

    public HeatMapColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public int getLeft(Rectangle rect, SizesAndPositions sizesAndPositions) {
        int left = HeatMapElementPanel.getLeft(rect, sizesAndPositions);
        if (left >= this.dataset.getColumnCount()) {
            left = this.dataset.getColumnCount();
        }
        return left;
    }

    public Project getProject() {
        return this.project;
    }

    public int getRight(Rectangle rect, SizesAndPositions sizesAndPositions) {
        return HeatMapElementPanel.getRight(this.dataset.getColumnCount(), rect, sizesAndPositions);
    }

    public int getTop(Rectangle rect, SizesAndPositions sizesAndPositions) {
        return HeatMapElementPanel.getTop(this.dataset.getRowCount(), rect, sizesAndPositions);
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public boolean isDrawValues() {
        return this.drawValues;
    }

    public void setDrawGrid(boolean drawGrid) {
        this.drawGrid = drawGrid;
    }

    public void setDrawValues(boolean drawValues) {
        this.drawValues = drawValues;
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    ElementPainter getElementPainter() {
        return this.elementPainter;
    }

    void setColorScheme(HeatMapColorScheme colorScheme) {
        this.colorScheme.dispose();
        ChangeListener[] savedListeners = new ChangeListener[]{};
        if (this.colorScheme != colorScheme) {
            savedListeners = this.colorScheme.getChangeListeners();
        }
        this.colorScheme = colorScheme;
        for (ChangeListener l : savedListeners) {
            this.colorScheme.addChangeListener(l);
        }
        this.colorScheme.setProject(this.project);
        this.colorScheme.getLegend().setVisible(this.elementPainter.setColorScheme(colorScheme));
        this.colorScheme.getLegend().revalidate();
        this.colorScheme.getLegend().repaint();
    }

    void setElementPainter(ElementPainter elementPainter) {
        this.elementPainter = elementPainter;
    }

    boolean setMaskedColumnIndices(TIntHashSet maskedColumnIndices) {
        boolean ret = this.maskedColumnIndices.size() == 0 && maskedColumnIndices.size() == 0;
        this.maskedColumnIndices = maskedColumnIndices;
        return ret;
    }

    boolean setMaskedRowIndices(TIntHashSet maskedRowIndices) {
        boolean ret = this.maskedRowIndices.size() == 0 && maskedRowIndices.size() == 0;
        this.maskedRowIndices = maskedRowIndices;
        return ret;
    }

    void updateDataset() {
        this.dataset = this.project.getSortedFilteredDataset();
        this.elementPainter.setProject(this.project);
    }
}

