/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.google.common.base.Function;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.SimpleScrollPane;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.category.CategoryLegend;
import org.broadinstitute.genee.category.ColorPanel;
import org.broadinstitute.genee.category.ColumnCategoryNamesPanel;
import org.broadinstitute.genee.category.ColumnCategoryPanel;
import org.broadinstitute.genee.category.ColumnHeaderMouseListener;
import org.broadinstitute.genee.category.RowColorPanel;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.category.VectorVisualMapperListener;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.clustering.hierarchical.ColumnDendrogramPanel;
import org.broadinstitute.genee.clustering.hierarchical.DendrogramColorEditor;
import org.broadinstitute.genee.clustering.hierarchical.RowDendrogramPanel;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableArray;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.PrintingStatus;
import org.broadinstitute.genee.gui.SplitPaneSynchronizer;
import org.broadinstitute.genee.gui.ThreadSafePrintable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.Zoomable;
import org.broadinstitute.genee.gui.scroll.HorizontalScrollBarUIHelper;
import org.broadinstitute.genee.gui.scroll.VerticalScrollBarUIHelper;
import org.broadinstitute.genee.heatmap.AbstractProjectQuickSearch;
import org.broadinstitute.genee.heatmap.ColumnGrouper;
import org.broadinstitute.genee.heatmap.DatasetElementToolTipProvider;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.ElementEvent;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.ElementSelectionListener;
import org.broadinstitute.genee.heatmap.HeatMapChart;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.heatmap.HeatMapEditorKit;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapOptionsDialog;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.MetadataVerticalTableHeader;
import org.broadinstitute.genee.heatmap.PresetColorSchemesShortcuts;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.QuickColumnSearch;
import org.broadinstitute.genee.heatmap.QuickRowSearch;
import org.broadinstitute.genee.heatmap.RowGrouper;
import org.broadinstitute.genee.heatmap.SelectMissingAction;
import org.broadinstitute.genee.heatmap.SelectionPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.SizesAndPositionsEvent;
import org.broadinstitute.genee.heatmap.SizesAndPositionsListener;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.heatmap.SparklineTableCellRenderer;
import org.broadinstitute.genee.heatmap.menu.ClearSelectionAction;
import org.broadinstitute.genee.heatmap.menu.InvertSelectionAction;
import org.broadinstitute.genee.heatmap.menu.SelectAllAction;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.math.stat.function.WeightedMean;
import org.broadinstitute.genee.math.stat.function.bivariate.SpearmanCorrelation;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.table.HeatMapColumnTable;
import org.broadinstitute.genee.table.HeatMapColumnTableDrawer;
import org.broadinstitute.genee.table.HeatMapColumnTableModel;
import org.broadinstitute.genee.table.HeatMapRowTable;
import org.broadinstitute.genee.table.HeatMapRowTableDrawer;
import org.broadinstitute.genee.table.HeatMapRowTableModel;
import org.broadinstitute.genee.table.SortingHelper;
import org.broadinstitute.genee.table.VerticalTableDrawer;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.swingx.util.OS;

public class HeatMapPanel
extends JPanel
implements Drawable,
Zoomable {
    private static final String AXIS_PROPERTY = "axis";
    private static final String DEPENDENT_COMPONENT = "dep.component";
    private static final int TOP_SPLIT_PANE_COLUMN_DENDROGRAM_INDEX = 0;
    SizesAndPositions viewColumnSizesAndPositions;
    private Component aboveRowTableCustomComponent;
    private JPanel aboveRowTablePanel;
    private VectorVisualMapperListener categoryColorModelListener;
    private boolean categoryLegendVisible = true;
    private JScrollPane colorLegendDescriptionTableHeaderScrollPane;
    private JComponent colorSchemeLegend;
    private MouseAdapter colorSchemeLegendMouseListener;
    private ColumnCategoryPanel columnCategoryPanel;
    private List<HeatMapChart> columnCharts = new ArrayList<HeatMapChart>();
    private int columnColorCategoryLegendBoxSize = 12;
    private ColumnCategoryNamesPanel columnColorNamesPanel;
    private DendrogramColorEditor columnDendrogramColorEditor;
    private ColumnDendrogramPanel columnDendrogramPanel;
    private DefaultSizesAndPositions columnModelSizesAndPositions;
    private JPopupMenu columnPopupMenu;
    private SizesAndPositionsListener columnSizesAndPositionsListener;
    private HeatMapColumnTable columnTable;
    private DrawablePositionInfo drawablePositionInfo;
    private HeatMapEditorKit editorKit;
    private HeatMapElementPanel elementPanel;
    private JSplitPane elementPanelAndTopSplitter;
    private JScrollPane elementPanelScrollPane;
    private boolean elementSelectionEnabled = true;
    private ElementSelectionListener elementSelectionListener;
    private HeatMapToolBar heatMapToolBar;
    private JideSplitPane horizontalSplitPane;
    private int maximumRowTableChars = -1;
    private MouseMode mouseMode = MouseMode.DRAG_PAN;
    private MatrixElement mouseMovedElement;
    private OptionController optionController;
    private HeatMapOptionsDialog optionsDialog;
    private Throwable printError;
    private boolean profileInTableVisible;
    private Project project;
    private ProjectListener projectListener;
    private boolean proportionalLayout = true;
    private boolean proportionsSet;
    private QuickColumnSearch quickColumnSearch;
    private QuickRowSearch quickRowSearch;
    private MetadataVerticalTableHeader rowCategoryHeader;
    private RowColorPanel rowCategoryPanel;
    private JScrollPane rowCategoryPanelScrollPane;
    private JSplitPane rowCategorySplitter;
    private List<HeatMapChart> rowCharts = new ArrayList<HeatMapChart>();
    private int rowColorCategoryLegendBoxSize = 12;
    private DendrogramColorEditor rowDendrogramColorEditor;
    private RowDendrogramPanel rowDendrogramPanel;
    private JScrollPane rowDendrogramScrollPane;
    private JSplitPane rowDendrogramSplitter;
    private JPanel rowDendrogramSplitterTopComponent;
    private DefaultSizesAndPositions rowModelSizesAndPositions;
    private JPopupMenu rowPopupMenu;
    private HeatMapRowTable rowTable;
    private JScrollPane rowTableScrollPane;
    private SelectionPanel selectionPanel;
    private boolean showColorSchemeLegendInImage = true;
    private boolean squareAspect = true;
    private DatasetElementToolTipProvider toolTipProvider;
    private JideSplitPane topSplitPane;
    private SplitPaneSynchronizer verticalSplitPaneSynchronizer;
    private SizesAndPositions viewRowSizesAndPositions;

    public HeatMapPanel(Project project) {
        if (project == null) {
            throw new NullPointerException("Project is null.");
        }
        this.project = project;
        this.setFocusable(true);
        this.viewRowSizesAndPositions = new DefaultSizesAndPositions();
        this.viewRowSizesAndPositions.addSizesAndPositionsListener(new SizesAndPositionsListener(){

            @Override
            public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                HeatMapPanel.this.updateModelSizesAndPositions(HeatMapPanel.this.project, e, HeatMapPanel.this.getRowModelSizesAndPositions(), HeatMapPanel.this.viewRowSizesAndPositions, true);
                HeatMapPanel.this.revalidate();
            }
        });
        new PresetColorSchemesShortcuts(this);
        this.optionController = new OptionController();
        this.squareAspect = true;
        this.init();
        this.setRowPopupMenu(this.createRowPopupMenu());
        this.setColumnPopupMenu(this.createColumnPopupMenu());
        this.setShowRowProfileSparkLines(false, false);
        this.setProject(project);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.proportionsSet) {
            this.setProportions();
        }
    }

    public void clearColumnSelection() {
        this.columnTable.clearSelection();
    }

    public void clearRowSelection() {
        this.rowTable.clearSelection();
    }

    @Override
    public void draw(Graphics g, Rectangle d) {
        int width;
        String name;
        Dimension chartSize;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        transform.translate(1.0, 0.0);
        if (this.aboveRowTableCustomComponent != null && this.aboveRowTableCustomComponent.isVisible()) {
            Dimension prefSize = this.aboveRowTableCustomComponent.getPreferredSize();
            if (this.aboveRowTableCustomComponent instanceof Drawable) {
                ((Drawable)((Object)this.aboveRowTableCustomComponent)).draw(g2, null);
            } else {
                new DrawableWrapper(this.aboveRowTableCustomComponent).draw(g2, null);
            }
            g.translate(0, prefSize.height);
        }
        g.setColor(Color.BLACK);
        if (this.categoryLegendVisible && MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0) {
            CategoryLegend columnColorLegend = new CategoryLegend(false, this.columnColorCategoryLegendBoxSize);
            columnColorLegend.setProject(this.project);
            new DrawableWrapper(columnColorLegend).draw(g2, d);
            g.translate(0, columnColorLegend.getPreferredSize().height);
        }
        if (this.categoryLegendVisible && MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0) {
            CategoryLegend rowColorLegend = new CategoryLegend(true, this.rowColorCategoryLegendBoxSize);
            rowColorLegend.setProject(this.project);
            new DrawableWrapper(rowColorLegend).draw(g2, d);
            g.translate(0, rowColorLegend.getPreferredSize().height);
        }
        g2.translate(this.drawablePositionInfo.elementPanelXStart, 0);
        JComponent colorSchemeLegend = this.elementPanel.getColorScheme().getLegend();
        if (colorSchemeLegend != null && colorSchemeLegend.isVisible()) {
            boolean customSizeSet;
            Drawable drawableWrapper = colorSchemeLegend instanceof Drawable ? (Drawable)((Object)colorSchemeLegend) : new DrawableWrapper(colorSchemeLegend);
            Dimension legendSize = drawableWrapper.getDrawableSize();
            boolean bl = customSizeSet = colorSchemeLegend instanceof HeatMapColorSchemeLegend ? ((HeatMapColorSchemeLegend)colorSchemeLegend).isDrawableSizeSet() : false;
            if (!customSizeSet && legendSize.width > d.width - 100) {
                legendSize.width = d.width - 100;
            }
            drawableWrapper.draw(g, new Rectangle(legendSize));
            g.translate(0, legendSize.height);
        }
        if (this.columnDendrogramPanel != null) {
            Dimension size = this.columnDendrogramPanel.getDrawableSize();
            this.columnDendrogramPanel.draw(g, new Rectangle(size));
            g.translate(0, size.height);
        }
        HeatMapColumnTableDrawer columnNamesTableDrawer = new HeatMapColumnTableDrawer((JTable)((Object)this.columnTable), this.viewColumnSizesAndPositions);
        columnNamesTableDrawer.draw(g, d);
        g2.translate(0, columnNamesTableDrawer.getPreferredSize().height + 2);
        for (HeatMapChart chart : this.columnCharts) {
            chartSize = chart.getDrawableSize();
            chart.draw(g2, new Rectangle(chartSize));
            Axis axis = (Axis)chart.getClientProperty(AXIS_PROPERTY);
            Dimension axisSize = axis.getDrawableSize();
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(-2, 6, -2, axisSize.height - 6);
            int tx = axisSize.width + 2;
            g.translate(-tx, 0);
            axis.draw(g, new Rectangle(axisSize));
            g2.translate(tx, chartSize.height);
            name = chart.getMetadataColumnNames().get(0);
            g.setColor(Color.BLACK);
            g.setFont(g.getFont().deriveFont(Math.min(10.0f, (float)(axisSize.height / 2 - 2))));
            width = g.getFontMetrics().stringWidth(name);
            g.drawString(name, -width - tx - 4, -axisSize.height / 2);
        }
        if (MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0) {
            Dimension columnCategoryPanelSize = this.columnCategoryPanel.getDrawableSize();
            int columnCategoriesHeight = columnCategoryPanelSize.height;
            this.columnCategoryPanel.draw(g, new Rectangle(columnCategoryPanelSize));
            g.setColor(Color.BLACK);
            g.setFont(g.getFont().deriveFont((float)this.columnCategoryPanel.getSizePerClass()));
            MetadataModel metadata = this.columnColorNamesPanel.getModel();
            int y = this.columnCategoryPanel.getSizePerClass() * metadata.getMetadataCount() - 1 - this.columnCategoryPanel.getSizePerClass();
            int metadataCount = metadata.getMetadataCount();
            for (int metadataIndex = 0; metadataIndex < metadataCount; ++metadataIndex) {
                name = metadata.getColumnName(metadataIndex);
                width = 1 + g.getFontMetrics().stringWidth(name);
                g.translate(-width, 0);
                g.drawString(name, 0, y + this.columnCategoryPanel.getSizePerClass());
                g.translate(width, 0);
                y -= this.columnCategoryPanel.getSizePerClass();
            }
            g.translate(0, columnCategoriesHeight);
        }
        if (this.rowDendrogramPanel != null) {
            g2.setTransform(transform);
            g.translate(this.drawablePositionInfo.elementPanelXStart, this.drawablePositionInfo.elementPanelYStart);
            Dimension dendSize = this.rowDendrogramPanel.getDrawableSize();
            g.translate(-dendSize.width, 0);
            this.rowDendrogramPanel.draw(g2, new Rectangle(dendSize));
            g.translate(dendSize.width, 0);
        }
        g2.setTransform(transform);
        g2.translate(this.drawablePositionInfo.elementPanelXStart + this.elementPanel.getPreferredSize().width, this.drawablePositionInfo.elementPanelYStart);
        if (MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0) {
            VerticalTableDrawer rowCategoryNamesTableDrawer = new VerticalTableDrawer(this.rowCategoryHeader){

                @Override
                protected int getColumnEnd(Rectangle clip) {
                    return HeatMapPanel.this.rowCategoryHeader.columnAtPoint(new Point(clip.x + clip.width, 0));
                }

                @Override
                protected int getColumnStart(Rectangle clip) {
                    return HeatMapPanel.this.rowCategoryHeader.columnAtPoint(new Point(clip.x, 0));
                }

                @Override
                protected float getPosition(int column) {
                    Rectangle rect = HeatMapPanel.this.rowCategoryHeader.getCellRect(0, column, false);
                    return rect.x;
                }

                @Override
                protected float getSize() {
                    return HeatMapPanel.this.rowCategoryHeader.getColumnModel().getColumn(0).getWidth();
                }
            };
            rowCategoryNamesTableDrawer.init();
            int height = rowCategoryNamesTableDrawer.getDrawableSize().height;
            g.translate(0, -height);
            rowCategoryNamesTableDrawer.draw(g2, d);
            g.translate(0, height);
            this.rowCategoryPanel.draw(g2, d);
            g2.translate(this.rowCategoryPanel.getDrawableSize().width, 0);
        }
        for (HeatMapChart chart : this.rowCharts) {
            chartSize = chart.getDrawableSize();
            chart.draw(g2, new Rectangle(chartSize));
            Axis axis = (Axis)chart.getClientProperty(AXIS_PROPERTY);
            axis.refresh();
            Dimension axisSize = axis.getDrawableSize();
            g.translate(0, -axisSize.height);
            axis.draw(g2, new Rectangle(axisSize));
            MetadataVerticalTableHeader rowHeaderTable = (MetadataVerticalTableHeader)chart.getClientProperty("header");
            JideLabel label = new JideLabel(rowHeaderTable.getMetadata().getColumnName(0));
            label.setOrientation(1);
            label.setClockwise(false);
            label.setHorizontalTextPosition(4);
            label.setVerticalTextPosition(0);
            DrawableWrapper wrapper = new DrawableWrapper((Component)label);
            Dimension labelSize = wrapper.getDrawableSize();
            int w = axisSize.width / 2 - labelSize.width / 2;
            g.translate(w, -labelSize.height - 6);
            wrapper.draw(g2, new Rectangle(labelSize));
            g.translate(-w, axisSize.height);
            g.translate(0, labelSize.height + 6);
            g2.translate(chartSize.width, 0);
        }
        if (this.rowTable.isVisible()) {
            HeatMapRowTableDrawer tableDrawer = new HeatMapRowTableDrawer(this.rowTable, this.viewRowSizesAndPositions, this.maximumRowTableChars);
            tableDrawer.draw(g2, d);
        }
        g2.setPaint(Color.BLACK);
        g2.setTransform(transform);
        g2.translate(this.drawablePositionInfo.elementPanelXStart, this.drawablePositionInfo.elementPanelYStart);
        this.elementPanel.draw(g, d);
        transform.translate(-1.0, 0.0);
        g2.setTransform(transform);
    }

    public void flipColumnDendrogram() {
        int i;
        int[] minMaxIndex = this.columnDendrogramPanel.flip();
        if (minMaxIndex == null) {
            return;
        }
        Dataset dataset = this.project.getOriginalDataset();
        int[] _currentOrder = this.project.getColumnSortOrder();
        int[] currentOrder = null;
        if (_currentOrder == null) {
            currentOrder = new int[dataset.getColumnCount()];
            for (int i2 = 0; i2 < currentOrder.length; ++i2) {
                currentOrder[i2] = i2;
            }
        } else {
            currentOrder = _currentOrder;
        }
        int[] order = new int[dataset.getColumnCount()];
        int min = minMaxIndex[0];
        int max = minMaxIndex[1];
        for (int i3 = 0; i3 < min; ++i3) {
            order[i3] = currentOrder[i3];
        }
        int index = max;
        for (i = min; i <= max; ++i) {
            order[i] = currentOrder[index--];
        }
        for (i = max + 1; i < dataset.getColumnCount(); ++i) {
            order[i] = currentOrder[i];
        }
        ArrayList<SortKeys.CustomSortKey> sortKeys = new ArrayList<SortKeys.CustomSortKey>();
        sortKeys.add(new SortKeys.CustomSortKey(order, SortOrder.UNSORTED));
        this.project.setColumnSortOrder(sortKeys);
    }

    public void flipRowDendrogram() {
        int i;
        int[] minMaxIndex = this.rowDendrogramPanel.flip();
        Dataset dataset = this.project.getOriginalDataset();
        int[] currentOrder = this.project.getRowSortOrder();
        if (currentOrder == null) {
            currentOrder = new int[dataset.getRowCount()];
            for (int i2 = 0; i2 < currentOrder.length; ++i2) {
                currentOrder[i2] = i2;
            }
        }
        int[] order = new int[dataset.getRowCount()];
        int min = minMaxIndex[0];
        int max = minMaxIndex[1];
        for (int i3 = 0; i3 < min; ++i3) {
            order[i3] = currentOrder[i3];
        }
        int index = max;
        for (i = min; i <= max; ++i) {
            order[i] = currentOrder[index--];
        }
        for (i = max + 1; i < dataset.getRowCount(); ++i) {
            order[i] = currentOrder[i];
        }
        ArrayList<SortKeys.CustomSortKey> sortKeys = new ArrayList<SortKeys.CustomSortKey>();
        sortKeys.add(new SortKeys.CustomSortKey(order, SortOrder.UNSORTED));
        this.project.setRowSortOrder(sortKeys);
    }

    public HeatMapColorScheme getColorScheme() {
        return this.elementPanel.getColorScheme();
    }

    public HeatMapColorScheme getColorScheme(int index) {
        return this.elementPanel.getColorScheme();
    }

    public JComponent getColorSchemeLegend() {
        return this.elementPanel != null ? this.elementPanel.getColorScheme().getLegend() : null;
    }

    public ColorPanel getColumnCategoryPanel() {
        return this.columnCategoryPanel;
    }

    public DendrogramColorEditor getColumnDendrogramColorEditor() {
        return this.columnDendrogramColorEditor;
    }

    public ColumnDendrogramPanel getColumnDendrogramPanel() {
        return this.columnDendrogramPanel;
    }

    public int getColumnIndex(int position) {
        return this.viewColumnSizesAndPositions.getIndex(position, true);
    }

    public JPopupMenu getColumnPopupMenu() {
        return this.columnPopupMenu;
    }

    public float getColumnPosition(int index) {
        return this.viewColumnSizesAndPositions.getPosition(index);
    }

    public float getColumnSize() {
        return this.elementPanel.getColumnSize();
    }

    public SizesAndPositions getColumnSizesAndPositions() {
        return this.viewColumnSizesAndPositions;
    }

    public JTable getColumnTable() {
        return this.columnTable;
    }

    public HeatMapColumnTableModel getColumnTableModel() {
        return (HeatMapColumnTableModel)this.columnTable.getModel();
    }

    @Override
    public Dimension getDrawableSize() {
        this.drawablePositionInfo = new DrawablePositionInfo();
        this.drawablePositionInfo.height = this.elementPanel.getPreferredSize().height;
        if (this.aboveRowTableCustomComponent != null && this.aboveRowTableCustomComponent.isVisible()) {
            this.drawablePositionInfo.elementPanelYStart += this.aboveRowTableCustomComponent.getPreferredSize().height;
        }
        int minWidth = 0;
        if (this.columnTable.isVisible()) {
            HeatMapColumnTableDrawer t = new HeatMapColumnTableDrawer((JTable)((Object)this.columnTable), this.viewColumnSizesAndPositions);
            this.drawablePositionInfo.elementPanelYStart += t.getPreferredSize().height;
        }
        if (this.columnDendrogramPanel != null) {
            this.drawablePositionInfo.elementPanelYStart += this.columnDendrogramPanel.getDrawableSize().height;
        }
        JComponent colorSchemeLegend = this.elementPanel.getColorScheme().getLegend();
        if (this.showColorSchemeLegendInImage && colorSchemeLegend != null && colorSchemeLegend.isVisible()) {
            Drawable drawableWrapper = colorSchemeLegend instanceof Drawable ? (Drawable)((Object)colorSchemeLegend) : new DrawableWrapper(colorSchemeLegend);
            this.drawablePositionInfo.elementPanelYStart += drawableWrapper.getDrawableSize().height;
        }
        for (HeatMapChart columnChart : this.columnCharts) {
            this.drawablePositionInfo.elementPanelYStart += columnChart.getDrawableSize().height;
        }
        if (MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0 && this.categoryLegendVisible) {
            CategoryLegend legend = new CategoryLegend(false, this.columnColorCategoryLegendBoxSize);
            legend.setProject(this.project);
            this.drawablePositionInfo.elementPanelYStart += legend.getPreferredSize().height;
            minWidth = Math.max(minWidth, legend.getPreferredSize().width);
        }
        int maxAxisWidth = 0;
        for (HeatMapChart chart : this.columnCharts) {
            Axis axis = (Axis)chart.getClientProperty(AXIS_PROPERTY);
            if (axis != null) {
                Dimension axisSize = axis.getDrawableSize();
                JLabel label = new JLabel(chart.getMetadataColumnNames().get(0));
                maxAxisWidth = Math.max(maxAxisWidth, axisSize.width + label.getPreferredSize().width);
                continue;
            }
            System.err.println("Axis is null for column chart.");
        }
        this.drawablePositionInfo.elementPanelXStart += Math.max(this.columnColorNamesPanel.getPreferredSize().width + 4, maxAxisWidth + 4);
        if (this.rowDendrogramPanel != null) {
            int rowDendrogramWidth = this.rowDendrogramPanel.getDrawableSize().width;
            this.drawablePositionInfo.elementPanelXStart += rowDendrogramWidth;
        }
        this.drawablePositionInfo.width += this.drawablePositionInfo.elementPanelXStart;
        this.drawablePositionInfo.width += this.elementPanel.getPreferredSize().width;
        for (HeatMapChart chart : this.rowCharts) {
            this.drawablePositionInfo.width += chart.getDrawableSize().width;
        }
        if (this.rowTable.isVisible()) {
            HeatMapRowTableDrawer tableDrawer = new HeatMapRowTableDrawer(this.rowTable, this.viewRowSizesAndPositions, this.maximumRowTableChars);
            this.drawablePositionInfo.width += tableDrawer.getDrawableSize().width;
        }
        this.drawablePositionInfo.elementPanelYStart += 12;
        this.drawablePositionInfo.elementPanelYStart += this.columnCategoryPanel.getPreferredSize().height;
        if (MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0) {
            if (this.categoryLegendVisible) {
                this.drawablePositionInfo.width += this.rowCategoryPanel.getDrawableSize().width;
                CategoryLegend legend = new CategoryLegend(true, this.rowColorCategoryLegendBoxSize);
                legend.setProject(this.project);
                this.drawablePositionInfo.elementPanelYStart += legend.getPreferredSize().height;
                minWidth = Math.max(minWidth, legend.getPreferredSize().width);
            }
            VerticalTableDrawer rowCategoryNamesTableDrawer = new VerticalTableDrawer(this.rowCategoryHeader){

                @Override
                protected int getColumnEnd(Rectangle clip) {
                    return HeatMapPanel.this.rowCategoryHeader.columnAtPoint(new Point(clip.x + clip.width, 0));
                }

                @Override
                protected int getColumnStart(Rectangle clip) {
                    return HeatMapPanel.this.rowCategoryHeader.columnAtPoint(new Point(clip.x, 0));
                }

                @Override
                protected float getPosition(int column) {
                    Rectangle rect = HeatMapPanel.this.rowCategoryHeader.getCellRect(0, column, false);
                    return rect.x;
                }

                @Override
                protected float getSize() {
                    return HeatMapPanel.this.rowCategoryHeader.getColumnModel().getColumn(0).getWidth();
                }
            };
            rowCategoryNamesTableDrawer.init();
            int namesHeight = rowCategoryNamesTableDrawer.getDrawableSize().height;
            this.drawablePositionInfo.elementPanelYStart = Math.max(this.drawablePositionInfo.elementPanelYStart, namesHeight);
        }
        if (this.aboveRowTableCustomComponent != null) {
            this.drawablePositionInfo.width = Math.max(this.aboveRowTableCustomComponent.getPreferredSize().width, this.drawablePositionInfo.width);
        }
        this.drawablePositionInfo.height += this.drawablePositionInfo.elementPanelYStart;
        this.drawablePositionInfo.width = Math.max(minWidth, this.drawablePositionInfo.width);
        this.drawablePositionInfo.width += 2;
        this.drawablePositionInfo.height += 2;
        return new Dimension(this.drawablePositionInfo.width, this.drawablePositionInfo.height);
    }

    public ElementPainter getElementPainter() {
        return this.elementPanel.getElementPainter();
    }

    public HeatMapElementPanel getElementPanel() {
        return this.elementPanel;
    }

    public Dimension getElementPanelPreferredSize() {
        return this.elementPanel.getPreferredSize();
    }

    public Color getGridColor() {
        return this.elementPanel.getGridColor();
    }

    public HeatMapEditorKit getHeatMapEditorKit() {
        return this.editorKit;
    }

    public BoundedRangeModel getHorizontalBoundedRangeModel() {
        return this.elementPanelScrollPane.getHorizontalScrollBar().getModel();
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public Printable getPrintable() {
        return new TiledHeatMapPrintable();
    }

    public Project getProject() {
        return this.project;
    }

    public AbstractProjectQuickSearch getQuickColumnSearch() {
        return this.quickColumnSearch;
    }

    public AbstractProjectQuickSearch getQuickRowSearch() {
        return this.quickRowSearch;
    }

    public MetadataVerticalTableHeader getRowCategoryHeader() {
        return this.rowCategoryHeader;
    }

    public ColorPanel getRowCategoryPanel() {
        return this.rowCategoryPanel;
    }

    public DendrogramColorEditor getRowDendrogramColorEditor() {
        return this.rowDendrogramColorEditor;
    }

    public RowDendrogramPanel getRowDendrogramPanel() {
        return this.rowDendrogramPanel;
    }

    public int getRowIndex(int position) {
        return this.viewRowSizesAndPositions.getIndex(position, true);
    }

    public JPopupMenu getRowPopupMenu() {
        return this.rowPopupMenu;
    }

    public float getRowPosition(int index) {
        return this.viewRowSizesAndPositions.getPosition(index);
    }

    public JScrollPane getRowScrollPane() {
        return this.rowTableScrollPane;
    }

    public float getRowSize() {
        return this.elementPanel.getRowSize();
    }

    public SizesAndPositions getRowSizesAndPositions() {
        return this.viewRowSizesAndPositions;
    }

    public HeatMapToolBar getToolBar() {
        return this.heatMapToolBar;
    }

    public DatasetElementToolTipProvider getToolTipProvider() {
        return this.toolTipProvider;
    }

    public Font getValuesInHeatmapFont() {
        return this.elementPanel.getFont();
    }

    public BoundedRangeModel getVerticalBoundedRangeModel() {
        return this.rowTableScrollPane.getVerticalScrollBar().getModel();
    }

    public Dimension getVisibleSize() {
        Rectangle rect = this.elementPanel.getVisibleRect();
        int height = rect.height;
        int width = rect.width;
        return new Dimension(width, height);
    }

    public void grabColumnSearchFocus() {
        if (this.heatMapToolBar != null) {
            this.heatMapToolBar.grabColumnSearchFocus();
        }
    }

    public void grabRowSearchFocus() {
        if (this.heatMapToolBar != null) {
            this.heatMapToolBar.grabRowSearchFocus();
        }
    }

    public void initFromParent(HeatMapPanel parentHeatMapPanel) {
        this.columnColorNamesPanel.setSizePerClass(parentHeatMapPanel.columnCategoryPanel.getSizePerClass());
        this.columnCategoryPanel.setSizePerClass(parentHeatMapPanel.columnCategoryPanel.getSizePerClass());
        this._setRowSize(parentHeatMapPanel.getRowSize());
        this._setColumnSize(parentHeatMapPanel.getColumnSize());
        SparklineTableCellRenderer parentProfileTableCellRenderer = (SparklineTableCellRenderer)parentHeatMapPanel.rowTable.getDefaultRenderer(Dataset.class);
        this.setShowRowProfileSparkLines(parentHeatMapPanel.isProfileSparkLinesVisible(), parentProfileTableCellRenderer.isFilled());
        this.setSquareAspect(parentHeatMapPanel.isSquareAspect());
        HeatMapColorScheme cs = parentHeatMapPanel.getColorScheme();
        if (cs != null) {
            this.setColorScheme(DefaultHeatMapColorScheme.copy(cs));
        }
        this.setDrawGrid(parentHeatMapPanel.isDrawGrid());
        if (this.getColumnDendrogramPanel() != null && parentHeatMapPanel.getColumnDendrogramPanel() != null) {
            this.getColumnDendrogramPanel().setDendrogramLineThickness(parentHeatMapPanel.getColumnDendrogramPanel().getDendrogramLineThickness());
        }
        if (this.getRowDendrogramPanel() != null && parentHeatMapPanel.getRowDendrogramPanel() != null) {
            this.getRowDendrogramPanel().setDendrogramLineThickness(parentHeatMapPanel.getRowDendrogramPanel().getDendrogramLineThickness());
        }
        this.setElementPainter(parentHeatMapPanel.getElementPainter().copy());
    }

    public void invalidateImage() {
        this.elementPanel.invalidateImage();
    }

    public void invertColumnSelection() {
        ListSelectionModel selectionModel = this.columnTable.getColumnModel().getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int length = this.elementPanel.getDataset().getColumnCount();
        for (int i = 0; i < length; ++i) {
            if (selectionModel.isSelectedIndex(i)) {
                selectionModel.removeSelectionInterval(i, i);
                continue;
            }
            selectionModel.addSelectionInterval(i, i);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void invertRowSelection() {
        ListSelectionModel selectionModel = this.rowTable.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int length = this.elementPanel.getDataset().getRowCount();
        for (int i = 0; i < length; ++i) {
            if (selectionModel.isSelectedIndex(i)) {
                selectionModel.removeSelectionInterval(i, i);
                continue;
            }
            selectionModel.addSelectionInterval(i, i);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public boolean isCategoryLegendVisible() {
        return this.categoryLegendVisible;
    }

    public boolean isDrawGrid() {
        return this.elementPanel.isDrawGrid();
    }

    public boolean isDrawValues() {
        return this.elementPanel.isDrawValues();
    }

    public boolean isProfileSparkLinesFilled() {
        SparklineTableCellRenderer r = (SparklineTableCellRenderer)this.rowTable.getDefaultRenderer(Dataset.class);
        return r.isFilled();
    }

    public boolean isProfileSparkLinesVisible() {
        return this.profileInTableVisible;
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print(boolean showPrintDialog, PrintRequestAttributeSet attr, boolean interactive, PrintService service) throws PrinterException, HeadlessException {
        Throwable pe;
        PrintingStatus printingStatus;
        boolean isHeadless = GraphicsEnvironment.isHeadless();
        if (isHeadless) {
            if (showPrintDialog) {
                throw new HeadlessException("Can't show print dialog.");
            }
            if (interactive) {
                throw new HeadlessException("Can't run interactively.");
            }
        }
        final PrinterJob job = PrinterJob.getPrinterJob();
        if (attr == null) {
            attr = new HashPrintRequestAttributeSet();
        }
        Printable printable = this.getPrintable();
        if (interactive) {
            printable = new ThreadSafePrintable(printable);
            printingStatus = PrintingStatus.createPrintingStatus(this, job);
            printable = printingStatus.createNotificationPrintable(printable);
        } else {
            printingStatus = null;
        }
        job.setPrintable(printable);
        if (service != null) {
            job.setPrintService(service);
        }
        if (showPrintDialog && !job.printDialog(attr)) {
            return false;
        }
        if (!interactive) {
            job.print(attr);
            return true;
        }
        this.printError = null;
        final Object lock = new Object();
        final PrintRequestAttributeSet copyAttr = attr;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    job.print(copyAttr);
                }
                catch (Throwable t) {
                    Object object = lock;
                    synchronized (object) {
                        HeatMapPanel.this.printError = t;
                    }
                }
                finally {
                    printingStatus.dispose();
                }
            }
        };
        Thread th = new Thread(runnable);
        th.start();
        printingStatus.showModal(true);
        Object object = lock;
        synchronized (object) {
            pe = this.printError;
            this.printError = null;
        }
        if (pe != null) {
            if (pe instanceof PrinterAbortException) {
                return false;
            }
            if (pe instanceof PrinterException) {
                throw (PrinterException)pe;
            }
            if (pe instanceof RuntimeException) {
                throw (RuntimeException)pe;
            }
            if (pe instanceof Error) {
                throw (Error)pe;
            }
            throw new AssertionError((Object)pe);
        }
        return true;
    }

    @Override
    public void revalidate() {
        super.revalidate();
        if (this.columnTable != null) {
            this.columnTable.revalidate();
            this.columnTable.repaint();
        }
        if (this.columnCategoryPanel != null) {
            this.columnCategoryPanel.revalidate();
            this.columnCategoryPanel.repaint();
        }
        if (this.horizontalSplitPane != null) {
            this.horizontalSplitPane.revalidate();
        }
        if (this.rowTable != null) {
            this.rowTable.revalidate();
            this.rowTable.repaint();
            this.rowCategoryPanel.revalidate();
            this.rowCategoryPanel.repaint();
        }
        if (this.columnCharts != null) {
            for (HeatMapChart chart : this.columnCharts) {
                chart.invalidateImage();
                chart.revalidate();
                chart.repaint();
            }
        }
        if (this.rowCharts != null) {
            for (HeatMapChart chart : this.rowCharts) {
                chart.invalidateImage();
                chart.revalidate();
                chart.repaint();
            }
        }
        if (this.columnDendrogramPanel != null) {
            this.columnDendrogramPanel.revalidate();
            this.columnDendrogramPanel.repaintImage();
        }
        if (this.rowDendrogramPanel != null) {
            this.rowDendrogramPanel.revalidate();
            this.rowDendrogramPanel.repaintImage();
        }
        this.repaint();
    }

    public void scrollToColumn(int column) {
        JScrollPane sp = UIUtil.getScrollPane((Component)((Object)this.columnTable));
        if (sp != null) {
            int position = (int)this.viewColumnSizesAndPositions.getPosition(column);
            sp.getHorizontalScrollBar().setValue(position);
        }
    }

    public void scrollToRow(int row) {
        int position = (int)this.viewRowSizesAndPositions.getPosition(row);
        this.rowTableScrollPane.getVerticalScrollBar().setValue(position);
    }

    public void selectAllColumns() {
        this.columnTable.selectAll();
    }

    public void selectAllRows() {
        this.rowTable.selectAll();
    }

    public void setAboveRowTableCustomComponent(Component c) {
        CellConstraints cc = new CellConstraints();
        if (this.aboveRowTableCustomComponent != null) {
            this.aboveRowTablePanel.remove(this.aboveRowTableCustomComponent);
        }
        this.aboveRowTableCustomComponent = c;
        this.aboveRowTablePanel.add(c, cc.xy(1, 1));
        this.aboveRowTablePanel.revalidate();
        this.aboveRowTablePanel.repaint();
    }

    public void setCategoryLegendVisible(boolean categoryLegendVisible) {
        this.categoryLegendVisible = categoryLegendVisible;
    }

    public void setColumnColorCategoryLegendBoxSize(int size) {
        this.columnColorCategoryLegendBoxSize = size;
    }

    public void setColumnDendrogram(ColumnDendrogramPanel c) {
        this.columnDendrogramPanel = c;
        if (this.columnDendrogramPanel != null) {
            this.columnDendrogramPanel.setVisible(this.project.isColumnSortOrderPreservesDendrogram());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.topSplitPane.setPaneAt((Component)this.createHeatMapScrollPane(c), 0);
            this.topSplitPane.getPaneAt(0).setVisible(c != null);
            if (c != null) {
                this.topSplitPane.setDividerLocation(0, 150);
            }
        }
    }

    public void setColumnPopupMenu(JPopupMenu popupMenu) {
        this.columnPopupMenu = popupMenu;
    }

    public void setColumnSize(float size) {
        this._setColumnSize(size);
    }

    public void setDrawGrid(boolean drawGrid) {
        this.elementPanel.setDrawGrid(drawGrid);
    }

    public void setDrawGrid(int index, boolean drawGrid) {
        this.elementPanel.setDrawGrid(drawGrid);
    }

    public void setDrawValues(boolean drawValues) {
        this.elementPanel.setDrawValues(drawValues);
    }

    public void setElementPainter(ElementPainter elementPainter) {
        if (elementPainter == null) {
            throw new NullPointerException("Element painter is null.");
        }
        HeatMapColorScheme cs = this.elementPanel.getColorScheme();
        elementPainter.setProject(this.project);
        this.elementPanel.setElementPainter(elementPainter);
        this.elementPanel.getHeatMapElementRenderer().setColorScheme(cs);
    }

    public void setElementSelectionEnabled(boolean elementSelectionEnabled) {
        this.elementSelectionEnabled = elementSelectionEnabled;
    }

    public void setGridColor(Color c) {
        this.elementPanel.setGridColor(c);
    }

    public void setHorizontalScrollBarBoundedRangeModel(BoundedRangeModel boundedRangeModel) {
        this.elementPanelScrollPane.getHorizontalScrollBar().setModel(boundedRangeModel);
        int cc = this.topSplitPane.getPaneCount();
        for (int i = 0; i < cc; ++i) {
            Component pane = this.topSplitPane.getPaneAt(i);
            if (!(pane instanceof JScrollPane)) continue;
            ((JScrollPane)pane).getHorizontalScrollBar().setModel(boundedRangeModel);
        }
    }

    public void setMaximumRowTablePrintingChars(int maximumRowTableChars) {
        this.maximumRowTableChars = maximumRowTableChars;
    }

    public void setMouseMovedPosition(int rowIndex, int columnIndex) {
        MatrixElement old = new MatrixElement(this.mouseMovedElement);
        this.mouseMovedElement.setRow(rowIndex);
        this.mouseMovedElement.setColumn(columnIndex);
        this.repaint();
        this.firePropertyChange("mouseMovedPosition", old, this.mouseMovedElement);
    }

    public void setProportions() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setHorizontalProportions();
            this.horizontalSplitPane.revalidate();
            this.setVerticalProportions();
        }
    }

    public void setRowColorCategoryLegendBoxSize(int size) {
        this.rowColorCategoryLegendBoxSize = size;
    }

    public void setRowPopupMenu(JPopupMenu popupMenu) {
        this.rowPopupMenu = popupMenu;
    }

    public void setRowSize(float size) {
        this._setRowSize(size);
    }

    public void setShowRowProfileSparkLines(boolean visible, boolean sparkLinesFilled) {
        boolean old = this.isProfileSparkLinesVisible();
        this.profileInTableVisible = visible;
        SparklineTableCellRenderer profileTableCellRenderer = (SparklineTableCellRenderer)this.rowTable.getDefaultRenderer(Dataset.class);
        boolean oldFilled = profileTableCellRenderer.isFilled();
        profileTableCellRenderer.setFilled(sparkLinesFilled);
        if (old == visible && oldFilled == sparkLinesFilled) {
            return;
        }
        ((HeatMapRowTableModel)this.rowTable.getModel()).setProfileVisible(visible);
    }

    public void setShowRowTableHeader(boolean show) {
        this.rowTable.getTableHeader().setVisible(show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSquareAspect(boolean b) {
        if (this.squareAspect != b) {
            this.squareAspect = b;
            if (this.squareAspect) {
                float size = Math.max(this.elementPanel.getRowSize(), this.elementPanel.getColumnSize());
                try {
                    this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(true);
                    this._setColumnSize(size);
                    this._setRowSize(size);
                }
                finally {
                    this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(false);
                }
            }
        }
    }

    public void setStatusBarVisible(boolean b) {
        if (this.selectionPanel != null) {
            this.selectionPanel.setVisible(b);
        }
    }

    public void setToolTipProvider(DatasetElementToolTipProvider toolTipProvider) {
        this.toolTipProvider = toolTipProvider;
        this.elementPanel.setToolTipProvider(toolTipProvider);
    }

    public void setVerticalScrollBarBoundedRangeModel(BoundedRangeModel model) {
        this.rowTableScrollPane.getVerticalScrollBar().setModel(model);
        if (this.rowDendrogramScrollPane != null) {
            this.rowDendrogramScrollPane.getVerticalScrollBar().setModel(model);
        }
        this.rowCategoryPanelScrollPane.getVerticalScrollBar().setModel(model);
        this.elementPanelScrollPane.getVerticalScrollBar().setModel(model);
    }

    @Override
    public void showOptionsDialog() {
        if (this.optionsDialog != null) {
            this.optionsDialog.show();
        } else {
            new BlockingThread("Loading " + (OS.isMacOSX() ? "Preferences" : "Options"), false){

                @Override
                protected void doInBackground() throws Exception {
                    HeatMapPanel.this.optionsDialog = new HeatMapOptionsDialog(HeatMapPanel.this, HeatMapPanel.this.elementPanel);
                    UIUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeatMapPanel.this.optionsDialog.show();
                        }
                    });
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(boolean zoomIn, boolean zoomRows, boolean zoomColumns) {
        float startRowSize = this.getRowSize();
        float startColumnSize = this.getColumnSize();
        float endRowSize = startRowSize + (float)(zoomIn ? 1 : -1) * (startRowSize * 0.2f);
        float endColumnSize = startColumnSize + (float)(zoomIn ? 1 : -1) * (startColumnSize * 0.2f);
        try {
            if (zoomRows && zoomColumns) {
                this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(true);
            }
            if (zoomColumns) {
                this._setColumnSize(endColumnSize);
            }
            if (zoomRows) {
                this._setRowSize(endRowSize);
            }
        }
        finally {
            if (zoomRows && zoomColumns) {
                this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(false);
            }
        }
    }

    @Override
    public void zoomIn() {
        this.zoom(true, true, true);
    }

    @Override
    public void zoomOut() {
        this.zoom(false, true, true);
    }

    protected JPopupMenu createColumnPopupMenu() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.getHeatMapEditorKit().getCopyAction());
        JMenu columnSelectionMenu = new JMenu("Column Selection");
        columnSelectionMenu.add(new SelectAllAction(this, false));
        columnSelectionMenu.add(new InvertSelectionAction(this, false));
        columnSelectionMenu.add(new SelectMissingAction(this, false));
        columnSelectionMenu.add(new ClearSelectionAction(this, false));
        popupMenu.add(columnSelectionMenu);
        JMenu columnMaskMenu = new JMenu("Column Mask");
        columnMaskMenu.add(this.editorKit.getMaskColumnsAction());
        columnMaskMenu.add(this.editorKit.getUnMaskColumnsAction());
        columnMaskMenu.add(this.editorKit.getResetMaskColumnsAction());
        popupMenu.add(columnMaskMenu);
        popupMenu.addSeparator();
        popupMenu.add(this.getHeatMapEditorKit().getColumnProfileAction());
        popupMenu.addSeparator();
        popupMenu.add(this.sortBySelection(true));
        return popupMenu;
    }

    protected JPopupMenu createRowPopupMenu() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkSystemClipboardAccess();
            }
            popupMenu.add(this.getHeatMapEditorKit().getCopyAction());
            JMenu rowSelectionMenu = new JMenu("Row Selection");
            rowSelectionMenu.add(new SelectAllAction(this, true));
            rowSelectionMenu.add(new InvertSelectionAction(this, true));
            rowSelectionMenu.add(new SelectMissingAction(this, true));
            rowSelectionMenu.add(new ClearSelectionAction(this, true));
            popupMenu.add(rowSelectionMenu);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        JMenu rowMaskMenu = new JMenu("Row Mask");
        rowMaskMenu.add(this.editorKit.getMaskRowsAction());
        rowMaskMenu.add(this.editorKit.getUnMaskRowsAction());
        rowMaskMenu.add(this.editorKit.getResetMaskRowsAction());
        popupMenu.add(rowMaskMenu);
        popupMenu.addSeparator();
        popupMenu.add(this.getHeatMapEditorKit().getRowProfileAction());
        popupMenu.addSeparator();
        popupMenu.add(this.sortBySelection(false));
        return popupMenu;
    }

    protected void init() {
        this.columnSizesAndPositionsListener = new SizesAndPositionsListener(){

            @Override
            public void sizesAndPositionsChanged(SizesAndPositionsEvent e) {
                HeatMapPanel.this.updateModelSizesAndPositions(HeatMapPanel.this.project, e, HeatMapPanel.this.getColumnModelSizesAndPositions(), HeatMapPanel.this.viewColumnSizesAndPositions, false);
                HeatMapPanel.this.layoutColumnTable();
                if (!HeatMapPanel.this.elementPanel.isIgnoreColumnSizesAndPositionsEvent()) {
                    HeatMapPanel.this.revalidate();
                }
            }
        };
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                HeatMapPanel.this._projectChanged(e);
            }
        };
        this.elementSelectionListener = new ElementSelectionListener(){

            @Override
            public void elementSelectionChanged(ElementEvent e) {
                HeatMapPanel.this.repaint();
            }
        };
        this.viewColumnSizesAndPositions = new DefaultSizesAndPositions();
        this.viewColumnSizesAndPositions.addSizesAndPositionsListener(this.columnSizesAndPositionsListener);
        this.mouseMovedElement = new MatrixElement(-1, -1);
        this.elementPanel = this.createElementPanel();
        this.columnColorNamesPanel = new ColumnCategoryNamesPanel(this);
        this.columnColorNamesPanel.setMinimumSize(new Dimension(0, 0));
        this.columnTable = new HeatMapColumnTable(this);
        this.columnTable.setViewSizesAndPositions(this.viewColumnSizesAndPositions);
        this.columnTable.setMouseMovedElement(this.mouseMovedElement);
        this.columnCategoryPanel = new ColumnCategoryPanel(this.columnColorNamesPanel);
        this.columnCategoryPanel.addPropertyChangeListener("sizePerClass", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int sizePerClass = (Integer)evt.getNewValue();
                HeatMapPanel.this.columnColorNamesPanel.setSizePerClass(sizePerClass);
                HeatMapPanel.this.revalidate();
            }
        });
        this.elementPanelAndTopSplitter = new JSplitPane(0);
        this.elementPanelAndTopSplitter.setBackground(Color.WHITE);
        this.elementPanelAndTopSplitter.setBorder(null);
        this.verticalSplitPaneSynchronizer = new SplitPaneSynchronizer(new JSplitPane[0]);
        this.verticalSplitPaneSynchronizer.addSplitPane(this.elementPanelAndTopSplitter);
        this.categoryColorModelListener = new VectorVisualMapperListener(){

            @Override
            public void mappingChanged(VectorVisualMapperEvent e) {
                HeatMapPanel.this.revalidate();
            }
        };
        this.rowDendrogramSplitter = new JSplitPane(0);
        this.rowDendrogramSplitter.setBackground(Color.WHITE);
        this.rowDendrogramSplitterTopComponent = new JPanel();
        this.rowDendrogramSplitterTopComponent.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                HeatMapPanel.this.rowDendrogramSplitterTopComponent.revalidate();
                HeatMapPanel.this.rowDendrogramSplitterTopComponent.repaint();
                HeatMapPanel.this.rowDendrogramSplitterTopComponent.removeComponentListener(this);
            }
        });
        this.rowDendrogramSplitterTopComponent.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layoutContainer(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    int ncomponents = parent.getComponentCount();
                    int width = parent.getWidth();
                    for (int i = 0; i < ncomponents; ++i) {
                        JComponent dependent;
                        JComponent c = (JComponent)parent.getComponent(i);
                        if (!c.isShowing() || !(dependent = (JComponent)c.getClientProperty(HeatMapPanel.DEPENDENT_COMPONENT)).isShowing()) continue;
                        Point p = dependent.getLocationOnScreen();
                        SwingUtilities.convertPointFromScreen(p, parent);
                        c.setBounds(0, p.y, width, dependent.getHeight());
                    }
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(0, 0);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(90, 90);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
        this.rowDendrogramSplitterTopComponent.setBackground(Color.WHITE);
        this.rowDendrogramSplitter.setTopComponent(this.rowDendrogramSplitterTopComponent);
        this.horizontalSplitPane = new JideSplitPane(1);
        this.horizontalSplitPane.setBackground(Color.WHITE);
        this.horizontalSplitPane.setInitiallyEven(false);
        this.horizontalSplitPane.setProportionalLayout(this.proportionalLayout);
        this.horizontalSplitPane.add((Component)this.rowDendrogramSplitter, (Object)"flexible");
        this.horizontalSplitPane.setBorder(null);
        this.horizontalSplitPane.setOneTouchExpandable(false);
        this.rowTable = new HeatMapRowTable(this);
        this.rowTable.setViewRowSizesAndPositions(this.viewRowSizesAndPositions);
        this.rowTable.setMouseMovedElement(this.mouseMovedElement);
        if (!GraphicsEnvironment.isHeadless()) {
            this.editorKit = new HeatMapEditorKit(this);
            this.rowTableScrollPane = new JScrollPane(this.rowTable);
            this.rowTableScrollPane.setHorizontalScrollBarPolicy(30);
            this.rowTableScrollPane.setMinimumSize(new Dimension(0, 0));
            this.rowTableScrollPane.setBorder(null);
            this.rowTableScrollPane.setMinimumSize(new Dimension(0, 0));
            this.quickRowSearch = new QuickRowSearch(this.project);
            this.quickRowSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatMapPanel.this.rowTable.revalidate();
                    HeatMapPanel.this.rowTable.repaint();
                }
            });
            this.quickColumnSearch = new QuickColumnSearch(this.project);
            this.quickColumnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatMapPanel.this.columnTable.revalidate();
                    HeatMapPanel.this.columnTable.repaint();
                }
            });
            this.rowTableScrollPane.getVerticalScrollBar().setUI(VerticalScrollBarUIHelper.createScrollBarUI(this.quickRowSearch, this.viewRowSizesAndPositions));
        }
        this.rowCategoryPanel = new RowColorPanel();
        this.rowCategoryPanel.setProject(this.project);
        this.rowCategoryPanel.setSizesAndPositions(this.viewRowSizesAndPositions);
        this.rowCategoryPanel.setCategoryColorModel(this.project.getRowColorModel());
        this.project.getRowColorModel().addVectorVisualMapperListener(new VectorVisualMapperListener(){

            @Override
            public void mappingChanged(VectorVisualMapperEvent e) {
                HeatMapPanel.this.revalidate();
                HeatMapPanel.this.rowCategoryPanel.repaint();
            }
        });
        CellConstraints cc = new CellConstraints();
        this.rowCategoryHeader = new MetadataVerticalTableHeader(this){

            @Override
            protected MetadataModel getMetadata(Dataset dataset) {
                return MetadataUtil.filter(dataset.getRowMetadata(), "Color Visible");
            }
        };
        this.rowCategoryHeader.setColumnWidth(this.rowCategoryPanel.getSizePerClass());
        this.rowCategoryPanel.addPropertyChangeListener("sizePerClass", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HeatMapPanel.this.revalidate();
                HeatMapPanel.this.rowCategoryHeader.setColumnWidth((Integer)evt.getNewValue());
            }
        });
        this.setLayout(new BorderLayout());
        this.rowDendrogramSplitter.setBorder(null);
        this.rowCategorySplitter = new JSplitPane(0){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = ((HeatMapPanel)HeatMapPanel.this).rowCategoryPanel.getMinimumSize().width;
                return d;
            }
        };
        this.rowCategorySplitter.setBorder(null);
        this.rowCategorySplitter.setBackground(Color.WHITE);
        if (!GraphicsEnvironment.isHeadless()) {
            this.rowCategoryPanelScrollPane = new JScrollPane(this.rowCategoryPanel, 21, 30);
            JPanel tmp = new JPanel((LayoutManager)new FormLayout("p:g", "b:p:g"));
            tmp.setBackground(Color.WHITE);
            tmp.add((Component)this.rowCategoryHeader, cc.xy(1, 1));
            JScrollPane rowCategoryNamesScrollPane = new JScrollPane(tmp, 21, 31);
            rowCategoryNamesScrollPane.getHorizontalScrollBar().setModel(this.rowCategoryPanelScrollPane.getHorizontalScrollBar().getModel());
            this.rowCategorySplitter.setTopComponent(rowCategoryNamesScrollPane);
            rowCategoryNamesScrollPane.setMinimumSize(new Dimension(0, 0));
            rowCategoryNamesScrollPane.setBorder(null);
            this.rowCategoryPanelScrollPane.setBorder(null);
            this.rowCategorySplitter.setBottomComponent(this.rowCategoryPanelScrollPane);
        }
        this.rowCategorySplitter.setVisible(MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0);
        this.rowCategoryHeader.setMinimumSize(new Dimension(0, 0));
        this.rowCategoryPanel.setMinimumSize(new Dimension(0, 0));
        JSplitPane rowTableSplitter = new JSplitPane(0);
        rowTableSplitter.setBorder(null);
        this.rowTable.setMinimumSize(new Dimension(0, 0));
        rowTableSplitter.setMinimumSize(new Dimension(0, 0));
        this.aboveRowTablePanel = new JPanel((LayoutManager)new FormLayout("p:grow", "p:g, p:n:bottom, p:n:bottom")){

            @Override
            public void add(Component c, Object constraints) {
                if (constraints instanceof String) {
                    constraints = new CellConstraints(1, 1);
                }
                super.add(c, constraints);
            }
        };
        this.aboveRowTablePanel.setBackground(Color.WHITE);
        if (!GraphicsEnvironment.isHeadless()) {
            // empty if block
        }
        if (!GraphicsEnvironment.isHeadless()) {
            rowTableSplitter.setBottomComponent(this.rowTableScrollPane);
            this.aboveRowTablePanel.add((Component)this.rowTable.getTableHeader(), cc.xy(1, 3, CellConstraints.LEFT, CellConstraints.BOTTOM));
            this.colorLegendDescriptionTableHeaderScrollPane = new JScrollPane(this.aboveRowTablePanel, 21, 31);
            this.colorLegendDescriptionTableHeaderScrollPane.setBorder(null);
            this.colorLegendDescriptionTableHeaderScrollPane.setMinimumSize(new Dimension(0, 0));
            rowTableSplitter.setTopComponent(this.colorLegendDescriptionTableHeaderScrollPane);
        }
        if (this.rowCategoryPanelScrollPane != null) {
            this.rowCategoryPanelScrollPane.getVerticalScrollBar().setModel(this.rowTableScrollPane.getVerticalScrollBar().getModel());
        }
        this.verticalSplitPaneSynchronizer.addSplitPane(this.rowDendrogramSplitter);
        this.verticalSplitPaneSynchronizer.addSplitPane(this.rowCategorySplitter);
        this.verticalSplitPaneSynchronizer.addSplitPane(rowTableSplitter);
        if (!GraphicsEnvironment.isHeadless()) {
            this.horizontalSplitPane.add((Component)this.rowCategorySplitter, (Object)"flexible");
            this.horizontalSplitPane.add((Component)rowTableSplitter, (Object)"flexible");
        }
        this.setMinimumSize(new Dimension(0, 0));
        JPanel spacer = new JPanel();
        spacer.setBackground(Color.WHITE);
        spacer.setMinimumSize(new Dimension(0, 0));
        this.rowDendrogramSplitter.setBottomComponent(spacer);
        if (this.project.getRowDendrogram() != null) {
            this.setRowDendrogram(new RowDendrogramPanel(this.project.getRowDendrogram(), this.viewRowSizesAndPositions, this.elementPanel));
        }
        this.add((Component)this.horizontalSplitPane, "Center");
        this.selectionPanel = new SelectionPanel(this.project);
        if (!GraphicsEnvironment.isHeadless()) {
            this.heatMapToolBar = new HeatMapToolBar(this);
            this.add((Component)this.heatMapToolBar, "North");
        }
        this.add((Component)this.selectionPanel, "South");
        if (!GraphicsEnvironment.isHeadless()) {
            this.elementPanelScrollPane = new JScrollPane(this.elementPanel, 21, 30);
            this.elementPanelScrollPane.getHorizontalScrollBar().setUI(HorizontalScrollBarUIHelper.createScrollBarUI(this.quickColumnSearch, this.viewColumnSizesAndPositions));
            this.elementPanelScrollPane.setBorder(null);
            this.elementPanelScrollPane.setMinimumSize(new Dimension(0, 0));
            this.topSplitPane = new JideSplitPane(0);
            this.topSplitPane.setProportionalLayout(this.proportionalLayout);
            this.topSplitPane.setBorder(null);
            this.topSplitPane.setBackground(Color.WHITE);
            this.columnTable.setMinimumSize(new Dimension(0, 0));
            this.topSplitPane.setMinimumSize(new Dimension(0, 0));
            this.columnCategoryPanel.setMinimumSize(new Dimension(0, 0));
            JPanel dendrogramSpaceHolder = new JPanel();
            dendrogramSpaceHolder.setVisible(false);
            dendrogramSpaceHolder.setPreferredSize(new Dimension(0, 0));
            dendrogramSpaceHolder.setMinimumSize(new Dimension(0, 0));
            this.topSplitPane.add((Component)dendrogramSpaceHolder, (Object)"flexible");
            this.topSplitPane.add((Component)this.createHeatMapScrollPane((JComponent)((Object)this.columnTable)), (Object)"vary");
            this.topSplitPane.add((Component)this.createHeatMapScrollPane(this.columnCategoryPanel), (Object)"flexible");
            UIUtil.applyRecursively((Component)this.topSplitPane, (Function<? super Component, Void>)new Function<Component, Void>(){

                public Void apply(Component c) {
                    c.setBackground(Color.WHITE);
                    return null;
                }
            });
            this.elementPanelScrollPane.getVerticalScrollBar().setModel(this.rowTableScrollPane.getVerticalScrollBar().getModel());
            this.colorLegendDescriptionTableHeaderScrollPane.getHorizontalScrollBar().setModel(this.rowTableScrollPane.getHorizontalScrollBar().getModel());
            this.elementPanelAndTopSplitter.setTopComponent((Component)this.topSplitPane);
            this.columnColorNamesPanel.putClientProperty(DEPENDENT_COMPONENT, this.columnCategoryPanel);
            this.columnCategoryPanel.addHierarchyBoundsListener(new HierarchyBoundsListener(){

                @Override
                public void ancestorMoved(HierarchyEvent e) {
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.revalidate();
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.repaint();
                }

                @Override
                public void ancestorResized(HierarchyEvent e) {
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.revalidate();
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.repaint();
                }
            });
            this.rowDendrogramSplitterTopComponent.add(this.columnColorNamesPanel);
            this.elementPanelAndTopSplitter.setBottomComponent(this.elementPanelScrollPane);
        }
        this.elementPanel.setMinimumSize(new Dimension(0, 0));
    }

    JTable getRowTable() {
        return this.rowTable;
    }

    private void _projectChanged(ProjectEvent e) {
        if (e.getType() == 5) {
            this.setRowCharts();
            if (!GraphicsEnvironment.isHeadless()) {
                this.rowCategorySplitter.setVisible(MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0);
                this.setHorizontalProportions();
            }
        } else if (e.getType() == 6) {
            HeatMapColumnTable.sizeTableRowHeight((JTable)((Object)this.columnTable));
            this.setColumnCharts();
            if (!GraphicsEnvironment.isHeadless()) {
                this.columnCategoryPanel.setVisible(MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0);
                this.topSplitPane.getPaneAt(this.topSplitPane.getPaneCount() - 1).setVisible(this.columnCategoryPanel.isVisible());
                this.rowDendrogramSplitter.setVisible(this.rowDendrogramPanel != null || this.columnCharts.size() > 0 || this.columnCategoryPanel.isVisible());
                this.setVerticalProportions();
                this.setHorizontalProportions();
                this.horizontalSplitPane.revalidate();
            }
        } else if (e.getType() == 1 || e.getType() == 12) {
            this.maskChanged();
        } else if (e.getType() == 10 || e.getType() == 0 || e.getType() == 7 || e.getType() == 8) {
            Dataset dataset;
            Project project = (Project)e.getSource();
            if (e.getType() == 10) {
                UIUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HeatMapPanel.this.createColumnDendrogramPanel(false);
                    }
                });
            }
            if ((dataset = project.getSortedFilteredDataset()) == null) {
                return;
            }
            if (this.rowDendrogramPanel != null) {
                this.rowDendrogramPanel.setVisible(project.isRowSortOrderPreservesDendrogram());
            }
            if (this.columnDendrogramPanel != null) {
                this.columnDendrogramPanel.setVisible(project.isColumnSortOrderPreservesDendrogram());
            }
            this.maskChanged();
            this.viewColumnSizesAndPositions.setLength(dataset.getColumnCount());
            this.viewRowSizesAndPositions.setLength(dataset.getRowCount());
            RowGrouper rowGrouper = new RowGrouper();
            this.viewRowSizesAndPositions.setSpaceSizes(rowGrouper.group(project));
            ColumnGrouper columnGrouper = new ColumnGrouper();
            if (this.viewColumnSizesAndPositions != null) {
                this.viewColumnSizesAndPositions.setSpaceSizes(columnGrouper.group(project));
            }
            this.setViewSizeFromModel(project, this.getColumnModelSizesAndPositions(), this.viewColumnSizesAndPositions);
            this.setViewSizeFromModel(project, this.getRowModelSizesAndPositions(), this.viewRowSizesAndPositions);
            this.setShowRowProfileSparkLines(this.isProfileSparkLinesVisible(), this.isProfileSparkLinesFilled());
            if (this.colorSchemeLegend != null) {
                this.colorSchemeLegend.repaint();
            }
            this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(true);
            this.viewColumnSizesAndPositions.notifyListeners(6);
            this.elementPanel.setIgnoreColumnSizesAndPositionsEvent(false);
            this.viewRowSizesAndPositions.notifyListeners(6);
        }
    }

    private void _setColumnSize(float size) {
        if (this.viewColumnSizesAndPositions.getSize() != size) {
            this.viewColumnSizesAndPositions.setSize(size);
            this.viewColumnSizesAndPositions.notifyListeners(4);
        }
    }

    private void _setRowSize(float size) {
        if (this.viewRowSizesAndPositions.getSize() != size) {
            this.viewRowSizesAndPositions.setSize(size);
            this.viewRowSizesAndPositions.notifyListeners(4);
        }
    }

    private ColumnDendrogramPanel createColumnDendrogramPanel(boolean disabled) {
        final ColumnDendrogramPanel columnDendrogramPanel = new ColumnDendrogramPanel(this.project.getColumnDendrogram(), this.elementPanel.getColumnSizeSequence(), this.elementPanel);
        if (disabled) {
            columnDendrogramPanel.setColor(Color.LIGHT_GRAY);
        }
        this.setColumnDendrogram(columnDendrogramPanel);
        columnDendrogramPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() != -1) {
                    HeatMapPanel.this.columnTable.setColumnSelectionInterval(e.getFirstIndex(), e.getLastIndex());
                } else {
                    HeatMapPanel.this.columnTable.clearSelection();
                }
                if (columnDendrogramPanel != null) {
                    columnDendrogramPanel.repaintImage();
                }
            }
        });
        if (!GraphicsEnvironment.isHeadless()) {
            this.columnDendrogramColorEditor = new DendrogramColorEditor(columnDendrogramPanel);
        }
        return columnDendrogramPanel;
    }

    private HeatMapElementPanel createElementPanel() {
        HeatMapElementPanel elementPanel = new HeatMapElementPanel(this.viewRowSizesAndPositions, this.viewColumnSizesAndPositions){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle clipBounds = g.getClipBounds();
                float pixelWidth = HeatMapPanel.this.viewColumnSizesAndPositions.getPosition(HeatMapPanel.this.viewColumnSizesAndPositions.getLength() - 1) + HeatMapPanel.this.viewColumnSizesAndPositions.getSize();
                if (clipBounds == null) {
                    clipBounds = new Rectangle();
                    clipBounds.setRect(0.0, 0.0, pixelWidth, this.getHeight());
                }
                Rectangle2D.Float rect = new Rectangle2D.Float();
                if (HeatMapPanel.this.project.getElementSelectionModel().getSelectedElements().size() > 0) {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke oldStroke = g2.getStroke();
                    g2.setStroke(new BasicStroke(2.0f));
                    int size = HeatMapPanel.this.project.getElementSelectionModel().getSelectedElements().size();
                    for (int i = 0; i < size; ++i) {
                        g.setColor(UIUtil.SELECTION_COLOR);
                        MatrixElement element = HeatMapPanel.this.project.getElementSelectionModel().getSelectedElements().get(i);
                        int viewSelectedColumnElementIndex = HeatMapPanel.this.project.convertModelColumnIndexToView(element.getColumn());
                        int viewSelectedRowElementIndex = HeatMapPanel.this.project.convertModelRowIndexToView(element.getRow());
                        rect.setRect(HeatMapPanel.this.viewColumnSizesAndPositions.getPosition(viewSelectedColumnElementIndex), HeatMapPanel.this.viewRowSizesAndPositions.getPosition(viewSelectedRowElementIndex), HeatMapPanel.this.viewColumnSizesAndPositions.getSize(), HeatMapPanel.this.viewRowSizesAndPositions.getSize());
                        g2.draw(rect);
                    }
                    g2.setStroke(oldStroke);
                }
            }
        };
        if (this.toolTipProvider != null) {
            elementPanel.setToolTipProvider(this.toolTipProvider);
        }
        elementPanel.addMouseListener(this.optionController);
        elementPanel.addMouseMotionListener(this.optionController);
        return elementPanel;
    }

    private JScrollPane createHeatMapScrollPane(JComponent c) {
        boolean simple = false;
        Object sp = simple ? new SimpleScrollPane((Component)c, 20, 31) : new JScrollPane(c, 21, 31);
        ((JScrollPane)sp).getHorizontalScrollBar().setModel(this.elementPanelScrollPane.getHorizontalScrollBar().getModel());
        c.addComponentListener(new ComponentListener((JScrollPane)sp){
            final /* synthetic */ JScrollPane val$sp;
            {
                this.val$sp = jScrollPane;
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.val$sp.setVisible(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.val$sp.setVisible(true);
            }
        });
        ((JComponent)sp).setVisible(c.isVisible());
        ((JComponent)sp).setBorder(null);
        ((JComponent)sp).setMinimumSize(new Dimension());
        return sp;
    }

    private DefaultSizesAndPositions getColumnModelSizesAndPositions() {
        return this.columnModelSizesAndPositions;
    }

    private int getDividerSizeOffset() {
        return this.topSplitPane.getDividerSize() * 4 + 12;
    }

    private int getHorizontalSplitPaneIndex(Class<?> cl) {
        int count = this.horizontalSplitPane.getPaneCount();
        for (int i = 0; i < count; ++i) {
            JScrollPane sp;
            Component c;
            JSplitPane splitPane = (JSplitPane)this.horizontalSplitPane.getPaneAt(i);
            Component bottom = splitPane.getBottomComponent();
            if (!(bottom instanceof JScrollPane) || !cl.isAssignableFrom((c = (sp = (JScrollPane)bottom).getViewport().getView()).getClass())) continue;
            return i;
        }
        return -1;
    }

    private int[] getHorizontalSplitPaneIndices(Class<?> cl) {
        TIntArrayList indices = new TIntArrayList();
        int count = this.horizontalSplitPane.getPaneCount();
        for (int i = 0; i < count; ++i) {
            JScrollPane sp;
            Component c;
            JSplitPane splitPane = (JSplitPane)this.horizontalSplitPane.getPaneAt(i);
            Component bottom = splitPane.getBottomComponent();
            if (!(bottom instanceof JScrollPane) || !cl.isAssignableFrom((c = (sp = (JScrollPane)bottom).getViewport().getView()).getClass())) continue;
            indices.add(i);
        }
        return indices.toArray();
    }

    private DefaultSizesAndPositions getRowModelSizesAndPositions() {
        if (this.rowModelSizesAndPositions == null) {
            this.rowModelSizesAndPositions = new DefaultSizesAndPositions(this.project.getOriginalDataset() != null ? this.project.getOriginalDataset().getRowCount() : 1);
        }
        return this.rowModelSizesAndPositions;
    }

    private void layoutColumnTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < HeatMapPanel.this.columnTable.getColumnCount(); ++i) {
                    TableColumn c = HeatMapPanel.this.columnTable.getColumnModel().getColumn(i);
                    int columnSize = (int)Math.ceil(HeatMapPanel.this.elementPanel.getColumnSize());
                    c.setMinWidth(columnSize);
                    c.setMaxWidth(columnSize);
                    c.setPreferredWidth(columnSize);
                    c.setWidth(columnSize);
                }
                HeatMapColumnTable.sizeTableRowHeight((JTable)((Object)HeatMapPanel.this.columnTable));
            }
        });
    }

    private void maskChanged() {
        this.elementPanel.setMaskedRowIndices(this.project.getViewRowMask());
        this.elementPanel.setMaskedColumnIndices(this.project.getViewColumnMask());
    }

    public void setColorScheme(HeatMapColorScheme colorScheme) {
        this.elementPanel.setColorScheme(colorScheme);
        this.updateColorSchemeLegend();
        this.revalidate();
    }

    private void setColumnCharts() {
        int i;
        MetadataModel chartMetadata = MetadataUtil.getChartColumns(this.project.getSortedFilteredDataset().getColumnMetadata());
        if (this.topSplitPane != null) {
            for (i = 0; i < this.topSplitPane.getPaneCount() - 1; ++i) {
                Component view;
                Component p = this.topSplitPane.getPaneAt(i);
                if (!(p instanceof JScrollPane) || !((view = ((JScrollPane)p).getViewport().getView()) instanceof HeatMapChart)) continue;
                this.topSplitPane.removePane(i);
                --i;
            }
        }
        this.columnCharts.clear();
        int count = this.rowDendrogramSplitterTopComponent.getComponentCount();
        for (i = 0; i < count; ++i) {
            Component c = this.rowDendrogramSplitterTopComponent.getComponent(i);
            if (!(c instanceof JComponent) || !(((JComponent)c).getClientProperty(DEPENDENT_COMPONENT) instanceof HeatMapChart)) continue;
            this.rowDendrogramSplitterTopComponent.remove(i);
            --i;
            --count;
        }
        if (this.topSplitPane != null) {
            this.topSplitPane.setProportions(new double[this.topSplitPane.getPaneCount() - 1]);
        }
        count = chartMetadata.getMetadataCount();
        for (i = 0; i < count; ++i) {
            String name = chartMetadata.get(i).getName();
            HeatMapChart columnChart = new HeatMapChart(this.viewColumnSizesAndPositions, Arrays.asList(name), false);
            columnChart.setProject(this.project);
            this.columnCharts.add(columnChart);
            if (this.topSplitPane != null) {
                JScrollPane columnChartScrollPane = this.createHeatMapScrollPane(columnChart);
                this.topSplitPane.insertPane((Component)columnChartScrollPane, (Object)"flexible", 2);
            }
            Axis axis = new Axis(false, columnChart.getCoordinateMapper(), true);
            axis.setBackground(Color.WHITE);
            columnChart.putClientProperty(AXIS_PROPERTY, axis);
            final JLabel label = new JLabel(name);
            columnChart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    label.setForeground(UIUtil.HIGHLIGHT_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    label.setForeground(Color.BLACK);
                }
            });
            label.setToolTipText("<html>" + name + "<br>" + "Click to sort. Shift-click to sort multiple columns simultaneously. Alt-click to group.");
            label.putClientProperty("metadataIndex", i);
            label.setFont(new Font(UIUtil.getFontName(), 0, 9));
            int sortIndex = this.project.getColumnSortKeys().indexOf(new SortKeys.VectorSortKey(name, SortOrder.UNSORTED, false));
            ProjectSortKey sortKey = sortIndex != -1 ? this.project.getColumnSortKeys().get(sortIndex) : new SortKeys.VectorSortKey(name, SortOrder.UNSORTED, false);
            Icon icon = SortingHelper.getIcon(this.project.getColumnSortKeys(), sortKey);
            label.setIcon(icon);
            label.addMouseListener(new ColumnHeaderMouseListener(this, "Chart Style"));
            label.setBackground(Color.WHITE);
            label.setVerticalAlignment(0);
            label.setHorizontalTextPosition(4);
            label.setHorizontalAlignment(4);
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.setBackground(Color.WHITE);
            tmp.add((Component)label, "Center");
            tmp.add((Component)axis, "East");
            tmp.putClientProperty(DEPENDENT_COMPONENT, columnChart);
            columnChart.addHierarchyBoundsListener(new HierarchyBoundsListener(){

                @Override
                public void ancestorMoved(HierarchyEvent e) {
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.revalidate();
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.repaint();
                }

                @Override
                public void ancestorResized(HierarchyEvent e) {
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.revalidate();
                    HeatMapPanel.this.rowDendrogramSplitterTopComponent.repaint();
                }
            });
            this.rowDendrogramSplitterTopComponent.add(tmp);
        }
        this.rowDendrogramSplitter.setVisible(this.rowDendrogramPanel != null || this.columnCharts.size() > 0 || this.columnCategoryPanel.isVisible());
        this.rowDendrogramSplitter.revalidate();
    }

    private void setHorizontalProportions() {
        if (!GraphicsEnvironment.isHeadless()) {
            double frameWidth;
            Container c = UIUtil.getTopLevelAncestor(this);
            if (c == null) {
                c = this;
            }
            if ((frameWidth = (double)c.getWidth()) <= 1.0) {
                frameWidth = UIUtil.getCurrentFrame().getWidth();
            }
            float[] sizesGoingAcrossHorizontally = new float[this.horizontalSplitPane.getPaneCount()];
            if (this.rowDendrogramPanel != null) {
                sizesGoingAcrossHorizontally[0] = 150.0f;
            }
            if (this.columnCharts.size() > 0) {
                sizesGoingAcrossHorizontally[0] = Math.max(sizesGoingAcrossHorizontally[0], 30.0f);
            }
            sizesGoingAcrossHorizontally[1] = this.elementPanel.getPreferredSize().width + 25;
            sizesGoingAcrossHorizontally[2] = this.rowCategoryPanel.getPreferredSize().width;
            if (MetadataUtil.getCategoryColumns(this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0) {
                sizesGoingAcrossHorizontally[0] = Math.min(150.0f, Math.max(sizesGoingAcrossHorizontally[0], (float)this.columnColorNamesPanel.getPreferredSize().width));
            }
            int[] rowChartIndices = this.getHorizontalSplitPaneIndices(HeatMapChart.class);
            for (int i = 0; i < rowChartIndices.length; ++i) {
                sizesGoingAcrossHorizontally[rowChartIndices[i]] = 30.0f;
            }
            sizesGoingAcrossHorizontally[3 + rowChartIndices.length] = this.rowTable.getPreferredSize().width;
            double[] proportionsGoingAcrossHorizontally = new double[this.horizontalSplitPane.getPaneCount() - 1];
            sizesGoingAcrossHorizontally[1] = (float)Math.max(frameWidth * 0.25, (double)sizesGoingAcrossHorizontally[1]);
            int length = proportionsGoingAcrossHorizontally.length;
            for (int i = 0; i < length; ++i) {
                proportionsGoingAcrossHorizontally[i] = (double)sizesGoingAcrossHorizontally[i] / frameWidth;
                if (proportionsGoingAcrossHorizontally[i] >= 1.0) {
                    proportionsGoingAcrossHorizontally[i] = 0.95;
                    continue;
                }
                if (!(proportionsGoingAcrossHorizontally[i] < 0.0)) continue;
                proportionsGoingAcrossHorizontally[i] = 0.0;
            }
            double sum = new PSum().evaluate(proportionsGoingAcrossHorizontally);
            double max = 0.95;
            sum = new PSum().evaluate(proportionsGoingAcrossHorizontally);
            int maxTries = 5;
            for (int tries = 0; sum > max && tries < maxTries; ++tries) {
                double totalOver = Math.abs(sum - max);
                if (totalOver <= 0.0) {
                    totalOver = 0.05;
                }
                proportionsGoingAcrossHorizontally[1] = proportionsGoingAcrossHorizontally[1] - totalOver;
                sum = new PSum().evaluate(proportionsGoingAcrossHorizontally);
            }
            if (sum > max) {
                System.out.println("Failed to allocate proportions: " + ToStringUtil.toString(proportionsGoingAcrossHorizontally, ", "));
                Arrays.fill(proportionsGoingAcrossHorizontally, 0.95 / (double)proportionsGoingAcrossHorizontally.length);
            }
            if (this.proportionalLayout) {
                this.horizontalSplitPane.setProportions(proportionsGoingAcrossHorizontally);
            } else {
                int[] dividerLocations = new int[proportionsGoingAcrossHorizontally.length];
                for (int i = 0; i < dividerLocations.length; ++i) {
                    int previous = 0;
                    for (int j = i - 1; j >= 0; --j) {
                        previous += dividerLocations[j];
                    }
                    dividerLocations[i] = previous + (int)Math.ceil(frameWidth * proportionsGoingAcrossHorizontally[i]);
                }
            }
        }
        this.proportionsSet = true;
    }

    private void setProject(Project project) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.horizontalSplitPane.insertPane((Component)this.elementPanelAndTopSplitter, (Object)"flexible", 1);
        }
        int dividerLocation = this.rowDendrogramSplitter.getDividerLocation();
        this.rowDendrogramSplitter.revalidate();
        this.rowDendrogramSplitter.setDividerLocation(dividerLocation);
        this.colorSchemeLegendMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    HeatMapPanel.this.showOptionsDialog();
                }
            }
        };
        this.rowTable.setProject(project);
        this.columnModelSizesAndPositions = new DefaultSizesAndPositions(project.getOriginalDataset().getColumnCount());
        if (this.project != null) {
            this.project.getElementSelectionModel().removeElementSelectionListener(this.elementSelectionListener);
        }
        project.getElementSelectionModel().addElementSelectionListener(this.elementSelectionListener);
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        project.addProjectListener(this.projectListener);
        if (this.project != null) {
            this.project.getColumnColorModel().addVectorVisualMapperListener(this.categoryColorModelListener);
        }
        project.getColumnColorModel().addVectorVisualMapperListener(this.categoryColorModelListener);
        HeatMapColumnTableModel tableModel = (HeatMapColumnTableModel)this.columnTable.getModel();
        tableModel.setProject(project);
        this.columnTable.setViewSizesAndPositions(this.viewColumnSizesAndPositions);
        this.columnColorNamesPanel.setProject(project);
        this.columnCategoryPanel.setProject(project);
        this.columnCategoryPanel.setSizesAndPositions(this.viewColumnSizesAndPositions);
        this.columnCategoryPanel.setCategoryColorModel(project.getColumnColorModel());
        this.rowCategoryHeader.setProject(project);
        this.rowCategoryHeader.getColumnModel().setSelectionModel(project.getViewRowCategoriesSelectionModel());
        this.rowCategoryPanel.setProject(project);
        this.rowCategoryPanel.setSizesAndPositions(this.viewRowSizesAndPositions);
        this.rowCategoryPanel.setCategoryColorModel(project.getRowColorModel());
        this.elementPanel.setProject(project);
        this.columnTable.getColumnModel().setSelectionModel(project.getColumnSelectionModel().getViewSelectionModel());
        if (project.getColumnDendrogram() != null) {
            this.columnDendrogramPanel = this.createColumnDendrogramPanel(false);
        }
        this.columnTable.setMouseMovedElement(this.mouseMovedElement);
        this.project = project;
        this.setRowCharts();
        this.setColumnCharts();
        this.rowDendrogramSplitter.setVisible(this.rowDendrogramPanel != null || this.columnCharts.size() > 0 || this.columnCategoryPanel.isVisible());
        this.updateColorSchemeLegend();
        this._projectChanged(new ProjectEvent(project, 8));
        this.layoutColumnTable();
        this.revalidate();
        this.setVerticalProportions();
    }

    private void setRowCharts() {
        int index;
        MetadataModel chartMetadata = MetadataUtil.getChartColumns(this.project.getSortedFilteredDataset().getRowMetadata());
        this.rowCharts.clear();
        while ((index = this.getHorizontalSplitPaneIndex(HeatMapChart.class)) != -1) {
            JSplitPane splitPane = (JSplitPane)this.horizontalSplitPane.getPaneAt(index);
            this.verticalSplitPaneSynchronizer.removeSplitPane(splitPane);
            this.horizontalSplitPane.removePane(index);
        }
        int count = chartMetadata.getMetadataCount();
        for (int i = 0; i < count; ++i) {
            final String metadataName = chartMetadata.get(i).getName();
            HeatMapChart rowChart = new HeatMapChart(this.viewRowSizesAndPositions, Arrays.asList(metadataName), true);
            MetadataVerticalTableHeader rowHeaderTable = new MetadataVerticalTableHeader(this){

                @Override
                protected MetadataModel getMetadata(Dataset dataset) {
                    int[] nArray;
                    int index = dataset.getRowMetadata().getColumnIndex(metadataName);
                    MetadataModel metadataModel = dataset.getRowMetadata();
                    if (index == -1) {
                        nArray = new int[]{};
                    } else {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = index;
                    }
                    MetadataModelColumnView m = new MetadataModelColumnView(metadataModel, nArray);
                    return m;
                }
            };
            rowHeaderTable.setProject(this.project);
            rowChart.setProject(this.project);
            this.rowCharts.add(rowChart);
            JScrollPane chartScrollPane = UIUtil.createNoBorderScrollPane(rowChart);
            chartScrollPane.setVerticalScrollBarPolicy(21);
            chartScrollPane.setHorizontalScrollBarPolicy(31);
            if (this.rowTableScrollPane != null) {
                chartScrollPane.getVerticalScrollBar().setModel(this.rowTableScrollPane.getVerticalScrollBar().getModel());
            }
            JSplitPane rowChartSplitPane = new JSplitPane(0);
            Axis axis = new Axis(true, rowChart.getCoordinateMapper(), true);
            axis.setBackground(Color.WHITE);
            axis.setHorizontalLabelsRotated(true);
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new JideBoxLayout((Container)panel, 1));
            panel.add((Component)rowHeaderTable, "fix");
            panel.add((Component)axis, "flexible");
            rowChart.putClientProperty(AXIS_PROPERTY, axis);
            rowChart.putClientProperty("header", rowHeaderTable);
            JScrollPane topScrollPane = UIUtil.createNoBorderScrollPane(panel);
            topScrollPane.setVerticalScrollBarPolicy(21);
            topScrollPane.setHorizontalScrollBarPolicy(31);
            topScrollPane.getHorizontalScrollBar().setModel(chartScrollPane.getHorizontalScrollBar().getModel());
            rowChartSplitPane.setTopComponent(topScrollPane);
            rowChartSplitPane.setBottomComponent(chartScrollPane);
            int tmp = this.elementPanelAndTopSplitter.getDividerLocation();
            rowChartSplitPane.setDividerLocation(tmp);
            this.verticalSplitPaneSynchronizer.addSplitPane(rowChartSplitPane);
            this.horizontalSplitPane.insertPane((Component)rowChartSplitPane, (Object)"flexible", 3);
            this.elementPanelAndTopSplitter.setDividerLocation(tmp);
        }
    }

    private void setRowDendrogram(RowDendrogramPanel rowDendrogramPanel) {
        this.rowDendrogramSplitter.setVisible(true);
        rowDendrogramPanel.revalidate();
        if (!GraphicsEnvironment.isHeadless()) {
            this.rowDendrogramScrollPane = new JScrollPane(rowDendrogramPanel, 21, 31);
            this.rowDendrogramScrollPane.setBorder(null);
            this.rowDendrogramScrollPane.setBackground(Color.WHITE);
            this.rowDendrogramScrollPane.getVerticalScrollBar().setModel(this.rowTableScrollPane.getVerticalScrollBar().getModel());
            this.rowDendrogramSplitter.setBottomComponent(this.rowDendrogramScrollPane);
        }
        rowDendrogramPanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() != -1) {
                    HeatMapPanel.this.rowTable.setRowSelectionInterval(e.getFirstIndex(), e.getLastIndex());
                }
            }
        });
        if (!GraphicsEnvironment.isHeadless()) {
            this.rowDendrogramColorEditor = new DendrogramColorEditor(rowDendrogramPanel);
        }
        this.rowDendrogramPanel = rowDendrogramPanel;
        rowDendrogramPanel.setVisible(this.project.isRowSortOrderPreservesDendrogram());
        this.rowDendrogramSplitter.revalidate();
        rowDendrogramPanel.repaintImage();
    }

    private void setVerticalProportions() {
        if (!GraphicsEnvironment.isHeadless()) {
            double max;
            double sum;
            double columnNamesHeight;
            this.topSplitPane.getPaneAt(this.topSplitPane.getPaneCount() - 1).setVisible(this.columnCategoryPanel.isVisible());
            this.topSplitPane.getPaneAt(0).setVisible(this.columnDendrogramPanel != null);
            int totalHeight = 0;
            int count = this.topSplitPane.getPaneCount();
            for (int i = 0; i < count; ++i) {
                JComponent c = (JComponent)this.topSplitPane.getPaneAt(i);
                if (!c.isVisible()) continue;
                int h = c.getPreferredSize().height;
                if (h > 300) {
                    h = 300;
                }
                totalHeight += h;
            }
            Drawable drawableWrapper = this.colorSchemeLegend instanceof Drawable ? (Drawable)((Object)this.colorSchemeLegend) : new DrawableWrapper(this.colorSchemeLegend);
            totalHeight = Math.max(totalHeight, this.rowTable.getTableHeader().getPreferredSize().height + (this.colorSchemeLegend != null ? drawableWrapper.getDrawableSize().height : 0));
            boolean namesOnly = false;
            if (this.topSplitPane.getPaneAt(1).isVisible()) {
                boolean found = false;
                int count2 = this.topSplitPane.getPaneCount();
                for (int i = 0; i < count2; ++i) {
                    if (i == 1 || !this.topSplitPane.getPaneAt(i).isVisible()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    totalHeight += this.getDividerSizeOffset();
                    namesOnly = true;
                }
            }
            this.elementPanelAndTopSplitter.setDividerLocation(totalHeight);
            double dividerLocation = this.elementPanelAndTopSplitter.getDividerLocation();
            double remainder = 0.0;
            if (this.topSplitPane.getPaneAt(this.topSplitPane.getPaneCount() - 1).isVisible()) {
                int columnCategoryHeight = this.columnCategoryPanel.getPreferredSize().height;
                columnCategoryHeight = Math.min(columnCategoryHeight, 150);
                remainder = (double)columnCategoryHeight / dividerLocation;
            }
            double[] proportions = new double[this.topSplitPane.getPaneCount() - 1];
            if (this.topSplitPane.getPaneAt(0).isVisible()) {
                proportions[0] = 150.0 / dividerLocation;
            }
            if ((columnNamesHeight = (double)this.topSplitPane.getPaneAt((int)1).getPreferredSize().height) > 300.0) {
                columnNamesHeight = 300.0;
            }
            proportions[1] = columnNamesHeight / dividerLocation;
            int count3 = this.topSplitPane.getPaneCount() - 1;
            for (int i = 2; i < count3; ++i) {
                if (!this.topSplitPane.getPaneAt(i).isVisible()) continue;
                proportions[i] = (double)Math.min(this.topSplitPane.getPaneAt((int)i).getPreferredSize().height, 150) / dividerLocation;
            }
            if (namesOnly) {
                Arrays.fill(proportions, 0.0);
                proportions[1] = 1.0;
            }
            if ((sum = new PSum().evaluate(proportions)) > (max = 1.0 - remainder)) {
                double over = Math.abs(sum - max);
                if (this.topSplitPane.getPaneAt(2).isVisible()) {
                    over /= 2.0;
                }
                proportions[1] = proportions[1] - over;
                if (this.topSplitPane.getPaneAt(2).isVisible()) {
                    proportions[1] = proportions[1] - over;
                }
                sum = new PSum().evaluate(proportions);
            }
            if (sum - max > 0.01 || sum > 1.0) {
                System.out.println("Failed to allocate top split pane proportions. Proportions: " + ToStringUtil.toString(proportions, ", ") + ", Max: " + max + ", Sum: " + sum);
                Arrays.fill(proportions, 0.95 / (double)proportions.length);
            }
            this.topSplitPane.setProportions(proportions);
        }
    }

    private void setViewSizeFromModel(Project project, DefaultSizesAndPositions modelSizes, SizesAndPositions viewSizes) {
        if (modelSizes != null) {
            viewSizes.setSize(modelSizes.getSize());
        }
    }

    private JMenuItem sortBySelection(final boolean isColumnPopup) {
        JMenuItem menuItem = new JMenuItem(isColumnPopup ? "Sort Rows By Selected Columns" : "Sort Columns By Selected Rows");
        menuItem.setIcon(IconManager.loadIcon(isColumnPopup ? "16x16/10626.sort.gif" : "16x16/10626.sort-columns.GIF"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox sortOrderComboBox = UIUtil.createComboBox((Object[])new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING});
                sortOrderComboBox.setSelectedIndex(0);
                WeightedMean weightedMean = Application.isDevVersion() ? new WeightedMean(){

                    @Override
                    public String toString() {
                        return "Mean weighted by spearman rank correlation";
                    }
                } : null;
                JComboBox summaryFunctionComboBox = weightedMean != null ? UIUtil.createComboBox(new FloatListFunction[]{new Mean(), new Median(), weightedMean}) : UIUtil.createComboBox(new FloatListFunction[]{new Mean(), new Median()});
                summaryFunctionComboBox.setSelectedIndex(0);
                FormBuilder formBuilder = new FormBuilder();
                formBuilder.nextRow();
                formBuilder.addLabel("Order:");
                formBuilder.add(sortOrderComboBox);
                JTextField thresholdTextField = new JTextField("10", 12);
                if (isColumnPopup && HeatMapPanel.this.project.getColumnSelectionModel().getSelectionCount() > 1 || !isColumnPopup && HeatMapPanel.this.project.getRowSelectionModel().getSelectionCount() > 1) {
                    formBuilder.nextRow();
                    formBuilder.addLabel("Summary function:");
                    formBuilder.add(summaryFunctionComboBox);
                    if (Application.isDevVersion()) {
                        formBuilder.nextRow();
                        formBuilder.addLabel("Absolute value for thresholding:");
                        formBuilder.add(thresholdTextField);
                    }
                }
                if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), formBuilder.getPanel(), "Sort")) {
                    int[] selectedIndices = isColumnPopup ? HeatMapPanel.this.project.getModelColumnIndices(true, false) : HeatMapPanel.this.project.getModelRowIndices(true, false);
                    float threshold = Float.NaN;
                    FloatListFunction summaryFunction = (FloatListFunction)summaryFunctionComboBox.getSelectedItem();
                    if (summaryFunction instanceof WeightedMean) {
                        threshold = ParserHelper.parseFloatNaN(thresholdTextField.getText().trim());
                        SpearmanCorrelation weightingFunction = new SpearmanCorrelation();
                        Dataset selection = DatasetUtil.sliceView(HeatMapPanel.this.project.getOriginalDataset(), (int[])(!isColumnPopup ? selectedIndices : null), (int[])(isColumnPopup ? selectedIndices : null));
                        if (!isColumnPopup) {
                            selection = DatasetUtil.transposeView(selection);
                        }
                        int ncols = selection.getColumnCount();
                        float[][] matrix = new float[ncols][ncols];
                        DatasetColumnView c1 = new DatasetColumnView(selection);
                        DatasetColumnView c2 = new DatasetColumnView(selection);
                        for (int i = 1; i < ncols; ++i) {
                            c1.setIndex(i);
                            for (int j = 0; j < i; ++j) {
                                float value;
                                c2.setIndex(j);
                                matrix[i][j] = value = weightingFunction.evaluate(c1, c2);
                                matrix[j][i] = value;
                            }
                        }
                        float[] weights = new float[selectedIndices.length];
                        for (int i = 0; i < ncols; ++i) {
                            float sum = 0.0f;
                            for (int j = 0; j < ncols; ++j) {
                                if (i == j) continue;
                                float weight = matrix[i][j];
                                sum += weight;
                            }
                            float weight = sum / (float)(ncols - 1);
                            if (weight < 0.0f) {
                                weight = 0.0f;
                            }
                            weights[i] = weight;
                        }
                        ((WeightedMean)summaryFunction).setWeights(new ArrayFloatList(weights));
                    }
                    SortOrder sortOrder = (SortOrder)((Object)sortOrderComboBox.getSelectedItem());
                    ArrayList<SortKeys.SortByValues> sortKey = new ArrayList<SortKeys.SortByValues>();
                    sortKey.add(new SortKeys.SortByValues(HeatMapPanel.this.project, selectedIndices, sortOrder, summaryFunction, threshold, isColumnPopup));
                    if (isColumnPopup) {
                        HeatMapPanel.this.project.setRowSortOrder(sortKey);
                    } else {
                        HeatMapPanel.this.project.setColumnSortOrder(sortKey);
                    }
                }
            }
        });
        return menuItem;
    }

    private void updateColorSchemeLegend() {
        if (this.colorSchemeLegend != null) {
            this.colorSchemeLegend.removeMouseListener(this.colorSchemeLegendMouseListener);
            if (this.heatMapToolBar != null) {
                this.heatMapToolBar.remove(this.colorSchemeLegend);
            }
        }
        this.colorSchemeLegend = this.getColorSchemeLegend();
        if (this.colorSchemeLegend != null && this.heatMapToolBar != null) {
            this.colorSchemeLegend.addMouseListener(this.colorSchemeLegendMouseListener);
            this.heatMapToolBar.add(this.colorSchemeLegend);
            this.heatMapToolBar.revalidate();
            this.heatMapToolBar.repaint();
        }
        if (this.colorSchemeLegend != null) {
            this.colorSchemeLegend.repaint();
        }
    }

    private void updateModelSizesAndPositions(Project project, SizesAndPositionsEvent event, DefaultSizesAndPositions modelSizes, SizesAndPositions viewSizes, boolean row) {
        if (event.isSpacesChanged()) {
            for (int viewIndex = viewSizes.getLength() - 1; viewIndex >= 0; --viewIndex) {
                int modelIndex = row ? project.convertViewRowIndexToModel(viewIndex) : project.convertViewColumnIndexToModel(viewIndex);
                modelSizes.setSpaceSize(modelIndex, viewSizes.getSpaceSize(viewIndex));
            }
        } else {
            modelSizes.setSize(viewSizes.getSize());
        }
    }

    private void zoomTo(MouseEvent e, boolean zoomIn) {
        final int column = this.project.convertViewColumnIndexToModel(this.viewColumnSizesAndPositions.getIndex(e.getX(), true));
        final int row = this.project.convertViewRowIndexToModel(this.viewRowSizesAndPositions.getIndex(e.getY(), true));
        if (column != -1 && row != -1) {
            Rectangle rect = this.elementPanel.getVisibleRect();
            float oldColumnPosition = this.viewColumnSizesAndPositions.getPosition(column);
            float oldRowPosition = this.viewRowSizesAndPositions.getPosition(row);
            this.elementPanel.setZoomToElement(new MatrixElement(row, column));
            this.zoom(zoomIn, true, true);
            final JScrollPane columnScrollPane = UIUtil.getScrollPane((Component)((Object)this.columnTable));
            final float yOffset = oldRowPosition - (float)rect.y;
            final float xOffset = oldColumnPosition - (float)rect.x;
            new Thread(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            float columnPosition = HeatMapPanel.this.viewColumnSizesAndPositions.getPosition(column);
                            if ((columnPosition = (float)((int)(columnPosition - xOffset))) > (float)columnScrollPane.getHorizontalScrollBar().getModel().getMaximum()) {
                                columnPosition = columnScrollPane.getHorizontalScrollBar().getModel().getMaximum();
                            }
                            if (columnPosition < (float)columnScrollPane.getVerticalScrollBar().getModel().getMinimum()) {
                                columnPosition = columnScrollPane.getHorizontalScrollBar().getModel().getMinimum();
                            }
                            columnScrollPane.getHorizontalScrollBar().getModel().setValue((int)columnPosition);
                            float rowPosition = HeatMapPanel.this.viewRowSizesAndPositions.getPosition(row);
                            rowPosition = (int)(rowPosition - yOffset);
                            if (rowPosition > (float)HeatMapPanel.this.rowTableScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                                rowPosition = HeatMapPanel.this.rowTableScrollPane.getVerticalScrollBar().getModel().getMaximum();
                            }
                            if (rowPosition < (float)HeatMapPanel.this.rowTableScrollPane.getVerticalScrollBar().getModel().getMinimum()) {
                                rowPosition = HeatMapPanel.this.rowTableScrollPane.getVerticalScrollBar().getModel().getMinimum();
                            }
                            HeatMapPanel.this.rowTableScrollPane.getVerticalScrollBar().getModel().setValue((int)rowPosition);
                            Animator animator = new Animator(1500);
                            animator.addTarget(new TimingTarget(){

                                @Override
                                public void begin() {
                                }

                                @Override
                                public void end() {
                                    HeatMapPanel.this.elementPanel.setZoomToElement(null);
                                    HeatMapPanel.this.elementPanel.repaint();
                                }

                                @Override
                                public void repeat() {
                                }

                                @Override
                                public void timingEvent(float fraction) {
                                    HeatMapPanel.this.elementPanel.repaint();
                                }
                            });
                            animator.start();
                        }
                    });
                }
            }.start();
        }
    }

    public static int getSize(SizesAndPositions sizesAndPositions) {
        return 20 + (int)Math.ceil(sizesAndPositions.getPosition(sizesAndPositions.getLength() - 1) + sizesAndPositions.getSize());
    }

    public static int getSizeNoBorder(SizesAndPositions sizesAndPositions) {
        return (int)Math.ceil(sizesAndPositions.getPosition(sizesAndPositions.getLength() - 1) + sizesAndPositions.getSize());
    }

    private class ZoomToAction
    extends AbstractAction {
        private MouseEvent mouseEvent;
        private boolean zoomIn;

        public ZoomToAction(boolean zoomIn) {
            super("Zoom " + (zoomIn ? "In" : "Out"));
            this.zoomIn = zoomIn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeatMapPanel.this.zoomTo(this.mouseEvent, this.zoomIn);
        }
    }

    private static class PSum {
        private PSum() {
        }

        public double evaluate(double[] ad) {
            double d = 0.0;
            for (int i = 0; i < ad.length; ++i) {
                if (ad[i] < 0.0) {
                    ad[i] = 0.0;
                }
                if (ad[i] > 1.0) {
                    ad[i] = 1.0;
                }
                d += ad[i];
            }
            return d;
        }
    }

    private static class Page {
        private List<Rectangle> clips = new ArrayList<Rectangle>();
        private List<Drawable> drawables = new ArrayList<Drawable>();

        private Page() {
        }

        public void add(Drawable d, Rectangle clip) {
            this.drawables.add(d);
            this.clips.add(clip);
        }
    }

    private class OptionController
    implements MouseListener,
    MouseMotionListener {
        private JPopupMenu popupMenu = new JPopupMenu();
        private int xstart = -1;
        private int ystart = -1;
        private ZoomToAction zoomIn = new ZoomToAction(true);
        private ZoomToAction zoomOut = new ZoomToAction(false);

        private OptionController() {
            this.popupMenu.add(this.zoomIn);
            this.popupMenu.add(this.zoomOut);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (HeatMapPanel.this.elementSelectionEnabled && !e.isPopupTrigger()) {
                this.selectElement(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (HeatMapPanel.this.mouseMode == MouseMode.TABLE_LENS) {
                this.tableLensDrag(e.getY(), false);
            } else if (HeatMapPanel.this.mouseMode == MouseMode.DRAG_PAN) {
                int maxY;
                JViewport jv = HeatMapPanel.this.elementPanelScrollPane.getViewport();
                Point p = jv.getViewPosition();
                int newX = p.x - (e.getX() - this.xstart);
                int newY = p.y - (e.getY() - this.ystart);
                Dimension size = HeatMapPanel.this.elementPanel.getPreferredSize();
                int maxX = size.width - jv.getWidth();
                if (maxX < 0) {
                    maxX = p.x;
                }
                if ((maxY = size.height - jv.getHeight()) < 0) {
                    maxY = p.y;
                }
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                jv.setViewPosition(new Point(newX, newY));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HeatMapPanel.this.setMouseMovedPosition(-1, -1);
            HeatMapPanel.this.elementPanel.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int column = HeatMapPanel.this.project.convertViewColumnIndexToModel(HeatMapPanel.this.viewColumnSizesAndPositions.getIndex(e.getX(), true));
            int row = HeatMapPanel.this.project.convertViewRowIndexToModel(HeatMapPanel.this.viewRowSizesAndPositions.getIndex(e.getY(), true));
            if (column != -1 && row != -1) {
                HeatMapPanel.this.setMouseMovedPosition(row, column);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.zoomIn.mouseEvent = e;
                this.zoomOut.mouseEvent = e;
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            this.xstart = e.getX();
            this.ystart = e.getY();
            if (HeatMapPanel.this.mouseMode == MouseMode.DRAG_PAN) {
                HeatMapPanel.this.elementPanel.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            HeatMapPanel.this.elementPanel.setCursor(Cursor.getPredefinedCursor(0));
            if (e.isPopupTrigger()) {
                this.zoomIn.mouseEvent = e;
                this.zoomOut.mouseEvent = e;
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (HeatMapPanel.this.mouseMode == MouseMode.TABLE_LENS) {
                this.tableLensDrag(e.getY(), true);
            }
        }

        private void selectElement(MouseEvent e) {
            int column = HeatMapPanel.this.project.convertViewColumnIndexToModel(HeatMapPanel.this.viewColumnSizesAndPositions.getIndex(e.getX(), true));
            int row = HeatMapPanel.this.project.convertViewRowIndexToModel(HeatMapPanel.this.viewRowSizesAndPositions.getIndex(e.getY(), true));
            if (column != -1 && row != -1) {
                MatrixElement selectedElement = new MatrixElement(row, column);
                List<MatrixElement> selectedModelElementIndices = HeatMapPanel.this.project.getElementSelectionModel().getSelectedElements();
                boolean removed = selectedModelElementIndices.remove(selectedElement);
                if (!e.isShiftDown()) {
                    selectedModelElementIndices.clear();
                }
                if (!removed) {
                    if (!e.isShiftDown()) {
                        HeatMapPanel.this.project.setSelectedModelColumnIndices(new int[]{selectedElement.getColumn()});
                        HeatMapPanel.this.project.setSelectedModelRowIndices(new int[]{selectedElement.getRow()});
                    } else {
                        TIntArrayList columnIndices = new TIntArrayList(HeatMapPanel.this.project.getColumnSelectionModel().getSelectedModelIndices());
                        if (!columnIndices.contains(selectedElement.getColumn())) {
                            columnIndices.add(selectedElement.getColumn());
                        }
                        HeatMapPanel.this.project.setSelectedModelColumnIndices(columnIndices.toArray());
                        TIntArrayList rowIndices = new TIntArrayList(HeatMapPanel.this.project.getRowSelectionModel().getSelectedModelIndices());
                        if (!rowIndices.contains(selectedElement.getRow())) {
                            rowIndices.add(selectedElement.getRow());
                        }
                        HeatMapPanel.this.project.setSelectedModelRowIndices(rowIndices.toArray());
                    }
                    selectedModelElementIndices.add(selectedElement);
                } else {
                    TIntArrayList columnIndices = new TIntArrayList(HeatMapPanel.this.project.getColumnSelectionModel().getSelectedModelIndices());
                    columnIndices.remove(selectedElement.getColumn());
                    HeatMapPanel.this.project.setSelectedModelColumnIndices(columnIndices.toArray());
                    TIntArrayList rowIndices = new TIntArrayList(HeatMapPanel.this.project.getRowSelectionModel().getSelectedModelIndices());
                    rowIndices.remove(selectedElement.getRow());
                    HeatMapPanel.this.project.setSelectedModelRowIndices(rowIndices.toArray());
                }
                HeatMapPanel.this.project.getElementSelectionModel().setSelectedElements(selectedModelElementIndices);
            }
            HeatMapPanel.this.repaint();
        }

        private void tableLensDrag(int ypix, boolean endDrag) {
        }
    }

    private static class DrawablePositionInfo {
        int elementPanelXStart;
        int elementPanelYStart;
        int height;
        int width;

        private DrawablePositionInfo() {
        }
    }

    public class TiledHeatMapPrintable
    implements Printable {
        private boolean initted;
        private Page page;
        private int pageHeight;
        private int pageRemainderHeight;
        private List<Page> pages;
        private boolean scaleToFitWidth = false;

        public int getNumberOfPages() {
            return this.pages.size();
        }

        public void init(int width, int height) {
            this.createPages(width, height);
            this.initted = true;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (!this.initted) {
                this.createPages((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
                this.initted = true;
            }
            if (pageIndex >= this.pages.size()) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            AffineTransform t = g2.getTransform();
            Shape savedClip = g2.getClip();
            Page p = this.pages.get(pageIndex);
            int pageHeight = 0;
            List drawables = p.drawables;
            for (int j = 0; j < drawables.size(); ++j) {
                Rectangle clip = (Rectangle)p.clips.get(j);
                Drawable drawable = (Drawable)drawables.get(j);
                g2.translate(0, pageHeight);
                drawable.draw(g2, clip);
                g2.setClip(savedClip);
                g2.setTransform(t);
                pageHeight += clip.height;
            }
            g2.setTransform(t);
            g2.setClip(savedClip);
            return 0;
        }

        private void createPages(int pageWidth, int pageHeight) {
            this.pageHeight = pageHeight;
            this.pages = new ArrayList<Page>();
            JComponent colorSchemeLegend = HeatMapPanel.this.elementPanel.getColorScheme().getLegend();
            this.page = new Page();
            this.pages.add(this.page);
            this.pageRemainderHeight = pageHeight;
            if (colorSchemeLegend != null && colorSchemeLegend.isVisible()) {
                DrawableWrapper drawableWrapper = new DrawableWrapper(colorSchemeLegend);
                Dimension legendSize = drawableWrapper.getDrawableSize();
                boolean customSizeSet = colorSchemeLegend instanceof HeatMapColorSchemeLegend ? ((HeatMapColorSchemeLegend)colorSchemeLegend).isDrawableSizeSet() : false;
                int heatMapWidth = ((HeatMapPanel)HeatMapPanel.this).elementPanel.getPreferredSize().width;
                if (!customSizeSet && legendSize.width > heatMapWidth - 14) {
                    legendSize.width = heatMapWidth - 14;
                    drawableWrapper.setDrawableSizeSpecified(legendSize);
                }
                this.page.add(drawableWrapper, new Rectangle(legendSize));
                this.pageRemainderHeight -= legendSize.height;
            }
            boolean horizontal = false;
            boolean vertical = true;
            if (HeatMapPanel.this.categoryLegendVisible) {
                if (MetadataUtil.getCategoryColumns(HeatMapPanel.this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0) {
                    CategoryLegend columnColorLegend = new CategoryLegend(false, HeatMapPanel.this.columnColorCategoryLegendBoxSize);
                    columnColorLegend.setProject(HeatMapPanel.this.project);
                    this.tile(new DrawableWrapper(columnColorLegend), true, false);
                }
                if (MetadataUtil.getCategoryColumns(HeatMapPanel.this.project.getOriginalDataset().getRowMetadata()).getMetadataCount() > 0) {
                    CategoryLegend rowColorLegend = new CategoryLegend(true, HeatMapPanel.this.rowColorCategoryLegendBoxSize);
                    rowColorLegend.setProject(HeatMapPanel.this.project);
                    this.tile(new DrawableWrapper(rowColorLegend), true, false);
                }
            }
            if (HeatMapPanel.this.columnDendrogramPanel != null) {
                this.tile(new DrawableWrapper(HeatMapPanel.this.columnDendrogramPanel), vertical, horizontal);
            }
            HeatMapColumnTableDrawer columnNamesTableDrawer = new HeatMapColumnTableDrawer((JTable)((Object)HeatMapPanel.this.columnTable), HeatMapPanel.this.viewColumnSizesAndPositions);
            columnNamesTableDrawer.init();
            this.tile(columnNamesTableDrawer, vertical, horizontal);
            for (HeatMapChart chart : HeatMapPanel.this.columnCharts) {
                Axis axis = (Axis)chart.getClientProperty(HeatMapPanel.AXIS_PROPERTY);
                final Dimension axisSize = axis.getDrawableSize();
                DrawableWrapper axisWrapper = new DrawableWrapper(chart, false){

                    @Override
                    protected void afterDraw(Graphics g, Rectangle size) {
                        int tx = axisSize.width + 2;
                        g.translate(tx, size.height);
                    }

                    @Override
                    protected void beforeDraw(Graphics g, Rectangle clip) {
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(-2, 6, -2, axisSize.height - 6);
                        int tx = axisSize.width + 2;
                        g.translate(-tx, 0);
                    }
                };
                DrawableArray drawable = new DrawableArray(chart, axisWrapper);
                this.tile(drawable, vertical, horizontal);
            }
            if (MetadataUtil.getCategoryColumns(HeatMapPanel.this.project.getOriginalDataset().getColumnMetadata()).getMetadataCount() > 0) {
                this.tile(HeatMapPanel.this.columnCategoryPanel, vertical, horizontal);
            }
        }

        private void tile(Drawable c, boolean vertical, boolean horizontal) {
            int componentHeightDrawn = 0;
            Dimension size = c.getDrawableSize();
            while (componentHeightDrawn < size.height) {
                Rectangle clip = new Rectangle(size);
                clip.y = componentHeightDrawn;
                clip.height = Math.min(this.pageRemainderHeight, size.height - componentHeightDrawn);
                if (clip.height <= 0) break;
                this.page.add(c instanceof DrawableWrapper ? ((DrawableWrapper)c).copy() : c, clip);
                componentHeightDrawn += clip.height;
                this.pageRemainderHeight -= clip.height;
                if (this.pageRemainderHeight > 0) continue;
                this.page = new Page();
                this.pages.add(this.page);
                this.pageRemainderHeight = this.pageHeight;
            }
        }
    }

    public static enum MouseMode {
        DRAG_FISHEYE,
        DRAG_PAN,
        MAGNIFYING_GLASS,
        TABLE_LENS;

    }
}

