/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.GradientOrDiscreteTrackRenderer;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.color.GradientThumbRenderer;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbDataListener;
import org.jdesktop.swingx.multislider.ThumbListener;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class LinearGradientChooserPanel
extends JPanel {
    private JButton addThumbButton;
    private JButton deleteThumbButton;
    private EditColorButton editColorButton;
    private TimerTextField locationTextField;
    private float max;
    private float min;
    private JXMultiThumbSlider<Color> thumbSlider;

    public LinearGradientChooserPanel() {
        CellConstraints cc = new CellConstraints();
        this.thumbSlider = new JXMultiThumbSlider<Color>(){

            protected void paintComponent(Graphics g) {
                g.setColor(UIManager.getColor("Slider.shadow"));
                g.translate(0, 5);
                int cw = this.getWidth();
                g.drawLine(0, 0, cw - 1, 0);
                g.drawLine(0, 1, 0, 2);
                g.setColor(UIManager.getColor("Slider.highlight"));
                g.drawLine(0, 3, cw, 3);
                g.drawLine(cw, 0, cw, 3);
                g.setColor(Color.BLACK);
                g.drawLine(1, 1, cw - 2, 1);
                g.translate(0, -5);
                super.paintComponent(g);
                if (!this.isEnabled()) {
                    Graphics2D g2 = (Graphics2D)g;
                    Composite old = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2.setComposite(old);
                }
            }
        };
        this.thumbSlider.setOpaque(false);
        this.thumbSlider.getModel().setMinimumValue(0.0f);
        this.thumbSlider.getModel().setMaximumValue(1.0f);
        this.thumbSlider.setPreferredSize(new Dimension(300, 35));
        this.thumbSlider.setThumbRenderer((ThumbRenderer)new GradientThumbRenderer());
        this.thumbSlider.setTrackRenderer((TrackRenderer)new GradientOrDiscreteTrackRenderer());
        this.thumbSlider.addMultiThumbListener((ThumbListener)new MyThumbListener());
        JPanel bottomPanel = new JPanel((LayoutManager)new FormLayout("pref", "pref, 2px, pref"));
        JPanel addDeletePanel = new JPanel((LayoutManager)new FormLayout("p, 2px, p, 2px, p", "p, 4px, p"));
        this.addThumbButton = new JButton(new AddThumbAction());
        this.deleteThumbButton = new JButton(new DeleteThumbAction());
        this.deleteThumbButton.setEnabled(false);
        this.editColorButton = new EditColorButton(Color.BLACK);
        this.editColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = LinearGradientChooserPanel.this.thumbSlider.getSelectedIndex();
                LinearGradientChooserPanel.this.thumbSlider.getModel().getThumbAt(index).setObject((Object)LinearGradientChooserPanel.this.editColorButton.getColor());
            }
        });
        this.editColorButton.setEnabled(false);
        this.locationTextField = new TimerTextField(){

            @Override
            public void update() {
                int index = LinearGradientChooserPanel.this.thumbSlider.getSelectedIndex();
                if (index >= 0) {
                    try {
                        float value = ParserHelper.parseFloat(this.getText().trim());
                        float span = LinearGradientChooserPanel.this.max - LinearGradientChooserPanel.this.min;
                        float pos = (value - LinearGradientChooserPanel.this.min) / span;
                        LinearGradientChooserPanel.this.thumbSlider.getModel().getThumbAt(index).setPosition(pos);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        };
        this.locationTextField.setEnabled(false);
        JPanel valuePanel = new JPanel((LayoutManager)new FormLayout("p, 6px, p", "p"));
        valuePanel.add((Component)new JLabel("Selected value: "), cc.xy(1, 1));
        valuePanel.add((Component)this.locationTextField, cc.xy(3, 1));
        addDeletePanel.add((Component)valuePanel, cc.xyw(1, 1, 5));
        addDeletePanel.add((Component)this.addThumbButton, cc.xy(1, 3));
        addDeletePanel.add((Component)this.deleteThumbButton, cc.xy(3, 3));
        addDeletePanel.add((Component)this.editColorButton, cc.xy(5, 3));
        bottomPanel.add((Component)addDeletePanel, cc.xy(1, 1));
        this.setLayout((LayoutManager)new FormLayout("pref", "pref, 2px, pref"));
        this.add((Component)this.thumbSlider, cc.xy(1, 1));
        this.add((Component)bottomPanel, cc.xy(1, 3));
    }

    public void addThumbDataListener(ThumbDataListener l) {
        this.thumbSlider.getModel().addThumbDataListener(l);
    }

    public FractionColorPair[] getFractionColorPairs() {
        List stops = this.thumbSlider.getModel().getSortedThumbs();
        ArrayList<FractionColorPair> fractions = new ArrayList<FractionColorPair>();
        for (Thumb thumb : stops) {
            fractions.add(new FractionColorPair(thumb.getPosition(), (Color)thumb.getObject()));
        }
        Collections.sort(fractions);
        return fractions.toArray(new FractionColorPair[0]);
    }

    public void removeThumbDataListener(ThumbDataListener l) {
        this.thumbSlider.getModel().removeThumbDataListener(l);
    }

    public void setColors(boolean discrete, Color[] colors, float[] fractions) {
        float[] fArray;
        Color[] colorArray;
        GradientOrDiscreteTrackRenderer renderer = (GradientOrDiscreteTrackRenderer)this.thumbSlider.getTrackRenderer();
        renderer.setDiscrete(discrete);
        if (colors != null) {
            colorArray = colors;
        } else {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLUE;
            colorArray = colorArray2;
            colorArray2[1] = Color.RED;
        }
        colors = colorArray;
        if (fractions != null) {
            fArray = fractions;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = 0.0f;
            fArray = fArray2;
            fArray2[1] = 1.0f;
        }
        fractions = fArray;
        MultiThumbModel thumbModel = this.thumbSlider.getModel();
        while (thumbModel.getThumbCount() > 0) {
            thumbModel.removeThumb(0);
        }
        int startIndex = colors.length > 1 && colors[0].equals(colors[1]) ? 1 : 0;
        int endIndex = colors.length > 1 && colors[colors.length - 2].equals(colors[colors.length - 1]) ? colors.length - 1 : colors.length;
        for (int i = startIndex; i < endIndex; ++i) {
            thumbModel.addThumb(fractions[i], (Object)colors[i]);
        }
        int index = this.thumbSlider.getSelectedIndex();
        if (index >= 0) {
            float span = this.max - this.min;
            float pos = this.thumbSlider.getModel().getThumbAt(index).getPosition();
            float value = pos * span + this.min;
            this.locationTextField.setTextNoUpdate(Formatter.format(value));
        }
        this.thumbSlider.repaint();
    }

    public void setMinMax(float min, float max) {
        this.min = min;
        this.max = max;
        float span = max - min;
        int index = this.thumbSlider.getSelectedIndex();
        if (index >= 0) {
            float pos = this.thumbSlider.getModel().getThumbAt(index).getPosition();
            float value = pos * span + min;
            this.locationTextField.setTextNoUpdate(Formatter.format(value));
        }
        this.repaint();
    }

    private void showColorChooser(int index) {
        Color initialColor = (Color)this.thumbSlider.getModel().getThumbAt(index).getObject();
        Color color = UIUtil.showColorDialog(this, "Choose Color", initialColor);
        if (color != null) {
            this.thumbSlider.getModel().getThumbAt(index).setObject((Object)color);
        }
    }

    private class MyThumbListener
    implements ThumbListener {
        private MyThumbListener() {
        }

        public void mousePressed(MouseEvent e) {
            int index;
            if (!LinearGradientChooserPanel.this.thumbSlider.isEnabled()) {
                return;
            }
            if (e.getClickCount() > 1 && (index = LinearGradientChooserPanel.this.thumbSlider.getSelectedIndex()) >= 0) {
                LinearGradientChooserPanel.this.showColorChooser(index);
            }
        }

        public void thumbMoved(int thumb, float pos) {
            if (!LinearGradientChooserPanel.this.thumbSlider.isEnabled()) {
                return;
            }
            if (thumb == -1) {
                LinearGradientChooserPanel.this.locationTextField.setTextNoUpdate("");
            } else {
                float span = LinearGradientChooserPanel.this.max - LinearGradientChooserPanel.this.min;
                float value = pos * span + LinearGradientChooserPanel.this.min;
                LinearGradientChooserPanel.this.locationTextField.setTextNoUpdate(Formatter.format(value));
            }
        }

        public void thumbSelected(int thumb) {
            if (!LinearGradientChooserPanel.this.thumbSlider.isEnabled()) {
                return;
            }
            if (thumb == -1) {
                LinearGradientChooserPanel.this.deleteThumbButton.setEnabled(false);
                LinearGradientChooserPanel.this.editColorButton.setEnabled(false);
                LinearGradientChooserPanel.this.locationTextField.setTextNoUpdate("");
                LinearGradientChooserPanel.this.editColorButton.setEnabled(false);
                LinearGradientChooserPanel.this.locationTextField.setEnabled(false);
            } else {
                LinearGradientChooserPanel.this.editColorButton.setEnabled(true);
                float span = LinearGradientChooserPanel.this.max - LinearGradientChooserPanel.this.min;
                float pos = LinearGradientChooserPanel.this.thumbSlider.getModel().getThumbAt(thumb).getPosition();
                float value = pos * span + LinearGradientChooserPanel.this.min;
                LinearGradientChooserPanel.this.deleteThumbButton.setEnabled(LinearGradientChooserPanel.this.thumbSlider.getModel().getThumbCount() > 2);
                LinearGradientChooserPanel.this.locationTextField.setTextNoUpdate(Formatter.format(value));
                LinearGradientChooserPanel.this.editColorButton.setColor((Color)LinearGradientChooserPanel.this.thumbSlider.getModel().getThumbAt(thumb).getObject());
                LinearGradientChooserPanel.this.locationTextField.setEnabled(true);
            }
        }
    }

    private final class DeleteThumbAction
    extends AbstractAction {
        public DeleteThumbAction() {
            super("Delete");
            this.putValue("ShortDescription", "Delete the selected color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int index = LinearGradientChooserPanel.this.thumbSlider.getSelectedIndex();
            if (index >= 0) {
                LinearGradientChooserPanel.this.thumbSlider.getModel().removeThumb(index);
            }
            this.setEnabled(false);
        }
    }

    private final class AddThumbAction
    extends AbstractAction {
        public AddThumbAction() {
            super("Add");
            this.putValue("ShortDescription", "Add a color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LinearGradientChooserPanel.this.thumbSlider.getModel().addThumb(0.3f, (Object)Color.BLACK);
        }
    }

    public static class FractionColorPair
    implements Comparable<FractionColorPair> {
        private float fraction;
        private Color color;

        public FractionColorPair(float fraction, Color color) {
            this.fraction = fraction;
            this.color = color;
        }

        @Override
        public int compareTo(FractionColorPair o) {
            return Float.compare(this.fraction, o.fraction);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FractionColorPair) {
                FractionColorPair other = (FractionColorPair)obj;
                return this.fraction == other.fraction;
            }
            return false;
        }

        public Color getColor() {
            return this.color;
        }

        public float getFraction() {
            return this.fraction;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.fraction);
        }
    }
}

