/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.OpenMapFile;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SeekableLineInputStreamTableModel;
import org.broadinstitute.genee.heatmap.menu.file.Importer;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class OpenDatasetFile {
    private OpenDatasetFile() {
    }

    public static void load(final String[] files) throws IOException {
        boolean isRnk = false;
        boolean isMap = false;
        for (String file : files) {
            if ("rnk".equalsIgnoreCase(IOUtil.getExtension(file))) {
                isRnk = true;
                continue;
            }
            if (!"map".equalsIgnoreCase(IOUtil.getExtension(file))) continue;
            isMap = true;
        }
        if (isMap) {
            OpenMapFile.open(files[0]);
        } else if (isRnk) {
            new BackgroundTask<ProjectGENEEResultTreeNode>("Open File"){

                @Override
                protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                    Dataset rankedList = ProjectIO.readProject(files[0]).getOriginalDataset();
                    RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset("Ranked Lists", rankedList.getRowCount(), files.length);
                    Vector rowIds = MetadataUtil.addColumnVector(combinedDataset.getRowMetadata(), "Id", String.class);
                    Map rowNameToIndex = VectorUtil.createValueToIndexMap(rankedList.getRowMetadata().get(0));
                    int nrows = combinedDataset.getRowCount();
                    for (int i = 0; i < nrows; ++i) {
                        rowIds.setValue(i, rankedList.getRowMetadata().getValue(i, 0));
                        combinedDataset.setValue(i, 0, rankedList.getValue(i, 0));
                        int ncols = combinedDataset.getColumnCount();
                        for (int j = 1; j < ncols; ++j) {
                            combinedDataset.setValue(i, j, Float.NaN);
                        }
                    }
                    Vector fileNameVector = MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), "Ranked List", String.class);
                    fileNameVector.setValue(0, IOUtil.getBaseFileName(rankedList.getName()));
                    for (int rankedListIndex = 1; rankedListIndex < files.length; ++rankedListIndex) {
                        rankedList = ProjectIO.readProject(files[rankedListIndex]).getOriginalDataset();
                        fileNameVector.setValue(rankedListIndex, IOUtil.getBaseFileName(rankedList.getName()));
                        int nrows2 = rankedList.getRowCount();
                        for (int i = 0; i < nrows2; ++i) {
                            Integer rowIndex = rowNameToIndex.get(rankedList.getRowMetadata().getValue(i, 0));
                            if (rowIndex == null) continue;
                            combinedDataset.setValue(rowIndex, rankedListIndex, rankedList.getValue(i, 0));
                        }
                    }
                    History map = new History("Open file");
                    return new ProjectGENEEResultTreeNode(new DefaultProject(combinedDataset), map);
                }

                @Override
                protected void succeeded(ProjectGENEEResultTreeNode node) {
                    if (node != null) {
                        File f;
                        if (files.length == 1 && (f = new File(files[0])).exists()) {
                            node.setFile(f);
                        }
                        Application.add(new GENEEFolderNode("Open File", node.getAuditTrail().last(), node));
                    }
                }
            }.execute();
        } else {
            for (String file : files) {
                OpenDatasetFile.load(file);
            }
        }
    }

    private static void load(final String file) throws FileNotFoundException {
        if (file == null) {
            return;
        }
        if (!new File(file).exists()) {
            throw new FileNotFoundException("File " + file + " not found.");
        }
        ProjectReader reader = ProjectIO.getProjectReader(file);
        if (reader == null) {
            OpenDatasetFile.doImport(file);
            return;
        }
        String atrFile = null;
        String gtrFile = null;
        String baseName = IOUtil.getBaseFileName(file);
        File f = new File(file);
        if (f.exists()) {
            File atr;
            File gtr = new File(f.getParentFile(), baseName + ".gtr");
            if (gtr.exists()) {
                try {
                    gtrFile = gtr.getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((atr = new File(f.getParentFile(), baseName + ".atr")).exists()) {
                try {
                    atrFile = atr.getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        final String _gtrFile = gtrFile;
        final String _atrFile = atrFile;
        new BackgroundTask<ProjectGENEEResultTreeNode>("Open File"){

            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                return OpenDatasetFile.createNode(file, _atrFile, _gtrFile);
            }

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                if (node != null) {
                    File f = new File(file);
                    if (f.exists()) {
                        node.setFile(f);
                    }
                    Application.add(new GENEEFolderNode("Open File", node.getAuditTrail().last(), node));
                }
            }
        }.execute();
    }

    public static ProjectGENEEResultTreeNode createNode(String inputFile, String atrFile, String gtrFile) {
        boolean cdt = inputFile.toLowerCase().endsWith(".cdt");
        ProjectReader reader = ProjectIO.getProjectReader(inputFile);
        Project p = null;
        if (reader != null) {
            try {
                p = ProjectIO.readProject(inputFile);
            }
            catch (IOException x) {
                x.printStackTrace();
                UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), x.getMessage());
                System.err.println("Error reading " + inputFile);
                return null;
            }
        }
        if (p == null) {
            OpenDatasetFile.doImport(inputFile);
            return null;
        }
        Dataset dataset = p.getOriginalDataset();
        AtrGtrDendrogram gtrReader = null;
        if (cdt && gtrFile != null) {
            try {
                String[] geneIds = new String[dataset.getRowCount()];
                int rows = dataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    geneIds[i] = (String)dataset.getRowMetadata().getValue(i, "gene id");
                }
                gtrReader = new AtrGtrDendrogram(geneIds, gtrFile);
            }
            catch (IOException e) {
                UIUtil.showErrorDialog(null, "An error occurred while reading the file " + gtrFile);
                throw new RuntimeException(e);
            }
        }
        AtrGtrDendrogram atrReader = null;
        if (cdt && atrFile != null) {
            try {
                String[] arrayIds = new String[dataset.getColumnCount()];
                int columns = dataset.getColumnCount();
                for (int j = 0; j < columns; ++j) {
                    arrayIds[j] = (String)dataset.getColumnMetadata().getValue(j, "array id");
                }
                atrReader = new AtrGtrDendrogram(arrayIds, atrFile);
            }
            catch (IOException e) {
                UIUtil.showErrorDialog(null, "An error occurred while reading the file " + atrFile);
                throw new RuntimeException(e);
            }
        }
        if (dataset != null) {
            if (gtrReader != null) {
                p.setRowDendrogram(gtrReader);
            }
            if (atrReader != null) {
                p.setColumnDendrogram(atrReader);
            }
            History map = new History("Open file");
            map.add("File", inputFile);
            return new ProjectGENEEResultTreeNode(p, map);
        }
        return null;
    }

    private static void doImport(final String file) {
        final boolean isExcelFile = ExcelReader.isExcelFile(file);
        File f = new File(file);
        if (isExcelFile || f.exists() && f.length() < 0x20000000L) {
            String sheet = null;
            if (isExcelFile) {
                Object[] sheets = ExcelReader.getSheetNames(file);
                sheet = sheets[0];
                if (sheets.length > 1) {
                    sheet = (String)JOptionPane.showInputDialog(UIUtil.getCurrentFrame(), "Select Excel Sheet", "Select Excel Sheet", -1, IconManager.loadIcon("heatmap-64.gif"), sheets, sheets[0]);
                }
            }
            final String _sheet = sheet;
            new BackgroundTask<TableModel>("Reading " + new File(file).getName()){

                @Override
                protected TableModel doInBackground() throws Exception {
                    try {
                        String[][] array2d = ((Array2DContentHandler)new ExcelReader(file, _sheet, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
                        return new StringTableModel(array2d);
                    }
                    catch (OutOfMemoryError x) {
                        System.err.println("Not enough memory");
                        if (isExcelFile) {
                            throw x;
                        }
                        return new SeekableLineInputStreamTableModel(file);
                    }
                }

                @Override
                protected void succeeded(TableModel tableModel) {
                    new Importer(tableModel, new File(file).getName());
                }
            }.execute();
        } else {
            new BackgroundTask<TableModel>("Reading " + new File(file).getName()){

                @Override
                protected TableModel doInBackground() throws Exception {
                    return new SeekableLineInputStreamTableModel(file);
                }

                @Override
                protected void succeeded(TableModel tableModel) {
                    new Importer(tableModel, new File(file).getName());
                }
            }.execute();
        }
    }
}

