/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.OpenFileListener;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class OpenRecentMenu
extends JMenu
implements MenuListener {
    public static final String OPEN_RECENT = "open.recent";
    private static Preferences prefs = Preferences.userNodeForPackage(OpenRecentMenu.class);

    public OpenRecentMenu() {
        super("Open Recent");
        this.addMenuListener(this);
    }

    @Override
    public void menuSelected(MenuEvent event) {
        this.rebuild();
    }

    private void rebuild() {
        this.removeAll();
        String recentFiles = prefs.get(OPEN_RECENT, null);
        String[] files = null;
        if (recentFiles != null) {
            files = recentFiles.split(";");
            ArrayList<File> sortedFiles = new ArrayList<File>();
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            for (String file : files) {
                File f;
                if (file.equals("") || !(f = new File(file)).exists()) continue;
                sortedFiles.add(f);
                Integer occurences = (Integer)fileNames.get(f.getName());
                if (occurences == null) {
                    occurences = 0;
                }
                fileNames.put(f.getName(), occurences + 1);
            }
            Collections.sort(sortedFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (final File file : sortedFiles) {
                String title = (Integer)fileNames.get(file.getName()) > 1 ? IOUtil.getPath(file) : file.getName();
                AbstractAction openRecentAction = new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerUtil.trackPageView("Open Recent");
                        try {
                            OpenFileListener[] listeners;
                            for (OpenFileListener l : listeners = Application.getOpenFileActionListeners()) {
                                l.open(new String[]{file.getCanonicalPath()}, null);
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                };
                if ((Integer)fileNames.get(file.getName()) == 1) {
                    openRecentAction.putValue("ShortDescription", IOUtil.getPath(file));
                }
                this.add(openRecentAction);
            }
        }
        if (this.getItemCount() > 0) {
            this.add(new JSeparator());
        }
        AbstractAction clearMenuItem = new AbstractAction("Clear Menu"){

            @Override
            public void actionPerformed(ActionEvent e) {
                prefs.remove(OpenRecentMenu.OPEN_RECENT);
                try {
                    prefs.sync();
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
                OpenRecentMenu.this.rebuild();
            }
        };
        clearMenuItem.setEnabled(files != null && files.length > 0);
        this.add(clearMenuItem);
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

