/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class PresetColorSchemesShortcuts {
    public PresetColorSchemesShortcuts(final HeatMapPanel heatMapPanel) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        int sc = UIUtil.getMenuShortcutKeyMask() | 1;
        KeyStroke rnaiColorScheme = KeyStroke.getKeyStroke(49, sc);
        heatMapPanel.getInputMap(2).put(rnaiColorScheme, "RNAi color scheme");
        heatMapPanel.getActionMap().put("RNAi color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setGlobalMaxMode(2, 1.0f);
                cs.setGlobalMinMode(2, 0.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE}, new float[]{0.0f, 1.0f});
                heatMapPanel.invalidateImage();
            }
        });
        KeyStroke rescaledColorScheme = KeyStroke.getKeyStroke(50, sc);
        heatMapPanel.getInputMap(2).put(rescaledColorScheme, "Rescaled color scheme");
        heatMapPanel.getActionMap().put("Rescaled color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setGlobalMaxMode(2, 100.0f);
                cs.setGlobalMinMode(2, 1.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE});
                heatMapPanel.repaint();
            }
        });
        KeyStroke global = KeyStroke.getKeyStroke(51, sc);
        heatMapPanel.getInputMap(2).put(global, "Global color scheme");
        heatMapPanel.getActionMap().put("Global color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
                cs.setGlobalMaxMode(2, 3.0f);
                cs.setGlobalMinMode(2, -3.0f);
                heatMapPanel.invalidateImage();
            }
        });
        KeyStroke global2 = KeyStroke.getKeyStroke(52, sc);
        heatMapPanel.getInputMap(2).put(global2, "Global 2 color scheme");
        heatMapPanel.getActionMap().put("Global 2 color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setGlobalMaxMode(0);
                cs.setGlobalMinMode(0);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
                heatMapPanel.invalidateImage();
            }
        });
        KeyStroke rowNormScheme = KeyStroke.getKeyStroke(53, sc);
        heatMapPanel.getInputMap(2).put(rowNormScheme, "Row normalized color scheme");
        heatMapPanel.getActionMap().put("Row normalized color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setRelative(true);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
                heatMapPanel.invalidateImage();
            }
        });
        KeyStroke rowNormStdev = KeyStroke.getKeyStroke(54, sc);
        heatMapPanel.getInputMap(2).put(rowNormStdev, "Row normalized stdev color scheme");
        heatMapPanel.getActionMap().put("Row normalized stdev color scheme", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorScheme cs = heatMapPanel.getColorScheme();
                cs.setRelative(true);
                cs.setRowScalingMode(3);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
                heatMapPanel.invalidateImage();
            }
        });
    }
}

