/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortOrder;

class SortLevelComponent {
    private JComboBox sortOnComboBox;
    private JComboBox sortOrderComboBox;

    SortLevelComponent(JComboBox sortOnComboBox, JComboBox sortOrderComboBox) {
        this.sortOnComboBox = sortOnComboBox;
        this.sortOrderComboBox = sortOrderComboBox;
    }

    public void setSortKeys(List<ProjectSortKey> items) {
        this.sortOnComboBox.removeAllItems();
        for (ProjectSortKey item : items) {
            this.sortOnComboBox.addItem(item);
        }
    }

    public void setPropertiesFrom(ProjectSortKey sortKey) {
        if (sortKey == null) {
            this.sortOnComboBox.setSelectedIndex(0);
            this.sortOrderComboBox.setSelectedIndex(0);
        } else {
            this.sortOrderComboBox.setSelectedItem((Object)sortKey.getSortOrder());
            int index = -1;
            ComboBoxModel dataModel = this.sortOnComboBox.getModel();
            for (int i = 0; i < dataModel.getSize(); ++i) {
                Object element = dataModel.getElementAt(i);
                if (!sortKey.equals(element)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.sortOnComboBox.setSelectedIndex(index);
            } else {
                this.sortOnComboBox.addItem(sortKey);
                this.sortOnComboBox.setSelectedIndex(this.sortOnComboBox.getItemCount() - 1);
            }
        }
    }

    public boolean isSorted() {
        if (this.sortOrderComboBox.isEnabled()) {
            return this.sortOnComboBox.getSelectedIndex() > 0;
        }
        return true;
    }

    public SortOrder getSortOrder() {
        return this.sortOrderComboBox.isEnabled() ? (SortOrder)((Object)this.sortOrderComboBox.getSelectedItem()) : SortOrder.ASCENDING;
    }

    public ProjectSortKey getSortKey() {
        return (ProjectSortKey)this.sortOnComboBox.getSelectedItem();
    }
}

