/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.heatmap.MiniProfilePlot;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.table.HeatMapRowTable;

public class SparklineTableCellRenderer
extends DefaultTableCellRenderer {
    private MiniProfilePlot miniProfilePlot = new MiniProfilePlot();
    public static final Color DEFAULT_COLOR = QualitativeColorSchemes.getTenColor(0);

    public SparklineTableCellRenderer() {
        this.setPreferredSize(new Dimension(20, 10));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Dataset dataset = (Dataset)value;
        int width = table.getColumnModel().getColumn(column).getWidth();
        int height = (int)Math.floor(((HeatMapRowTable)table).getViewSizesAndPositions().getSize());
        this.miniProfilePlot.setSize(width, height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        g.setColor(isSelected ? table.getSelectionBackground() : table.getBackground());
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        this.miniProfilePlot.draw(g, dataset, row, DEFAULT_COLOR);
        g.dispose();
        ImageIcon imageIcon = new ImageIcon(image);
        this.setIcon(imageIcon);
        return this;
    }

    public void setFilled(boolean sparkLinesFilled) {
        this.miniProfilePlot.setFilled(sparkLinesFilled);
    }

    public boolean isFilled() {
        return this.miniProfilePlot.isFilled();
    }
}

