/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.AbstractDatasetView;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class CreateComputedVectorAction
extends AbstractAction {
    private boolean rows;
    private static final String[] FUNCTIONS = new String[]{"CV", "MAD", "MAX", "MEAN", "MEDIAN", "MIN", "STDEV", "SUM", "VARIANCE"};

    public CreateComputedVectorAction(boolean rows) {
        super("Create " + (rows ? "Row" : "Column") + " Annotation");
        this.rows = rows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Project project = Application.getProject();
        final GENEEWindow window = Application.getWindowManager().createInputWindow((String)this.getValue("Name"), null);
        final JTextField annotationNameTextField = new JTextField(12);
        FormBuilder fb = new FormBuilder();
        fb.nextRow();
        JLabel annotationNameLabel = new JLabel("Annotation name:");
        fb.addFirstColumn(annotationNameLabel);
        fb.add(annotationNameTextField);
        fb.nextRow();
        fb.addLabel("Formula:");
        final JButton okButton = new JButton("OK");
        okButton.setEnabled(false);
        final RSyntaxTextArea textArea = new RSyntaxTextArea(10, 50);
        DocumentListener dl = new DocumentListener(){

            private void setEnabled() {
                okButton.setEnabled(!annotationNameTextField.getText().trim().equals("") && CreateComputedVectorAction.this.isFormulaValid(textArea.getText().trim()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setEnabled();
            }
        };
        annotationNameTextField.getDocument().addDocumentListener(dl);
        textArea.getDocument().addDocumentListener(dl);
        textArea.setHighlightCurrentLine(false);
        textArea.setSyntaxEditingStyle("text/javascript");
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        for (String key : FUNCTIONS) {
            provider.addCompletion((Completion)new BasicCompletion((CompletionProvider)provider, key));
        }
        AutoCompletion ac = new AutoCompletion((CompletionProvider)provider);
        ac.install((JTextComponent)textArea);
        fb.add(UIUtil.createNoBorderScrollPane((Component)textArea));
        fb.nextRow();
        final JCheckBox spaceCheckBox = new JCheckBox("Compute function in space of selected " + (this.rows ? "columns" : "rows") + " only", false);
        fb.addSpanned(spaceCheckBox);
        JPanel p1 = fb.getPanel();
        fb = new FormBuilder(new JPanel(), 4);
        fb.nextRow();
        JLabel functionLabel = new JLabel("Functions:");
        functionLabel.setPreferredSize(annotationNameLabel.getPreferredSize());
        fb.addFirstColumn(functionLabel);
        final JList<String> functionList = new JList<String>(FUNCTIONS);
        functionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = functionList.locationToIndex(e.getPoint());
                    String s = "";
                    try {
                        String last;
                        if (textArea.getDocument().getLength() > 0 && !(last = textArea.getText(textArea.getDocument().getLength() - 1, 1)).equals(" ")) {
                            s = " ";
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    textArea.append(s + FUNCTIONS[index]);
                }
            }
        });
        functionList.setSelectionMode(0);
        fb.add(UIUtil.createNoBorderScrollPane(functionList));
        fb.nextColumn();
        fb.addLabel("Fields:");
        MetadataModel model = this.rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
        final ArrayList<String> fieldNames = new ArrayList<String>();
        int nmetadata = model.getMetadataCount();
        for (int metadataIndex = 0; metadataIndex < nmetadata; ++metadataIndex) {
            Class<?> c = model.get(metadataIndex).getColumnClass();
            if (!Number.class.isAssignableFrom(c)) continue;
            String name = model.getColumnName(metadataIndex);
            name = name.replace(' ', '_');
            fieldNames.add(name);
        }
        final JList<String> fieldsList = new JList<String>(fieldNames.toArray(new String[0]));
        fieldsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = fieldsList.locationToIndex(e.getPoint());
                    String s = "";
                    try {
                        String last;
                        if (textArea.getDocument().getLength() > 0 && !(last = textArea.getText(textArea.getDocument().getLength() - 1, 1)).equals(" ")) {
                            s = " ";
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    textArea.append(s + (String)fieldNames.get(index));
                }
            }
        });
        fieldsList.setSelectionMode(0);
        fb.add(UIUtil.createNoBorderScrollPane(fieldsList));
        fb.nextRow();
        JPanel p2 = fb.getPanel();
        JPanel p = new JPanel((LayoutManager)new FormLayout("p:g", "p:g, p:g"));
        p.add((Component)p1, CC.xy((int)1, (int)1));
        p.add((Component)p2, CC.xy((int)1, (int)2));
        window.getContentPane().add(p);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.dispose();
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String name = annotationNameTextField.getText().trim();
                if (name.equals("")) {
                    UIUtil.showErrorDialog((Component)textArea, "Please enter an annotation name.");
                    return;
                }
                final String text = textArea.getText().trim();
                final boolean selection = spaceCheckBox.isSelected();
                new BlockingThread("Computing annotation", false){

                    @Override
                    protected void doInBackground() throws Exception {
                        TrackerUtil.trackPageView((String)CreateComputedVectorAction.this.getValue("Name"));
                        CreateComputedVectorAction.createComputedField(project, name, text, CreateComputedVectorAction.this.rows, selection);
                    }
                };
                window.dispose();
            }
        });
        JPanel buttonBar = UIUtil.buildOKCancelBar(okButton, cancelButton);
        window.getContentPane().add((Component)buttonBar, "South");
        window.pack();
        window.setVisible(true);
    }

    public static void createComputedField(Project project, String fieldName, String formula, boolean isRows, boolean selectionOnly) throws ScriptException {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        Dataset dataset = project.getOriginalDataset();
        if (selectionOnly) {
            dataset = isRows ? DatasetUtil.sliceView(dataset, null, project.getModelColumnIndices(true, false)) : DatasetUtil.sliceView(dataset, project.getModelRowIndices(true, false), null);
        }
        MetadataModel model = isRows ? dataset.getRowMetadata() : dataset.getColumnMetadata();
        AbstractDatasetView view = isRows ? new DatasetRowView(dataset) : new DatasetColumnView(dataset);
        Vector v = isRows ? MetadataUtil.addRowVector(model, fieldName, Float.class) : MetadataUtil.addColumnVector(model, fieldName, Float.class);
        v.setProperty("Discrete Key", false);
        v.setProperty("formula", formula);
        MetadataUtil.setValuesFromFormula(v, model, view, engine, formula);
        if (isRows) {
            project.fireRowMetadataChanged();
        } else {
            project.fireColumnMetadataChanged();
        }
    }

    private boolean isFormulaValid(String text) {
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            for (String f : FUNCTIONS) {
                engine.put(f, 1);
            }
            Number result = (Number)engine.eval(text);
            return !Float.isNaN(result.floatValue());
        }
        catch (Exception x) {
            return false;
        }
    }
}

