/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import org.broadinstitute.genee.application.GENEEWindowMenu;
import org.broadinstitute.genee.application.GeneeExtensionManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.Zoomable;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.menu.EditMenu;
import org.broadinstitute.genee.heatmap.menu.HelpMenu;
import org.broadinstitute.genee.heatmap.menu.ViewMenu;
import org.broadinstitute.genee.heatmap.menu.analysis.ToolsMenu;
import org.broadinstitute.genee.heatmap.menu.file.FileMenu;
import org.broadinstitute.genee.heatmap.visualization.VisualizationMenu;

public class GENEEMenuBar
extends JMenuBar {
    private JPopupMenu rowDendrogramPopupMenu;
    private JPopupMenu columnDendrogramPopupMenu;
    private ViewMenu viewMenu;
    private EditMenu editMenu;
    private VisualizationMenu visualizationMenu;
    protected HeatMapPanel heatMapPanel;
    private GENEEWindowMenu windowMenu;
    private FileMenu fileMenu;

    public GENEEMenuBar(final HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        this.fileMenu = this.createFileMenu();
        this.add(this.fileMenu);
        this.editMenu = new EditMenu(heatMapPanel);
        this.viewMenu = new ViewMenu(heatMapPanel);
        this.add(this.editMenu);
        if (heatMapPanel.getRowDendrogramPanel() != null) {
            this.rowDendrogramPopupMenu = new JPopupMenu();
            AbstractAction flipRowDendrogramAction = new AbstractAction("Flip Node"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (heatMapPanel.getRowDendrogramPanel().getSelectedNode() == null) {
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                        return;
                    }
                    heatMapPanel.flipRowDendrogram();
                }
            };
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (heatMapPanel.getRowDendrogramPanel().getSelectedNode() == null) {
                            heatMapPanel.getRowDendrogramPanel().setSelectedNode(e);
                        }
                        UIUtil.setChildrenEnabledRecursively(GENEEMenuBar.this.rowDendrogramPopupMenu, heatMapPanel.getRowDendrogramPanel().getSelectedNode() != null);
                        GENEEMenuBar.this.rowDendrogramPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
            heatMapPanel.getRowDendrogramPanel().addMouseListener(mouseListener);
            this.rowDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getRowDendrogramBranchColorAction());
            this.rowDendrogramPopupMenu.add(flipRowDendrogramAction);
            this.rowDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getCutRowDendrogramAction());
        }
        if (heatMapPanel.getColumnDendrogramPanel() != null) {
            this.columnDendrogramPopupMenu = new JPopupMenu();
            heatMapPanel.getColumnDendrogramPanel().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (heatMapPanel.getColumnDendrogramPanel().getSelectedNode() == null) {
                            heatMapPanel.getColumnDendrogramPanel().setSelectedNode(e);
                        }
                        UIUtil.setChildrenEnabledRecursively(GENEEMenuBar.this.columnDendrogramPopupMenu, heatMapPanel.getColumnDendrogramPanel().getSelectedNode() != null);
                        GENEEMenuBar.this.columnDendrogramPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.columnDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getColumnDendrogramBranchColorAction());
            AbstractAction flipColumnDendrogramAction = new AbstractAction("Flip Node"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (heatMapPanel.getColumnDendrogramPanel().getSelectedNode() == null) {
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                        return;
                    }
                    heatMapPanel.flipColumnDendrogram();
                }
            };
            this.columnDendrogramPopupMenu.add(flipColumnDendrogramAction);
            this.columnDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getCutColumnDendrogramAction());
        }
        this.add(this.viewMenu);
        this.visualizationMenu = new VisualizationMenu(heatMapPanel);
        this.add(this.visualizationMenu);
        this.add(this.createToolsMenu());
        this.windowMenu = new GENEEWindowMenu();
        this.add(this.windowMenu);
        this.add(new HelpMenu(heatMapPanel));
        this.setZoomable(heatMapPanel);
        GeneeExtensionManager.getInstance().install(this, heatMapPanel.getToolBar());
    }

    public void rebuild() {
        this.windowMenu.rebuild();
    }

    protected FileMenu createFileMenu() {
        return new FileMenu(this.heatMapPanel);
    }

    protected JMenu createToolsMenu() {
        return new ToolsMenu(this.heatMapPanel);
    }

    private void setZoomable(Zoomable zoomable) {
        this.heatMapPanel.getHeatMapEditorKit().getZoomInAction().setEnabled(zoomable != null);
        this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction().setEnabled(zoomable != null);
        this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setEnabled(zoomable != null);
        if (zoomable != null) {
            this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setZoomable(zoomable);
            this.heatMapPanel.getHeatMapEditorKit().getZoomInAction().setZoomable(zoomable);
            this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction().setZoomable(zoomable);
        }
    }
}

