/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.analysis;

import gnu.trove.list.array.TFloatArrayList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.MarkerSelectionAction;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.RadioButtonParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.marker.MarkerSelection;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.CityBlock;
import org.broadinstitute.genee.math.stat.function.bivariate.CosineSimilarity;
import org.broadinstitute.genee.math.stat.function.bivariate.EuclideanDistance;
import org.broadinstitute.genee.math.stat.function.bivariate.KendallsTau;
import org.broadinstitute.genee.math.stat.function.bivariate.OneMinusPearsonCorrelation;
import org.broadinstitute.genee.math.stat.function.bivariate.PearsonCorrelation;
import org.broadinstitute.genee.math.stat.function.bivariate.SpearmanCorrelation;
import org.broadinstitute.genee.math.stat.function.bivariate.SpearmanDistance;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class NearestNeighborsAction
extends AbstractInputAction {
    private static final String COLUMN_ANNOTATION = "Column annotation";
    private static final String SELECTED_ROWS = "Selected rows";
    private static final String SELECTED_COLUMNS = "Selected columns";
    private static final String COMPUTE_NEAREST_NEIGHBORS_OF = "Compute nearest neighbors of";
    public static BivariateFloatListFunction[] FUNCTIONS = new BivariateFloatListFunction[]{new PearsonCorrelation(), new OneMinusPearsonCorrelation(), new SpearmanCorrelation(), new SpearmanDistance(), new KendallsTau(), new EuclideanDistance(), new CityBlock(), new CosineSimilarity()};
    private static final String METRIC = "Metric";
    private static final String COLLAPSE_METHOD = "Method to collapse rows if > 1 selected";
    private ComboBoxParameter numericColumnAnnotationComboBoxParameter;

    public NearestNeighborsAction() {
        super("Nearest Neighbors");
        this.setDescription("Compute the nearest neighbors of the selected row(s) or a numeric column annotation");
        this.addParameter(METRIC, new ComboBoxParameter((Object[])FUNCTIONS, FUNCTIONS[0]), true);
        this.addParameter("Markers", new IntegerInputParameter(50), "The number of markers to show initially. Enter zero to show all markers. Select Tools>Filter Rows to change.", true);
        this.addParameter("Permutations", new IntegerInputParameter(1000), "Enter -1 to perform all possible permutations. Number of possible exhaustive permutations is n!", false);
        final RadioButtonParameter buttons = new RadioButtonParameter(new String[]{SELECTED_ROWS, SELECTED_COLUMNS, COLUMN_ANNOTATION}, 0);
        this.addParameter(COMPUTE_NEAREST_NEIGHBORS_OF, buttons, true);
        this.numericColumnAnnotationComboBoxParameter = new ComboBoxParameter(String.class);
        this.addParameter(COLUMN_ANNOTATION, this.numericColumnAnnotationComboBoxParameter, false);
        this.getInputPanelBuilder().setEnabled(COLUMN_ANNOTATION, false);
        this.addParameter(COLLAPSE_METHOD, new ComboBoxParameter((Object[])new FloatListFunction[]{new Mean(), new Median()}, 0), false);
        this.addParameter("Random number seed", new IntegerInputParameter(779948241), false);
        buttons.getButtonGroupHelper().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NearestNeighborsAction.this.getInputPanelBuilder().setEnabled(NearestNeighborsAction.COLUMN_ANNOTATION, buttons.getSelectedIndex() == 1);
                NearestNeighborsAction.this.getInputPanelBuilder().setEnabled(NearestNeighborsAction.COLLAPSE_METHOD, buttons.getSelectedIndex() == 0);
            }
        });
    }

    @Override
    public boolean beforeWindowShown() {
        super.beforeWindowShown();
        Project project = Application.getProject();
        Object selection = this.numericColumnAnnotationComboBoxParameter.getSelectedItem();
        this.numericColumnAnnotationComboBoxParameter.removeAllItems();
        MetadataModel metadata = project.getOriginalDataset().getColumnMetadata();
        int nmetadata = metadata.getMetadataCount();
        for (int i = 0; i < nmetadata; ++i) {
            Class<?> c = metadata.get(i).getColumnClass();
            if (!Number.class.isAssignableFrom(c)) continue;
            this.numericColumnAnnotationComboBoxParameter.addItem(metadata.get(i).getName());
        }
        this.numericColumnAnnotationComboBoxParameter.setSelectedItem(selection);
        return true;
    }

    @Override
    protected void customizeMap(Project project, Map map) {
        super.customizeMap(project, map);
        if (SELECTED_ROWS.equals(map.get(COMPUTE_NEAREST_NEIGHBORS_OF))) {
            int[] modelRowIndices = project.getModelRowIndices(true, false);
            if (modelRowIndices == null || modelRowIndices.length == 0) {
                throw new RuntimeException("Please select one or more rows in the dataset.");
            }
            Dataset dataset = DatasetUtil.sliceView(project.getOriginalDataset(), modelRowIndices, null);
            map.put("selected.dataset", dataset);
        } else if (SELECTED_COLUMNS.equals(map.get(COMPUTE_NEAREST_NEIGHBORS_OF))) {
            int[] modelColumnIndices = project.getModelColumnIndices(true, false);
            if (modelColumnIndices == null || modelColumnIndices.length == 0) {
                throw new RuntimeException("Please select one or more columns in the dataset.");
            }
            Dataset dataset = DatasetUtil.sliceView(project.getOriginalDataset(), null, modelColumnIndices);
            map.put("selected.dataset", dataset);
        }
    }

    @Override
    protected MutableTreeNode execute(Map map, ProgressNotifier status) throws Exception {
        FloatList referenceList;
        Project project = (Project)map.get("project");
        Dataset dataset = (Dataset)map.get("dataset");
        boolean transpose = SELECTED_COLUMNS.equals(map.get(COMPUTE_NEAREST_NEIGHBORS_OF));
        if (transpose) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        BivariateFloatListFunction function = (BivariateFloatListFunction)map.get(METRIC);
        if (SELECTED_ROWS.equals(map.get(COMPUTE_NEAREST_NEIGHBORS_OF)) || SELECTED_COLUMNS.equals(map.get(COMPUTE_NEAREST_NEIGHBORS_OF))) {
            Dataset selectedDataset = (Dataset)map.get("selected.dataset");
            if (transpose) {
                selectedDataset = DatasetUtil.transposeView(selectedDataset);
            }
            if (selectedDataset.getRowCount() > 1) {
                referenceList = new ArrayFloatList(selectedDataset.getColumnCount());
                FloatListFunction summary = (FloatListFunction)map.get(COLLAPSE_METHOD);
                int ncols = selectedDataset.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    TFloatArrayList listForColumn = new TFloatArrayList();
                    int nrows = selectedDataset.getRowCount();
                    for (int i = 0; i < nrows; ++i) {
                        float value = selectedDataset.getValue(i, j);
                        if (Float.isNaN(value)) continue;
                        listForColumn.add(value);
                    }
                    float mean = summary.evaluate(new TroveFloatList(listForColumn));
                    referenceList.setValue(j, mean);
                }
            } else {
                referenceList = new DatasetRowView(selectedDataset);
                ((DatasetRowView)referenceList).setIndex(0);
            }
        } else {
            String columnAnnotation = (String)map.get(COLUMN_ANNOTATION);
            Vector vector = dataset.getColumnMetadata().get(columnAnnotation);
            if (vector == null) {
                throw new RuntimeException("Please select a column annotation.");
            }
            referenceList = VectorUtil.asFloatList(vector);
        }
        int permutations = (Integer)map.get("Permutations");
        int seed = (Integer)map.get("Random number seed");
        MarkerSelection ms = new MarkerSelection(dataset, null, permutations, 2, false, permutations < 0, function, seed, null, false, referenceList);
        ms.execute();
        dataset = DatasetUtil.shallowCopy(dataset);
        MarkerSelectionAction.addResults(dataset, ms);
        int numMarkers = (Integer)map.get("Markers");
        History history = this.getHistory(map);
        DefaultProject newProject = new DefaultProject(dataset, project);
        SortKeys.VectorSortKey sortKey = new SortKeys.VectorSortKey(ms.getFunction().toString(), SortOrder.DESCENDING, true);
        newProject.setRowSortOrder(Arrays.asList(sortKey));
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        if (numMarkers > 0) {
            CombinedFilter combinedFilter = new CombinedFilter();
            Filters.TopFilter topFilter = new Filters.TopFilter();
            topFilter.setTop(true);
            topFilter.setFilterBy("Rank");
            topFilter.setN(numMarkers);
            combinedFilter.add(topFilter);
            Filters.TopFilter bottomFilter = new Filters.TopFilter();
            bottomFilter.setTop(false);
            bottomFilter.setFilterBy("Rank");
            bottomFilter.setN(numMarkers);
            combinedFilter.add(bottomFilter);
            newProject.setRowFilter(combinedFilter);
            combinedFilter.fireFilterChanged();
        }
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

