/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.TreeNavigator;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.gui.actions.AnnotateRowsFromWebsite;
import org.broadinstitute.genee.gui.actions.SaveDatasetAction;
import org.broadinstitute.genee.gui.actions.SaveDendrogramAction;
import org.broadinstitute.genee.heatmap.ExampleDatasetsMenu;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.ImportAnalystTxtFiles;
import org.broadinstitute.genee.heatmap.ImportEnVisionTxtFiles;
import org.broadinstitute.genee.heatmap.ImportLmnxCsv;
import org.broadinstitute.genee.heatmap.ImportRankedLists;
import org.broadinstitute.genee.heatmap.ImportSpectraMaxFiles;
import org.broadinstitute.genee.heatmap.LinkToMenu;
import org.broadinstitute.genee.heatmap.OpenFileAction;
import org.broadinstitute.genee.heatmap.OpenRecentMenu;
import org.broadinstitute.genee.heatmap.menu.SaveImageAction;
import org.broadinstitute.genee.heatmap.menu.file.ImportFromClipboard;
import org.broadinstitute.genee.heatmap.menu.file.ImportFromGEO;
import org.broadinstitute.genee.io.persistence.SessionSaver;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.jdesktop.swingx.util.OS;

public class FileMenu
extends JMenu {
    private SaveImageAction saveImageMenu;

    public FileMenu(HeatMapPanel heatMapPanel) {
        super("File");
        boolean enabled = heatMapPanel.getProject().getOriginalDataset().getRowCount() > 0;
        JMenu importMenu = new JMenu("Import");
        importMenu.add(new ImportFromClipboard());
        importMenu.addSeparator();
        importMenu.add(new ImportEnVisionTxtFiles());
        importMenu.add(new ImportLmnxCsv());
        importMenu.add(new ImportRankedLists());
        importMenu.add(new ImportAnalystTxtFiles());
        importMenu.add(new ImportFromGEO());
        importMenu.add(new ImportLmnxCsv());
        if (Application.isDevVersion()) {
            importMenu.add(new ImportSpectraMaxFiles());
        }
        this.add(importMenu);
        this.add(new JSeparator());
        this.add(new OpenFileAction());
        this.add(new OpenRecentMenu());
        AbstractAction openSessionAction = new AbstractAction("Open Session\u2026"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerUtil.trackPageView("Open Session");
                final File file = FileChooserUtil.showSelectDirectoryDialog(FileMenu.this, "Select Directory", SessionSaver.getRootSessionsDir());
                if (file == null) {
                    return;
                }
                new BackgroundTask<GENEEFolderNode>("Loading " + file.getName()){

                    @Override
                    protected GENEEFolderNode doInBackground() throws Exception {
                        return SessionSaver.open(file);
                    }

                    @Override
                    protected void succeeded(GENEEFolderNode node) {
                        Application.add(node, true);
                    }
                }.execute();
            }
        };
        openSessionAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, UIUtil.getMenuShortcutKeyMask() | 1));
        if (Application.isDevVersion()) {
            this.add(openSessionAction);
        }
        this.add(new ExampleDatasetsMenu());
        this.add(new JSeparator());
        AnnotateAction annotateColumnsAction = new AnnotateAction(false);
        annotateColumnsAction.setEnabled(enabled);
        AnnotateAction annotateRowsAction = new AnnotateAction(true);
        annotateRowsAction.setEnabled(enabled);
        this.add(annotateColumnsAction);
        this.add(annotateRowsAction);
        AnnotateRowsFromWebsite annotateRowsFromWebsite = new AnnotateRowsFromWebsite();
        annotateRowsFromWebsite.setEnabled(enabled);
        this.add(annotateRowsFromWebsite);
        this.add(new JSeparator());
        LinkToMenu linkToMenu = new LinkToMenu(true);
        linkToMenu.setEnabled(enabled);
        this.add(linkToMenu);
        this.add(new JSeparator());
        SaveDatasetAction saveDatasetAction = heatMapPanel.getHeatMapEditorKit().getSaveDatasetAction();
        saveDatasetAction.setEnabled(enabled);
        this.add(saveDatasetAction);
        this.saveImageMenu = heatMapPanel.getHeatMapEditorKit().getSaveImageAction();
        this.saveImageMenu.setJComponent(heatMapPanel);
        this.saveImageMenu.setEnabled(enabled);
        this.add(this.saveImageMenu);
        if (Application.isDevVersion()) {
            AbstractAction saveSessionAction = new AbstractAction("Save Session\u2026"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeNavigator navigator;
                    TrackerUtil.trackPageView("Save Session");
                    Map<GENEEFolderNode, String> map = SessionSaver.showGui();
                    if (map != null && (navigator = Application.getNavigator()) != null) {
                        try {
                            SessionSaver.save(navigator.getRoot(), map);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Unable to save session.");
                        }
                    }
                }
            };
            saveSessionAction.setEnabled(enabled);
            this.add(saveSessionAction);
            this.add(new JSeparator());
            SaveDendrogramAction saveColumnDendrogramAction = new SaveDendrogramAction(false);
            saveColumnDendrogramAction.setEnabled(heatMapPanel.getColumnDendrogramPanel() != null);
            this.add(saveColumnDendrogramAction);
            SaveDendrogramAction saveRowDendrogramAction = new SaveDendrogramAction(true);
            saveRowDendrogramAction.setEnabled(heatMapPanel.getRowDendrogramPanel() != null);
            this.add(saveRowDendrogramAction);
        }
        if (!OS.isMacOSX() && Application.isStandalone()) {
            this.add(new JSeparator());
            this.add(new AbstractAction("Exit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Application.quit();
                }
            });
        }
    }
}

