/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.file;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.menu.file.Transposable;
import org.broadinstitute.genee.io.util.ProjectIO;

public class Importer {
    private TableModel tableModel;
    private String title;
    private JTable table;

    public Importer(final TableModel tableModel, String title) {
        this.title = title;
        final GENEEWindow window = Application.createDialog("Import - " + title);
        this.tableModel = tableModel;
        this.table = new JTable(tableModel){

            @Override
            protected void configureEnclosingScrollPane() {
            }
        };
        this.table.setGridColor(UIUtil.LIGHT_BLUE);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(String.class, new MyTableCellRenderer());
        AbstractAction copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringBuilder buf = new StringBuilder();
                int[] rows = Importer.this.table.getSelectedRows();
                int[] columns = Importer.this.table.getSelectedColumns();
                for (int i = 0; i < rows.length; ++i) {
                    if (i > 0) {
                        buf.append("\n");
                    }
                    for (int j = 0; j < columns.length; ++j) {
                        buf.append(tableModel.getValueAt(rows[i], columns[j]));
                        buf.append("\t");
                    }
                }
                StringSelection stringSelection = new StringSelection(buf.toString());
                clipboard.setContents(stringSelection, stringSelection);
            }
        };
        if (!GraphicsEnvironment.isHeadless()) {
            KeyStroke ks = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String cmd = (String)copyAction.getValue("Name");
            this.table.getInputMap(0).put(ks, cmd);
            copyAction.putValue("AcceleratorKey", ks);
            ActionMap map = this.table.getActionMap();
            map.put("copy", copyAction);
        }
        this.table.setIntercellSpacing(new Dimension(1, 1));
        this.table.setShowHorizontalLines(true);
        this.table.setShowVerticalLines(true);
        this.table.setShowGrid(true);
        this.table.setGridColor(UIUtil.LIGHT_BLUE);
        this.table.setCellSelectionEnabled(false);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        final JButton okBtn = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == okBtn) {
                    Importer.this.ok();
                }
                window.dispose();
            }
        };
        JPanel buttonPanel = UIUtil.buildOKCancelBar(okBtn, cancel);
        okBtn.addActionListener(l);
        cancel.addActionListener(l);
        CellConstraints cc = new CellConstraints();
        final JCheckBox transposeCheckBox = new JCheckBox("Transpose", false);
        transposeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Transposable)((Object)tableModel)).setTransposed(transposeCheckBox.isSelected());
            }
        });
        FormBuilder legendFormBuilder = new FormBuilder();
        legendFormBuilder.getPanel().setBackground(Color.WHITE);
        legendFormBuilder.nextSmallRow();
        legendFormBuilder.addFirstColumn(new JLabel("Row metadata", new MyIcon(MyTableCellRenderer.ROW_META_DATA_COLOR), 10));
        legendFormBuilder.nextSmallRow();
        legendFormBuilder.addFirstColumn(new JLabel("Column metadata", new MyIcon(MyTableCellRenderer.COLUMN_META_DATA_COLOR), 10));
        legendFormBuilder.nextSmallRow();
        legendFormBuilder.addFirstColumn(new JLabel("Data matrix", new MyIcon(MyTableCellRenderer.DATA_COLOR), 10));
        legendFormBuilder.nextSmallRow();
        JPanel hintsPanel = new JPanel((LayoutManager)new FormLayout("left:p, right:p", "8px, p, 8px, p"));
        hintsPanel.add((Component)legendFormBuilder.getPanel(), cc.xy(2, 2));
        if (tableModel instanceof Transposable) {
            hintsPanel.add((Component)transposeCheckBox, cc.xyw(1, 4, 2));
        }
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout("p", "p, p"));
        topPanel.add((Component)this.table.getTableHeader(), cc.xy(1, 2));
        int cols = this.table.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            this.table.getTableHeader().getColumnModel().getColumn(j).setMinWidth(32);
        }
        JLabel instructionsLabel = new JLabel("Click the table cell containing the first data row and column.");
        instructionsLabel.setFont(instructionsLabel.getFont().deriveFont(instructionsLabel.getFont().getSize2D() + 3.0f).deriveFont(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)instructionsLabel, "North");
        northPanel.add(hintsPanel);
        window.getContentPane().add((Component)northPanel, "North");
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        tableScrollPane.setColumnHeaderView(topPanel);
        window.getContentPane().add((Component)tableScrollPane, "Center");
        window.getContentPane().add((Component)buttonPanel, "South");
        window.getRootPane().setDefaultButton(okBtn);
        UIUtil.sizeToScreen(window);
        window.setVisible(true);
    }

    public Project getProject() throws IOException {
        int columnStart = this.table.getSelectedColumn();
        int rowStart = this.table.getSelectedRow();
        return ProjectIO.readProject(this.tableModel, columnStart, rowStart, this.title);
    }

    protected void ok() {
        new BackgroundTask<GENEEFolderNode>("Importing " + this.title){

            @Override
            protected GENEEFolderNode doInBackground() throws Exception {
                Project p = Importer.this.getProject();
                p.getOriginalDataset().setName(Importer.this.title);
                History map = new History("Import File");
                map.add("File", Importer.this.title);
                ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(p, map);
                return new GENEEFolderNode("Import File", map, node);
            }

            @Override
            protected void succeeded(GENEEFolderNode node) {
                Application.add(node);
            }
        }.execute();
    }

    private static class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        public static final Color DATA_COLOR = new Color(179, 205, 227);
        public static final Color ROW_META_DATA_COLOR = new Color(204, 235, 197);
        public static final Color COLUMN_META_DATA_COLOR = new Color(251, 180, 174);

        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int dataRowStart = table.getSelectedRow();
            int dataColumnStart = table.getSelectedColumn();
            if (column >= dataColumnStart && row >= dataRowStart) {
                this.setBackground(DATA_COLOR);
            } else if (row <= dataRowStart - 1 && column >= dataColumnStart) {
                this.setBackground(COLUMN_META_DATA_COLOR);
            } else if (column < dataColumnStart && row >= dataRowStart) {
                this.setBackground(ROW_META_DATA_COLOR);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    private static class MyIcon
    implements Icon {
        Color color;

        public MyIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(x, y, 15, 15);
        }
    }
}

