/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.preprocess;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class MaskAction
extends AbstractAction {
    boolean maskRows = true;

    public MaskAction(boolean maskRows) {
        super("Mask " + (maskRows ? "Rows" : "Columns"));
        this.maskRows = maskRows;
        if (!maskRows) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, UIUtil.getMenuShortcutKeyMask()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        Project p = Application.getProject();
        if (this.maskRows) {
            int[] rows = p.getRowSelectionModel().getSelectedViewIndices();
            p.addToRowMask(rows);
        } else {
            int[] columns = p.getColumnSelectionModel().getSelectedViewIndices();
            p.addToColumnMask(columns);
        }
    }
}

