/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class AddToMetadataContentHandler
implements ExcelReaderContentHandler {
    private VectorColorModel colorModel;
    private int[] metadataColumnIndices;
    private String[] metadataColumnNames;
    private Map<Integer, Integer> includedHeaderIndices;
    private Map<String, TIntArrayList> keyToIndices;
    private String key;
    private MetadataModel metadata;
    private int rowIndex = -1;
    private int[] headerColumnIndices;
    private boolean rows;
    private boolean convertClass;

    public AddToMetadataContentHandler(MetadataModel metadata, VectorColorModel colorModel, int[] headerColumnIndices, Map<String, TIntArrayList> keyToIndices, boolean rows) {
        this(metadata, colorModel, headerColumnIndices, keyToIndices, rows, true);
    }

    public AddToMetadataContentHandler(MetadataModel metadata, VectorColorModel colorModel, int[] headerColumnIndices, Map<String, TIntArrayList> keyToIndices, boolean rows, boolean convertClass) {
        this.headerColumnIndices = headerColumnIndices;
        this.metadata = metadata;
        this.colorModel = colorModel;
        this.keyToIndices = keyToIndices;
        this.rows = rows;
        this.convertClass = convertClass;
    }

    @Override
    public void color(int columnIndex, String value, Color color) {
        Integer tmp = this.includedHeaderIndices.get(columnIndex);
        if (tmp == null) {
            return;
        }
        columnIndex = tmp;
        String columnName = this.metadataColumnNames[columnIndex];
        int metadataColumnIndex = this.metadata.getColumnIndex(columnName);
        if (metadataColumnIndex != -1 && this.colorModel != null) {
            Vector v = this.metadata.get(metadataColumnIndex);
            this.colorModel.setMappedValue(v, value, color);
        }
    }

    @Override
    public void end() {
        if (this.convertClass && this.metadataColumnIndices != null) {
            for (int columnIndex : this.metadataColumnIndices) {
                MetadataUtil.maybeConvertMetadataClass(this.metadata, this.colorModel, true, columnIndex, this.rows);
            }
        }
    }

    @Override
    public void init(int rows, int columns) {
        int i;
        int length;
        if (this.headerColumnIndices == null) {
            this.headerColumnIndices = new int[columns - 1];
            length = this.headerColumnIndices.length;
            for (i = 0; i < length; ++i) {
                this.headerColumnIndices[i] = i + 1;
            }
        }
        this.includedHeaderIndices = new HashMap<Integer, Integer>();
        length = this.headerColumnIndices.length;
        for (i = 0; i < length; ++i) {
            this.includedHeaderIndices.put(this.headerColumnIndices[i], i);
        }
        this.metadataColumnNames = new String[this.headerColumnIndices.length];
    }

    @Override
    public boolean nextRow() {
        if (this.rowIndex == 0) {
            int j;
            this.metadataColumnIndices = new int[this.metadataColumnNames.length];
            for (j = 0; j < this.metadataColumnNames.length; ++j) {
                if (this.rows) {
                    MetadataUtil.addRowVector(this.metadata, this.metadataColumnNames[j], String.class);
                    continue;
                }
                MetadataUtil.addColumnVector(this.metadata, this.metadataColumnNames[j], String.class);
            }
            for (j = 0; j < this.metadataColumnNames.length; ++j) {
                this.metadataColumnIndices[j] = this.metadata.getColumnIndex(this.metadataColumnNames[j]);
            }
        }
        ++this.rowIndex;
        return true;
    }

    @Override
    public void value(int columnIndex, String s) {
        Integer tmp;
        if (columnIndex == 0) {
            this.key = s;
        }
        if ((tmp = this.includedHeaderIndices.get(columnIndex)) == null) {
            return;
        }
        columnIndex = tmp;
        if (this.rowIndex == 0) {
            this.metadataColumnNames[columnIndex] = s;
        } else {
            TIntArrayList indices = this.keyToIndices.get(this.key);
            if (indices != null) {
                int nIndices = indices.size();
                for (int i = 0; i < nIndices; ++i) {
                    this.metadata.setValue(indices.getQuick(i), this.metadataColumnIndices[columnIndex], (Object)s);
                }
            }
        }
    }
}

