/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.cls;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.DefaultClassVector;

public class ClsReader {
    private BufferedReader reader;
    private int numClasses;
    private int numItems;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultClassVector read(String file) throws IOException {
        try {
            int i;
            this.reader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            this.processHeader();
            String classifierLine = this.reader.readLine();
            Object[] names = null;
            String dataLine = null;
            Object[] assignments = null;
            HashMap<Integer, String> classNumber2NameMap = new HashMap<Integer, String>();
            if (this.hasClassNames(classifierLine)) {
                names = this.readClassNamesLine(classifierLine);
                int length = names.length;
                for (i = 0; i < length; ++i) {
                    classNumber2NameMap.put(i, names[i]);
                }
                dataLine = this.reader.readLine();
                assignments = this.processData(dataLine, classNumber2NameMap);
            } else {
                names = new String[this.numClasses];
                for (i = 0; i < this.numClasses; ++i) {
                    names[i] = String.valueOf(i);
                    classNumber2NameMap.put(i, String.valueOf(i));
                }
                dataLine = classifierLine;
                assignments = this.processData(dataLine, classNumber2NameMap);
            }
            DefaultClassVector cv = new DefaultClassVector(assignments, names);
            cv.setDescription(IOUtil.getBaseFileName(file));
            DefaultClassVector defaultClassVector = cv;
            return defaultClassVector;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private boolean hasClassNames(String classifierLine) {
        return classifierLine != null && classifierLine.length() > 2 && classifierLine.startsWith("#");
    }

    private String[] processData(String data_line, Map<Integer, String> classNumber2ClassNameMap) throws IOException {
        if (data_line == null) {
            throw new IOException("Missing data (numbers seperated by spaces) on 3rd line");
        }
        String[] tokens = data_line.split("[ \t]");
        String[] assignments = new String[this.numItems];
        try {
            if (tokens.length != this.numItems) {
                throw new IOException("Header specifies " + this.numItems + " data points, but file contains " + tokens.length + " data points.");
            }
            for (int i = 0; i < tokens.length; ++i) {
                String name;
                int classNumber = Integer.parseInt(tokens[i].trim());
                if (classNumber >= this.numClasses || classNumber < 0) {
                    throw new IOException("Header specifies " + this.numClasses + " classes, but data line contains a " + classNumber + ", a value " + "that is too " + (classNumber < 0 ? "small" : "large") + "." + " All data for this file must be in the range 0-" + (this.numClasses - 1) + ".");
                }
                assignments[i] = name = classNumber2ClassNameMap.get(classNumber);
            }
        }
        catch (NumberFormatException ex) {
            LinkedHashMap<String, String> tokenToClassName = new LinkedHashMap<String, String>();
            int classNumber = 0;
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                String className = (String)tokenToClassName.get(token);
                if (className == null) {
                    className = classNumber2ClassNameMap.get(classNumber);
                    if (className == null) {
                        throw new IOException("More classes than expected.");
                    }
                    tokenToClassName.put(token, className);
                    ++classNumber;
                }
                assignments[i] = className;
            }
        }
        return assignments;
    }

    private void processHeader() throws IOException {
        String headerLine = this.reader.readLine();
        if (headerLine == null) {
            throw new IOException("No header line");
        }
        int[] hdrInts = new int[3];
        StringTokenizer tok = new StringTokenizer(headerLine, " \t");
        if (tok.countTokens() != 3) {
            throw new IOException("Header line needs three numbers!\n\"" + headerLine + "\"");
        }
        try {
            for (int i = 0; i < 3; ++i) {
                hdrInts[i] = Integer.parseInt(tok.nextToken().trim());
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Header line element '" + e.getMessage() + "' is not a number");
        }
        if (hdrInts[0] <= 0) {
            throw new IOException("Header line missing first number, number of data points");
        }
        if (hdrInts[1] <= 0) {
            throw new IOException("Header line missing second number, number of classes");
        }
        this.numClasses = hdrInts[1];
        this.numItems = hdrInts[0];
    }

    private String[] readClassNamesLine(String classifierLine) throws IOException {
        StringTokenizer st = new StringTokenizer(classifierLine = classifierLine.substring(classifierLine.indexOf(35) + 1), " \t");
        if (st.countTokens() != this.numClasses) {
            throw new IOException("First line specifies " + this.numClasses + " classes, but found " + st.countTokens() + ".");
        }
        String[] names = new String[this.numClasses];
        int ic = 0;
        while (st.hasMoreTokens()) {
            names[ic] = st.nextToken();
            ++ic;
        }
        return names;
    }
}

